/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.suppressors;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterIdList;
import com.jetbrains.rd.ide.model.HighlighterList;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.daemon.suppressors.HighlighterElementSuppressor;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModelKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u0013\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u0016\u0010\u0015\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002JD\u0010 \u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0\u00050!\"\u0004\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"0\u00052\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u00020%0$H\u0002J\u001a\u0010&\u001a\u00020%*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010'\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006("}, d2={"Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "", "protocolMarkup", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "supressors", "", "Lcom/jetbrains/rdclient/daemon/suppressors/HighlighterElementSuppressor;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdMarkupModel;Ljava/util/List;)V", "pendingAddHighlighters", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "pendingUpdateHighlighters", "pendingRemoveHighlighters", "", "highlightersAdded", "Lcom/jetbrains/rd/util/reactive/ISignal;", "getHighlightersAdded", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "highlightersUpdated", "getHighlightersUpdated", "highlightersRemoved", "getHighlightersRemoved", "highlightersCleared", "", "getHighlightersCleared", "bind", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "elements", "idsToRemove", "flush", "splitBySuppressors", "Lkotlin/Pair;", "T", "predicate", "Lkotlin/Function1;", "", "isSuppressed", "element", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolSuppressableMarkupModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolSuppressableMarkupModel.kt\ncom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n1863#2,2:84\n3193#2,10:98\n1755#2,3:108\n1755#2,3:111\n68#3,4:86\n68#3,4:90\n68#3,4:94\n*S KotlinDebug\n*F\n+ 1 ProtocolSuppressableMarkupModel.kt\ncom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel\n*L\n31#1:84,2\n80#1:98,10\n82#1:108,3\n51#1:111,3\n38#1:86,4\n45#1:90,4\n52#1:94,4\n*E\n"})
public final class ProtocolSuppressableMarkupModel {
    @NotNull
    private final RdMarkupModel protocolMarkup;
    @NotNull
    private final List<HighlighterElementSuppressor> supressors;
    @NotNull
    private final List<HighlighterElement> pendingAddHighlighters;
    @NotNull
    private final List<HighlighterElement> pendingUpdateHighlighters;
    @NotNull
    private final List<Long> pendingRemoveHighlighters;
    @NotNull
    private final ISignal<List<HighlighterElement>> highlightersAdded;
    @NotNull
    private final ISignal<List<HighlighterElement>> highlightersUpdated;
    @NotNull
    private final ISignal<List<Long>> highlightersRemoved;
    @NotNull
    private final ISignal<Unit> highlightersCleared;

    public ProtocolSuppressableMarkupModel(@NotNull RdMarkupModel protocolMarkup, @NotNull List<? extends HighlighterElementSuppressor> supressors) {
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        Intrinsics.checkNotNullParameter(supressors, (String)"supressors");
        this.protocolMarkup = protocolMarkup;
        this.supressors = supressors;
        this.pendingAddHighlighters = new ArrayList();
        this.pendingUpdateHighlighters = new ArrayList();
        this.pendingRemoveHighlighters = new ArrayList();
        this.highlightersAdded = (ISignal)new Signal();
        this.highlightersUpdated = (ISignal)new Signal();
        this.highlightersRemoved = (ISignal)new Signal();
        this.highlightersCleared = (ISignal)new Signal();
    }

    @NotNull
    public final ISignal<List<HighlighterElement>> getHighlightersAdded() {
        return this.highlightersAdded;
    }

    @NotNull
    public final ISignal<List<HighlighterElement>> getHighlightersUpdated() {
        return this.highlightersUpdated;
    }

    @NotNull
    public final ISignal<List<Long>> getHighlightersRemoved() {
        return this.highlightersRemoved;
    }

    @NotNull
    public final ISignal<Unit> getHighlightersCleared() {
        return this.highlightersCleared;
    }

    public final void bind(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.protocolMarkup.getHighlightersRemoved().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$0(this, arg_0));
        this.protocolMarkup.getHighlightersAdded().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$1(this, arg_0));
        this.protocolMarkup.getHighlightersUpdated().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$2(this, arg_0));
        this.protocolMarkup.getHighlightersCleared().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$3(this, arg_0));
        Iterable $this$forEach$iv = this.supressors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HighlighterElementSuppressor it = (HighlighterElementSuppressor)element$iv;
            boolean bl = false;
            it.getFlush().advise(lifetime, arg_0 -> ProtocolSuppressableMarkupModel.bind$lambda$5$lambda$4(this, arg_0));
        }
    }

    private final void highlightersUpdated(List<HighlighterElement> elements) {
        Pair<List<HighlighterElement>, List<HighlighterElement>> pair2 = this.splitBySuppressors(elements, arg_0 -> ProtocolSuppressableMarkupModel.highlightersUpdated$lambda$6(this, arg_0));
        List suppressed = (List)pair2.component1();
        List toUpdate = (List)pair2.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersRemoved: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toUpdate).size() + " toUpdate");
        }
        this.pendingUpdateHighlighters.addAll(suppressed);
        this.highlightersUpdated.fire((Object)toUpdate);
    }

    private final void highlightersAdded(List<HighlighterElement> elements) {
        Pair<List<HighlighterElement>, List<HighlighterElement>> pair2 = this.splitBySuppressors(elements, arg_0 -> ProtocolSuppressableMarkupModel.highlightersAdded$lambda$8(this, arg_0));
        List suppressed = (List)pair2.component1();
        List toAdd = (List)pair2.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersRemoved: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toAdd).size() + " toAdd");
        }
        this.pendingAddHighlighters.addAll(suppressed);
        this.highlightersAdded.fire((Object)toAdd);
    }

    private final void highlightersRemoved(List<Long> idsToRemove) {
        Pair<List<Long>, List<Long>> pair2 = this.splitBySuppressors(idsToRemove, arg_0 -> ProtocolSuppressableMarkupModel.highlightersRemoved$lambda$11(this, arg_0));
        List suppressed = (List)pair2.component1();
        List toRemove = (List)pair2.component2();
        Logger $this$trace$iv = ProtocolSuppressableMarkupModelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("highlightersRemoved: " + ((Collection)suppressed).size() + " suppressed, " + ((Collection)toRemove).size() + " toRemove");
        }
        this.pendingRemoveHighlighters.addAll(suppressed);
        this.highlightersRemoved.fire((Object)toRemove);
    }

    private final void highlightersCleared() {
        this.pendingAddHighlighters.clear();
        this.pendingUpdateHighlighters.clear();
        this.pendingRemoveHighlighters.clear();
        InterfacesKt.fire(this.highlightersCleared);
    }

    private final void flush() {
        List pendingAddList = CollectionsKt.toList((Iterable)this.pendingAddHighlighters);
        this.pendingAddHighlighters.clear();
        this.highlightersAdded(pendingAddList);
        List pendingUpdateList = CollectionsKt.toList((Iterable)this.pendingUpdateHighlighters);
        this.pendingUpdateHighlighters.clear();
        this.highlightersUpdated(pendingUpdateList);
        List pendingRemoveList = CollectionsKt.toList((Iterable)this.pendingRemoveHighlighters);
        this.pendingRemoveHighlighters.clear();
        this.highlightersRemoved(pendingRemoveList);
    }

    private final <T> Pair<List<T>, List<T>> splitBySuppressors(List<? extends T> $this$splitBySuppressors, Function1<? super T, Boolean> predicate) {
        if (this.supressors.isEmpty()) {
            return new Pair((Object)CollectionsKt.emptyList(), $this$splitBySuppressors);
        }
        Iterable $this$partition$iv = $this$splitBySuppressors;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            if (((Boolean)predicate.invoke(element$iv)).booleanValue()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        return new Pair(first$iv, second$iv);
    }

    private final boolean isSuppressed(List<? extends HighlighterElementSuppressor> $this$isSuppressed, HighlighterElement element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isSuppressed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HighlighterElementSuppressor it = (HighlighterElementSuppressor)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldSuppress(element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit bind$lambda$0(ProtocolSuppressableMarkupModel this$0, HighlighterIdList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersRemoved(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(ProtocolSuppressableMarkupModel this$0, HighlighterList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersAdded(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(ProtocolSuppressableMarkupModel this$0, HighlighterList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersUpdated(it.getElements());
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(ProtocolSuppressableMarkupModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.highlightersCleared();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$5$lambda$4(ProtocolSuppressableMarkupModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.flush();
        return Unit.INSTANCE;
    }

    private static final boolean highlightersUpdated$lambda$6(ProtocolSuppressableMarkupModel this$0, HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.isSuppressed(this$0.supressors, element);
    }

    private static final boolean highlightersAdded$lambda$8(ProtocolSuppressableMarkupModel this$0, HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.isSuppressed(this$0.supressors, element);
    }

    private static final boolean highlightersRemoved$lambda$11(ProtocolSuppressableMarkupModel this$0, long elementId) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this$0.pendingAddHighlighters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HighlighterElement element = (HighlighterElement)element$iv;
                    boolean bl2 = false;
                    if (!(element.getHighlighter().getId() == elementId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

