/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.InlineDebugRendererModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendDebugRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugInlayModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createRender", "Lcom/intellij/xdebugger/impl/inline/InlineDebugRendererBase;", "Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
@ApiStatus.Internal
public class FrontendDebugInlayModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;

    public FrontendDebugInlayModelHandler(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof InlineDebugRendererModel && Intrinsics.areEqual((Object)((InlineDebugRendererModel)model2).getSpecialRenderId(), (Object)"");
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        InlineDebugRendererModel cfr_ignored_0 = (InlineDebugRendererModel)model2;
        Inlay<?> oldInlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (oldInlay != null) {
            EditorCustomElementRenderer editorCustomElementRenderer = oldInlay.getRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
            EditorCustomElementRenderer renderer = editorCustomElementRenderer;
            if (renderer instanceof FrontendDebugRenderer) {
                ((FrontendDebugRenderer)renderer).updateFromModel((InlineDebugRendererModel)model2);
                oldInlay.update();
                return;
            }
            Disposer.dispose((Disposable)((Disposable)oldInlay));
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, null);
        }
        InlayProperties properties = new InlayProperties().disableSoftWrapping(true).priority(((InlineDebugRendererModel)model2).isCustomNode() ? 0 : -1);
        Inlay inlay = this.editor.getInlayModel().addAfterLineEndElement(model2.getStart(), properties, (EditorCustomElementRenderer)this.createRender((InlineDebugRendererModel)model2, highlighter));
        FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, inlay);
    }

    @NotNull
    protected InlineDebugRendererBase createRender(@NotNull InlineDebugRendererModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return new FrontendDebugRenderer(model2, highlighter);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter)) {
            return false;
        }
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        EditorCustomElementRenderer renderer = editorCustomElementRenderer;
        return renderer instanceof FrontendDebugRenderer && Intrinsics.areEqual((Object)((FrontendDebugRenderer)renderer).getModel(), (Object)model2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        InlineDebugRendererModel $this$move_u24lambda_u240 = (InlineDebugRendererModel)model2;
        boolean bl = false;
        return (HighlighterModel)new InlineDebugRendererModel($this$move_u24lambda_u240.getColoredText(), $this$move_u24lambda_u240.isInExecutionPointHighlight(), $this$move_u24lambda_u240.isCustomNode(), $this$move_u24lambda_u240.isErrorMessage(), $this$move_u24lambda_u240.getSpecialRenderId(), $this$move_u24lambda_u240.getLayer(), $this$move_u24lambda_u240.isExactRange(), $this$move_u24lambda_u240.getDocumentVersion(), $this$move_u24lambda_u240.isGreedyToLeft(), $this$move_u24lambda_u240.isGreedyToRight(), $this$move_u24lambda_u240.isThinErrorStripeMark(), $this$move_u24lambda_u240.getTextToHighlight(), $this$move_u24lambda_u240.getTextAttributesKey(), $this$move_u24lambda_u240.getId(), $this$move_u24lambda_u240.getProperties(), startOffset, endOffset);
    }
}

