/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangConfig.clangFormat.language;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.clangConfig.ClangConfigFileUtils;
import com.jetbrains.clangConfig.messages.ClangConfigBundle;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u000f\u0010\u000f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/clangConfig/clangFormat/language/ClangFormatSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "<init>", "()V", "ourPresentableName", "", "getOurPresentableName", "()Ljava/lang/String;", "ourPresentableName$delegate", "Lkotlin/Lazy;", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "getSchemaFile", "Lorg/jetbrains/annotations/Nullable;", "isUserVisible", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "getPresentableName", "intellij.cidr.clangConfig"})
public final class ClangFormatSchemaProvider
implements JsonSchemaFileProvider {
    @NotNull
    public static final ClangFormatSchemaProvider INSTANCE = new ClangFormatSchemaProvider();
    @NotNull
    private static final Lazy ourPresentableName$delegate = LazyKt.lazy(ClangFormatSchemaProvider::ourPresentableName_delegate$lambda$0);

    private ClangFormatSchemaProvider() {
    }

    private final String getOurPresentableName() {
        Lazy lazy = ourPresentableName$delegate;
        return (String)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ClangConfigFileUtils.isClangFormatConfig(file)) return true;
        if (!(file instanceof LightVirtualFile)) return false;
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object[] objectArray = new Object[]{""};
        if (!StringsKt.startsWith$default((String)string, (String)ClangConfigBundle.message("cf.title.actual.clang.format", objectArray), (boolean)false, (int)2, null)) return false;
        return true;
    }

    @NotNull
    public String getName() {
        return this.getOurPresentableName();
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        return JsonSchemaProviderFactory.getResourceFile(ClangFormatSchemaProvider.class, (String)("/schemas/" + (EditorColorsManager.getInstance().isDarkEditor() ? "clangformatDark.json" : "clangformat.json")));
    }

    public boolean isUserVisible() {
        return false;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        return JsonSchemaVersion.SCHEMA_7;
    }

    @NotNull
    public String getPresentableName() {
        return this.getOurPresentableName();
    }

    private static final String ourPresentableName_delegate$lambda$0() {
        return ClangConfigBundle.message("cf.schema.name", new Object[0]);
    }
}

