/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.dissolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.locationtech.jts.dissolve.DissolveEdgeGraph;
import org.locationtech.jts.dissolve.DissolveHalfEdge;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.edgegraph.MarkHalfEdge;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LineDissolver {
    private Geometry result;
    private GeometryFactory factory;
    private final DissolveEdgeGraph graph;
    private final List lines = new ArrayList();
    private final Stack nodeEdgeStack = new Stack();
    private DissolveHalfEdge ringStartEdge;

    public static Geometry dissolve(Geometry g) {
        LineDissolver d = new LineDissolver();
        d.add(g);
        return d.getResult();
    }

    public LineDissolver() {
        this.graph = new DissolveEdgeGraph();
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    LineDissolver.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        CoordinateSequence seq = lineString.getCoordinateSequence();
        boolean doneStart = false;
        for (int i2 = 1; i2 < seq.size(); ++i2) {
            DissolveHalfEdge e = (DissolveHalfEdge)this.graph.addEdge(seq.getCoordinate(i2 - 1), seq.getCoordinate(i2));
            if (e == null || doneStart) continue;
            e.setStart();
            doneStart = true;
        }
    }

    public Geometry getResult() {
        if (this.result == null) {
            this.computeResult();
        }
        return this.result;
    }

    private void computeResult() {
        Collection edges = this.graph.getVertexEdges();
        for (HalfEdge e : edges) {
            if (MarkHalfEdge.isMarked(e)) continue;
            this.process(e);
        }
        this.result = this.factory.buildGeometry(this.lines);
    }

    private void process(HalfEdge e) {
        HalfEdge eNode = e.prevNode();
        if (eNode == null) {
            eNode = e;
        }
        this.stackEdges(eNode);
        this.buildLines();
    }

    private void buildLines() {
        while (!this.nodeEdgeStack.empty()) {
            HalfEdge e = (HalfEdge)this.nodeEdgeStack.pop();
            if (MarkHalfEdge.isMarked(e)) continue;
            this.buildLine(e);
        }
    }

    private void updateRingStartEdge(DissolveHalfEdge e) {
        if (!e.isStart() && !(e = (DissolveHalfEdge)e.sym()).isStart()) {
            return;
        }
        if (this.ringStartEdge == null) {
            this.ringStartEdge = e;
            return;
        }
        if (e.orig().compareTo(this.ringStartEdge.orig()) < 0) {
            this.ringStartEdge = e;
        }
    }

    private void buildLine(HalfEdge eStart) {
        CoordinateList line = new CoordinateList();
        DissolveHalfEdge e = (DissolveHalfEdge)eStart;
        this.ringStartEdge = null;
        MarkHalfEdge.markBoth(e);
        line.add(e.orig().copy(), false);
        while (e.sym().degree() == 2) {
            this.updateRingStartEdge(e);
            DissolveHalfEdge eNext = (DissolveHalfEdge)e.next();
            if (eNext == eStart) {
                this.buildRing(this.ringStartEdge);
                return;
            }
            line.add(eNext.orig().copy(), false);
            e = eNext;
            MarkHalfEdge.markBoth(e);
        }
        line.add(e.dest().clone(), false);
        this.stackEdges(e.sym());
        this.addLine(line);
    }

    private void buildRing(HalfEdge eStartRing) {
        HalfEdge eNext;
        CoordinateList line = new CoordinateList();
        HalfEdge e = eStartRing;
        line.add(e.orig().copy(), false);
        while (e.sym().degree() == 2 && (eNext = e.next()) != eStartRing) {
            line.add(eNext.orig().copy(), false);
            e = eNext;
        }
        line.add(e.dest().copy(), false);
        this.addLine(line);
    }

    private void addLine(CoordinateList line) {
        this.lines.add(this.factory.createLineString(line.toCoordinateArray()));
    }

    private void stackEdges(HalfEdge node) {
        HalfEdge e = node;
        do {
            if (MarkHalfEdge.isMarked(e)) continue;
            this.nodeEdgeStack.add(e);
        } while ((e = e.oNext()) != node);
    }
}

