/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.Typed;
import org.eclipse.sisu.inject.Legacy;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.space.MediationListener;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.WildcardKey;

public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_JSR299_TYPED;
    private final Binder rootBinder;
    private MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (null != source) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (org.sonatype.inject.Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (null != module) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(mediatorType, Mediator.class);
        if (args2.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (null != mediator) {
                this.mediate(QualifiedTypeBinder.watchedKey(args2[1], args2[0].getRawType()), mediator, args2[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<org.sonatype.inject.Mediator> mediatorType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(mediatorType, org.sonatype.inject.Mediator.class);
        if (args2.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = Legacy.adapt(this.newInstance(mediatorType));
            if (null != mediator) {
                this.mediate(QualifiedTypeBinder.watchedKey(args2[1], args2[0].getRawType()), mediator, args2[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, Mediator mediator, Class watcherType) {
        if (null == this.mediationListener) {
            this.mediationListener = new MediationListener(this.binder);
            this.binder.bindListener((Matcher)this.mediationListener, (TypeListener)this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(providerType, Provider.class);
        if (args2.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types = QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key2 = QualifiedTypeBinder.getBindingKey(args2[0], (Annotation)bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key2).toProvider(providerType);
            if (QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if (QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (null != types) {
                for (Class<?> bindingType : types) {
                    this.binder.bind(key2.ofType(bindingType)).to(key2);
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder sbb = this.binder.bind(qualifiedType);
        if (QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (null != types) {
            Key<Object> key2 = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            for (Class<?> bindingType : types) {
                this.binder.bind(key2.ofType(bindingType)).to(qualifiedType);
            }
        } else {
            this.binder.bind(WildcardKey.get(qualifiedType, (Annotation)bindingName)).to(qualifiedType);
        }
    }

    private void bindQualifiedInstance(Object qualifiedInstance) {
        Class<?> qualifiedType = qualifiedInstance.getClass();
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (null != types) {
            Key<Object> key2 = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            for (Class<?> bindingType : types) {
                this.binder.bind(key2.ofType(bindingType)).toInstance(qualifiedInstance);
            }
        } else {
            this.binder.bind(WildcardKey.get(qualifiedType, (Annotation)bindingName)).toInstance(qualifiedInstance);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            final Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ctor.setAccessible(true);
                        return null;
                    }
                });
            }
            T instance = ctor.newInstance(new Object[0]);
            this.bindQualifiedInstance(instance);
            return instance;
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("Error creating instance of: " + type + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type, Class<?> superType) {
        return TypeArguments.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return null != qualifier ? Key.get(bindingType, (Annotation)qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (null != jsr330) {
            try {
                String name2 = jsr330.value();
                if (name2.length() > 0) {
                    return "default".equals(name2) ? null : Names.named((String)name2);
                }
            }
            catch (IncompleteAnnotationException name2) {}
        } else {
            String name3;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (null != guice && (name3 = guice.value()).length() > 0) {
                return "default".equals(name3) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named((String)qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        for (Class<?> c2 = clazz; null != c2 && c2 != Object.class; c2 = c2.getSuperclass()) {
            Object typed;
            if (HAS_JSR299_TYPED && null != (typed = c2.getAnnotation(javax.enterprise.inject.Typed.class))) {
                return typed.value().length > 0 ? typed.value() : c2.getInterfaces();
            }
            typed = c2.getAnnotation(Typed.class);
            if (null == typed) continue;
            return typed.value().length > 0 ? typed.value() : c2.getInterfaces();
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type) {
        return type.isAnnotationPresent(javax.inject.Singleton.class) || type.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type) {
        return type.isAnnotationPresent(EagerSingleton.class) || type.isAnnotationPresent(org.sonatype.inject.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type, Class qualifierType) {
        return qualifierType.isAnnotation() ? Key.get(type, (Class)qualifierType) : Key.get(type);
    }

    static {
        boolean hasJsr299Typed;
        try {
            hasJsr299Typed = javax.enterprise.inject.Typed.class.isAnnotation();
        }
        catch (LinkageError e) {
            hasJsr299Typed = false;
        }
        HAS_JSR299_TYPED = hasJsr299Typed;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }
}

