/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.CollectionCache;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 R2\u00020\u0001:\u0001RB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u000e*\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0!H\u0002J\u001a\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0!2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u001c\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001c\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001c\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001c\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180!2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J!\u0010+\u001a\u000f\u0012\u0006\b\u0001\u0012\u00020\u00180!\u00a2\u0006\u0002\b,2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001a\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\b\u0010\u001e\u001a\u0004\u0018\u000100H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0018H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000e05H\u0002J\u0010\u00106\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0015\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0010\u00a2\u0006\u0002\b;J\u0015\u0010<\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0010\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0010\u00a2\u0006\u0002\b?J\u001d\u0010@\u001a\u00020\u00102\u0006\u00109\u001a\u00020:2\u0006\u0010A\u001a\u00020BH\u0010\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020:H\u0002J\u0010\u0010F\u001a\u00020\u00102\u0006\u0010E\u001a\u00020:H\u0002J\u0010\u0010G\u001a\u00020\u00102\u0006\u0010E\u001a\u00020:H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010J\u001a\u00020I2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010K\u001a\u00020I2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010N\u001a\u00020M2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\b\u0010O\u001a\u00020\u0010H\u0002J\b\u0010P\u001a\u00020\u0010H\u0016J\u0010\u0010Q\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "level", "", "getLevel", "()B", "project", "Lcom/intellij/openapi/project/Project;", "knownViewOptionsCounter", "", "dataSources", "Lcom/intellij/database/view/structure/CollectionCache;", "Lcom/intellij/database/view/DataSourceNode;", "setup", "", "base", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "parentOfElement", "Lcom/intellij/database/model/basic/BasicElement;", "dataSourceNode", "Lcom/intellij/database/model/basic/BasicRoot;", "parentOfFamily", "Lcom/intellij/database/model/families/HostFamily;", "getDataSourceNodeFor", "model", "Lcom/intellij/database/model/DasModel;", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "listDataSources", "listElementFamilies", "Lcom/intellij/database/model/families/Family;", "element", "listFamilyChildren", "family", "listDatabases", "listSchemas", "listNamespacesToShow", "listRegularFamilyElements", "Lorg/jetbrains/annotations/NotNull;", "getObjectFilterForRegularObjects", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/database/model/DasObject;", "Lcom/intellij/database/model/basic/BasicModel;", "getScope", "Lcom/intellij/database/util/TreePattern;", "host", "retrieveAllDataSourceNodes", "", "isAlwaysLeaf", "", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "getDSN", "ds", "addDSN", "removeDSN", "countAllChildrenOf", "", "countRealChildrenOf", "countRealChildrenOfFamily", "presentableNameOf", "", "presentableNameOfFamily", "invalidateCaches", "clearAll", "isValid", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,264:1\n1#2:265\n14#3:266\n*S KotlinDebug\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer\n*L\n254#1:266\n*E\n"})
public final class DvTreeModelLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private Project project;
    private long knownViewOptionsCounter = -1L;
    @NotNull
    private final CollectionCache<DataSourceNode> dataSources = new CollectionCache(() -> DvTreeModelLayer.dataSources$lambda$0(this));
    @NotNull
    private static final List<Class<?>> excluded = CollectionsKt.listOf(BasicArgument.class);
    @NotNull
    private static final List<Class<?>> alwaysLeafs;
    @NotNull
    private static final Logger logger;

    @Override
    public byte getLevel() {
        return 1;
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.project = base.getContext().project;
        this.knownViewOptionsCounter = this.getVo().getModificationCount();
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? this.parentOfElement((BasicElement)node) : (basicNode instanceof HostFamily ? this.parentOfFamily((HostFamily)node) : (basicNode instanceof DataSourceNode ? this.getRoot() : (basicNode instanceof DvHostNode ? (BasicNode)((DvHostNode)node).host : null)));
    }

    private final BasicNode parentOfElement(BasicElement node) {
        return node instanceof BasicRoot ? this.getRoot() : (BasicNode)node.getParentFamily();
    }

    private final DataSourceNode dataSourceNode(BasicRoot $this$dataSourceNode) {
        BasicModel model;
        BasicModel basicModel = model = $this$dataSourceNode.getModel();
        return basicModel != null ? this.getDataSourceNodeFor(basicModel) : null;
    }

    private final BasicNode parentOfFamily(HostFamily<?> node) {
        DataSourceNode dsn;
        BasicElement basicElement = node.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicNode parent = basicElement;
        if (parent instanceof BasicRoot && (dsn = this.dataSourceNode((BasicRoot)parent)) != null) {
            parent = dsn;
        }
        return parent;
    }

    private final DataSourceNode getDataSourceNodeFor(DasModel model) {
        return model instanceof BasicModel ? this.getContext().modelRegistry.getDataSourceNode((BasicModel)model) : null;
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isAlwaysLeaf(node)) {
            JBIterable<Family<?>> jBIterable = JBIterable.empty();
            object = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        } else {
            BasicNode basicNode = node;
            if (basicNode instanceof BasicElement) {
                object = this.listElementFamilies((BasicElement)node);
            } else if (basicNode instanceof HostFamily) {
                object = this.listFamilyChildren((HostFamily)node);
            } else if (basicNode instanceof DataSourceNode) {
                object = ((DataSourceNode)node).getModelRoot();
                if (object == null || (object = object.getFamilies()) == null || (object = UtilKt.asJBIterable((Iterable)((Iterable)object))) == null) {
                    JBIterable jBIterable = JBIterable.empty();
                    object = jBIterable;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                }
            } else if (Intrinsics.areEqual((Object)basicNode, (Object)this.getRoot())) {
                object = this.listDataSources();
            } else {
                JBIterable jBIterable = JBIterable.empty();
                object = jBIterable;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            }
        }
        return object;
    }

    private final JBIterable<DataSourceNode> listDataSources() {
        Collection<DataSourceNode> content = this.dataSources.content();
        JBIterable jBIterable = JBIterable.from((Iterable)content);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    private final JBIterable<Family<?>> listElementFamilies(BasicElement element) {
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)element.getFamilies()).filter(arg_0 -> DvTreeModelLayer.listElementFamilies$lambda$2(arg_0 -> DvTreeModelLayer.listElementFamilies$lambda$1(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<? extends BasicNode> listFamilyChildren(HostFamily<?> family) {
        Object object;
        if (family.isEmpty()) {
            JBIterable<? extends BasicNode> jBIterable = JBIterable.empty();
            object = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        } else {
            ObjectKind objectKind = family.getChildrenKind();
            object = DbImplUtilCore.DATABASE_KINDS.contains(objectKind) ? this.listDatabases(family) : (DbImplUtilCore.SCHEMA_KINDS.contains(objectKind) ? this.listSchemas(family) : this.listRegularFamilyElements(family));
        }
        return object;
    }

    private final JBIterable<? extends BasicNode> listDatabases(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicNode> listSchemas(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicElement> listNamespacesToShow(HostFamily<?> family) {
        JBIterable jBIterable;
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        TreePattern scope2 = this.getScope(basicElement);
        if (scope2 == null) {
            JBIterable jBIterable2 = family.jbi();
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"jbi(...)");
        } else if (Intrinsics.areEqual((Object)scope2, (Object)TreePattern.EMPTY)) {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        } else {
            JBIterable jBIterable4 = family.jbi().filter(arg_0 -> DvTreeModelLayer.listNamespacesToShow$lambda$3(new Function1(scope2){
                final /* synthetic */ TreePattern $scope;
                {
                    this.$scope = $scope;
                }

                public final Boolean invoke(BasicElement it) {
                    return DataSourceSchemaMapping.matches(this.$scope, it);
                }
            }, arg_0));
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
        }
        JBIterable namespaces2 = jBIterable;
        return namespaces2;
    }

    private final JBIterable<? extends BasicElement> listRegularFamilyElements(HostFamily<?> family) {
        JBIterable jBIterable = family.jbi();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"jbi(...)");
        JBIterable children2 = jBIterable;
        Condition<DasObject> filter = this.getObjectFilterForRegularObjects(family.getModel());
        if (filter != null) {
            children2 = children2.filter(arg_0 -> DvTreeModelLayer.listRegularFamilyElements$lambda$4((Function1)new Function1<DasObject, Boolean>(filter){

                public final Boolean invoke(DasObject p0) {
                    return ((Condition)this.receiver).value((Object)p0);
                }
            }, arg_0));
        }
        if (!this.getVo().getShowGeneratedObjects()) {
            children2 = children2.filter(arg_0 -> DvTreeModelLayer.listRegularFamilyElements$lambda$5(listRegularFamilyElements.2.INSTANCE, arg_0));
        }
        return children2;
    }

    private final Condition<DasObject> getObjectFilterForRegularObjects(BasicModel model) {
        Condition<DasObject> condition;
        if (model == null) {
            return null;
        }
        RawDataSource rawDataSource = this.getContext().modelRegistry.getDataSource(model);
        if (rawDataSource == null) {
            return null;
        }
        RawDataSource ds = rawDataSource;
        try {
            condition = DbImplUtilCore.buildObjectFilter(ds);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        Condition<DasObject> filter = condition;
        return filter;
    }

    private final TreePattern getScope(BasicElement host) {
        if (this.getVo().getShowAllNamespaces()) {
            return null;
        }
        LocalDataSource localDataSource = this.getContext().modelRegistry.getLocalDataSource(host);
        if (localDataSource == null) {
            return null;
        }
        LocalDataSource lds = localDataSource;
        return lds.getIntrospectionScope();
    }

    private final Collection<DataSourceNode> retrieveAllDataSourceNodes() {
        BasicModelRegistry basicModelRegistry = this.getContext().modelRegistry;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        return basicModelRegistry.getDataSourceNodesForProject(project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof BasicElement)) return false;
        BasicMetaObject<?> o = ((BasicElement)node).getMetaObject();
        boolean bl = false;
        Intrinsics.checkNotNull(o);
        if (Companion.kindOfAny(o, alwaysLeafs)) return true;
        Intrinsics.checkNotNullExpressionValue(o.children, (String)"children");
        if (((Object[])o.children).length != 0) return false;
        return true;
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.addDSN(dataSource);
        }
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.removeDSN(dataSource);
        }
    }

    private final DataSourceNode getDSN(RawDataSource ds) {
        return this.getContext().modelRegistry.getDataSourceNode(ds);
    }

    private final void addDSN(RawDataSource ds) {
        DataSourceNode dsn = this.getDSN(ds);
        this.dataSources.include(dsn);
    }

    private final void removeDSN(RawDataSource ds) {
        this.dataSources.exclude((Function1<DataSourceNode, Boolean>)((Function1)arg_0 -> DvTreeModelLayer.removeDSN$lambda$7(ds, arg_0)));
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof Family ? ((Family)node).size() : (basicNode instanceof BasicElement ? ((BasicElement)node).getFamilies().size() : CollectionsKt.count((Iterable)((Iterable)this.childrenOf(node))));
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof Family ? this.countRealChildrenOfFamily((Family)node) : (basicNode instanceof BasicElement ? ((BasicElement)node).getFamilies().size() : CollectionsKt.count((Iterable)((Iterable)this.childrenOf(node))));
    }

    private final int countRealChildrenOfFamily(Family<?> family) {
        ObjectKind objectKind;
        return family instanceof HostFamily ? (Intrinsics.areEqual((Object)(objectKind = ((HostFamily)family).getChildrenKind()), (Object)ObjectKind.SCHEMA) ? this.listSchemas((HostFamily)family).size() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? this.listDatabases((HostFamily)family).size() : ((HostFamily)family).size())) : family.size();
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof HostFamily) {
            string = this.presentableNameOfFamily((HostFamily)node);
        } else {
            String string2 = node.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    private final String presentableNameOfFamily(HostFamily<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return DvFun.getFamilyPresentableName(family);
        }
        BasicModel model = basicModel;
        ModelHelper helper = ModelFun.getHelper(model);
        String customName = helper.getCustomName(family.getChildrenKind(), true);
        String string = customName;
        if (string == null) {
            string = DvFun.getFamilyPresentableName(family);
        }
        return string;
    }

    private final void invalidateCaches() {
        this.dataSources.invalidate();
    }

    @Override
    public void clearAll() {
        this.invalidateCaches();
    }

    @Override
    public boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return !(node instanceof BasicModElement) || !((BasicModElement)node).isDropped();
    }

    private static final Iterable dataSources$lambda$0(DvTreeModelLayer this$0) {
        return this$0.retrieveAllDataSourceNodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean listElementFamilies$lambda$1(DvTreeModelLayer this$0, Family f) {
        if (!(f instanceof HostFamily)) return false;
        BasicMetaObject<?> basicMetaObject = ((HostFamily)f).getMetaObject();
        Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
        if (Companion.kindOfAny(basicMetaObject, excluded)) return false;
        if (this$0.getVo().getHiddenKinds().contains(((HostFamily)f).getChildrenKind().code())) return false;
        if (this$0.getVo().getShowEmptyGroups()) return true;
        if (DbImplUtilCore.NAMESPACE_KINDS.contains(((HostFamily)f).getChildrenKind())) return true;
        if (!((HostFamily)f).isNotEmpty()) return false;
        return true;
    }

    private static final boolean listElementFamilies$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listNamespacesToShow$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listRegularFamilyElements$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listRegularFamilyElements$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeDSN$lambda$7(RawDataSource $ds, DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        return dsn.dataSource == $ds;
    }

    static {
        Object[] objectArray = new Class[]{BasicSequence.class, BasicSynonym.class, BasicRoutine.class};
        alwaysLeafs = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DvTreeModelLayer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer$Companion;", "", "<init>", "()V", "excluded", "", "Ljava/lang/Class;", "getExcluded", "()Ljava/util/List;", "alwaysLeafs", "getAlwaysLeafs", "kindOfAny", "", "Lcom/intellij/database/model/meta/BasicMetaObject;", "classes", "alwaysInvalidateAll", "getAlwaysInvalidateAll", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logErrorReturnNull", "", "message", "", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1755#2,3:265\n*S KotlinDebug\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer$Companion\n*L\n249#1:265,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Class<?>> getExcluded() {
            return excluded;
        }

        @NotNull
        public final List<Class<?>> getAlwaysLeafs() {
            return alwaysLeafs;
        }

        public final boolean kindOfAny(@NotNull BasicMetaObject<?> $this$kindOfAny, @NotNull List<? extends Class<?>> classes) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$kindOfAny, (String)"<this>");
                Intrinsics.checkNotNullParameter(classes, (String)"classes");
                Iterable $this$any$iv = classes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Class it = (Class)element$iv;
                        boolean bl2 = false;
                        if (!$this$kindOfAny.kindOf(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean getAlwaysInvalidateAll() {
            return Registry.Companion.is("database.view.layers.model.alwaysInvalidateAll");
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @Nullable
        public final Void logErrorReturnNull(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.getLogger().error(message);
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

