/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelperCore {
    protected DatabaseDialogsHelperCore() {
    }

    public static DdlBuilder createDdlBuilder(@NotNull DatabaseEditorContext context, boolean forCreate) {
        if (context == null) {
            DatabaseDialogsHelperCore.$$$reportNull$$$0(0);
        }
        return DatabaseDialogsHelperCore.createDdlBuilder(context.getProject(), context.getDialect(), context.getSqlDialect(), context.getCasingProvider(), forCreate).pushDefaultSchema(SearchPath.getCurrent(context.getSearchPath()));
    }

    public static DdlBuilder createDdlBuilder(@Nullable Project project, @NotNull DatabaseDialectEx dialect, SqlLanguageDialect sqlDialect, @Nullable CasingProvider provider, boolean forCreate) {
        if (dialect == null) {
            DatabaseDialogsHelperCore.$$$reportNull$$$0(1);
        }
        return DatabaseDialogsHelperCore.createDdlBuilder(forCreate).withDialect(dialect).applyCodeStyle(project, sqlDialect).withCasing((CasingProvider)ObjectUtils.chooseNotNull((Object)provider, (Object)dialect));
    }

    public static DdlBuilder createDdlBuilder(@NotNull DbElement source, boolean forCreate) {
        if (source == null) {
            DatabaseDialogsHelperCore.$$$reportNull$$$0(2);
        }
        return DatabaseDialogsHelperCore.createDdlBuilder(forCreate).configureFor(source).pushDefaultSchema(ObjectPaths.of(DbImplUtilCore.getSearchPathObject(source)));
    }

    public static DdlBuilder createDdlBuilder(final boolean forCreate) {
        return new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder newName(@NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.newName(newName);
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            @Override
            @NotNull
            public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name2) {
                boolean suppress;
                if (name2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                boolean bl = suppress = object != null && 1.isNameModifiedOrNew(object, name2);
                if (suppress) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.identifier(object, name2);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v1 = this;
                if (v1 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return v1;
            }

            @Override
            @NotNull
            public DdlBuilder constraintRef(@NotNull DasObject object) {
                boolean suppress;
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (suppress = 1.isNameModifiedOrNew(object, object.getName())) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.constraintRef(object);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return v0;
            }

            private static boolean isNameModifiedOrNew(@Nullable DasObject obj2, @NotNull String name2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return obj2 != null && !name2.equals(obj2.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelperCore$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelperCore$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "constraintRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "constraintRef";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "isNameModifiedOrNew";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        }.qualifyReferences(true).splitStatements(true).suppressQuoteIdentifiers(forCreate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/view/DatabaseDialogsHelperCore";
        objectArray[2] = "createDdlBuilder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

