/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\u0006\u0010\u001e\u001a\u00020\tR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\n\u00a8\u0006\""}, d2={"Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/model/basic/BasicNode;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "projectLocationHash", "", "<init>", "(Lcom/intellij/database/model/RawDataSource;Ljava/lang/String;)V", "isGlobal", "", "()Z", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "modelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getModelRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "groupName", "getGroupName", "()Ljava/lang/String;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getLocalDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "toString", "isIntrospectable", "levelAutoSelectable", "getLevelAutoSelectable", "Companion", "intellij.database.core.impl"})
public final class DataSourceNode
implements BasicNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final RawDataSource dataSource;
    @JvmField
    @Nullable
    public final String projectLocationHash;

    public DataSourceNode(@NotNull RawDataSource dataSource, @Nullable String projectLocationHash) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
        this.projectLocationHash = projectLocationHash;
    }

    public final boolean isGlobal() {
        return this.projectLocationHash == null;
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return dbms;
    }

    @Nullable
    public final BasicRoot getModelRoot() {
        BasicModel basicModel = this.getModel();
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public final String getGroupName() {
        return this.dataSource.getGroupName();
    }

    @Nullable
    public final LocalDataSource getLocalDataSource() {
        RawDataSource rawDataSource = this.dataSource;
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        DasModel dasModel = this.dataSource.getModel();
        return dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.dataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.dataSource.getName() + ": DSN";
    }

    public final boolean isIntrospectable() {
        DasModel dasModel = this.dataSource.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model = dasModel;
        if (model instanceof BasicModel) {
            return true;
        }
        return Intrinsics.areEqual((Object)model.getMetaModel(), (Object)MetaModel.EMPTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getLevelAutoSelectable() {
        if (!(this.dataSource instanceof LocalDataSource)) return false;
        Dbms dbms = ((LocalDataSource)this.dataSource).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) return false;
        return true;
    }

    @Deprecated(message="Use BasicModelRegistry.getDataSourceNode instead", replaceWith=@ReplaceWith(expression="BasicModelRegistry.instance().getDataSourceNode(dbDataSource.delegateDataSource)", imports={}), level=DeprecationLevel.WARNING)
    @JvmStatic
    @NotNull
    public static final DataSourceNode node(@NotNull DbDataSource $this$node) {
        return Companion.node($this$node);
    }

    @Deprecated(message="Use BasicModelRegistry.getDataSourceNodeIfExists instead", replaceWith=@ReplaceWith(expression="BasicModelRegistry.instance().getDataSourceNodeIfExists(dbDataSource.delegateDataSource)", imports={}), level=DeprecationLevel.WARNING)
    @JvmStatic
    @Nullable
    public static final DataSourceNode nodeIfExists(@NotNull DbDataSource $this$nodeIfExists) {
        return Companion.nodeIfExists($this$nodeIfExists);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/DataSourceNode$Companion;", "", "<init>", "()V", "node", "Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/psi/DbDataSource;", "nodeIfExists", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use BasicModelRegistry.getDataSourceNode instead", replaceWith=@ReplaceWith(expression="BasicModelRegistry.instance().getDataSourceNode(dbDataSource.delegateDataSource)", imports={}), level=DeprecationLevel.WARNING)
        @JvmStatic
        @NotNull
        public final DataSourceNode node(@NotNull DbDataSource $this$node) {
            Intrinsics.checkNotNullParameter((Object)$this$node, (String)"<this>");
            BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
            RawDataSource rawDataSource = $this$node.getDelegateDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
            return basicModelRegistry.getDataSourceNode(rawDataSource);
        }

        @Deprecated(message="Use BasicModelRegistry.getDataSourceNodeIfExists instead", replaceWith=@ReplaceWith(expression="BasicModelRegistry.instance().getDataSourceNodeIfExists(dbDataSource.delegateDataSource)", imports={}), level=DeprecationLevel.WARNING)
        @JvmStatic
        @Nullable
        public final DataSourceNode nodeIfExists(@NotNull DbDataSource $this$nodeIfExists) {
            Intrinsics.checkNotNullParameter((Object)$this$nodeIfExists, (String)"<this>");
            BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
            RawDataSource rawDataSource = $this$nodeIfExists.getDelegateDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
            return basicModelRegistry.getDataSourceNodeIfExists(rawDataSource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

