/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.IntrospectionTaskInnerHelper;
import com.intellij.database.introspection.IntrospectionTaskKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/database/introspection/SchemaFragmentIntrospectionTask;", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "dataSourceId", "", "databaseName", "schemaName", "fragments", "", "Lcom/intellij/database/introspection/FamilyFragment;", "checkForDroppedObjects", "", "forceL3", "forceFragmentMode", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;ZZZ)V", "getSchemaName", "()Ljava/lang/String;", "getFragments", "()Ljava/util/Collection;", "getCheckForDroppedObjects", "()Z", "getForceL3", "getForceFragmentMode", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "namesCount", "", "getNamesCount", "()I", "toString", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nIntrospectionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrospectionTask.kt\ncom/intellij/database/introspection/SchemaFragmentIntrospectionTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,467:1\n1#2:468\n*E\n"})
public final class SchemaFragmentIntrospectionTask
extends DefiniteIntrospectionTask {
    @NotNull
    private final String schemaName;
    @NotNull
    private final Collection<FamilyFragment> fragments;
    private final boolean checkForDroppedObjects;
    private final boolean forceL3;
    private final boolean forceFragmentMode;
    private final int namesCount;

    public SchemaFragmentIntrospectionTask(@NotNull String dataSourceId, @NotNull String databaseName, @NotNull String schemaName, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects, boolean forceL3, boolean forceFragmentMode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        super(dataSourceId, databaseName, null);
        this.schemaName = schemaName;
        this.fragments = fragments2;
        this.checkForDroppedObjects = checkForDroppedObjects;
        this.forceL3 = forceL3;
        this.forceFragmentMode = forceFragmentMode;
        Iterable iterable = this.fragments;
        SchemaFragmentIntrospectionTask schemaFragmentIntrospectionTask = this;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        FamilyFragment f = (FamilyFragment)iterator.next();
        boolean bl = false;
        int n2 = f.getSize();
        while (iterator.hasNext()) {
            FamilyFragment f2 = (FamilyFragment)iterator.next();
            $i$a$-maxOf-SchemaFragmentIntrospectionTask$namesCount$1 = false;
            int n3 = f2.getSize();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        schemaFragmentIntrospectionTask.namesCount = n = n2;
        IntrospectionTaskInnerHelper.INSTANCE.recordCreation$intellij_database_core_impl(this);
    }

    public /* synthetic */ SchemaFragmentIntrospectionTask(String string, String string2, String string3, Collection collection, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        this(string, string2, string3, collection, bl, bl2, bl3);
    }

    @NotNull
    public final String getSchemaName() {
        return this.schemaName;
    }

    @NotNull
    public final Collection<FamilyFragment> getFragments() {
        return this.fragments;
    }

    public final boolean getCheckForDroppedObjects() {
        return this.checkForDroppedObjects;
    }

    public final boolean getForceL3() {
        return this.forceL3;
    }

    public final boolean getForceFragmentMode() {
        return this.forceFragmentMode;
    }

    @Override
    public byte getTaskTypeOrder() {
        return 12;
    }

    public final int getNamesCount() {
        return this.namesCount;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.fragments.size();
        $this$toString_u24lambda_u241.append("Introspect schema fragments in the database " + this.getDatabaseName() + " schema " + this.schemaName + " ");
        $this$toString_u24lambda_u241.append(IntrospectionTaskKt.access$describeFragments(this.fragments));
        $this$toString_u24lambda_u241.append("\twith checking for dropped objects: ").append(this.checkForDroppedObjects ? "yes" : "no");
        if (this.forceFragmentMode) {
            $this$toString_u24lambda_u241.append(" (force fragment mode)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u241.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

