/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.oracle.introspector.HeavyStrategy;
import com.intellij.database.dialects.oracle.introspector.MiniStrategy;
import com.intellij.database.dialects.oracle.introspector.SimpleStrategy;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.text.StringKt;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fH\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010\u001cR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u0082\u0001\u0003\u001e\u001f \u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraLevelAutoSelectionStrategy;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "tracer", "Ljava/util/function/Consumer;", "getTracer", "()Ljava/util/function/Consumer;", "setTracer", "(Ljava/util/function/Consumer;)V", "setup", "", "selectSchemaLevel", "Lcom/intellij/database/model/properties/Level;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "trace", "message", "(Ljava/lang/String;)Lkotlin/Unit;", "Companion", "Lcom/intellij/database/dialects/oracle/introspector/HeavyStrategy;", "Lcom/intellij/database/dialects/oracle/introspector/MiniStrategy;", "Lcom/intellij/database/dialects/oracle/introspector/SimpleStrategy;", "intellij.database.dialects.oracle"})
public abstract class OraLevelAutoSelectionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected Project project;
    @Nullable
    private Consumer<String> tracer;
    @NotNull
    private static final Logger log;

    private OraLevelAutoSelectionStrategy() {
    }

    @NotNull
    protected abstract String getName();

    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    protected final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Nullable
    protected final Consumer<String> getTracer() {
        return this.tracer;
    }

    protected final void setTracer(@Nullable Consumer<String> consumer) {
        this.tracer = consumer;
    }

    protected final void setup(@NotNull Project project, @Nullable Consumer<String> tracer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
        this.tracer = tracer;
        this.trace("Using level selection strategy " + this.getName());
    }

    @NotNull
    public abstract Level selectSchemaLevel(@NotNull OraSchema var1);

    @Nullable
    protected final Unit trace(@NotNull String message) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Consumer<String> consumer = this.tracer;
        if (consumer != null) {
            consumer.accept(message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @JvmStatic
    @NotNull
    public static final OraLevelAutoSelectionStrategy prepareStrategy(@NotNull Project project, @Nullable Consumer<String> trace) {
        return Companion.prepareStrategy(project, trace);
    }

    @NotNull
    protected static final Logger getLog() {
        return Companion.getLog();
    }

    public /* synthetic */ OraLevelAutoSelectionStrategy(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Logger logger2 = Logger.getInstance(OraLevelAutoSelectionStrategy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rH\u0007R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\u000e\u001a\u00020\u000f8\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraLevelAutoSelectionStrategy$Companion;", "", "<init>", "()V", "strategyName", "", "getStrategyName", "()Ljava/lang/String;", "prepareStrategy", "Lcom/intellij/database/dialects/oracle/introspector/OraLevelAutoSelectionStrategy;", "project", "Lcom/intellij/openapi/project/Project;", "trace", "Ljava/util/function/Consumer;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog$annotations", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        private final String getStrategyName() {
            String string;
            String string2 = StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)Registry.Companion.get("database.introspection.level.auto.select.strategy").asString())).toString(), (boolean)false, (int)1, null);
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string4 = string3.toUpperCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final OraLevelAutoSelectionStrategy prepareStrategy(@NotNull Project project, @Nullable Consumer<String> trace) {
            String name2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = name2 = this.getStrategyName();
            OraLevelAutoSelectionStrategy strategy = Intrinsics.areEqual((Object)string, (Object)"MINI") ? (OraLevelAutoSelectionStrategy)new MiniStrategy() : (Intrinsics.areEqual((Object)string, (Object)"HEAVY") ? (OraLevelAutoSelectionStrategy)new HeavyStrategy() : (OraLevelAutoSelectionStrategy)new SimpleStrategy());
            strategy.setup(project, trace);
            return strategy;
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        @JvmStatic
        protected static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

