/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\f\b\u0007\u0018\u0000 52\u00020\u0001:\u000556789B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J(\u0010\u0014\u001a\u00020\r\"\b\b\u0000\u0010\u0015*\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002J \u0010\u0019\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\tJ\u0010\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010&\u001a\u00020\tJ\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010'\u001a\u00020(J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\tJ\u0010\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020(J\u0010\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\tJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070.J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070.2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u00100\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u00101\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u00102\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u00103\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u00104\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/database/BasicModelRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "dataSources", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/view/DataSourceNode;", "models", "Lcom/intellij/database/model/basic/BasicModel;", "disposed", "", "subscribeToAllProjectsDataSourcesNotifications", "", "subscribeToProjectDataSourcesNotifications", "project", "Lcom/intellij/openapi/project/Project;", "recollectAllDataSources", "collectAllDataSources", "collectAllDataSourcesUsingManagers", "collectDataSourcesFromOneManager", "D", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "collectAllDataSourcesUsingStorages", "registerDataSourcesAndModels", "Lkotlin/sequences/Sequence;", "registerDSN", "ds", "ensureDSN", "instantiateNewDSN", "findProjectHard", "dataSource", "handleDataSourceModelPossiblyChanged", "invalidateModelByDSN", "dsn", "deregisterDSN", "getDataSource", "model", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getLocalDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDataSourceNode", "getDataSourceNodeIfExists", "getAllDataSourceNodes", "", "getDataSourceNodesForProject", "dataSourceIsApplicableToTheProject", "onDataSourceAdded", "onDataSourceChangeNotified", "onDataSourceRemoved", "dispose", "Companion", "DataSourceListener", "StorageListener", "ManagerListener", "ProjectManagerEventListener", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nBasicModelRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicModelRegistry.kt\ncom/intellij/database/BasicModelRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1#2:307\n*E\n"})
public final class BasicModelRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<RawDataSource, DataSourceNode> dataSources;
    @NotNull
    private final Cache<BasicModel, DataSourceNode> models;
    private boolean disposed;
    @NotNull
    private static final String LIST_DATA_SOURCE_WAY_KEY = "database.datasource.registry.using.storages";
    @NotNull
    private static final Logger logger;

    public BasicModelRegistry() {
        Cache cache2 = Caffeine.newBuilder().weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.dataSources = cache2;
        Cache cache3 = Caffeine.newBuilder().weakKeys().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.models = cache3;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic<AbstractDataSource.Listener> topic = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DataSourceListener());
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new StorageListener(null));
        Topic topic3 = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        messageBusConnection.subscribe(topic3, (Object)new ProjectManagerEventListener());
        this.subscribeToAllProjectsDataSourcesNotifications();
        this.collectAllDataSources();
    }

    private final void subscribeToAllProjectsDataSourcesNotifications() {
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            this.subscribeToProjectDataSourcesNotifications(p2);
        }
    }

    private final void subscribeToProjectDataSourcesNotifications(Project project) {
        ManagerListener managerListener = new ManagerListener(project);
        StorageListener storageListener = new StorageListener(project);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Topic<DataSourceManager.Listener> topic = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)managerListener);
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)storageListener);
    }

    private final void recollectAllDataSources() {
        this.models.invalidateAll();
        this.dataSources.invalidateAll();
        this.collectAllDataSources();
    }

    private final void collectAllDataSources() {
        boolean bl = BasicModelRegistry.Companion.getListDataSourcesUsingStorages();
        if (!bl) {
            this.collectAllDataSourcesUsingManagers();
        } else if (bl) {
            this.collectAllDataSourcesUsingStorages();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void collectAllDataSourcesUsingManagers() {
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            List<DataSourceManager<?>> list = DataSourceManager.getManagers(p2);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getManagers(...)");
            Collection managers = list;
            for (DataSourceManager manager : managers) {
                this.collectDataSourcesFromOneManager(manager, p2);
            }
        }
    }

    private final <D extends RawDataSource> void collectDataSourcesFromOneManager(DataSourceManager<D> manager, Project project) {
        List<D> list = manager.getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        Collection dataSources = list;
        for (RawDataSource ds : dataSources) {
            this.registerDSN(ds, project);
        }
    }

    private final void collectAllDataSourcesUsingStorages() {
        List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        List<LocalDataSource> globalDataSources = list;
        this.registerDataSourcesAndModels((Sequence<? extends RawDataSource>)CollectionsKt.asSequence((Iterable)globalDataSources), null);
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            List<LocalDataSource> list2 = DataSourceStorage.getProjectStorage(p2).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getDataSources(...)");
            Sequence projectDataSources = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)list2), BasicModelRegistry::collectAllDataSourcesUsingStorages$lambda$0);
            this.registerDataSourcesAndModels((Sequence<? extends RawDataSource>)projectDataSources, p2);
        }
    }

    private final void registerDataSourcesAndModels(Sequence<? extends RawDataSource> dataSources, Project project) {
        for (RawDataSource ds : dataSources) {
            this.registerDSN(ds, project);
        }
    }

    private final void registerDSN(RawDataSource ds, Project project) {
        BasicModel m;
        DataSourceNode dsn = this.ensureDSN(ds, project);
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (m != null) {
            this.models.put((Object)m, (Object)dsn);
        }
    }

    private final DataSourceNode ensureDSN(RawDataSource ds, Project project) {
        Object object = this.dataSources.get((Object)ds, arg_0 -> BasicModelRegistry.ensureDSN$lambda$2(arg_0 -> BasicModelRegistry.ensureDSN$lambda$1(this, ds, project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (DataSourceNode)object;
    }

    private final DataSourceNode instantiateNewDSN(RawDataSource ds, Project project) {
        Project p2;
        Project project2;
        if (ds.isGlobal()) {
            project2 = null;
        } else {
            project2 = project;
            if (project2 == null) {
                project2 = ds instanceof SqlDataSource ? ((SqlDataSource)ds).getProject() : this.findProjectHard(ds);
            }
        }
        Project project3 = p2 = project2;
        String projectLocationHash = project3 != null ? project3.getLocationHash() : null;
        return new DataSourceNode(ds, projectLocationHash);
    }

    private final Project findProjectHard(RawDataSource dataSource) {
        for (Project project : BasicModelRegistry.Companion.listOpenedProjects()) {
            if (DataSourceManager.byDataSource(project, dataSource) == null) continue;
            return project;
        }
        String message = "Cannot found a project for data source (" + dataSource + ")";
        logger.warn(message, (Throwable)new Exception(message));
        return null;
    }

    private final void handleDataSourceModelPossiblyChanged(RawDataSource ds) {
        BasicModel m;
        DataSourceNode dsn = (DataSourceNode)this.dataSources.getIfPresent((Object)ds);
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (dsn == null && m == null) {
            return;
        }
        if (m != null) {
            DataSourceNode dataSourceNode = dsn;
            if (dataSourceNode == null) {
                dataSourceNode = this.ensureDSN(ds, null);
            }
            dsn = dataSourceNode;
            this.models.put((Object)m, (Object)dsn);
        } else if (dsn != null) {
            this.invalidateModelByDSN(dsn);
        }
    }

    private final void invalidateModelByDSN(DataSourceNode dsn) {
        Sequence ms = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.models.asMap().entrySet()), arg_0 -> BasicModelRegistry.invalidateModelByDSN$lambda$3(dsn, arg_0)), BasicModelRegistry::invalidateModelByDSN$lambda$4);
        for (BasicModel m : ms) {
            this.models.invalidate((Object)m);
        }
    }

    private final void deregisterDSN(RawDataSource ds) {
        BasicModel m;
        this.dataSources.invalidate((Object)ds);
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (m != null) {
            this.models.invalidate((Object)m);
        }
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DataSourceNode dataSourceNode = (DataSourceNode)this.models.getIfPresent((Object)model);
        return dataSourceNode != null ? dataSourceNode.dataSource : null;
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        return this.getDataSource(model);
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RawDataSource rawDataSource = this.getDataSource(model);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RawDataSource rawDataSource = this.getDataSource(element);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @NotNull
    public final DataSourceNode getDataSourceNode(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Object object = this.dataSources.get((Object)dataSource, arg_0 -> BasicModelRegistry.getDataSourceNode$lambda$6(arg_0 -> BasicModelRegistry.getDataSourceNode$lambda$5(this, dataSource, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (DataSourceNode)object;
    }

    @Nullable
    public final DataSourceNode getDataSourceNode(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (DataSourceNode)this.models.getIfPresent((Object)model);
    }

    @Nullable
    public final DataSourceNode getDataSourceNode(@NotNull BasicElement element) {
        DataSourceNode dataSourceNode;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        if (basicModel != null) {
            BasicModel p0 = basicModel;
            boolean $i$f$getDataSourceNode$stub_for_inlining = false;
            boolean bl = false;
            dataSourceNode = this.getDataSourceNode(p0);
        } else {
            dataSourceNode = null;
        }
        return dataSourceNode;
    }

    @Nullable
    public final DataSourceNode getDataSourceNodeIfExists(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (DataSourceNode)this.dataSources.getIfPresent((Object)dataSource);
    }

    @Nullable
    public final DataSourceNode getDataSourceNodeIfExists(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (DataSourceNode)this.models.getIfPresent((Object)model);
    }

    @NotNull
    public final Collection<DataSourceNode> getAllDataSourceNodes() {
        this.dataSources.cleanUp();
        return CollectionsKt.toList((Iterable)this.dataSources.asMap().values());
    }

    @NotNull
    public final Collection<DataSourceNode> getDataSourceNodesForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List nodes2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.dataSources.asMap().values()), arg_0 -> BasicModelRegistry.getDataSourceNodesForProject$lambda$7(this, project, arg_0)));
        return nodes2;
    }

    private final boolean dataSourceIsApplicableToTheProject(DataSourceNode dsn, Project project) {
        return dsn.isGlobal() || Intrinsics.areEqual((Object)dsn.projectLocationHash, (Object)project.getLocationHash());
    }

    private final void onDataSourceAdded(RawDataSource dataSource, Project project) {
        this.registerDSN(dataSource, project);
    }

    private final void onDataSourceChangeNotified(RawDataSource dataSource) {
        if (dataSource == null) {
            this.recollectAllDataSources();
        } else {
            this.handleDataSourceModelPossiblyChanged(dataSource);
        }
    }

    private final void onDataSourceRemoved(RawDataSource dataSource) {
        this.deregisterDSN(dataSource);
    }

    public void dispose() {
        this.disposed = true;
        this.models.invalidateAll();
        this.dataSources.invalidateAll();
    }

    private static final boolean collectAllDataSourcesUsingStorages$lambda$0(LocalDataSource it) {
        return it.isGlobal();
    }

    private static final DataSourceNode ensureDSN$lambda$1(BasicModelRegistry this$0, RawDataSource $ds, Project $project, RawDataSource it) {
        return this$0.instantiateNewDSN($ds, $project);
    }

    private static final DataSourceNode ensureDSN$lambda$2(Function1 $tmp0, Object p0) {
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final boolean invalidateModelByDSN$lambda$3(DataSourceNode $dsn, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        DataSourceNode d = (DataSourceNode)entry.getValue();
        return d == $dsn;
    }

    private static final BasicModel invalidateModelByDSN$lambda$4(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        BasicModel m = (BasicModel)entry.getKey();
        return m;
    }

    private static final DataSourceNode getDataSourceNode$lambda$5(BasicModelRegistry this$0, RawDataSource $dataSource, RawDataSource it) {
        return this$0.ensureDSN($dataSource, null);
    }

    private static final DataSourceNode getDataSourceNode$lambda$6(Function1 $tmp0, Object p0) {
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final boolean getDataSourceNodesForProject$lambda$7(BasicModelRegistry this$0, Project $project, DataSourceNode it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.dataSourceIsApplicableToTheProject(it, $project);
    }

    @JvmStatic
    @NotNull
    public static final BasicModelRegistry instance() {
        return Companion.instance();
    }

    static {
        Logger logger2 = Logger.getInstance(BasicModelRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0015\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/BasicModelRegistry$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/database/BasicModelRegistry;", "LIST_DATA_SOURCE_WAY_KEY", "", "listDataSourcesUsingStorages", "", "getListDataSourcesUsingStorages", "()Z", "listOpenedProjects", "", "Lcom/intellij/openapi/project/Project;", "()[Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BasicModelRegistry instance() {
            Object object = ApplicationManager.getApplication().getService(BasicModelRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BasicModelRegistry)object;
        }

        private final boolean getListDataSourcesUsingStorages() {
            return Registry.Companion.is(BasicModelRegistry.LIST_DATA_SOURCE_WAY_KEY);
        }

        private final Project[] listOpenedProjects() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            return projectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/BasicModelRegistry$DataSourceListener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "onModelReplaced", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "intellij.database.core.impl"})
    private final class DataSourceListener
    implements AbstractDataSource.Listener {
        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            DataSourceNode dsn = (DataSourceNode)BasicModelRegistry.this.dataSources.getIfPresent((Object)dataSource);
            if (oldModel != null) {
                BasicModelRegistry.this.models.invalidate((Object)oldModel);
            }
            if (newModel != null && dsn != null) {
                BasicModelRegistry.this.models.put((Object)newModel, (Object)dsn);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0010\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u0001H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0011\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/BasicModelRegistry$ManagerListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "dataSourceChanged", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class ManagerListener
    implements DataSourceManager.Listener {
        @NotNull
        private final Project project;

        public ManagerListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            BasicModelRegistry.this.registerDSN(dataSource, this.project);
        }

        @Override
        public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource) {
            BasicModelRegistry.this.onDataSourceChangeNotified(dataSource);
        }

        @Override
        public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            BasicModelRegistry.this.onDataSourceRemoved(dataSource);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/BasicModelRegistry$ProjectManagerEventListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosed", "intellij.database.core.impl"})
    private final class ProjectManagerEventListener
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BasicModelRegistry.this.subscribeToProjectDataSourcesNotifications(project);
        }

        public void projectClosed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DvTreeInternalFunKt.invalidateEntriesThat(BasicModelRegistry.this.models, (arg_0, arg_1) -> ProjectManagerEventListener.projectClosed$lambda$0(project, arg_0, arg_1));
        }

        private static final boolean projectClosed$lambda$0(Project $project, BasicModel basicModel, DataSourceNode dsn) {
            Intrinsics.checkNotNullParameter((Object)basicModel, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return Intrinsics.areEqual((Object)dsn.projectLocationHash, (Object)$project.getLocationHash());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/BasicModelRegistry$StorageListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceAdded", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceChanged", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class StorageListener
    implements DataSourceStorage.Listener {
        @Nullable
        private final Project project;

        public StorageListener(Project project) {
            this.project = project;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            BasicModelRegistry.this.onDataSourceAdded(dataSource, this.project);
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            BasicModelRegistry.this.onDataSourceChangeNotified(dataSource);
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            BasicModelRegistry.this.onDataSourceRemoved(dataSource);
        }
    }
}

