/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.IntBinder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SafeStatementPointer;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteStatement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/sqlite/SqliteIntPreparedStatement;", "Lorg/jetbrains/sqlite/SqliteStatement;", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "sql", "", "<init>", "(Lorg/jetbrains/sqlite/SqliteConnection;Ljava/lang/String;)V", "pointer", "Lorg/jetbrains/sqlite/SafeStatementPointer;", "binder", "Lorg/jetbrains/sqlite/IntBinder;", "getBinder", "()Lorg/jetbrains/sqlite/IntBinder;", "close", "", "toString", "ensureCapacity", "count", "", "addBatch", "executeBatch", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteIntPreparedStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteIntPreparedStatement.kt\norg/jetbrains/sqlite/SqliteIntPreparedStatement\n+ 2 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n*L\n1#1,54:1\n67#2,6:55\n67#2,6:61\n67#2,6:67\n*S KotlinDebug\n*F\n+ 1 SqliteIntPreparedStatement.kt\norg/jetbrains/sqlite/SqliteIntPreparedStatement\n*L\n11#1:55,6\n23#1:61,6\n44#1:67,6\n*E\n"})
public final class SqliteIntPreparedStatement
implements SqliteStatement {
    @NotNull
    private final SqliteConnection connection;
    @NotNull
    private final String sql;
    @NotNull
    private final SafeStatementPointer pointer;
    @NotNull
    private final IntBinder binder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqliteIntPreparedStatement(@NotNull SqliteConnection connection, @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        this.connection = connection;
        this.sql = sql2;
        SafeStatementPointer pointer = null;
        int paramCount = 0;
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            pointer = db.addStatement(new SafeStatementPointer(this.connection, db.prepare_utf8(StringsKt.encodeToByteArray((String)this.sql))));
            SafeStatementPointer safeStatementPointer = pointer;
            if (safeStatementPointer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pointer");
                safeStatementPointer = null;
            }
            paramCount = db.bind_parameter_count(safeStatementPointer.pointer);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (!(paramCount > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.pointer = pointer;
        this.binder = new IntBinder(paramCount, paramCount * 2);
    }

    @NotNull
    public final IntBinder getBinder() {
        return this.binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            this.pointer.close$intellij_platform_sqlite(db);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        return this.sql;
    }

    public final void ensureCapacity(int count) {
        this.binder.ensureCapacity$intellij_platform_sqlite(count);
    }

    public final void addBatch() {
        this.binder.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatch() {
        if (this.binder.getBatchQueryCount() == 0) {
            return;
        }
        try {
            SqliteConnection this_$iv = this.connection;
            boolean $i$f$useDb$intellij_platform_sqlite = false;
            if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
                throw new AlreadyClosedException();
            }
            Lock lock = SqliteConnection.access$getLock$p(this_$iv);
            lock.lock();
            try {
                boolean bl = false;
                NativeDB db = SqliteConnection.access$getDb(this_$iv);
                boolean bl2 = false;
                this.pointer.ensureOpen();
                this.binder.executeBatch$intellij_platform_sqlite(this.pointer.pointer, db);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.binder.clearBatch$intellij_platform_sqlite();
        }
    }
}

