/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import com.thaiopensource.validate.nrl.FilteredAttributes;
import com.thaiopensource.validate.nrl.Hashset;
import com.thaiopensource.validate.nrl.IntSet;
import com.thaiopensource.validate.nrl.Mode;
import com.thaiopensource.validate.nrl.ModeUsage;
import com.thaiopensource.validate.nrl.NoResultAction;
import com.thaiopensource.validate.nrl.ResultAction;
import com.thaiopensource.validate.nrl.SectionState;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ValidatorImpl
extends DefaultHandler
implements Validator {
    private static final String BEARER_URI = "";
    private static final String BEARER_LOCAL_NAME = "#bearer";
    private static final String NO_NS = "\u0000";
    private final ErrorHandler eh;
    private final PropertyMap properties;
    private Locator locator;
    private Section currentSection;
    private PrefixMapping prefixMapping = null;
    private final Hashtable validatorHandlerCache = new Hashtable();
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$nrl$ValidatorImpl == null ? (class$com$thaiopensource$validate$nrl$ValidatorImpl = ValidatorImpl.class$("com.thaiopensource.validate.nrl.ValidatorImpl")) : class$com$thaiopensource$validate$nrl$ValidatorImpl);
    private final Hashset noResultActions = new Hashset();
    private final Hashtable attributeNamespaceIndexSets = new Hashtable();
    private final Vector activeHandlersAttributeIndexSets = new Vector();
    private final Hashset attributeSchemas = new Hashset();
    private boolean attributeNamespaceRejected;
    private Attributes filteredAttributes;
    private final Mode startMode;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$ValidatorImpl;

    ValidatorImpl(Mode mode, PropertyMap propertyMap) {
        this.properties = propertyMap;
        this.eh = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        this.startMode = mode;
        this.initCurrentSection();
    }

    private void initCurrentSection() {
        this.currentSection = new Section(NO_NS, null);
        this.currentSection.addChildMode(new ModeUsage(this.startMode, this.startMode), null);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = 0;
        int n4 = this.currentSection.activeHandlers.size();
        while (n3 < n4) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(n3)).characters(cArray, n, n2);
            ++n3;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        int n3 = 0;
        int n4 = this.currentSection.activeHandlers.size();
        while (n3 < n4) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(n3)).ignorableWhitespace(cArray, n, n2);
            ++n3;
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (!string2.equals(this.currentSection.ns)) {
            this.startSection(string2);
        }
        ++this.currentSection.depth;
        if (this.currentSection.contextDependent) {
            this.currentSection.context.push(string3);
        }
        boolean bl = this.processAttributes(attributes);
        int n = 0;
        int n2 = this.currentSection.activeHandlers.size();
        while (n < n2) {
            ContentHandler contentHandler = (ContentHandler)this.currentSection.activeHandlers.elementAt(n);
            contentHandler.startElement(string2, string3, string4, bl ? ValidatorImpl.filterAttributes((IntSet)this.activeHandlersAttributeIndexSets.elementAt(n), attributes) : attributes);
            ++n;
        }
    }

    private static Attributes filterAttributes(IntSet intSet, Attributes attributes) {
        if (intSet.size() == attributes.getLength()) {
            return attributes;
        }
        return new FilteredAttributes(intSet, attributes);
    }

    private boolean processAttributes(Attributes attributes) throws SAXException {
        Object object;
        if (this.currentSection.attributeProcessing == 0 || attributes.getLength() == 0) {
            return false;
        }
        this.attributeNamespaceIndexSets.clear();
        int n = 0;
        int n2 = attributes.getLength();
        while (n < n2) {
            object = attributes.getURI(n);
            IntSet intSet = (IntSet)this.attributeNamespaceIndexSets.get(object);
            if (intSet == null) {
                intSet = new IntSet();
                this.attributeNamespaceIndexSets.put(object, intSet);
            }
            intSet.add(n);
            ++n;
        }
        if (this.currentSection.attributeProcessing == 1 && this.attributeNamespaceIndexSets.size() == 1 && this.attributeNamespaceIndexSets.get(BEARER_URI) != null) {
            return false;
        }
        object = this.currentSection.activeHandlersAttributeModeUsage;
        this.activeHandlersAttributeIndexSets.setSize(((Vector)object).size());
        int n3 = 0;
        int n4 = ((Vector)object).size();
        while (n3 < n4) {
            this.activeHandlersAttributeIndexSets.setElementAt(new IntSet(), n3);
            ++n3;
        }
        boolean bl = false;
        Vector vector = this.currentSection.attributeValidationModeUsages;
        Enumeration enumeration = this.attributeNamespaceIndexSets.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            IntSet intSet = (IntSet)this.attributeNamespaceIndexSets.get(string2);
            this.attributeSchemas.clear();
            this.filteredAttributes = null;
            this.attributeNamespaceRejected = false;
            int n5 = 0;
            int n6 = ((Vector)object).size();
            while (n5 < n6) {
                ModeUsage modeUsage = (ModeUsage)((Vector)object).elementAt(n5);
                AttributeActionSet attributeActionSet = this.processAttributeSection(modeUsage, string2, intSet, attributes);
                if (attributeActionSet.getAttach()) {
                    ((IntSet)this.activeHandlersAttributeIndexSets.get(n5)).addAll(intSet);
                } else {
                    bl = true;
                }
                ++n5;
            }
            int n7 = 0;
            int n8 = vector.size();
            while (n7 < n8) {
                ModeUsage modeUsage = (ModeUsage)vector.elementAt(n7);
                this.processAttributeSection(modeUsage, string2, intSet, attributes);
                ++n7;
            }
        }
        return bl;
    }

    private AttributeActionSet processAttributeSection(ModeUsage modeUsage, String string2, IntSet intSet, Attributes attributes) throws SAXException {
        Mode mode = modeUsage.getMode(this.currentSection.context);
        AttributeActionSet attributeActionSet = mode.getAttributeActions(string2);
        if (attributeActionSet.getReject() && !this.attributeNamespaceRejected) {
            this.attributeNamespaceRejected = true;
            if (this.eh != null) {
                this.eh.error(new SAXParseException(this.localizer.message("reject_attribute", string2), this.locator));
            }
        }
        Schema[] schemaArray = attributeActionSet.getSchemas();
        int n = 0;
        while (n < schemaArray.length) {
            if (!this.attributeSchemas.contains(schemaArray[n])) {
                this.attributeSchemas.add(schemaArray[n]);
                if (this.filteredAttributes == null) {
                    this.filteredAttributes = ValidatorImpl.filterAttributes(intSet, attributes);
                }
                this.validateAttributes(schemaArray[n], this.filteredAttributes);
            }
            ++n;
        }
        return attributeActionSet;
    }

    private void validateAttributes(Schema schema, Attributes attributes) throws SAXException {
        Validator validator = this.createValidator(schema);
        ContentHandler contentHandler = validator.getContentHandler();
        this.initHandler(contentHandler);
        contentHandler.startElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME, attributes);
        contentHandler.endElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME);
        this.cleanupHandler(contentHandler);
        this.releaseValidator(schema, validator);
    }

    private void startSection(String string2) throws SAXException {
        Section section = new Section(string2, this.currentSection);
        Vector vector = this.currentSection.childPrograms;
        this.noResultActions.clear();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Program program2 = (Program)vector.elementAt(n);
            ActionSet actionSet = program2.modeUsage.getMode(this.currentSection.context).getElementActions(string2);
            ResultAction resultAction = actionSet.getResultAction();
            if (resultAction != null) {
                resultAction.perform(program2.handler, section);
            }
            NoResultAction[] noResultActionArray = actionSet.getNoResultActions();
            int n3 = 0;
            while (n3 < noResultActionArray.length) {
                NoResultAction noResultAction = noResultActionArray[n3];
                if (!this.noResultActions.contains(noResultAction)) {
                    noResultActionArray[n3].perform(section);
                    this.noResultActions.add(noResultAction);
                }
                ++n3;
            }
            ++n;
        }
        int n4 = 0;
        int n5 = section.validators.size();
        while (n4 < n5) {
            this.initHandler(((Validator)section.validators.elementAt(n4)).getContentHandler());
            ++n4;
        }
        this.currentSection = section;
    }

    private void initHandler(ContentHandler contentHandler) throws SAXException {
        if (this.locator != null) {
            contentHandler.setDocumentLocator(this.locator);
        }
        contentHandler.startDocument();
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.startPrefixMapping(prefixMapping.prefix, prefixMapping.uri);
            prefixMapping = prefixMapping.parent;
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        int n = 0;
        int n2 = this.currentSection.activeHandlers.size();
        while (n < n2) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(n)).endElement(string2, string3, string4);
            ++n;
        }
        --this.currentSection.depth;
        if (this.currentSection.contextDependent) {
            this.currentSection.context.pop();
        }
        if (this.currentSection.depth == 0) {
            this.endSection();
        }
    }

    private void endSection() throws SAXException {
        int n = 0;
        int n2 = this.currentSection.validators.size();
        while (n < n2) {
            Validator validator = (Validator)this.currentSection.validators.elementAt(n);
            this.cleanupHandler(validator.getContentHandler());
            this.releaseValidator((Schema)this.currentSection.schemas.elementAt(n), validator);
            this.currentSection.validators.setElementAt(null, n);
            ++n;
        }
        this.currentSection = this.currentSection.parent;
    }

    private void cleanupHandler(ContentHandler contentHandler) throws SAXException {
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.endPrefixMapping(prefixMapping.prefix);
            prefixMapping = prefixMapping.parent;
        }
        contentHandler.endDocument();
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        super.startPrefixMapping(string2, string3);
        this.prefixMapping = new PrefixMapping(string2, string3, this.prefixMapping);
    }

    public void endPrefixMapping(String string2) throws SAXException {
        super.endPrefixMapping(string2);
        this.prefixMapping = this.prefixMapping.parent;
    }

    private Validator createValidator(Schema schema) {
        Stack stack = (Stack)this.validatorHandlerCache.get(schema);
        if (stack == null) {
            stack = new Stack();
            this.validatorHandlerCache.put(schema, stack);
        }
        if (stack.empty()) {
            return schema.createValidator(this.properties);
        }
        return (Validator)stack.pop();
    }

    private void releaseValidator(Schema schema, Validator validator) {
        if (validator == null) {
            return;
        }
        validator.reset();
        ((Stack)this.validatorHandlerCache.get(schema)).push(validator);
    }

    public void reset() {
        while (this.currentSection != null) {
            int n = 0;
            int n2 = this.currentSection.validators.size();
            while (n < n2) {
                this.releaseValidator((Schema)this.currentSection.schemas.elementAt(n), (Validator)this.currentSection.validators.elementAt(n));
                ++n;
            }
            this.currentSection = this.currentSection.parent;
        }
        this.initCurrentSection();
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Program {
        final ModeUsage modeUsage;
        final ContentHandler handler;

        Program(ModeUsage modeUsage, ContentHandler contentHandler) {
            this.modeUsage = modeUsage;
            this.handler = contentHandler;
        }
    }

    private class Section
    implements SectionState {
        final Section parent;
        final String ns;
        int depth = 0;
        final Vector validators = new Vector();
        final Vector schemas = new Vector();
        final Vector activeHandlers = new Vector();
        final Vector activeHandlersAttributeModeUsage = new Vector();
        final Vector attributeValidationModeUsages = new Vector();
        final Vector childPrograms = new Vector();
        final Stack context = new Stack();
        boolean contextDependent = false;
        int attributeProcessing = 0;

        Section(String string2, Section section) {
            this.ns = string2;
            this.parent = section;
        }

        public void addChildMode(ModeUsage modeUsage, ContentHandler contentHandler) {
            this.childPrograms.addElement(new Program(modeUsage, contentHandler));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addValidator(Schema schema, ModeUsage modeUsage) {
            this.schemas.addElement(schema);
            Validator validator = ValidatorImpl.this.createValidator(schema);
            this.validators.addElement(validator);
            this.activeHandlers.addElement(validator.getContentHandler());
            this.activeHandlersAttributeModeUsage.addElement(modeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, modeUsage.getAttributeProcessing());
            this.childPrograms.addElement(new Program(modeUsage, validator.getContentHandler()));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addActiveHandler(ContentHandler contentHandler, ModeUsage modeUsage) {
            this.activeHandlers.addElement(contentHandler);
            this.activeHandlersAttributeModeUsage.addElement(modeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, modeUsage.getAttributeProcessing());
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addAttributeValidationModeUsage(ModeUsage modeUsage) {
            int n = modeUsage.getAttributeProcessing();
            if (n != 0) {
                this.attributeValidationModeUsages.addElement(modeUsage);
                this.attributeProcessing = Math.max(n, this.attributeProcessing);
                if (modeUsage.isContextDependent()) {
                    this.contextDependent = true;
                }
            }
        }

        public void reject() throws SAXException {
            if (ValidatorImpl.this.eh != null) {
                ValidatorImpl.this.eh.error(new SAXParseException(ValidatorImpl.this.localizer.message("reject_element", this.ns), ValidatorImpl.this.locator));
            }
        }
    }

    private static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping parent;

        PrefixMapping(String string2, String string3, PrefixMapping prefixMapping) {
            this.prefix = string2;
            this.uri = string3;
            this.parent = prefixMapping;
        }
    }
}

