/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.configuration;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.clones.configuration.DuplicateIndexConfiguration;
import com.jetbrains.clones.index.HashFragmentIndex;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016R'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/clones/configuration/DuplicatesConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "<init>", "()V", "getId", "", "getHelpTopic", "configurableSettingsMap", "", "Lcom/intellij/openapi/options/Configurable;", "Lcom/jetbrains/clones/configuration/DuplicateIndexConfiguration;", "getConfigurableSettingsMap", "()Ljava/util/Map;", "configurableSettingsMap$delegate", "Lkotlin/Lazy;", "descriptionList", "Lcom/intellij/ui/CheckBoxList;", "isModified", "", "configurable", "getDisplayName", "createComponent", "Ljavax/swing/JComponent;", "apply", "", "reset", "createPanel", "Ljavax/swing/JPanel;", "disposeUIResources", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesConfigurable.kt\ncom/jetbrains/clones/configuration/DuplicatesConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,114:1\n1755#2,3:115\n774#2:118\n865#2,2:119\n1863#2,2:121\n774#2:123\n865#2,2:124\n1863#2,2:126\n216#3,2:128\n662#4:130\n743#4,4:131\n*S KotlinDebug\n*F\n+ 1 DuplicatesConfigurable.kt\ncom/jetbrains/clones/configuration/DuplicatesConfigurable\n*L\n29#1:115,3\n42#1:118\n42#1:119,2\n42#1:121,2\n55#1:123\n55#1:124,2\n55#1:126,2\n82#1:128,2\n24#1:130\n24#1:131,4\n*E\n"})
public final class DuplicatesConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Lazy configurableSettingsMap$delegate = LazyKt.lazy(DuplicatesConfigurable::configurableSettingsMap_delegate$lambda$1);
    @Nullable
    private CheckBoxList<Configurable> descriptionList;

    @NotNull
    public String getId() {
        return "duplicates.index";
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.editor.duplicates";
    }

    private final Map<Configurable, DuplicateIndexConfiguration> getConfigurableSettingsMap() {
        Lazy lazy = this.configurableSettingsMap$delegate;
        return (Map)lazy.getValue();
    }

    public boolean isModified() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getConfigurableSettingsMap().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Configurable configurable = (Configurable)element$iv;
                    boolean bl2 = false;
                    if (!this.isModified(configurable)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isModified(Configurable configurable) {
        CheckBoxList<Configurable> checkBoxList = this.descriptionList;
        DuplicateIndexConfiguration duplicateIndexConfiguration = this.getConfigurableSettingsMap().get(configurable);
        return !Intrinsics.areEqual((Object)(checkBoxList != null ? Boolean.valueOf(checkBoxList.isItemSelected((Object)configurable)) : null), (Object)(duplicateIndexConfiguration != null ? Boolean.valueOf(duplicateIndexConfiguration.isEnabled()) : null)) || configurable.isModified();
    }

    @NotNull
    public String getDisplayName() {
        String string2 = IdeBundle.message((String)"configurable.DuplicatesConfigurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public JComponent createComponent() {
        return this.createPanel();
    }

    /*
     * WARNING - void declaration
     */
    public void apply() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getConfigurableSettingsMap().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Configurable it = (Configurable)element$iv$iv;
            boolean bl = false;
            if (!this.isModified(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configurable it = (Configurable)element$iv;
            boolean bl = false;
            this.apply(it);
        }
        HashFragmentIndex.Companion.requestRebuild();
    }

    private final void apply(Configurable configurable) {
        Boolean isEnabled;
        CheckBoxList<Configurable> checkBoxList = this.descriptionList;
        Boolean bl = isEnabled = checkBoxList != null ? Boolean.valueOf(checkBoxList.isItemSelected((Object)configurable)) : null;
        if (isEnabled != null) {
            DuplicateIndexConfiguration duplicateIndexConfiguration = this.getConfigurableSettingsMap().get(configurable);
            if (duplicateIndexConfiguration != null) {
                duplicateIndexConfiguration.setEnabled(isEnabled);
            }
            configurable.apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getConfigurableSettingsMap().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Configurable it = (Configurable)element$iv$iv;
            boolean bl = false;
            if (!this.isModified(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configurable it = (Configurable)element$iv;
            boolean bl = false;
            this.reset(it);
            CheckBoxList<Configurable> checkBoxList = this.descriptionList;
            if (checkBoxList == null) continue;
            checkBoxList.repaint();
        }
    }

    private final void reset(Configurable configurable) {
        block1: {
            DuplicateIndexConfiguration settings = this.getConfigurableSettingsMap().get(configurable);
            if (settings == null) break block1;
            configurable.reset();
            CheckBoxList<Configurable> checkBoxList = this.descriptionList;
            if (checkBoxList != null) {
                checkBoxList.setItemSelected((Object)configurable, settings.isEnabled());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createPanel() {
        void $this$forEach$iv;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(JBUI.scale((int)2), JBUI.scale((int)2)));
        CardLayout descriptionLayout = new CardLayout();
        JPanel descriptionPanel = new JPanel(descriptionLayout);
        descriptionPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)6));
        panel.add((Component)descriptionPanel, "Center");
        CheckBoxList list2 = new CheckBoxList();
        list2.setBorder((Border)JBUI.Borders.empty((int)2, (int)6, (int)2, (int)24));
        Map<Configurable, DuplicateIndexConfiguration> map = this.getConfigurableSettingsMap();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator.next();
            boolean bl = false;
            Configurable configurable = (Configurable)entry2.getKey();
            DuplicateIndexConfiguration settings = (DuplicateIndexConfiguration)entry2.getValue();
            String name = configurable.getDisplayName();
            JComponent component = configurable.createComponent();
            if (component == null) continue;
            list2.addItem((Object)configurable, name, settings.isEnabled());
            descriptionPanel.add((Component)component, name);
        }
        list2.addListSelectionListener(arg_0 -> DuplicatesConfigurable.createPanel$lambda$8(list2, descriptionLayout, descriptionPanel, arg_0));
        list2.setCheckBoxListListener((arg_0, arg_1) -> DuplicatesConfigurable.createPanel$lambda$9(list2, descriptionPanel, arg_0, arg_1));
        if (!list2.isEmpty()) {
            list2.setSelectedIndex(0);
        }
        panel.add((Component)new JBScrollPane((Component)list2), "West");
        this.descriptionList = list2;
        return panel;
    }

    public void disposeUIResources() {
        this.descriptionList = null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map configurableSettingsMap_delegate$lambda$1() {
        void var3_3;
        void $this$associateTo$iv$iv;
        Sequence<DuplicateScope> $this$associate$iv = DuplicateScopeExtension.Companion.findAllUniqueDuplicateScopes();
        boolean $i$f$associate = false;
        Sequence<DuplicateScope> sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            DuplicateScope scope = (DuplicateScope)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)scope.createIndexConfigurable(), (Object)scope.getIndexConfiguration());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return var3_3;
    }

    private static final void createPanel$lambda$8(CheckBoxList $list, CardLayout $descriptionLayout, JPanel $descriptionPanel, ListSelectionEvent it) {
        int selectedIndex = $list.getSelectedIndex();
        Configurable configurable = (Configurable)$list.getItemAt(selectedIndex);
        if (configurable != null) {
            $descriptionLayout.show($descriptionPanel, configurable.getDisplayName());
            UIUtil.setEnabled((Component)$descriptionPanel, (boolean)$list.isItemSelected((Object)configurable), (boolean)true);
        }
    }

    private static final void createPanel$lambda$9(CheckBoxList $list, JPanel $descriptionPanel, int index, boolean value) {
        Configurable configurable = (Configurable)$list.getItemAt(index);
        if (configurable != null) {
            UIUtil.setEnabled((Component)$descriptionPanel, (boolean)value, (boolean)true);
        }
    }
}

