/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.RightMarginForm;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.highlighter.XmlHighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CodeStyleXmlPanel
extends CodeStyleAbstractPanel {
    private JTextField myKeepBlankLines;
    private JComboBox<CodeStyleSettings.WrapStyle> myWrapAttributes;
    private JCheckBox myAlignAttributes;
    private JCheckBox myKeepWhiteSpaces;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JCheckBox mySpacesAroundEquality;
    private JCheckBox mySpacesAfterTagName;
    private JCheckBox myKeepLineBreaks;
    private JCheckBox myInEmptyTag;
    private JCheckBox myWrapText;
    private JCheckBox myKeepLineBreaksInText;
    private JComboBox<String> myWhiteSpaceAroundCDATA;
    private JCheckBox myKeepWhitespaceInsideCDATACheckBox;
    private JBScrollPane myJBScrollPane;
    private JPanel myRightMarginPanel;
    private RightMarginForm myRightMarginForm;

    public CodeStyleXmlPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        CodeStyleXmlPanel.fillWrappingCombo(this.myWrapAttributes);
        this.addPanelToWatch(this.myPanel);
        this.myWhiteSpaceAroundCDATA.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(Arrays.asList(XmlBundle.message("preserve", new Object[0]), XmlBundle.message("remove.keep.with.tags", new Object[0]), XmlBundle.message("add.new.lines", new Object[0]))));
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            CodeStyleXmlPanel.$$$reportNull$$$0(0);
        }
        return XmlHighlighterFactory.createXMLHighlighter(scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            CodeStyleXmlPanel.$$$reportNull$$$0(1);
        }
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        xmlSettings.XML_KEEP_BLANK_LINES = CodeStyleXmlPanel.getIntValue(this.myKeepBlankLines);
        xmlSettings.XML_KEEP_LINE_BREAKS = this.myKeepLineBreaks.isSelected();
        xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT = this.myKeepLineBreaksInText.isSelected();
        xmlSettings.XML_ATTRIBUTE_WRAP = CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributes.getSelectedItem()));
        xmlSettings.XML_TEXT_WRAP = this.myWrapText.isSelected() ? 1 : 0;
        xmlSettings.XML_ALIGN_ATTRIBUTES = this.myAlignAttributes.isSelected();
        xmlSettings.XML_KEEP_WHITESPACES = this.myKeepWhiteSpaces.isSelected();
        xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = this.mySpacesAroundEquality.isSelected();
        xmlSettings.XML_SPACE_AFTER_TAG_NAME = this.mySpacesAfterTagName.isSelected();
        xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG = this.myInEmptyTag.isSelected();
        xmlSettings.XML_WHITE_SPACE_AROUND_CDATA = this.myWhiteSpaceAroundCDATA.getSelectedIndex();
        xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = this.myKeepWhitespaceInsideCDATACheckBox.isSelected();
        this.myRightMarginForm.apply(settings);
    }

    private static int getIntValue(JTextField keepBlankLines) {
        try {
            return Integer.parseInt(keepBlankLines.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleXmlPanel.$$$reportNull$$$0(2);
        }
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        this.myKeepBlankLines.setText(String.valueOf(xmlSettings.XML_KEEP_BLANK_LINES));
        this.myWrapAttributes.setSelectedItem(CodeStyleSettings.WrapStyle.forWrapping((int)xmlSettings.XML_ATTRIBUTE_WRAP));
        this.myAlignAttributes.setSelected(xmlSettings.XML_ALIGN_ATTRIBUTES);
        this.myKeepWhiteSpaces.setSelected(xmlSettings.XML_KEEP_WHITESPACES);
        this.mySpacesAfterTagName.setSelected(xmlSettings.XML_SPACE_AFTER_TAG_NAME);
        this.mySpacesAroundEquality.setSelected(xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE);
        this.myKeepLineBreaks.setSelected(xmlSettings.XML_KEEP_LINE_BREAKS);
        this.myKeepLineBreaksInText.setSelected(xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT);
        this.myInEmptyTag.setSelected(xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG);
        this.myWrapText.setSelected(CodeStyleXmlPanel.wrapText(settings));
        this.myWhiteSpaceAroundCDATA.setSelectedIndex(xmlSettings.XML_WHITE_SPACE_AROUND_CDATA);
        this.myKeepWhitespaceInsideCDATACheckBox.setSelected(xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA);
        this.myRightMarginForm.reset(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        if (this.myWrapText.isSelected() != CodeStyleXmlPanel.wrapText(settings)) {
            return true;
        }
        if (xmlSettings.XML_KEEP_BLANK_LINES != CodeStyleXmlPanel.getIntValue(this.myKeepBlankLines)) {
            return true;
        }
        if (xmlSettings.XML_ATTRIBUTE_WRAP != CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributes.getSelectedItem()))) {
            return true;
        }
        if (xmlSettings.XML_ALIGN_ATTRIBUTES != this.myAlignAttributes.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_WHITESPACES != this.myKeepWhiteSpaces.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE != this.mySpacesAroundEquality.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_AFTER_TAG_NAME != this.mySpacesAfterTagName.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_LINE_BREAKS != this.myKeepLineBreaks.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT != this.myKeepLineBreaksInText.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG != this.myInEmptyTag.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_WHITE_SPACE_AROUND_CDATA != this.myWhiteSpaceAroundCDATA.getSelectedIndex()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA != this.myKeepWhitespaceInsideCDATACheckBox.isSelected()) {
            return true;
        }
        return this.myRightMarginForm.isModified(settings);
    }

    private static boolean wrapText(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        return xmlSettings.XML_TEXT_WRAP == 1;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    protected String getPreviewText() {
        return CodeStyleXmlPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.xml.template");
    }

    @NotNull
    protected FileType getFileType() {
        XmlFileType xmlFileType = XmlFileType.INSTANCE;
        if (xmlFileType == null) {
            CodeStyleXmlPanel.$$$reportNull$$$0(3);
        }
        return xmlFileType;
    }

    private void createUIComponents() {
        this.myJBScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                return new Dimension(prefSize.width + 15, prefSize.height);
            }
        };
        this.myRightMarginForm = new RightMarginForm(XmlFileType.INSTANCE.getLanguage(), this.getSettings());
        this.myRightMarginPanel = this.myRightMarginForm.getTopPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        JBScrollPane jBScrollPane = this.myJBScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAlignAttributes = jCheckBox9 = new JCheckBox();
        jCheckBox9.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox9, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.align.attributes"));
        jPanel5.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepWhiteSpaces = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.keep.white.spaces"));
        jPanel5.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapText = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.wrap.text"));
        jPanel5.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.putClientProperty("html.disable", Boolean.TRUE);
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeStyleXmlPanel.class).getString("title.spaces"), (int)0, (int)0, null, null));
        this.mySpacesAroundEquality = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.spaces.around.equals.in.attribute"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacesAfterTagName = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.spaces.around.tag.name"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInEmptyTag = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.spaces.in.empty.tag"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeStyleXmlPanel.class).getString("label.wrap.attributes"));
        jPanel7.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myWrapAttributes = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel7.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("editbox.keep.blank.lines"));
        jPanel7.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepLineBreaksInText = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.keep.line.breaks.in.text"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKeepBlankLines = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel7.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myKeepLineBreaks = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("checkbox.keep.line.breaks"));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel8, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("xml.code.style.border.title.cdata"), (int)0, (int)0, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("xml.code.style.label.whitespace.around"));
        jPanel8.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepWhitespaceInsideCDATACheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleXmlPanel.class).getString("xml.code.style.checkbox.keep.whitespace.inside"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myWhiteSpaceAroundCDATA = jComboBox2;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Preserve");
        defaultComboBoxModel.addElement("Remove (keep with tags)");
        defaultComboBoxModel.addElement("Add new lines");
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel8.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel9 = this.myRightMarginPanel;
        jPanel3.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleXmlPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleXmlPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

