/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.settings;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.docker.remote.settings.DockerExtraHostConfigurable;
import com.intellij.docker.settings.ConfigurableAwareTableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.util.Column;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DockerExtraHostsEditor
extends ConfigurableAwareTableWithCardEditor<DockerExtraHost, ColumnBase> {
    public DockerExtraHostsEditor() {
        super((Column[])new ColumnBase[]{new HostnameColumn(), new IPColumn()});
    }

    @Override
    protected DockerExtraHost createItem() {
        return new DockerExtraHost();
    }

    @Override
    protected DockerExtraHost cloneItem(DockerExtraHost item) {
        return new DockerExtraHost(item);
    }

    @Override
    @NotNull
    protected Configurable createItemConfigurable(DockerExtraHost item) {
        return new DockerExtraHostConfigurable(item);
    }

    public static abstract class ColumnBase
    extends Column<DockerExtraHost> {
        public ColumnBase(@Nls String name2) {
            super(name2);
        }
    }

    private static class HostnameColumn
    extends ColumnBase {
        HostnameColumn() {
            super(DockerBundle.message("DockerExtraHostsEditor.HostnameColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerExtraHost row) {
            return row.getHostname();
        }
    }

    private static class IPColumn
    extends ColumnBase {
        IPColumn() {
            super(DockerBundle.message("DockerExtraHostsEditor.IPColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerExtraHost row) {
            return row.getIP();
        }
    }
}

