/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeFile;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeElementFactory {
    private static final Logger LOG = Logger.getInstance((String)("#" + CMakeElementFactory.class.getPackage().getName()));

    @NotNull
    public static CMakeFile createFile(@NotNull Project project, @NonNls @NotNull CharSequence text) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            CMakeElementFactory.$$$reportNull$$$0(1);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        String filename = "dummy." + CMakeListsFileType.INSTANCE.getDefaultExtension();
        LightVirtualFile virtualFile = new LightVirtualFile(filename, CMakeListsFileType.INSTANCE, text);
        virtualFile.setLanguage((Language)CMakeLanguage.INSTANCE);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        CMakeLanguage lang = CMakeLanguage.getInstance();
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, (Language)lang, false, true);
        if (psiFile == null) {
            FileViewProviderFactory viewFactory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage((Language)lang);
            ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)lang);
            throw new AssertionError((Object)("trySetupPsiForFile returned null\n\tviewFactory=" + viewFactory + "\n\tparserDefinition=" + parser));
        }
        CMakeFile cMakeFile = (CMakeFile)psiFile;
        if (cMakeFile == null) {
            CMakeElementFactory.$$$reportNull$$$0(2);
        }
        return cMakeFile;
    }

    @NotNull
    public static CMakeArgument createArgument(@NotNull Project project, @NlsSafe @NotNull CharSequence text) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(3);
        }
        if (text == null) {
            CMakeElementFactory.$$$reportNull$$$0(4);
        }
        String value = CMakeArgumentManipulator.getCMakeLiteralFromValue(text.toString());
        return CMakeElementFactory.createArgumentRaw(project, value);
    }

    @NotNull
    public static CMakeArgument createArgumentRaw(@NotNull Project project, @NlsSafe @NotNull CharSequence text) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(5);
        }
        if (text == null) {
            CMakeElementFactory.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(!StringUtil.isEmpty((CharSequence)text), (Object)"empty arguments are not allowed");
        PsiElement arg = CMakeElementFactory.createFile(project, "foo(" + text + ")").findElementAt(4);
        while (!(arg instanceof CMakeArgument)) {
            assert (arg != null);
            arg = arg.getParent();
        }
        CMakeArgument cMakeArgument = (CMakeArgument)arg;
        if (cMakeArgument == null) {
            CMakeElementFactory.$$$reportNull$$$0(7);
        }
        return cMakeArgument;
    }

    @Nullable
    public static CMakeCommandName createCommandName(@NotNull Project project, @NlsSafe CharSequence newCommandName) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(8);
        }
        CMakeFile psiFile = CMakeElementFactory.createFile(project, newCommandName + "()\n");
        return ((CMakeCommand)psiFile.getFirstChild()).getCMakeCommandName();
    }

    public static CMakeCommand createCommand(@NotNull Project project, @NlsSafe @NotNull String cmdName, List<String> args) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(9);
        }
        if (cmdName == null) {
            CMakeElementFactory.$$$reportNull$$$0(10);
        }
        CMakeFile psiFile = CMakeElementFactory.createFile(project, cmdName + "(" + String.join((CharSequence)" ", args) + ")\n");
        return (CMakeCommand)CodeStyleManager.getInstance((Project)project).reformat(psiFile.getFirstChild());
    }

    @NotNull
    public static PsiElement createWhitespace(@NotNull Project project, WhitespaceKind kind) {
        if (project == null) {
            CMakeElementFactory.$$$reportNull$$$0(11);
        }
        String text = switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case WhitespaceKind.Space -> " ";
            case WhitespaceKind.NewLine -> "\n";
        };
        PsiElement psiElement = CMakeElementFactory.createFile(project, text).findElementAt(0);
        if (psiElement == null) {
            CMakeElementFactory.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/CMakeElementFactory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/CMakeElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentRaw";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createWhitespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentRaw";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createWhitespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 12 -> new IllegalStateException(string);
        };
    }

    static enum WhitespaceKind {
        Space,
        NewLine;

    }
}

