/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.editor;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cmake/editor/CMakeBreadcrumbsProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "<init>", "()V", "getLanguages", "", "Lcom/intellij/lang/Language;", "()[Lcom/intellij/lang/Language;", "acceptElement", "", "element", "Lcom/intellij/psi/PsiElement;", "acceptStickyElement", "getElementInfo", "", "getElementIcon", "Ljavax/swing/Icon;", "intellij.cmake.psi"})
public final class CMakeBreadcrumbsProvider
implements BreadcrumbsProvider {
    @NotNull
    public Language[] getLanguages() {
        Language[] languageArray = new Language[]{CMakeLanguage.INSTANCE};
        return languageArray;
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof CMakeRoutine;
    }

    public boolean acceptStickyElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.acceptElement(element);
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof CMakeRoutine) {
            string = ((CMakeRoutine)element).getName();
            if (string == null) {
                string = "";
            }
        } else {
            throw new IllegalArgumentException("Unexpected element " + element);
        }
        return string;
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CMakeElement cMakeElement = element instanceof CMakeElement ? (CMakeElement)element : null;
        return cMakeElement != null ? CMakePsiUtils.getIcon(cMakeElement) : null;
    }
}

