/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.DocumentationKind;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J$\u0010\n\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t2\u000b\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider;", "", "basePath", "Ljava/nio/file/Path;", "kind", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "reversePath", "path", "", "Lcom/intellij/openapi/util/NlsSafe;", "html", "name", "css", "Companion", "intellij.cmake.psi"})
@SourceDebugExtension(value={"SMAP\nCMakeBundledDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeBundledDocumentationProvider.kt\ncom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public interface CMakeBundledDocumentationProvider {
    @NotNull
    public static final Companion Companion = com.jetbrains.cmake.documentation.CMakeBundledDocumentationProvider$Companion.$$INSTANCE;
    @NotNull
    public static final String CSS_PLACEHOLDER = "/* CLION CMAKE DOCUMENTATION CSS PLACEHOLDER */";

    @NotNull
    public Path basePath();

    @NotNull
    default public Path basePath(@NotNull DocumentationKind kind) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        String resourcePath = Companion.getDOCUMENTATION_MAPPING().get((Object)kind);
        if (!(resourcePath != null)) {
            boolean bl = false;
            String string = "Unknown documentation path";
            throw new IllegalArgumentException(string.toString());
        }
        Path basePath = this.basePath();
        try {
            path = basePath.resolve(resourcePath);
        }
        catch (Exception e) {
            CMakePsiLog.INSTANCE.getLOG().error("Can't resolve base documentation path, basePath = " + basePath + ", resourcePath = " + resourcePath, (Throwable)e);
            path = basePath;
        }
        return path;
    }

    @Nullable
    default public DocumentationKind reversePath(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable iterable = Companion.getDOCUMENTATION_MAPPING().entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)path)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (DocumentationKind)((Object)entry.getKey()) : null;
    }

    @Nullable
    default public String html(@NotNull String name, @NotNull DocumentationKind kind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Path basePath = this.basePath(kind);
        Object htmlName = StringsKt.endsWith$default((String)name, (String)".html", (boolean)false, (int)2, null) ? name : name + ".html";
        try {
            Path path = basePath.resolve((String)htmlName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return CMakeDocumentationUtilKt.readFile(path);
        }
        catch (Exception e) {
            CMakePsiLog.INSTANCE.getLOG().debug("Can't find documentation page, basePath = " + basePath + ", htmlName = " + (String)htmlName, (Throwable)e);
            return null;
        }
    }

    @NotNull
    default public String css() {
        String string;
        Path basePath = this.basePath();
        try {
            Path path = basePath.resolve("_static/basic.css");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String string2 = CMakeDocumentationUtilKt.readFile(path);
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        catch (Exception e) {
            CMakePsiLog.INSTANCE.getLOG().error("Can't find basic CSS page, basePath = " + basePath, (Throwable)e);
            string = "";
        }
        String basicCss = string;
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalOrDefaultColorScheme(...)");
        EditorColorsScheme colorScheme = editorColorsScheme;
        String pygmentsCss = CMakeDocumentationUtilKt.convertToPygments(colorScheme);
        String linksCss = CMakeDocumentationUtilKt.linkCss();
        return basicCss + pygmentsCss + linksCss;
    }

    @JvmStatic
    @Nullable
    public static CMakeBundledDocumentationProvider getProvider() {
        return Companion.getProvider();
    }

    @NotNull
    public static Map<DocumentationKind, String> getDOCUMENTATION_MAPPING() {
        return Companion.getDOCUMENTATION_MAPPING();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider;", "getProvider", "CSS_PLACEHOLDER", "", "DOCUMENTATION_MAPPING", "", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "getDOCUMENTATION_MAPPING$annotations", "getDOCUMENTATION_MAPPING", "()Ljava/util/Map;", "intellij.cmake.psi"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<CMakeBundledDocumentationProvider> EP_NAME;
        @NotNull
        public static final String CSS_PLACEHOLDER = "/* CLION CMAKE DOCUMENTATION CSS PLACEHOLDER */";
        @NotNull
        private static final Map<DocumentationKind, String> DOCUMENTATION_MAPPING;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CMakeBundledDocumentationProvider getProvider() {
            return (CMakeBundledDocumentationProvider)CollectionsKt.firstOrNull((List)EP_NAME.getExtensionList());
        }

        @NotNull
        public final Map<DocumentationKind, String> getDOCUMENTATION_MAPPING() {
            return DOCUMENTATION_MAPPING;
        }

        @JvmStatic
        public static /* synthetic */ void getDOCUMENTATION_MAPPING$annotations() {
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = new ExtensionPointName("com.intellij.cmake.bundledDocumentationProvider");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)DocumentationKind.COMMAND), (Object)"command"), TuplesKt.to((Object)((Object)DocumentationKind.VARIABLE), (Object)"variable"), TuplesKt.to((Object)((Object)DocumentationKind.MODULE), (Object)"module"), TuplesKt.to((Object)((Object)DocumentationKind.POLICY), (Object)"policy"), TuplesKt.to((Object)((Object)DocumentationKind.GLOBAL_PROPERTY), (Object)"prop_gbl"), TuplesKt.to((Object)((Object)DocumentationKind.DIRECTORY_PROPERTY), (Object)"prop_dir"), TuplesKt.to((Object)((Object)DocumentationKind.TARGET_PROPERTY), (Object)"prop_tgt"), TuplesKt.to((Object)((Object)DocumentationKind.SOURCE_PROPERTY), (Object)"prop_sf"), TuplesKt.to((Object)((Object)DocumentationKind.INSTALL_PROPERTY), (Object)"prop_inst"), TuplesKt.to((Object)((Object)DocumentationKind.TEST_PROPERTY), (Object)"prop_test"), TuplesKt.to((Object)((Object)DocumentationKind.CACHE_PROPERTY), (Object)"prop_cache")};
            DOCUMENTATION_MAPPING = MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

