/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cmake.completion.contributors.providers.CMakeVariableProvider;
import java.util.Arrays;
import java.util.HashSet;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class CMakeKnownLiteralsProvider {
    private static final Regex numericPattern = new Regex("[0-9.]+");
    @NonNls
    public static final String[] KNOWN_DOCUMENTED_LITERALS = new String[]{"@ONLY", "ABSOLUTE_PATH", "ABSTRACT", "ABS_SYMLINK", "ABS_SYMLINK_OR_COPY", "ADDITIONAL_CLEAN_FILES", "ADDITIONAL_MAKE_CLEAN_FILES", "ADVANCED", "AFTER", "AFTER_TIMEOUT", "AIX", "AIX_EXPORT_ALL_SYMBOLS", "ALIAS", "ALIASED_TARGET", "ALIAS_GLOBAL", "ALL", "ALLOW_DUPLICATE_CUSTOM_TARGETS", "ALL_BUILD", "ALL_COMPONENTS", "ALWAYS", "AND", "ANDROID_ANT_ADDITIONAL_OPTIONS", "ANDROID_API", "ANDROID_API_MIN", "ANDROID_ARCH", "ANDROID_ASSETS_DIRECTORIES", "ANDROID_GUI", "ANDROID_JAR_DEPENDENCIES", "ANDROID_JAR_DIRECTORIES", "ANDROID_JAVA_SOURCE_DIR", "ANDROID_MK", "ANDROID_NATIVE_LIB_DEPENDENCIES", "ANDROID_NATIVE_LIB_DIRECTORIES", "ANDROID_PROCESS_MAX", "ANDROID_PROGUARD", "ANDROID_PROGUARD_CONFIG_PATH", "ANDROID_SECURE_PROPS_PATH", "ANDROID_SKIP_ANT_STEP", "ANDROID_STL_TYPE", "ANSI", "ANY", "API_VERSION", "APPEND", "APPEND_STRING", "ARCHIVE", "ARCHIVE_CREATE", "ARCHIVE_EXTRACT", "ARCHIVE_OUTPUT_DIRECTORY", "ARCHS", "ARGC", "ARGN", "ARGS", "ARGV", "ARM", "ARRAY", "ASC", "ASCENDING", "ASCII", "ASM", "ASM_MARMASM", "ASM_MASM", "ASM_NASM", "AT", "ATTACHED_FILES", "ATTACHED_FILES_ON_FAIL", "ATTRIBUTES", "AUTHOR_WARNING", "AUTO", "AUTOGEN", "AUTOGEN_BETTER_GRAPH_MULTI_CONFIG", "AUTOGEN_BUILD_DIR", "AUTOGEN_COMMAND_LINE_LENGTH_MAX", "AUTOGEN_ORIGIN_DEPENDS", "AUTOGEN_PARALLEL", "AUTOGEN_SOURCE_GROUP", "AUTOGEN_TARGETS_FOLDER", "AUTOGEN_TARGET_DEPENDS", "AUTOGEN_USE_SYSTEM_INCLUDE", "AUTOMOC", "AUTOMOC_COMPILER_PREDEFINES", "AUTOMOC_DEPEND_FILTERS", "AUTOMOC_EXECUTABLE", "AUTOMOC_MACRO_NAMES", "AUTOMOC_MOC_OPTIONS", "AUTOMOC_PATH_PREFIX", "AUTOMOC_TARGETS_FOLDER", "AUTORCC", "AUTORCC_EXECUTABLE", "AUTORCC_OPTIONS", "AUTOUIC", "AUTOUIC_EXECUTABLE", "AUTOUIC_OPTIONS", "AUTOUIC_SEARCH_PATHS", "AUTO_DEPEND_ON", "AVAILABLE_PHYSICAL_MEMORY", "AVAILABLE_VIRTUAL_MEMORY", "BASE_DIR", "BASE_DIRECTORY", "BASE_DIRS", "BATCH", "BEFORE", "BIN", "BINARY_DIR", "BOLD_TITLE", "BOOL", "BOOLEAN", "BOTH", "BRIEF_DOCS", "BSDOS", "BUILDSYSTEM_TARGETS", "BUILD_ID", "BUILD_INTERFACE", "BUILD_LOCAL_INTERFACE", "BUILD_RPATH", "BUILD_RPATH_USE_ORIGIN", "BUILD_TYPE", "BUILD_WITH_INSTALL_NAME_DIR", "BUILD_WITH_INSTALL_RPATH", "BUILT_ONLY", "BUNDLE", "BUNDLE_EXECUTABLE", "BUNDLE_EXTENSION", "BYPASS_PROVIDER", "BYPRODUCTS", "C", "CACHE_VARIABLES", "CALL", "CAPTURE_CMAKE_ERROR", "CASE", "CC", "CCMAKE_COLORS", "CDASH_UPLOAD", "CENTER", "CHECKABLE", "CHECK_FAIL", "CHECK_PASS", "CHECK_START", "CHMOD", "CHMOD_RECURSE", "CLEAN_NO_CUSTOM", "CLEAR", "CMAKEFILES", "CMAKE_", "CMAKE_BUILD_PARALLEL_LEVEL", "CMAKE_CONFIGURE_DEPENDS", "CMAKE_CONFIG_TYPE", "CMAKE_CUDA_KNOWN_FEATURES", "CMAKE_CXX_KNOWN_FEATURES", "CMAKE_C_KNOWN_FEATURES", "CMAKE_EXPERIMENTAL_CXX_IMPORT_STD", "CMAKE_EXPERIMENTAL_EXPORT_PACKAGE_DEPENDENCIES", "CMAKE_FLAGS", "CMAKE_GET_OS_RELEASE_FALLBACK_RESULT", "CMAKE_GET_OS_RELEASE_FALLBACK_SCRIPTS", "CMAKE_GET_RUNTIME_DEPENDENCIES_COMMAND", "CMAKE_GET_RUNTIME_DEPENDENCIES_PLATFORM", "CMAKE_GET_RUNTIME_DEPENDENCIES_TOOL", "CMAKE_HIP_KNOWN_FEATURES", "CMAKE_INSTALL_DATAROOTDIR", "CMAKE_INSTALL_MODE", "CMAKE_INSTALL_PREFIX", "CMAKE_LINKER_TYPE", "CMAKE_OBJDUMP", "CMAKE_ROLE", "CMAKE_SKIP_TEST_ALL_DEPENDENCY", "CMAKE_STRIP", "CMAKE_TEST_LAUNCHER", "CMAKE_VS_PLATFORM_TOOLSET_FORTRAN", "CODE", "CODEMODEL", "COMMAND", "COMMAND_ECHO", "COMMAND_ERROR_IS_FATAL", "COMMAND_EXPAND_LISTS", "COMMENT", "COMMON_LANGUAGE_RUNTIME", "COMPARE", "COMPATIBILITY", "COMPATIBLE_INTERFACE_", "COMPATIBLE_INTERFACE_BOOL", "COMPATIBLE_INTERFACE_NUMBER_MAX", "COMPATIBLE_INTERFACE_NUMBER_MIN", "COMPATIBLE_INTERFACE_STRING", "COMPILE_DEFINITIONS", "COMPILE_FEATURES", "COMPILE_FLAGS", "COMPILE_LANGUAGE", "COMPILE_LANG_AND_ID", "COMPILE_ONLY", "COMPILE_OPTIONS", "COMPILE_OUTPUT_VARIABLE", "COMPILE_PDB_NAME", "COMPILE_PDB_OUTPUT_DIRECTORY", "COMPILE_WARNING_AS_ERROR", "COMPONENT", "COMPONENTS", "COMPRESSION", "COMPRESSION_LEVEL", "CONCAT", "CONFIG", "CONFIGS", "CONFIGURATION", "CONFIGURATIONS", "CONFIGURE", "CONFIGURE_DEPENDS", "CONFIGURE_LOG", "CONTENT", "CONVERT", "COPY", "COPYONLY", "COPY_FILE", "COPY_ON_ERROR", "COST", "CPACK", "CPACK_APPLE_PKG_INSTALLER_CONTENT", "CPACK_ARCHIVE_COMPONENT_INSTALL", "CPACK_ARCHIVE_FILE_EXTENSION", "CPACK_ARCHIVE_FILE_NAME", "CPACK_ARCHIVE_THREADS", "CPACK_BUNDLE_APPLE_CERT_APP", "CPACK_BUNDLE_APPLE_CODESIGN_FILES", "CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER", "CPACK_BUNDLE_APPLE_ENTITLEMENTS", "CPACK_BUNDLE_ICON", "CPACK_BUNDLE_NAME", "CPACK_BUNDLE_PLIST", "CPACK_BUNDLE_STARTUP_COMMAND", "CPACK_COMMAND_CODESIGN", "CPACK_COMMAND_HDIUTIL", "CPACK_COMMAND_PKGBUILD", "CPACK_COMMAND_PRODUCTBUILD", "CPACK_COMMAND_REZ", "CPACK_COMMAND_SETFILE", "CPACK_COMPONENTS_GROUPING", "CPACK_CREATE_DESKTOP_LINKS", "CPACK_CYGWIN_BUILD_SCRIPT", "CPACK_CYGWIN_PATCH_FILE", "CPACK_CYGWIN_PATCH_NUMBER", "CPACK_DEBIAN_PACKAGE_GENERATE_SHLIBS", "CPACK_DEB_COMPONENT_INSTALL", "CPACK_DESKTOP_SHORTCUTS", "CPACK_DMG_", "CPACK_DMG_BACKGROUND_IMAGE", "CPACK_DMG_DISABLE_APPLICATIONS_SYMLINK", "CPACK_DMG_DS_STORE", "CPACK_DMG_DS_STORE_SETUP_SCRIPT", "CPACK_DMG_FILESYSTEM", "CPACK_DMG_FORMAT", "CPACK_DMG_SLA_DIR", "CPACK_DMG_SLA_LANGUAGES", "CPACK_DMG_SLA_USE_RESOURCE_FILE_LICENSE", "CPACK_DMG_VOLUME_NAME", "CPACK_EXTERNAL_BUILT_PACKAGES", "CPACK_EXTERNAL_ENABLE_STAGING", "CPACK_EXTERNAL_PACKAGE_SCRIPT", "CPACK_FREEBSD_PACKAGE_CATEGORIES", "CPACK_FREEBSD_PACKAGE_COMMENT", "CPACK_FREEBSD_PACKAGE_DEPS", "CPACK_FREEBSD_PACKAGE_DESCRIPTION", "CPACK_FREEBSD_PACKAGE_LICENSE", "CPACK_FREEBSD_PACKAGE_LICENSE_LOGIC", "CPACK_FREEBSD_PACKAGE_MAINTAINER", "CPACK_FREEBSD_PACKAGE_NAME", "CPACK_FREEBSD_PACKAGE_ORIGIN", "CPACK_FREEBSD_PACKAGE_WWW", "CPACK_GENERATOR", "CPACK_IFW_ADMIN_TARGET_DIRECTORY", "CPACK_IFW_ARCHIVE_COMPRESSION", "CPACK_IFW_ARCHIVE_FORMAT", "CPACK_IFW_BINARYCREATOR_EXECUTABLE", "CPACK_IFW_DOWNLOAD_ALL", "CPACK_IFW_FRAMEWORK_VERSION", "CPACK_IFW_PACKAGES_DIRECTORIES", "CPACK_IFW_PACKAGE_ALLOW_NON_ASCII_CHARACTERS", "CPACK_IFW_PACKAGE_ALLOW_SPACE_IN_PATH", "CPACK_IFW_PACKAGE_BACKGROUND", "CPACK_IFW_PACKAGE_BANNER", "CPACK_IFW_PACKAGE_CONTROL_SCRIPT", "CPACK_IFW_PACKAGE_DISABLE_COMMAND_LINE_INTERFACE", "CPACK_IFW_PACKAGE_FILE_EXTENSION", "CPACK_IFW_PACKAGE_GROUP", "CPACK_IFW_PACKAGE_ICON", "CPACK_IFW_PACKAGE_LOGO", "CPACK_IFW_PACKAGE_MAINTENANCE_TOOL_INI_FILE", "CPACK_IFW_PACKAGE_MAINTENANCE_TOOL_NAME", "CPACK_IFW_PACKAGE_NAME", "CPACK_IFW_PACKAGE_PRODUCT_IMAGES", "CPACK_IFW_PACKAGE_PUBLISHER", "CPACK_IFW_PACKAGE_REMOVE_TARGET_DIR", "CPACK_IFW_PACKAGE_RESOURCES", "CPACK_IFW_PACKAGE_RUN_PROGRAM", "CPACK_IFW_PACKAGE_RUN_PROGRAM_ARGUMENTS", "CPACK_IFW_PACKAGE_RUN_PROGRAM_DESCRIPTION", "CPACK_IFW_PACKAGE_SIGNING_IDENTITY", "CPACK_IFW_PACKAGE_START_MENU_DIRECTORY", "CPACK_IFW_PACKAGE_STYLE_SHEET", "CPACK_IFW_PACKAGE_TITLE", "CPACK_IFW_PACKAGE_TITLE_COLOR", "CPACK_IFW_PACKAGE_WATERMARK", "CPACK_IFW_PACKAGE_WINDOW_ICON", "CPACK_IFW_PACKAGE_WIZARD_DEFAULT_HEIGHT", "CPACK_IFW_PACKAGE_WIZARD_DEFAULT_WIDTH", "CPACK_IFW_PACKAGE_WIZARD_SHOW_PAGE_LIST", "CPACK_IFW_PACKAGE_WIZARD_STYLE", "CPACK_IFW_PRODUCT_URL", "CPACK_IFW_REPOGEN_EXECUTABLE", "CPACK_IFW_REPOSITORIES_ALL", "CPACK_IFW_REPOSITORIES_DIRECTORIES", "CPACK_IFW_RESOLVE_DUPLICATE_NAMES", "CPACK_IFW_TARGET_DIRECTORY", "CPACK_INNOSETUP_ALLOW_CUSTOM_DIRECTORY", "CPACK_INNOSETUP_ARCHITECTURE", "CPACK_INNOSETUP_CODE_FILES", "CPACK_INNOSETUP_CREATE_UNINSTALL_LINK", "CPACK_INNOSETUP_CUSTOM_INSTALL_INSTRUCTIONS", "CPACK_INNOSETUP_DEFINE_", "CPACK_INNOSETUP_EXECUTABLE", "CPACK_INNOSETUP_EXECUTABLE_ARGUMENTS", "CPACK_INNOSETUP_EXTRA_SCRIPTS", "CPACK_INNOSETUP_ICON_FILE", "CPACK_INNOSETUP_IGNORE_LICENSE_PAGE", "CPACK_INNOSETUP_IGNORE_README_PAGE", "CPACK_INNOSETUP_INSTALL_ROOT", "CPACK_INNOSETUP_LANGUAGES", "CPACK_INNOSETUP_MENU_LINKS", "CPACK_INNOSETUP_PASSWORD", "CPACK_INNOSETUP_PROGRAM_MENU_FOLDER", "CPACK_INNOSETUP_RUN_EXECUTABLES", "CPACK_INNOSETUP_SETUP_", "CPACK_INNOSETUP_USE_CMAKE_BOOL_FORMAT", "CPACK_INNOSETUP_USE_MODERN_WIZARD", "CPACK_INNOSETUP_VERIFY_DOWNLOADS", "CPACK_INSTALLED_DIRECTORIES", "CPACK_INSTALL_CMAKE_PROJECTS", "CPACK_INSTALL_SCRIPT", "CPACK_INSTALL_SCRIPTS", "CPACK_NEVER_OVERWRITE", "CPACK_NSIS_", "CPACK_NSIS_BRANDING_TEXT", "CPACK_NSIS_BRANDING_TEXT_TRIM_POSITION", "CPACK_NSIS_COMPRESSOR", "CPACK_NSIS_EXECUTABLE", "CPACK_NSIS_EXECUTABLES_DIRECTORY", "CPACK_NSIS_EXECUTABLE_POST_ARGUMENTS", "CPACK_NSIS_EXECUTABLE_PRE_ARGUMENTS", "CPACK_NSIS_FINISH_TITLE", "CPACK_NSIS_IGNORE_LICENSE_PAGE", "CPACK_NSIS_INSTALLER_MUI_ICON_CODE", "CPACK_NSIS_MANIFEST_DPI_AWARE", "CPACK_NSIS_MENU_LINKS", "CPACK_NSIS_MUI_FINISHPAGE_RUN", "CPACK_NSIS_MUI_HEADERIMAGE", "CPACK_NSIS_MUI_ICON", "CPACK_NSIS_MUI_UNIICON", "CPACK_NSIS_MUI_UNWELCOMEFINISHPAGE_BITMAP", "CPACK_NSIS_MUI_WELCOMEFINISHPAGE_BITMAP", "CPACK_NSIS_WELCOME_TITLE", "CPACK_NUGET_COMPONENT_INSTALL", "CPACK_PACKAGEMAKER_CHOICES", "CPACK_PACKAGE_CHECKSUM", "CPACK_PACKAGE_DESCRIPTION", "CPACK_PACKAGE_DESCRIPTION_FILE", "CPACK_PACKAGE_DESCRIPTION_SUMMARY", "CPACK_PACKAGE_DIRECTORY", "CPACK_PACKAGE_EXECUTABLES", "CPACK_PACKAGE_FILES", "CPACK_PACKAGE_FILE_NAME", "CPACK_PACKAGE_HOMEPAGE_URL", "CPACK_PACKAGE_ICON", "CPACK_PACKAGE_INSTALL_DIRECTORY", "CPACK_PACKAGE_NAME", "CPACK_PACKAGE_VENDOR", "CPACK_PACKAGE_VERSION", "CPACK_PACKAGE_VERSION_MAJOR", "CPACK_PACKAGE_VERSION_MINOR", "CPACK_PACKAGE_VERSION_PATCH", "CPACK_PERMANENT", "CPACK_PKGBUILD_IDENTITY_NAME", "CPACK_PKGBUILD_KEYCHAIN_PATH", "CPACK_POST_BUILD_SCRIPTS", "CPACK_PRE_BUILD_SCRIPTS", "CPACK_PRODUCTBUILD_DOMAINS", "CPACK_PRODUCTBUILD_DOMAINS_ANYWHERE", "CPACK_PRODUCTBUILD_DOMAINS_ROOT", "CPACK_PRODUCTBUILD_DOMAINS_USER", "CPACK_PRODUCTBUILD_IDENTIFIER", "CPACK_PRODUCTBUILD_IDENTITY_NAME", "CPACK_PRODUCTBUILD_KEYCHAIN_PATH", "CPACK_PRODUCTBUILD_RESOURCES_DIR", "CPACK_PROJECT_CONFIG_FILE", "CPACK_RESOURCE_FILE_LICENSE", "CPACK_RESOURCE_FILE_README", "CPACK_RPM_", "CPACK_RPM_COMPONENT_INSTALL", "CPACK_RPM_DEBUGINFO_PACKAGE", "CPACK_RPM_DEBUGINFO_SINGLE_PACKAGE", "CPACK_RPM_MAIN_COMPONENT", "CPACK_STARTUP_SHORTCUTS", "CPACK_START_MENU_SHORTCUTS", "CPACK_STRIP_FILES", "CPACK_TEMPORARY_DIRECTORY", "CPACK_THREADS", "CPACK_TOPLEVEL_DIRECTORY", "CPACK_WIX_ACL", "CPACK_WIX_ARCHITECTURE", "CPACK_WIX_CMAKE_PACKAGE_REGISTRY", "CPACK_WIX_CULTURES", "CPACK_WIX_CUSTOM_XMLNS", "CPACK_WIX_EXTENSIONS", "CPACK_WIX_EXTRA_OBJECTS", "CPACK_WIX_EXTRA_SOURCES", "CPACK_WIX_INSTALL_SCOPE", "CPACK_WIX_LICENSE_RTF", "CPACK_WIX_PATCH_FILE", "CPACK_WIX_PRODUCT_GUID", "CPACK_WIX_PRODUCT_ICON", "CPACK_WIX_PROGRAM_MENU_FOLDER", "CPACK_WIX_PROPERTY_", "CPACK_WIX_ROOT_FEATURE_DESCRIPTION", "CPACK_WIX_ROOT_FEATURE_TITLE", "CPACK_WIX_ROOT_FOLDER_ID", "CPACK_WIX_SKIP_PROGRAM_FOLDER", "CPACK_WIX_SKIP_WIX_UI_EXTENSION", "CPACK_WIX_TEMPLATE", "CPACK_WIX_UI_BANNER", "CPACK_WIX_UI_DIALOG", "CPACK_WIX_UI_REF", "CPACK_WIX_UPGRADE_GUID", "CPACK_WIX_VERSION", "CPATH", "CREATE_LINK", "CRLF", "CROSSCOMPILING_EMULATOR", "CTEST", "CTEST_BUILD_CONFIGURATION", "CTEST_BUILD_FLAGS", "CTEST_BUILD_TARGET", "CTEST_INTERACTIVE_DEBUG_MODE", "CTEST_NO_TESTS_ACTION", "CTEST_OUTPUT_ON_FAILURE", "CTEST_PARALLEL_LEVEL", "CTEST_PROGRESS_OUTPUT", "CTEST_RESOURCE_GROUP_COUNT", "CTEST_TLS_VERIFY", "CTEST_TLS_VERSION", "CUDA", "CUDA_ARCHITECTURES", "CUDA_COMPILER_ID", "CUDA_COMPILER_VERSION", "CUDA_CUBIN_COMPILATION", "CUDA_FATBIN_COMPILATION", "CUDA_OPTIX_COMPILATION", "CUDA_PTX_COMPILATION", "CUDA_RESOLVE_DEVICE_SYMBOLS", "CUDA_RUNTIME_LIBRARY", "CUDA_SEPARABLE_COMPILATION", "CUDA_STANDARD", "CURLOPT_SSL_VERIFYHOST_OFF", "CURLOPT_SSL_VERIFYPEER_OFF", "CVS", "CXX", "CXX_COMPILER_ID", "CXX_EXTENSIONS", "CXX_MODULE", "CXX_MODULES", "CXX_MODULES_BMI", "CXX_MODULES_DIRECTORY", "CXX_MODULE_DIRS", "CXX_MODULE_SET", "CXX_MODULE_SETS", "CXX_MODULE_STD", "CXX_SCAN_FOR_MODULES", "CXX_STANDARD", "CXX_STANDARD_REQUIRED", "C_COMPILER_ID", "C_STANDARD", "DASHBOARD_TEST_FROM_CTEST", "DATA", "DEBUG", "DEBUG_CONFIGURATIONS", "DECIMAL", "DEFAULT", "DEFER", "DEFINED", "DEFINE_SYMBOL", "DEFINITIONS", "DEPENDENCIES", "DEPENDS", "DEPLOYMENT_ADDITIONAL_FILES", "DEPLOYMENT_REMOTE_DIRECTORY", "DEPRECATION", "DESCENDING", "DESCRIPTION", "DESTDIR", "DESTINATION", "DEVICE_LINK", "DIRECTORIES", "DIRECTORY", "DIRECTORY_PERMISSIONS", "DISABLED", "DISABLE_PRECOMPILE_HEADERS", "DISPLAY_NAME", "DLL", "DLL_NAME_WITH_SOVERSION", "DOC", "DOS", "DOTNET_SDK", "DOTNET_TARGET_FRAMEWORK", "DOTNET_TARGET_FRAMEWORK_VERSION", "DOWNLOAD", "ECHO_ERROR_VARIABLE", "ECHO_OUTPUT_VARIABLE", "ECLIPSE_EXTRA_CPROJECT_CONTENTS", "ECLIPSE_EXTRA_NATURES", "ELF", "ENABLED", "ENABLED_LANGUAGES", "ENABLE_EXPORTS", "ENCODING", "ENV", "ENVIRONMENT", "ENVIRONMENT_MODIFICATION", "EQUAL", "ERROR", "ERROR_FILE", "ERROR_QUIET", "ERROR_VARIABLE", "ESCAPE_QUOTES", "EVAL", "EXACT", "EXCLUDE", "EXCLUDE_FIXTURE", "EXCLUDE_FROM_ALL", "EXCLUDE_FROM_DEFAULT_BUILD", "EXCLUDE_FROM_FILE", "EXECUTABLE", "EXECUTABLES", "EXISTS", "EXIT", "EXPANDED", "EXPAND_TILDE", "EXPORT", "EXPORT_ANDROID_MK", "EXPORT_COMPILE_COMMANDS", "EXPORT_FIND_PACKAGE_NAME", "EXPORT_LINK_INTERFACE_LIBRARIES", "EXPORT_NAME", "EXPORT_NO_SYSTEM", "EXPORT_PACKAGE_DEPENDENCIES", "EXPORT_PROPERTIES", "EXTERNAL_OBJECT", "EXTRA_ARGS", "EXTRA_INCLUDE", "FAILED_TO_RUN", "FAIL_REGULAR_EXPRESSION", "FALSE", "FATAL_ERROR", "FETCHCONTENT_MAKEAVAILABLE_SERIAL", "FILE", "FILEPATH", "FILES", "FILES_MATCHING", "FILE_BASENAME", "FILE_PERMISSIONS", "FILE_SET", "FILTER", "FIND", "FIND_LIBRARY_USE_OPENBSD_VERSIONING", "FIND_PACKAGE", "FIRST", "FIXED", "FIXTURES_CLEANUP", "FIXTURES_REQUIRED", "FIXTURES_SETUP", "FLAG", "FOLDER", "FOLLOW_SYMLINKS", "FOLLOW_SYMLINK_CHAIN", "FOR", "FORCE", "FORCED_INSTALLATION", "FORMAT", "FOSSIL", "FQDN", "FRAMEWORK", "FRAMEWORK_VERSION", "FREE", "FULL_DOCS", "FUNCTION", "GENERATE", "GENERATED", "GENERATED_RESOURCE_SPEC_FILE", "GENERATOR_FILE_NAME", "GENERATOR_IS_MULTI_CONFIG", "GENEX_STRIP", "GET", "GET_MESSAGE_LOG_LEVEL", "GET_RUNTIME_DEPENDENCIES", "GHS_BSP_NAME", "GHS_CUSTOMIZATION", "GHS_GPJ_MACROS", "GHS_NO_SOURCE_GROUP_FILE", "GHS_OS_DIR", "GHS_OS_DIR_OPTION", "GHS_OS_ROOT", "GHS_PRIMARY_TARGET", "GHS_TARGET_PLATFORM", "GHS_TOOLSET_ROOT", "GIT", "GLOB", "GLOBAL", "GLOBAL_DEPENDS_DEBUG_MODE", "GLOBAL_DEPENDS_NO_CYCLES", "GLOB_RECURSE", "GNU", "GREATER", "GREATER_EQUAL", "GROUP", "GROUP_EXECUTE", "GROUP_READ", "GROUP_WRITE", "GUARD", "GUID", "HASH", "HAS_CXX", "HAS_EXTENSION", "HAS_FILENAME", "HAS_FPU", "HAS_MMX", "HAS_MMX_PLUS", "HAS_PARENT_PATH", "HAS_RELATIVE_PART", "HAS_ROOT_DIRECTORY", "HAS_ROOT_NAME", "HAS_ROOT_PATH", "HAS_SERIAL_NUMBER", "HAS_SSE", "HAS_SSE_FP", "HAS_SSE_MMX", "HAS_STEM", "HEAD", "HEADERS", "HEADER_DIRS", "HEADER_FILE_ONLY", "HEADER_SET", "HEADER_SETS", "HELPSTRING", "HEX", "HEXADECIMAL", "HG", "HINTS", "HIP", "HIP_ARCHITECTURES", "HIP_STANDARD", "HKCC", "HKCR", "HKCU", "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_CURRENT_USER", "HKEY_LOCAL_MACHINE", "HKEY_USERS", "HKLM", "HKU", "HOME", "HOMEPAGE_URL", "HOST", "HOSTNAME", "HOST_LINK", "HTTPHEADER", "ID", "ID_VAR", "IF", "IFW", "IGNORE", "IGNORED", "IMPLICIT_DEPENDS_INCLUDE_TRANSFORM", "IMPORTED", "IMPORTED_", "IMPORTED_COMMON_LANGUAGE_RUNTIME", "IMPORTED_CONFIGURATIONS", "IMPORTED_CXX_MODULES_COMPILE_DEFINITIONS", "IMPORTED_CXX_MODULES_COMPILE_FEATURES", "IMPORTED_CXX_MODULES_COMPILE_OPTIONS", "IMPORTED_CXX_MODULES_INCLUDE_DIRECTORIES", "IMPORTED_CXX_MODULES_LINK_LIBRARIES", "IMPORTED_GLOBAL", "IMPORTED_IMPLIB", "IMPORTED_LIBNAME", "IMPORTED_LINK_DEPENDENT_LIBRARIES", "IMPORTED_LINK_INTERFACE_LANGUAGES", "IMPORTED_LINK_INTERFACE_LIBRARIES", "IMPORTED_LINK_INTERFACE_MULTIPLICITY", "IMPORTED_LOCATION", "IMPORTED_NO_SONAME", "IMPORTED_NO_SYSTEM", "IMPORTED_OBJECTS", "IMPORTED_RUNTIME_ARTIFACTS", "IMPORTED_SONAME", "IMPORTED_TARGETS", "IMPORT_PREFIX", "IMPORT_SUFFIX", "INCLUDE", "INCLUDE_DIRECTORIES", "INCLUDE_FROM_FILE", "INCLUDE_INTERNALS", "INCLUDE_REGULAR_EXPRESSION", "INFO", "INHERITED", "INITIALIZE_FROM_VARIABLE", "INNOSETUP", "INPUT", "INPUT_MAY_BE_RECENT", "INSENSITIVE", "INSERT", "INSTALL", "INSTALL_INTERFACE", "INSTALL_NAME_DIR", "INSTALL_PARALLEL", "INSTALL_PREFIX", "INSTALL_REMOVE_ENVIRONMENT_RPATH", "INSTALL_RPATH", "INSTALL_RPATH_USE_LINK_PATH", "INTERFACE", "INTERFACE_", "INTERFACE_AUTOMOC_MACRO_NAMES", "INTERFACE_AUTOUIC_OPTIONS", "INTERFACE_COMPILE_DEFINITIONS", "INTERFACE_COMPILE_FEATURES", "INTERFACE_COMPILE_OPTIONS", "INTERFACE_CXX_MODULE_SETS", "INTERFACE_HEADER_SETS", "INTERFACE_HEADER_SETS_TO_VERIFY", "INTERFACE_INCLUDE_DIRECTORIES", "INTERFACE_LINK_DEPENDS", "INTERFACE_LINK_DIRECTORIES", "INTERFACE_LINK_LIBRARIES", "INTERFACE_LINK_LIBRARIES_DIRECT", "INTERFACE_LINK_LIBRARIES_DIRECT_EXCLUDE", "INTERFACE_LINK_OPTIONS", "INTERFACE_POSITION_INDEPENDENT_CODE", "INTERFACE_PRECOMPILE_HEADERS", "INTERFACE_SOURCES", "INTERFACE_SYSTEM_INCLUDE_DIRECTORIES", "INTERNAL", "INTERPROCEDURAL_OPTIMIZATION", "IN_LIST", "IN_TRY_COMPILE", "IOS_INSTALL_COMBINED", "ISCC", "ISPC", "ISPC_HEADER_DIRECTORY", "ISPC_HEADER_SUFFIX", "ISPC_INSTRUCTION_SETS", "IS_ABSOLUTE", "IS_EXECUTABLE", "IS_NEWER_THAN", "IS_PREFIX", "IS_READABLE", "IS_RELATIVE", "IS_WRITABLE", "ITEMS", "JOB_POOL", "JOB_POOLS", "JOB_POOL_COMPILE", "JOB_POOL_LINK", "JOB_POOL_PRECOMPILE_HEADER", "JOB_SERVER_AWARE", "JOIN", "JSON", "KEEP_EXTENSION", "KEYWORD", "KNOWN_LOCATION", "LABELS", "LANG", "LANGUAGE", "LANGUAGES", "LAST", "LAST_EXT", "LAST_ONLY", "LAZY", "LCC", "LEFT", "LENGTH", "LESS", "LESS_EQUAL", "LF", "LIB", "LIBRARIES", "LIBRARY", "LIBRARY_OUTPUT_DIRECTORY", "LINKER_LANGUAGE", "LINKER_TYPE", "LINK_DEPENDS", "LINK_DEPENDS_NO_SHARED", "LINK_DIRECTORIES", "LINK_FLAGS", "LINK_GROUP", "LINK_INTERFACE_LIBRARIES", "LINK_INTERFACE_MULTIPLICITY", "LINK_LANGUAGE", "LINK_LANG_AND_ID", "LINK_LIBRARIES", "LINK_LIBRARIES_ONLY_TARGETS", "LINK_LIBRARY", "LINK_LIBRARY_OVERRIDE", "LINK_ONLY", "LINK_OPTIONS", "LINK_PRIVATE", "LINK_PUBLIC", "LINK_SEARCH_END_STATIC", "LINK_SEARCH_START_STATIC", "LINK_WHAT_YOU_USE", "LIST", "LISTFILE_STACK", "LISTS", "LIST_DIRECTORIES", "LIST_ONLY", "LOCALE", "LOCALSTATE", "LOCATION", "LOCATION_CONFIG", "LOCK", "LOG_DESCRIPTION", "MACHO_COMPATIBILITY_VERSION", "MACHO_CURRENT_VERSION", "MACOSX_BUNDLE", "MACOSX_BUNDLE_BUNDLE_NAME", "MACOSX_BUNDLE_BUNDLE_VERSION", "MACOSX_BUNDLE_COPYRIGHT", "MACOSX_BUNDLE_GUI_IDENTIFIER", "MACOSX_BUNDLE_ICON_FILE", "MACOSX_BUNDLE_INFO_PLIST", "MACOSX_BUNDLE_INFO_STRING", "MACOSX_BUNDLE_LONG_VERSION_STRING", "MACOSX_BUNDLE_SHORT_VERSION_STRING", "MACOSX_DEPLOYMENT_TARGET", "MACOSX_FRAMEWORK_BUNDLE_VERSION", "MACOSX_FRAMEWORK_ICON_FILE", "MACOSX_FRAMEWORK_IDENTIFIER", "MACOSX_FRAMEWORK_INFO_PLIST", "MACOSX_FRAMEWORK_SHORT_VERSION_STRING", "MACOSX_PACKAGE_LOCATION", "MACOSX_RPATH", "MACROS", "MAKE_C_IDENTIFIER", "MAKE_DIRECTORY", "MAN", "MANIFEST", "MANUALLY_ADDED_DEPENDENCIES", "MATCHES", "MEASUREMENT", "MESSAGE_NEVER", "MINSIZEREL", "MODIFIED", "MODIFIED_ACCESS", "MODULE", "MODULES", "MODULE_LIBRARY", "MSVC_DEBUG_INFORMATION_FORMAT", "MSVC_RUNTIME_LIBRARY", "MSYSTEM", "MSYSTEM_PREFIX", "MTIME", "NAME", "NAMELINK_COMPONENT", "NAMELINK_ONLY", "NAMELINK_SKIP", "NAMES", "NAMESPACE", "NAMES_PER_DIR", "NAME_WLE", "NATIVE_COMMAND", "NATIVE_PATH", "NATURAL", "NETRC", "NETRC_FILE", "NEVER", "NEW", "NEWLINE_CONSUME", "NEWLINE_STYLE", "NEW_PROCESS", "NO", "NONE", "NORMAL", "NORMALIZE", "NORMAL_PATH", "NOT", "NOTFOUND", "NOTICE", "NO_CACHE", "NO_CMAKE_BUILDS_PATH", "NO_CMAKE_ENVIRONMENT_PATH", "NO_CMAKE_INSTALL_PREFIX", "NO_CMAKE_PACKAGE_REGISTRY", "NO_CMAKE_PATH", "NO_CMAKE_SYSTEM_PACKAGE_REGISTRY", "NO_CMAKE_SYSTEM_PATH", "NO_DEFAULT_PATH", "NO_HEX_CONVERSION", "NO_LOG", "NO_MODULE", "NO_PACKAGE_ROOT_PATH", "NO_POLICY_SCOPE", "NO_REPLACE", "NO_SONAME", "NO_SOURCE_PERMISSIONS", "NO_SYSTEM_ENVIRONMENT_PATH", "NO_SYSTEM_FROM_IMPORTED", "NSIS", "NULL", "NUMBER", "NUMBER_OF_LOGICAL_CORES", "NUMBER_OF_PHYSICAL_CORES", "NVIDIA", "OBJC", "OBJCXX", "OBJCXX_STANDARD", "OBJC_STANDARD", "OBJECT", "OBJECTS", "OBJECT_DEPENDS", "OBJECT_OUTPUTS", "OEM", "OFF", "OLD", "ON", "ONLY", "ONLY_IF_DIFFERENT", "OPTIMIZE_DEPENDENCIES", "OPTIONAL", "OPTIONAL_COMPONENTS", "OPTIONS", "OR", "ORDER", "OSX_ARCHITECTURES", "OS_NAME", "OS_PLATFORM", "OS_RELEASE", "OS_VERSION", "OUTPUT", "OUTPUT_FILE", "OUTPUT_FORMAT", "OUTPUT_JUNIT", "OUTPUT_NAME", "OUTPUT_QUIET", "OUTPUT_VARIABLE", "OWNER_EXECUTE", "OWNER_READ", "OWNER_WRITE", "PACKAGE", "PACKAGES_FOUND", "PACKAGES_NOT_FOUND", "PACKAGE_DEPENDENCY", "PACKAGE_FIND_NAME", "PACKAGE_FIND_VERSION", "PACKAGE_FIND_VERSION_COMPLETE", "PACKAGE_FIND_VERSION_MAX", "PACKAGE_FIND_VERSION_MIN", "PACKAGE_FIND_VERSION_RANGE", "PACKAGE_FIND_VERSION_RANGE_MAX", "PACKAGE_FIND_VERSION_RANGE_MIN", "PACKAGE_VERSION", "PACKAGE_VERSION_COMPATIBLE", "PACKAGE_VERSION_EXACT", "PACKAGE_VERSION_UNSUITABLE", "PARALLEL_LEVEL", "PARENT_DIRECTORY", "PARENT_PATH", "PARENT_SCOPE", "PARSE_ARGV", "PASS_REGULAR_EXPRESSION", "PATH", "PATHS", "PATH_EQUAL", "PATH_SUFFIXES", "PATTERN", "PATTERNS", "PCH_INSTANTIATE_TEMPLATES", "PCH_WARN_INVALID", "PDB_NAME", "PDB_OUTPUT_DIRECTORY", "PERMISSIONS", "PGI", "PIE", "PLATFORM", "PLATFORM_ID", "POLICIES", "POP", "POP_BACK", "POP_FRONT", "POSITION_INDEPENDENT_CODE", "POST_BUILD", "POST_EXCLUDE_FILES", "POST_EXCLUDE_REGEXES", "POST_INCLUDE_FILES", "POST_INCLUDE_REGEXES", "POST_INSTALL_SCRIPT", "PRECOMPILE_HEADERS", "PRECOMPILE_HEADERS_REUSE_FROM", "PREDEFINED_TARGETS_FOLDER", "PREFIX", "PREORDER", "PREPEND", "PRE_EXCLUDE_REGEXES", "PRE_INCLUDE_REGEXES", "PRE_INSTALL_SCRIPT", "PRE_LINK", "PRIORITY", "PRIVATE", "PRIVATE_HEADER", "PROCESS", "PROCESSORS", "PROCESSOR_AFFINITY", "PROCESSOR_ARCHITECTURE", "PROCESSOR_DESCRIPTION", "PROCESSOR_NAME", "PROCESSOR_SERIAL_NUMBER", "PROGRAM", "PROGRAMS", "PROGRAM_ARGS", "PROJECT", "PROJECT_LABEL", "PROPAGATE", "PROPAGATE_TOP_LEVEL_INCLUDES_TO_TRY_COMPILE", "PROPERTIES", "PROPERTY", "PUBLIC", "PUBLIC_HEADER", "PUSH", "QCC", "QT_VERSION_MAJOR", "QT_VERSION_MINOR", "QUERY", "QUIET", "QUOTE", "Q_PLUGIN_METADATA", "RANDOM", "RANDOM_SEED", "RANGE_END", "RANGE_START", "RC", "READ", "READ_ACCESS", "READ_SYMLINK", "REALPATH", "REAL_PATH", "REGEX", "REGISTRY_VIEW", "REGULAR_EXPRESSION", "RELATIVE", "RELATIVE_PATH", "RELEASE", "RELEASE_DATE", "RELWITHDEBINFO", "REL_SYMLINK", "REL_SYMLINK_OR_COPY", "REMOVE", "REMOVED_ACCESS", "REMOVE_AT", "REMOVE_DUPLICATES", "REMOVE_EXTENSION", "REMOVE_FILENAME", "REMOVE_ITEM", "REMOVE_RECURSE", "RENAME", "REPEAT", "REPLACE", "REPLACES", "REPLACE_EXTENSION", "REPLACE_FILENAME", "REQUIRED", "REQUIRED_FILES", "REQUIRES_ADMIN_RIGHTS", "RESOURCE", "RESOURCE_GROUPS", "RESOURCE_LOCK", "RESOURCE_SPEC_FILE", "RESULT", "RESULTS_VARIABLE", "RESULT_VARIABLE", "RETRY_COUNT", "RETRY_DELAY", "RETURN_VALUE", "REUSE_FROM", "REVERSE", "RIGHT", "ROOT_NAME", "RPATH", "RULE_LAUNCH_COMPILE", "RULE_LAUNCH_CUSTOM", "RULE_LAUNCH_LINK", "RULE_MESSAGES", "RUNPATH", "RUNSTATE", "RUNTIME", "RUNTIME_DEPENDENCIES", "RUNTIME_DEPENDENCY_SET", "RUNTIME_DIRECTORY", "RUNTIME_OUTPUT_DIRECTORY", "RUN_OUTPUT_STDERR_VARIABLE", "RUN_OUTPUT_STDOUT_VARIABLE", "RUN_OUTPUT_VARIABLE", "RUN_SERIAL", "RUN_TESTS", "SBIN", "SCOPE_FOR", "SCRIPT", "SDCC", "SDKROOT", "SEMICOLON", "SEND_ERROR", "SENSITIVE", "SEPARATE_ARGS", "SEPARATOR", "SET", "SETGID", "SETUID", "SETUP", "SET_DEPENDENCY_PROVIDER", "SHARED", "SHAREDSTATE", "SHARED_LIBRARY", "SHELL_PATH", "SHOW_PROGRESS", "SIGINT", "SIGQUIT", "SIGSTOP", "SIGTERM", "SIZE", "SKIP_AUTOGEN", "SKIP_AUTOMOC", "SKIP_AUTORCC", "SKIP_AUTOUIC", "SKIP_BUILD_RPATH", "SKIP_LINTING", "SKIP_PRECOMPILE_HEADERS", "SKIP_REGULAR_EXPRESSION", "SKIP_RETURN_CODE", "SKIP_UNITY_BUILD_INCLUSION", "SONAME", "SORT", "SORTING_PRIORITY", "SOURCE", "SOURCES", "SOURCES_TYPE", "SOURCE_DATE_EPOCH", "SOURCE_DIR", "SOURCE_FROM_CONTENT", "SOURCE_FROM_VAR", "SOVERSION", "SSL_CERT_DIR", "SSL_CERT_FILE", "STANDARD", "STATIC", "STATIC_LIBRARY", "STATIC_LIBRARY_FLAGS", "STATIC_LIBRARY_OPTIONS", "STATUS", "STDERR", "STDOUT", "STOP_ON_FAILURE", "STREQUAL", "STRGREATER", "STRGREATER_EQUAL", "STRING", "STRINGS", "STRIP", "STRLESS", "STRLESS_EQUAL", "SUBDIRECTORIES", "SUBKEYS", "SUBLIST", "SUBMIT_URL", "SUBSTRING", "SUFFIX", "SVN", "SWIFT_COMPILATION_MODE", "SYMBOLIC", "SYMLINK", "SYMLINK_OR_COPY", "SYSCONF", "SYSTEM", "TAG", "TARGET", "TARGETS", "TARGET_ARCHIVES_MAY_BE_SHARED_LIBS", "TARGET_BUNDLE_CONTENT_DIR", "TARGET_BUNDLE_DIR", "TARGET_BUNDLE_DIR_NAME", "TARGET_DIRECTORY", "TARGET_FILE", "TARGET_FILE_BASE_NAME", "TARGET_FILE_DIR", "TARGET_FILE_NAME", "TARGET_FILE_PREFIX", "TARGET_FILE_SUFFIX", "TARGET_IMPORT_FILE", "TARGET_IMPORT_FILE_BASE_NAME", "TARGET_IMPORT_FILE_DIR", "TARGET_IMPORT_FILE_NAME", "TARGET_IMPORT_FILE_PREFIX", "TARGET_IMPORT_FILE_SUFFIX", "TARGET_LINKER_FILE", "TARGET_LINKER_FILE_BASE_NAME", "TARGET_LINKER_FILE_DIR", "TARGET_LINKER_FILE_NAME", "TARGET_LINKER_FILE_PREFIX", "TARGET_LINKER_FILE_SUFFIX", "TARGET_LINKER_IMPORT_FILE", "TARGET_LINKER_IMPORT_FILE_NAME", "TARGET_LINKER_LIBRARY_FILE", "TARGET_LINKER_LIBRARY_FILE_NAME", "TARGET_MESSAGES", "TARGET_OBJECTS", "TARGET_PDB_FILE", "TARGET_PDB_FILE_BASE_NAME", "TARGET_PDB_FILE_DIR", "TARGET_PDB_FILE_NAME", "TARGET_POLICY", "TARGET_PROPERTY", "TARGET_RUNTIME_DLLS", "TARGET_RUNTIME_DLL_DIRS", "TARGET_SONAME_FILE", "TARGET_SONAME_FILE_DIR", "TARGET_SONAME_FILE_NAME", "TARGET_SUPPORTS_SHARED_LIBS", "TEST", "TESTS", "TEST_INCLUDE_FILE", "TEST_INCLUDE_FILES", "TEST_LAUNCHER", "TEST_LOAD", "TIMEOUT", "TIMEOUT_AFTER_MATCH", "TIMEOUT_SIGNAL_GRACE_PERIOD", "TIMEOUT_SIGNAL_NAME", "TIMESTAMP", "TLS_CAINFO", "TLS_VERIFY", "TLS_VERSION", "TOLOWER", "TOOL", "TOOLCHAINS", "TOTAL_PHYSICAL_MEMORY", "TOTAL_VIRTUAL_MEMORY", "TOUCH", "TOUCH_NOCREATE", "TOUPPER", "TO_CMAKE_PATH", "TO_CMAKE_PATH_LIST", "TO_NATIVE_PATH", "TO_NATIVE_PATH_LIST", "TRACE", "TRACK", "TRANSFORM", "TRANSITIVE_COMPILE_PROPERTIES", "TRANSITIVE_LINK_PROPERTIES", "TRANSLATIONS", "TREE", "TRUE", "TXZ", "TYPE", "UDZO", "UNINITIALIZED", "UNITY_BUILD", "UNITY_BUILD_BATCH_SIZE", "UNITY_BUILD_CODE_AFTER_INCLUDE", "UNITY_BUILD_CODE_BEFORE_INCLUDE", "UNITY_BUILD_MODE", "UNITY_BUILD_UNIQUE_ID", "UNITY_GROUP", "UNIX_COMMAND", "UNKNOWN", "UNKNOWN_READ_ACCESS", "UNTIL_FAIL", "UNTIL_PASS", "UPDATE_TEXT", "UPLOAD", "UPPER", "URL", "USERPROFILE", "USER_INTERFACES", "USES_TERMINAL", "USE_FOLDERS", "USE_SOURCE_PERMISSIONS", "UTC", "UUID", "VALIDATOR", "VALUE", "VALUE_NAMES", "VARIABLE", "VARIABLES", "VERBATIM", "VERBOSE", "VERIFY_INTERFACE_HEADER_SETS", "VERSION", "VERSION_EQUAL", "VERSION_GREATER", "VERSION_GREATER_EQUAL", "VERSION_LESS", "VERSION_LESS_EQUAL", "VIEW", "VIRTUAL", "VISIBILITY_INLINES_HIDDEN", "VS_CONFIGURATION_TYPE", "VS_COPY_TO_OUT_DIR", "VS_DEBUGGER_COMMAND", "VS_DEBUGGER_COMMAND_ARGUMENTS", "VS_DEBUGGER_ENVIRONMENT", "VS_DEBUGGER_WORKING_DIRECTORY", "VS_DEPLOYMENT_CONTENT", "VS_DEPLOYMENT_LOCATION", "VS_DESKTOP_EXTENSIONS_VERSION", "VS_DOTNET_DOCUMENTATION_FILE", "VS_DOTNET_REFERENCES", "VS_DOTNET_REFERENCES_COPY_LOCAL", "VS_DOTNET_STARTUP_OBJECT", "VS_DOTNET_TARGET_FRAMEWORK_VERSION", "VS_DPI_AWARE", "VS_FILTER_PROPS", "VS_GLOBAL_KEYWORD", "VS_GLOBAL_PROJECT_TYPES", "VS_GLOBAL_ROOTNAMESPACE", "VS_INCLUDE_IN_VSIX", "VS_IOT_EXTENSIONS_VERSION", "VS_IOT_STARTUP_TASK", "VS_JUST_MY_CODE_DEBUGGING", "VS_KEYWORD", "VS_MOBILE_EXTENSIONS_VERSION", "VS_NO_COMPILE_BATCHING", "VS_NO_SOLUTION_DEPLOY", "VS_PACKAGE_REFERENCES", "VS_PLATFORM_TOOLSET", "VS_PROJECT_IMPORT", "VS_RESOURCE_GENERATOR", "VS_SCC_AUXPATH", "VS_SCC_LOCALPATH", "VS_SCC_PROJECTNAME", "VS_SCC_PROVIDER", "VS_SDK_REFERENCES", "VS_SETTINGS", "VS_SHADER_DISABLE_OPTIMIZATIONS", "VS_SHADER_ENABLE_DEBUG", "VS_SHADER_ENTRYPOINT", "VS_SHADER_FLAGS", "VS_SHADER_MODEL", "VS_SHADER_OBJECT_FILE_NAME", "VS_SHADER_OUTPUT_HEADER_FILE", "VS_SHADER_TYPE", "VS_SHADER_VARIABLE_NAME", "VS_SOLUTION_DEPLOY", "VS_STARTUP_PROJECT", "VS_TOOL_OVERRIDE", "VS_USER_PROPS", "VS_USE_DEBUG_LIBRARIES", "VS_WINDOWS_TARGET_PLATFORM_MIN_VERSION", "VS_WINRT_COMPONENT", "VS_WINRT_EXTENSIONS", "VS_WINRT_REFERENCES", "VS_XAML_TYPE", "WAIT", "WARNING", "WATCOM_RUNTIME_LIBRARY", "WEAK_FRAMEWORK", "WEAK_LIBRARY", "WILL_FAIL", "WINDOWS_COMMAND", "WINDOWS_EXPORT_ALL_SYMBOLS", "WIX", "WORKING_DIRECTORY", "WORLD_EXECUTE", "WORLD_READ", "WORLD_WRITE", "WRAP_EXCLUDE", "WRITE", "XCFRAMEWORK_LOCATION", "XCODE_EMBED_FRAMEWORKS_CODE_SIGN_ON_COPY", "XCODE_EMBED_FRAMEWORKS_REMOVE_HEADERS_ON_COPY", "XCODE_EMIT_EFFECTIVE_PLATFORM_NAME", "XCODE_EXPLICIT_FILE_TYPE", "XCODE_FILE_ATTRIBUTES", "XCODE_GENERATE_SCHEME", "XCODE_LAST_KNOWN_FILE_TYPE", "XCODE_LINK_BUILD_PHASE_MODE", "XCODE_PRODUCT_TYPE", "XCODE_SCHEME_ADDRESS_SANITIZER", "XCODE_SCHEME_ADDRESS_SANITIZER_USE_AFTER_RETURN", "XCODE_SCHEME_ARGUMENTS", "XCODE_SCHEME_DEBUG_AS_ROOT", "XCODE_SCHEME_DEBUG_DOCUMENT_VERSIONING", "XCODE_SCHEME_DISABLE_MAIN_THREAD_CHECKER", "XCODE_SCHEME_DYNAMIC_LIBRARY_LOADS", "XCODE_SCHEME_DYNAMIC_LINKER_API_USAGE", "XCODE_SCHEME_ENABLE_GPU_API_VALIDATION", "XCODE_SCHEME_ENABLE_GPU_FRAME_CAPTURE_MODE", "XCODE_SCHEME_ENABLE_GPU_SHADER_VALIDATION", "XCODE_SCHEME_ENVIRONMENT", "XCODE_SCHEME_EXECUTABLE", "XCODE_SCHEME_GUARD_MALLOC", "XCODE_SCHEME_LAUNCH_CONFIGURATION", "XCODE_SCHEME_LAUNCH_MODE", "XCODE_SCHEME_MAIN_THREAD_CHECKER_STOP", "XCODE_SCHEME_MALLOC_GUARD_EDGES", "XCODE_SCHEME_MALLOC_SCRIBBLE", "XCODE_SCHEME_MALLOC_STACK", "XCODE_SCHEME_THREAD_SANITIZER", "XCODE_SCHEME_THREAD_SANITIZER_STOP", "XCODE_SCHEME_UNDEFINED_BEHAVIOUR_SANITIZER", "XCODE_SCHEME_UNDEFINED_BEHAVIOUR_SANITIZER_STOP", "XCODE_SCHEME_WORKING_DIRECTORY", "XCODE_SCHEME_ZOMBIE_OBJECTS", "XCODE_XCCONFIG", "XCTEST", "XL", "XZ", "YES", "ZERO_CHECK", "ZIP_LISTS", "_CMAKE_", "_FOUND", "_LIB_DEPENDS", "_ROOT", "_WINRT_DLL", ""};
    @NlsSafe
    public static final HashSet<String> CMAKE_RESERVED_WORDS;

    public static boolean isNumeric(@NlsSafe @Nullable String name) {
        if (name == null) {
            return false;
        }
        return numericPattern.matches((CharSequence)name);
    }

    public static boolean isReserved(@NlsSafe String id) {
        return CMAKE_RESERVED_WORDS.contains(id);
    }

    public static boolean highlightAllCMakeDocumented() {
        return ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"cmake.highlight.all.completion.variables.only", (boolean)true);
    }

    static {
        HashSet<String> a = new HashSet<String>();
        if (CMakeKnownLiteralsProvider.highlightAllCMakeDocumented()) {
            a.addAll(Arrays.asList(KNOWN_DOCUMENTED_LITERALS));
        }
        a.addAll(Arrays.asList(CMakeVariableProvider.ALL_COMPLETION_VARIABLES));
        CMAKE_RESERVED_WORDS = a;
    }
}

