/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathMapper;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteUtil {
    @NlsSafe
    public static final String DEFAULT_CMAKE_PATH = "/usr/bin/cmake";
    @NlsSafe
    public static final String DEFAULT_GDB_PATH = "/usr/bin/gdb";
    @NlsSafe
    public static final String PIGZ_EXECUTABLE = "pigz";
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Remote Development", (String)ToolchainsBundle.message("remote.development", new Object[0]));
    public static final int CONNECTION_TIMEOUT = StringUtil.parseInt((String)System.getProperty("clion.remote.connection.timeout"), (int)3000);

    private RemoteUtil() {
    }

    public static boolean isFullRemoteModeAvailable() {
        return RemoteDeploymentHelper.isRemoteDeploymentServiceAvailable();
    }

    @NotNull
    private static ConnectionBuilder createConnectionBuilder(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(0);
        }
        return RemoteUtil.createConnectionBuilder(credentials, null);
    }

    @NotNull
    public static ConnectionBuilder createConnectionBuilder(@NotNull RemoteCredentials credentials, @Nullable ProgressIndicator indicator) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(1);
        }
        boolean allowDialogs = false;
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, null, (ProgressIndicator)indicator, (boolean)false);
        if (connectionBuilder == null) {
            RemoteUtil.$$$reportNull$$$0(2);
        }
        return connectionBuilder;
    }

    @NotNull
    public static CidrProcessBuilder createRemoteProcess(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(3);
        }
        return RemoteUtil.createRemoteProcess(credentials, null);
    }

    @NotNull
    public static CidrProcessBuilder createRemoteProcess(final @NotNull RemoteCredentials credentials, final @Nullable PathMapper pathMapper) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(4);
        }
        return new CidrProcessBuilder(){

            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cmd, @NotNull CidrProcessBuilder.Parameters parameters2) throws ExecutionException {
                if (cmd == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parameters2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                BaseProcessHandler<?> baseProcessHandler = RemoteUtil.createRemoteProcess(cmd, credentials, parameters2, pathMapper);
                if (baseProcessHandler == null) {
                    1.$$$reportNull$$$0(2);
                }
                return baseProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cmd";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static BaseProcessHandler<?> createRemoteProcess(@NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials, @NotNull CidrProcessBuilder.Parameters params, @Nullable PathMapper pathMapper) throws ExecutionException {
        if (cmd == null) {
            RemoteUtil.$$$reportNull$$$0(5);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(6);
        }
        if (params == null) {
            RemoteUtil.$$$reportNull$$$0(7);
        }
        RemoteUtil.prepare(cmd, pathMapper);
        try {
            if (RemoteHostUtil.LOG.isTraceEnabled()) {
                RemoteHostUtil.LOG.trace("Create remote process: " + cmd.getCommandLineString());
            }
            ConnectionBuilder connectionBuilder = RemoteUtil.createConnectionBuilder(credentials, params.getProgressIndicator()).withConnectionTimeout((long)CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            SshExecProcess process2 = RemoteUtil.executeOrRunTask(() -> RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)cmd).withAllocatePty(params.isPty()).withSudo((PasswordStringProvider)(params.isElevated() ? new DialogSshSudoPasswordStringProvider(credentials) : null)).withChangeDir(true).start());
            if (params.isEmulateTerminal()) {
                return new TerminalEmulatorRemoteProcessHandler((RemoteProcess)process2, cmd.getCommandLineString(), cmd.getCharset());
            }
            if (params.isColored()) {
                return new ParameterizedColoredRemoteProcessHandler((RemoteProcess)process2, cmd.getCommandLineString(), cmd.getCharset(), params);
            }
            if (params.isCapturedOutput()) {
                return new ParameterizedCapturingSshProcessHandler((SshProcess<?>)process2, cmd.getCharset(), cmd.getCommandLineString(), params);
            }
            return new ParameterizedRemoteProcessHandler<SshExecProcess>(process2, cmd.getCommandLineString(), cmd.getCharset(), params);
        }
        catch (SshException e) {
            RemoteHostUtil.LOG.warn((Throwable)e);
            Throwable cause = e.getCause();
            if (cause != null && cause.getMessage() != null) {
                throw new ExecutionException(e.getCause());
            }
            throw new ExecutionException((Throwable)e);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            RemoteHostUtil.LOG.warn((Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
    }

    private static void prepare(@NotNull GeneralCommandLine cl, @Nullable PathMapper pathMapper) {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            return;
        }
        Path wd = cl.getWorkingDirectory();
        if (wd != null) {
            cl.withWorkingDirectory(Path.of(pathMapper.convertToRemote(wd.normalize().toString()), new String[0]));
        }
        String exe = cl.getExePath();
        cl.setExePath(pathMapper.convertToRemote(exe));
        File inputFile = cl.getInputFile();
        if (inputFile != null) {
            cl.withInput(new File(pathMapper.convertToRemote(inputFile.getPath())));
        }
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, int timeout) throws ExecutionException {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(9);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(10);
        }
        return RemoteUtil.runRemoteProcess(cl, credentials, null, timeout);
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(11);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(12);
        }
        BaseProcessHandler handler2 = RemoteUtil.createRemoteProcess(credentials).withProgressIndicator(indicator).build(cl);
        ProcessOutput processOutput = CidrRunProcessUtil.runProcess((BaseProcessHandler)handler2, (ProgressIndicator)indicator, (int)timeout);
        if (processOutput == null) {
            RemoteUtil.$$$reportNull$$$0(13);
        }
        return processOutput;
    }

    public static void killProcessTree(@NotNull BaseProcessHandler<?> handler2) {
        Process process2;
        if (handler2 == null) {
            RemoteUtil.$$$reportNull$$$0(14);
        }
        if ((process2 = handler2.getProcess()) instanceof RemoteProcess) {
            ((RemoteProcess)process2).killProcessTree();
        }
    }

    public static boolean checkConnection(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(15);
        }
        try {
            return RemoteUtil.executeOrRunTask(() -> RemoteUtil.createConnectionBuilder(credentials).checkCanAuthenticate(false));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated(forRemoval=true, since="2024.3")
    @NotNull
    public static String mktemp(@NotNull RemoteCredentials credentials, @NotNull OSType osType, boolean createDir) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(16);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(17);
        }
        String string = RemoteUtil.mktemp(credentials, osType.toOS(), createDir);
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static String mktemp(@NotNull RemoteCredentials credentials, @NotNull OS osType, boolean createDir) throws ExecutionException {
        ProcessOutput output2;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(19);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(20);
        }
        CidrToolsUtil.assertUnixOnly((OS)osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: mktemp");
        }
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"mktemp"});
        if (createDir) {
            command.addParameter("-d");
        }
        if ((output2 = RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT)).isTimeout() || output2.getExitCode() != 0) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.temp.file.ext", output2.isTimeout() ? "Timed out" : "Exit code " + output2.getExitCode(), output2.getExitCode()));
        }
        String path = StringUtil.nullize((String)output2.getStdout().trim());
        if (path == null) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.temp.file", new Object[0]));
        }
        return path;
    }

    public static void mkdir(@NotNull RemoteCredentials credentials, @NotNull OS osType, String dirName) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(21);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(22);
        }
        CidrToolsUtil.assertUnixOnly((OS)osType);
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"mkdir", dirName});
        ProcessOutput output2 = RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        if (output2.isTimeout()) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.dir.timed.out", output2.getExitCode()));
        }
        if (output2.getExitCode() != 0) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.create.dir", output2.getExitCode()));
        }
    }

    public static boolean fileExists(@NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(23);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(24);
        }
        return RemoteUtil.fileExists(OSType.LINUX, credentials, path);
    }

    @Deprecated(forRemoval=true, since="2024.3")
    public static boolean fileExists(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(25);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(26);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(27);
        }
        return RemoteUtil.fileExists(osType.toOS(), credentials, path);
    }

    public static boolean fileExists(@NotNull OS osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output2;
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(28);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(29);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(30);
        }
        CidrToolsUtil.assertUnixOnly((OS)osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: file exists: " + path);
        }
        return (output2 = RemoteUtil.runRemoteProcess(command = new GeneralCommandLine(new String[]{"test", "-e", path}), credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT)).getExitCode() == 0;
    }

    @Deprecated(forRemoval=true, since="2024.3")
    public static void touch(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(31);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(32);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(33);
        }
        RemoteUtil.touch(osType.toOS(), credentials, path);
    }

    public static void touch(@NotNull OS osType, @NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output2;
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(34);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(35);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(36);
        }
        CidrToolsUtil.assertUnixOnly((OS)osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: touch: " + path);
        }
        if (!(output2 = RemoteUtil.runRemoteProcess(command = new GeneralCommandLine(new String[]{"touch", path}), credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT)).checkSuccess(RemoteHostUtil.LOG)) {
            RemoteHostUtil.LOG.warn("Command 'touch' has been failed: " + path);
        }
    }

    @Nullable
    public static String resolveToExecutable(@NotNull HostMachine host, @NotNull String name) throws ExecutionException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(38);
        }
        return RemoteUtil.resolveToExecutable(command -> host.runProcess(command, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT), host.getOS(), name);
    }

    @Nullable
    public static String resolveToExecutable(@NotNull RemoteCredentials credentials, @NotNull String name) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(40);
        }
        return RemoteUtil.resolveToExecutable(command -> RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT), OS.Linux, name);
    }

    @Nullable
    private static String resolveToExecutable(@NotNull CidrToolsUtil.CommandRunner runner, @NotNull OS osType, @NotNull String name) throws ExecutionException {
        ProcessOutput output2;
        if (runner == null) {
            RemoteUtil.$$$reportNull$$$0(41);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(42);
        }
        if (name == null) {
            RemoteUtil.$$$reportNull$$$0(43);
        }
        CidrToolsUtil.assertUnixOnly((OS)osType);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: resolve to executable: " + name);
        }
        if (!(output2 = runner.run(new GeneralCommandLine(new String[]{"which", name}))).checkSuccess(RemoteHostUtil.LOG)) {
            RemoteHostUtil.LOG.warn("Cannot resolve '" + name + "' to executable.");
            return null;
        }
        return StringUtil.nullize((String)output2.getStdout().trim());
    }

    public static boolean isTarInstalled(@NotNull CidrToolsUtil.CommandRunner commandRunner) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(44);
        }
        return RemoteUtil.isToolAvailable(commandRunner, "tar");
    }

    public static boolean isRsyncInstalled(@NotNull CidrToolsUtil.CommandRunner commandRunner) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(45);
        }
        return RemoteUtil.isToolAvailable(commandRunner, "rsync");
    }

    public static boolean isPigzInstalled(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(46);
        }
        return RemoteUtil.isToolAvailable(command -> RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT), PIGZ_EXECUTABLE);
    }

    public static boolean isPigzInstalled(@NotNull CidrToolsUtil.CommandRunner commandRunner) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(47);
        }
        return RemoteUtil.isToolAvailable(commandRunner, PIGZ_EXECUTABLE);
    }

    public static boolean isTarInstalled(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(48);
        }
        return RemoteUtil.isToolAvailable(command -> RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT), "tar");
    }

    private static boolean isToolAvailable(@NotNull CidrToolsUtil.CommandRunner commandRunner, @NotNull @NonNls String tool) {
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(49);
        }
        if (tool == null) {
            RemoteUtil.$$$reportNull$$$0(50);
        }
        try {
            ProcessOutput output2 = commandRunner.run(new GeneralCommandLine(new String[]{tool, "--version"}));
            if (!output2.checkSuccess(RemoteHostUtil.LOG)) {
                RemoteHostUtil.LOG.info("RemoteUtil: " + tool + " not found");
                return false;
            }
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteUtil: " + tool + " version: " + (String)ContainerUtil.getFirstItem((List)output2.getStdoutLines()));
            }
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.error("Error during execution of `" + tool + "` command", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void setExecutable(@NotNull RemoteCredentials credentials, @NotNull String uploadPath, @NotNull ProgressIndicator indicator) throws ExecutionException {
        ProcessOutput output2;
        GeneralCommandLine cmd;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(51);
        }
        if (uploadPath == null) {
            RemoteUtil.$$$reportNull$$$0(52);
        }
        if (indicator == null) {
            RemoteUtil.$$$reportNull$$$0(53);
        }
        if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)(cmd = new GeneralCommandLine(new String[]{"chmod", "u+x", uploadPath})), (ProcessOutput)(output2 = RemoteUtil.runRemoteProcess(cmd, credentials, indicator, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT)), (Logger)RemoteHostUtil.LOG)) {
            throw new ExecutionException(output2.getExitCode() + ": " + output2.getStderr());
        }
    }

    @NotNull
    public static CidrToolsUtil.Status verifyConnectionAndRemoteEnvironment(@Nullable RemoteCredentials credentials) {
        CidrToolsUtil.Status status = RemoteUtil.verifyConnection(credentials);
        if (status.code == CidrToolsUtil.StatusCode.ERROR) {
            CidrToolsUtil.Status status2 = status;
            if (status2 == null) {
                RemoteUtil.$$$reportNull$$$0(54);
            }
            return status2;
        }
        assert (status.code == CidrToolsUtil.StatusCode.OK && credentials != null);
        return RemoteUtil.verifyRemoteEnvironment(status, command -> RemoteUtil.runRemoteProcess(command, credentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT));
    }

    @NotNull
    static CidrToolsUtil.Status verifyRemoteEnvironment(@NotNull CidrToolsUtil.Status connectionStatus, @NotNull CidrToolsUtil.CommandRunner commandRunner) {
        if (connectionStatus == null) {
            RemoteUtil.$$$reportNull$$$0(55);
        }
        if (commandRunner == null) {
            RemoteUtil.$$$reportNull$$$0(56);
        }
        if (RSyncUtil.checkRsyncInstalled()) {
            if (!RemoteUtil.isRsyncInstalled(commandRunner)) {
                CidrToolsUtil.Status status = CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.missing.rsync", new Object[0]));
                if (status == null) {
                    RemoteUtil.$$$reportNull$$$0(57);
                }
                return status;
            }
        } else if (Registry.is((String)"clion.remote.compress.tar") && !RemoteUtil.isTarInstalled(commandRunner)) {
            return new CidrToolsUtil.Status(CidrToolsUtil.StatusCode.WARNING, ToolchainsBundle.message("remote.status.missing.tar", new Object[0]));
        }
        CidrToolsUtil.Status status = connectionStatus;
        if (status == null) {
            RemoteUtil.$$$reportNull$$$0(58);
        }
        return status;
    }

    @NotNull
    public static CidrToolsUtil.Status verifyConnection(@Nullable RemoteCredentials credentials) {
        if (credentials == null) {
            CidrToolsUtil.Status status = CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.empty.credentials", new Object[0]));
            if (status == null) {
                RemoteUtil.$$$reportNull$$$0(59);
            }
            return status;
        }
        boolean connected = RemoteUtil.checkConnection(credentials);
        CidrToolsUtil.Status status = connected ? new CidrToolsUtil.Status(CidrToolsUtil.StatusCode.OK, ToolchainsBundle.message("remote.status.connected", new Object[0])) : CidrToolsUtil.Status.error((String)ToolchainsBundle.message("remote.status.connection.problem", new Object[0]));
        if (status == null) {
            RemoteUtil.$$$reportNull$$$0(60);
        }
        return status;
    }

    @Nullable
    public static Path filterTextFiles(@NotNull HostMachine host, @NotNull String workingDir, @NotNull Path outputFile, boolean useAbsolutePaths, boolean resolveSymlinks) {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(61);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(62);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(63);
        }
        try {
            RemoteUtil.filterTextFilesInternal(host, workingDir, outputFile, useAbsolutePaths, resolveSymlinks);
            return outputFile;
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.warn((Throwable)e);
            return null;
        }
    }

    public static boolean isTextFilesSyncEnabled() {
        return Registry.is((String)"clion.remote.sync.text.files", (boolean)true);
    }

    private static int textFilesFilterTimeout() {
        return Registry.intValue((String)"clion.remote.filter.text.files.timeout", (int)240000);
    }

    private static void filterTextFilesInternal(@NotNull HostMachine host, @NotNull String workingDir, @NotNull Path outputFile, boolean useAbsolutePaths, boolean resolveSymlinks) throws IOException {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(64);
        }
        if (workingDir == null) {
            RemoteUtil.$$$reportNull$$$0(65);
        }
        if (outputFile == null) {
            RemoteUtil.$$$reportNull$$$0(66);
        }
        try {
            boolean isRemotePath = UnixSshFileSysProvider.isRemotePath((Path)outputFile);
            if (resolveSymlinks && Registry.is((String)"clion.resolve.symlinks.before.download")) {
                RemoteUtil.resolveSymlinks(host, workingDir, outputFile);
            }
            GeneralCommandLine find = new GeneralCommandLine(new String[]{"sh", "-c"});
            String findIn = useAbsolutePaths ? workingDir : ".";
            find.addParameter("find " + findIn + " -type l -print -o -type f -exec grep -Il . {} +");
            if (isRemotePath) {
                find.addParameters(new String[]{">>", outputFile.toString()});
            }
            find.setWorkDirectory(workingDir);
            Ssh.doNotEscapeArgs((GeneralCommandLine)find);
            ProcessOutput output2 = host.runProcess(find, RemoteUtil.textFilesFilterTimeout());
            if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)find, (ProcessOutput)output2, (Logger)RemoteHostUtil.LOG)) {
                throw new IOException("cannot get list of non-binary files: " + CidrToolsUtil.extractError((ProcessOutput)output2));
            }
            if (!isRemotePath) {
                PathKt.write((Path)outputFile, (CharSequence)output2.getStdout());
            }
        }
        catch (ExecutionException e) {
            throw e.toIOException();
        }
    }

    public static void resolveSymlinks(HostMachine host, String dir, Path file) throws IOException {
        try {
            Set<String> links = RemoteUtil.resolveAllSymlinks(host, dir);
            try (OutputStream stream = PathKt.outputStream((Path)file, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE});){
                links.forEach(link -> {
                    try {
                        stream.write(link.getBytes(Charsets.UTF_8));
                        stream.write(LineSeparator.LF.getSeparatorBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throw e;
        }
        catch (ExecutionException e) {
            throw e.toIOException();
        }
    }

    private static Set<String> resolveAllSymlinks(HostMachine runner, String workingDir) throws ExecutionException {
        List<String> symlinksAndFilesToBeResolved = RemoteUtil.getSymlinksInDir(runner, workingDir);
        HashSet<String> result = new HashSet<String>(symlinksAndFilesToBeResolved);
        int lastResultSize = -1;
        for (int depth = 0; lastResultSize != result.size() && depth < Registry.intValue((String)"clion.resolve.symlink.depth"); ++depth) {
            lastResultSize = result.size();
            List<String> targets = List.of(RemoteHostUtil.resolveSymlink((HostMachine)runner, symlinksAndFilesToBeResolved));
            symlinksAndFilesToBeResolved = targets;
            result.addAll(targets);
        }
        return result;
    }

    private static List<String> getSymlinksInDir(HostMachine runner, String dir) throws ExecutionException {
        ProcessOutput output2;
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"sh", "-c", "find " + dir + " -type l"});
        if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)cmd, (ProcessOutput)(output2 = runner.runProcess(cmd, RemoteUtil.textFilesFilterTimeout())), (Logger)RemoteHostUtil.LOG)) {
            throw new RuntimeException(new IOException("cannot get list of symlinks: " + CidrToolsUtil.extractError((ProcessOutput)output2)));
        }
        return output2.getStdoutLines();
    }

    @Nullable
    public static RemoteCredentials toCredentials(@Nullable SshConfig sshConfig) {
        return sshConfig != null ? sshConfig.copyToCredentials() : null;
    }

    @Nullable
    public static RemoteCredentials getCredentials(@NotNull HostMachine host) {
        if (host == null) {
            RemoteUtil.$$$reportNull$$$0(67);
        }
        return host instanceof RemoteHost ? ((RemoteHost)host).getCredentials() : null;
    }

    public static String suggestLocalPathName(@NotNull String remotePath) {
        if (remotePath == null) {
            RemoteUtil.$$$reportNull$$$0(68);
        }
        remotePath = StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)remotePath), (String)"/");
        List elements = ContainerUtil.map((Collection)FileUtilRt.splitPath((String)remotePath, (char)'/'), element -> PathUtil.suggestFileName((String)element, (boolean)true, (boolean)true));
        return FileUtil.join((String[])((String[])elements.toArray(String[]::new)));
    }

    private static <T> T executeOrRunTask(final @NotNull Supplier<T> processBuilder) {
        if (processBuilder == null) {
            RemoteUtil.$$$reportNull$$$0(69);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return processBuilder.get();
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(null, SshBundle.message((String)"remote.process.start", (Object[])new Object[0]), true){

            protected T compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return processBuilder.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/system/RemoteUtil$2", "compute"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 18, 54, 57, 58, 59, 60 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: 
            case 61: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandRunner";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadPath";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionStatus";
                break;
            }
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "runRemoteProcess";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mktemp";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyConnectionAndRemoteEnvironment";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyRemoteEnvironment";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConnectionBuilder";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runRemoteProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkConnection";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mktemp";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mkdir";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fileExists";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "touch";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveToExecutable";
                break;
            }
            case 44: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isTarInstalled";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isRsyncInstalled";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isPigzInstalled";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isToolAvailable";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "verifyRemoteEnvironment";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "filterTextFiles";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "filterTextFilesInternal";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "suggestLocalPathName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "executeOrRunTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 18, 54, 57, 58, 59, 60 -> new IllegalStateException(string);
        };
    }

    private static final class TerminalEmulatorRemoteProcessHandler
    extends BaseRemoteProcessHandler<RemoteProcess> {
        private TerminalEmulatorRemoteProcessHandler(@NotNull RemoteProcess process2, String commandLine, @Nullable Charset charset) {
            if (process2 == null) {
                TerminalEmulatorRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process2, commandLine, charset);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
            if (options == null) {
                TerminalEmulatorRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$TerminalEmulatorRemoteProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$TerminalEmulatorRemoteProcessHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ParameterizedColoredRemoteProcessHandler
    extends ColoredRemoteProcessHandler<RemoteProcess> {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedColoredRemoteProcessHandler(@NotNull RemoteProcess process2, String commandLine, @Nullable Charset charset, @NotNull CidrProcessBuilder.Parameters parameters2) {
            if (process2 == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            if (parameters2 == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            super(process2, commandLine, charset);
            this.myParameters = parameters2;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedColoredRemoteProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedColoredRemoteProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedColoredRemoteProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ParameterizedCapturingSshProcessHandler
    extends CapturingSshProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedCapturingSshProcessHandler(@NotNull SshProcess<?> process2, @Nullable Charset charset, @NotNull String commandLine, @NotNull CidrProcessBuilder.Parameters parameters2) {
            if (process2 == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(1);
            }
            if (parameters2 == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(2);
            }
            super(process2, charset, commandLine);
            this.myParameters = parameters2;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedCapturingSshProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedCapturingSshProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedCapturingSshProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ParameterizedRemoteProcessHandler<T extends RemoteProcess>
    extends BaseRemoteProcessHandler<T> {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        private ParameterizedRemoteProcessHandler(@NotNull T process2, @NotNull String commandLine, @Nullable Charset charset, @NotNull CidrProcessBuilder.Parameters parameters2) {
            if (process2 == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            if (parameters2 == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(2);
            }
            super(process2, commandLine, charset);
            this.myParameters = parameters2;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions((CidrProcessBuilder.Parameters)this.myParameters, (BaseOutputReader.Options)super.readerOptions());
            if (options == null) {
                ParameterizedRemoteProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedRemoteProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteUtil$ParameterizedRemoteProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

