/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class CidrRSyncUtil {
    @NotNull
    public static File rsyncDirToLocal(@NotNull RemoteHost remoteHost, @NotNull String remotePath, @NotNull String localPath, boolean downloadingToRoot) throws IOException {
        Comparable<File> comparable;
        Comparable<File> result;
        if (remoteHost == null) {
            CidrRSyncUtil.$$$reportNull$$$0(0);
        }
        if (remotePath == null) {
            CidrRSyncUtil.$$$reportNull$$$0(1);
        }
        if (localPath == null) {
            CidrRSyncUtil.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        RemoteCredentials credentials = remoteHost.getCredentials();
        File logfile = FileUtil.createTempFile((String)"rsync_download", (String)".log");
        File fileListPath = null;
        if (RemoteUtil.isTextFilesSyncEnabled()) {
            if (SystemInfo.isWindows) {
                File wd = new File(localPath).getParentFile();
                FileUtil.createDirectory((File)wd);
                fileListPath = FileUtil.createTempFile((File)wd, (String)"fileList", (String)".txt");
            } else {
                fileListPath = FileUtil.createTempFile((String)"fileList", (String)".txt");
            }
            result = RemoteUtil.filterTextFiles(remoteHost, remotePath, fileListPath.toPath(), downloadingToRoot, false);
            fileListPath = result == null ? null : result.toFile();
        }
        try {
            ProgressIndicator indicator;
            result = new File(localPath);
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: rsync directory: " + remotePath + " -> " + localPath);
            }
            String fileListPathStr = fileListPath != null ? (SystemInfo.isWindows ? fileListPath.getName() : fileListPath.getPath()) : null;
            RSyncOptions rsyncOptions = new RSyncOptions().withFilesFrom(fileListPathStr).withLogfilePath(logfile.getPath()).withRelative(downloadingToRoot);
            if (Registry.is((String)"clion.resolve.symlinks.rsync")) {
                rsyncOptions = rsyncOptions.withCopyUnsafeLinks(true);
            }
            if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) == null) {
                indicator = new EmptyProgressIndicator();
            }
            if (downloadingToRoot && fileListPathStr != null) {
                remotePath = "/";
            }
            boolean success = RSyncUtil.downloadFolderWithRSync((String)localPath, (String)remotePath, (RemoteCredentials)credentials, (ProgressIndicator)indicator, (RSyncOptions)rsyncOptions);
            FileUtil.delete((File)logfile);
            if (!((File)result).exists() && success) {
                FileUtil.createDirectory(result);
            }
            Comparable<File> comparable2 = result;
            comparable = comparable2;
        }
        catch (SshRemoteHostIdentificationHasChangedException e) {
            RemoteHostUtil.LOG.info("rsync: remote host identification has changed");
            @NlsSafe String title = "rsync";
            RemoteUtil.NOTIFICATION_GROUP.createNotification("rsync", ToolchainsBundle.message("remote.rsync.fix.message", new Object[0]), NotificationType.ERROR).setSubtitle(e.getMessage()).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ToolchainsBundle.message("remote.rsync.fix", new Object[0]), () -> ProcessIOExecutorService.INSTANCE.execute(() -> {
                GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"ssh-keygen"});
                cmd.addParameters(new String[]{"-f", SystemProperties.getUserHome() + "/.ssh/known_hosts"});
                cmd.addParameters(new String[]{"-R", "[" + credentials.getHost() + "]:" + credentials.getPort()});
                try {
                    ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
                    output2.checkSuccess(RemoteHostUtil.LOG);
                }
                catch (ExecutionException ex) {
                    RemoteHostUtil.LOG.error("ERROR: " + cmd.getCommandLineString(), (Throwable)ex);
                }
            }))).addAction((AnAction)NotificationAction.createSimple((String)SshBundle.message((String)"notification.Anonymous.text.log.file", (Object[])new Object[0]), () -> RevealFileAction.openFile((File)logfile))).notify(null);
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.error("rsync directory failed: remote (" + remotePath + ") -> local (" + localPath + ")");
            throw new IOException(e);
        }
        finally {
            if (fileListPath != null) {
                FileUtil.delete((File)fileListPath);
            }
        }
        if (comparable == null) {
            CidrRSyncUtil.$$$reportNull$$$0(3);
        }
        return comparable;
    }

    public static boolean canUseRSync(@NotNull String hostId) {
        Application application;
        if (hostId == null) {
            CidrRSyncUtil.$$$reportNull$$$0(4);
        }
        return (application = ApplicationManager.getApplication()) != null && ((RemoteDeployment)application.getService(RemoteDeployment.class)).isUseRsync(hostId) && RSyncUtil.checkRsyncInstalled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/CidrRSyncUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/CidrRSyncUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "rsyncDirToLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rsyncDirToLocal";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canUseRSync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

