/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.model.impl;

import com.jetbrains.cidr.external.system.model.ExternalFileConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalFileConfigurationImpl;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/external/system/model/impl/ExternalFileConfigurationBuilder;", "", "file", "Ljava/io/File;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "<init>", "(Ljava/io/File;Lcom/jetbrains/cidr/lang/OCLanguageKind;)V", "getFile", "()Ljava/io/File;", "getLanguageKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "compilerSwitches", "", "", "invoke", "Lcom/jetbrains/cidr/external/system/model/ExternalFileConfiguration;", "withCompilerSwitches", "", "intellij.cidr.externalSystem"})
public final class ExternalFileConfigurationBuilder {
    @NotNull
    private final File file;
    @NotNull
    private final OCLanguageKind languageKind;
    @Nullable
    private List<String> compilerSwitches;

    public ExternalFileConfigurationBuilder(@NotNull File file, @NotNull OCLanguageKind languageKind) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        this.file = file;
        this.languageKind = languageKind;
    }

    public /* synthetic */ ExternalFileConfigurationBuilder(File file, OCLanguageKind oCLanguageKind, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            oCLanguageKind = (OCLanguageKind)CLanguageKind.CPP;
        }
        this(file, oCLanguageKind);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final OCLanguageKind getLanguageKind() {
        return this.languageKind;
    }

    @NotNull
    public final ExternalFileConfiguration invoke() {
        return new ExternalFileConfigurationImpl(this.file, this.languageKind, this.compilerSwitches);
    }

    @NotNull
    public final ExternalFileConfigurationBuilder withCompilerSwitches(@NotNull List<String> compilerSwitches) {
        Intrinsics.checkNotNullParameter(compilerSwitches, (String)"compilerSwitches");
        if (this.compilerSwitches == null) {
            this.compilerSwitches = new ArrayList();
        }
        List<String> list2 = this.compilerSwitches;
        Intrinsics.checkNotNull(list2);
        list2.addAll((Collection<String>)compilerSwitches);
        return this;
    }
}

