/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.HostConfig;
import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerDownloader;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerExecutor;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerProcessBuilder;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWithRemoteFSCacheLookup;
import com.jetbrains.cidr.system.RemoteFSCache;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 ]2\u00020\u00012\u00020\u0002:\u0001]B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\fH\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\b\u0010-\u001a\u00020\u001aH\u0016J\b\u0010.\u001a\u00020\u001aH\u0016J \u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020$H\u0016J\b\u00106\u001a\u00020$H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u001a082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a08H\u0016J\b\u0010:\u001a\u00020;H\u0016J\"\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u000200H\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020\u001dH\u0016J\b\u0010F\u001a\u00020\fH\u0016J\u001a\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020\u001a2\b\u0010I\u001a\u0004\u0018\u00010\u001aH\u0016J)\u0010J\u001a\u00020\f2\u0006\u0010K\u001a\u00020\u001a2\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0M\"\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010NJ)\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001a0M2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a082\u0006\u0010P\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010QJ!\u0010R\u001a\u00020$2\u0016\b\u0001\u0010S\u001a\u0010\u0012\u0002\b\u00030T\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bVH\u0096\u0001JD\u0010W\u001a8\u0012\f\u0012\n Y*\u0004\u0018\u00010X0X Y*\u001a\u0012\f\u0012\n Y*\u0004\u0018\u00010X0X0\u0012\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bV08\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bVH\u0097\u0001\u00a2\u0006\u0002\u0010\u0015J\t\u0010Z\u001a\u00020\u0018H\u0096\u0001J!\u0010[\u001a\u00020$2\u0016\b\u0001\u0010S\u001a\u0010\u0012\u0002\b\u00030T\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bVH\u0096\u0001J'\u0010\\\u001a\f0\b\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bV2\u0012\b\u0001\u0010S\u001a\f0\b\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bVH\u0097\u0001J'\u0010\\\u001a\f0\b\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bV2\u0012\b\u0001\u0010S\u001a\f0\f\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bVH\u0097\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0010\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b'\u0010(\u00a8\u0006^"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerHost;", "Lcom/jetbrains/cidr/system/HostMachine;", "Lcom/jetbrains/cidr/system/MappedHost;", "credentialsHolder", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "projectDir", "Ljava/io/File;", "<init>", "(Lcom/intellij/docker/remote/DockerCredentialsHolder;Lcom/intellij/docker/remote/DockerContainerSettings;Ljava/io/File;)V", "tmpDir", "Ljava/nio/file/Path;", "getTmpDir", "()Ljava/nio/file/Path;", "tmpDir$delegate", "Lkotlin/Lazy;", "bindVolumes", "", "Lcom/intellij/docker/agent/settings/DockerVolumeBinding;", "getBindVolumes", "()Ljava/util/List;", "bindVolumes$delegate", "volumeBindingsContainProjectDir", "", "convertToLocalPathIfNeeded", "", "hostPath", "mapper", "Lcom/intellij/util/PathMapper;", "getMapper", "()Lcom/intellij/util/PathMapper;", "mapper$delegate", "isPathOnHost", "getLocalPrettyPrintersDirectory", "setupPrettyPrinters", "", "fsCache", "Lcom/jetbrains/cidr/system/RemoteFSCache;", "getFsCache", "()Lcom/jetbrains/cidr/system/RemoteFSCache;", "fsCache$delegate", "getOSType", "Lcom/jetbrains/cidr/toolchains/OSType;", "isRemote", "getName", "getHostId", "sendSignal", "", "pid", "signalName", "mainProcess", "Ljava/lang/Process;", "invalidateCache", "markCacheInvalid", "resolveAndCache", "", "paths", "createProcessBuilder", "Lcom/jetbrains/cidr/system/CidrProcessBuilder;", "runProcess", "Lcom/intellij/execution/process/ProcessOutput;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "openNamedPipe", "Lcom/jetbrains/cidr/NamedPipe;", "getPathMapper", "getTempDirectory", "createTempDirectory", "prefix", "suffix", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "toCanonicalPath", "resolveSymlink", "(Ljava/util/List;Z)[Ljava/lang/String;", "destroyProcess", "p0", "Lcom/intellij/execution/process/BaseProcessHandler;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "getProcessList", "Lcom/intellij/execution/process/ProcessInfo;", "kotlin.jvm.PlatformType", "hasRemoteFS", "killProcessTree", "resolvePath", "Companion", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerHost.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,281:1\n1755#2,3:282\n1557#2:289\n1628#2,3:290\n774#2:293\n865#2,2:294\n1863#2,2:296\n1863#2,2:302\n14#3:285\n40#4,3:286\n1#5:298\n3829#6:299\n4344#6,2:300\n*S KotlinDebug\n*F\n+ 1 DockerHost.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerHost\n*L\n83#1:282,3\n107#1:289\n107#1:290,3\n111#1:293\n111#1:294,2\n112#1:296,2\n121#1:302,2\n208#1:285\n235#1:286,3\n120#1:299\n120#1:300,2\n*E\n"})
public final class DockerHost
implements HostMachine,
MappedHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LocalHost $$delegate_0;
    @NotNull
    private final DockerCredentialsHolder credentialsHolder;
    @Nullable
    private final DockerContainerSettings containerSettings;
    @NotNull
    private final Lazy tmpDir$delegate;
    @NotNull
    private final Lazy bindVolumes$delegate;
    @NotNull
    private final Lazy mapper$delegate;
    @NotNull
    private final Lazy fsCache$delegate;
    private static final boolean useTemporaryDirectoryForPrettyPrinters = SystemInfo.isMac;
    @NotNull
    private static final String containerPrettyPrintersMount = "/.clion-stl-pretty-printers";
    @NotNull
    private static final Lazy<Path> dotDocker$delegate = LazyKt.lazy(DockerHost::dotDocker_delegate$lambda$16);

    public DockerHost(@NotNull DockerCredentialsHolder credentialsHolder, @Nullable DockerContainerSettings containerSettings, @Nullable File projectDir) {
        Intrinsics.checkNotNullParameter((Object)credentialsHolder, (String)"credentialsHolder");
        this.$$delegate_0 = LocalHost.INSTANCE;
        this.credentialsHolder = credentialsHolder;
        this.containerSettings = containerSettings;
        this.tmpDir$delegate = LazyKt.lazy(() -> DockerHost.tmpDir_delegate$lambda$0(this));
        this.bindVolumes$delegate = LazyKt.lazy(() -> DockerHost.bindVolumes_delegate$lambda$1(this, projectDir));
        this.mapper$delegate = LazyKt.lazy(() -> DockerHost.mapper_delegate$lambda$11(this));
        this.fsCache$delegate = LazyKt.lazy(() -> DockerHost.fsCache_delegate$lambda$15(this));
    }

    private final Path getTmpDir() {
        Lazy lazy = this.tmpDir$delegate;
        return (Path)lazy.getValue();
    }

    private final List<DockerVolumeBinding> getBindVolumes() {
        Lazy lazy = this.bindVolumes$delegate;
        return (List)lazy.getValue();
    }

    private final boolean volumeBindingsContainProjectDir(File projectDir) {
        boolean bl;
        block6: {
            if (!CidrDockerUtil.isContainerOptionsEnabled() || this.containerSettings == null) {
                return false;
            }
            String canonicalProjectPath = FileUtil.toCanonicalPath((String)projectDir.getAbsolutePath(), (boolean)true);
            List list2 = this.containerSettings.getVolumeBindings();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getVolumeBindings(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    DockerVolumeBindingImpl binding = (DockerVolumeBindingImpl)element$iv;
                    boolean bl3 = false;
                    if (binding.isReadOnly()) {
                        bl2 = false;
                    } else {
                        String string = binding.getHostPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                        String hostPath = this.convertToLocalPathIfNeeded(string);
                        String canonicalVolumePath = FileUtil.toCanonicalPath((String)hostPath, (boolean)true);
                        bl2 = FileUtil.startsWith((String)canonicalProjectPath, (String)canonicalVolumePath);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean result = bl;
        return result;
    }

    private final String convertToLocalPathIfNeeded(String hostPath) {
        String string;
        String string2;
        if (SystemInfo.isWindows && StringsKt.startsWith$default((String)hostPath, (String)"/", (boolean)false, (int)2, null)) {
            DockerCloudConfiguration dockerCloudConfiguration;
            RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(this.credentialsHolder.getAccountName(), (ServerType)DockerCloudType.getInstance());
            if (remoteServer != null && (dockerCloudConfiguration = (DockerCloudConfiguration)remoteServer.getConfiguration()) != null) {
                DockerCloudConfiguration it = dockerCloudConfiguration;
                boolean bl = false;
                string2 = DockerUtils.convertDockerMachinePathToLocalPath((DockerCloudConfiguration)it, (String)hostPath);
            } else {
                string2 = null;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = hostPath;
        }
        return string;
    }

    private final PathMapper getMapper() {
        Lazy lazy = this.mapper$delegate;
        return (PathMapper)lazy.getValue();
    }

    private final boolean isPathOnHost(String hostPath) {
        return SystemInfo.isWindows ? OSAgnosticPathUtil.isAbsolute((String)hostPath) : FileUtil.isAbsolute((String)hostPath);
    }

    private final Path getLocalPrettyPrintersDirectory() {
        Path path;
        if (useTemporaryDirectoryForPrettyPrinters) {
            Path path2 = Path.of(FileUtil.getTempDirectory(), new String[0]).resolve(".clion-pretty-printers").resolve("gdb");
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            Path path3 = CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().toPath();
            Intrinsics.checkNotNull((Object)path3);
            path = path3;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupPrettyPrinters() {
        Path localPrettyPrintersDirectory = this.getLocalPrettyPrintersDirectory();
        if (Intrinsics.areEqual((Object)localPrettyPrintersDirectory, (Object)CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().toPath())) {
            return;
        }
        DockerHelper dockerService = DockerHelper.getInstance();
        Intrinsics.checkNotNull((Object)dockerService);
        DockerHelper dockerHelper = dockerService;
        synchronized (dockerHelper) {
            boolean bl = false;
            if (Files.exists(localPrettyPrintersDirectory, new LinkOption[0])) {
                Files.walk(localPrettyPrintersDirectory, 1, new FileVisitOption[0]).forEach(arg_0 -> DockerHost.setupPrettyPrinters$lambda$14$lambda$13(arg_0 -> DockerHost.setupPrettyPrinters$lambda$14$lambda$12(localPrettyPrintersDirectory, arg_0), arg_0));
            }
            FileUtil.copyDir((File)CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters(), (File)localPrettyPrintersDirectory.toFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    private final RemoteFSCache getFsCache() {
        Lazy lazy = this.fsCache$delegate;
        return (RemoteFSCache)lazy.getValue();
    }

    @NotNull
    public OSType getOSType() {
        return OSType.LINUX;
    }

    public boolean isRemote() {
        return true;
    }

    @NotNull
    public String getName() {
        return "Docker (" + this.credentialsHolder.getImageName() + ")";
    }

    @NotNull
    public String getHostId() {
        return "Docker null " + this.credentialsHolder.getAccountName() + "-" + this.credentialsHolder.getImageName();
    }

    public int sendSignal(int pid, @NotNull String signalName, @NotNull Process mainProcess) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        Intrinsics.checkNotNullParameter((Object)mainProcess, (String)"mainProcess");
        if (mainProcess instanceof DockerExecProcess) {
            RemoteDockerApplicationRuntime runtime = ((DockerExecProcess)mainProcess).getApplicationRuntime();
            String[] stringArray = new String[]{"kill", "-s", signalName, String.valueOf(pid)};
            ProcessOutput processOutput = runtime.exec(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"exec(...)");
            ProcessOutput output2 = processOutput;
            return output2.getExitCode();
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Cannot cast init process to DockerExecProcess");
        return -1;
    }

    public int sendSignal(int pid, @NotNull String signalName) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        throw new UnsupportedOperationException();
    }

    public void invalidateCache() {
        this.getFsCache().invalidateCache();
    }

    public void markCacheInvalid() {
        this.getFsCache().markInvalidated();
    }

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        List<String> list2 = this.getFsCache().resolveAndCache(paths);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolveAndCache(...)");
        return list2;
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        return new DockerProcessBuilder(this.credentialsHolder, this.containerSettings, this.getBindVolumes(), this.getPathMapper());
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (AdvancedSettings.Companion.getBoolean("clion.docker.use.exec.for.short-lived.processes")) {
            boolean $i$f$service = false;
            Class<DockerExecutor> serviceClass$iv = DockerExecutor.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((DockerExecutor)object).exec(this.credentialsHolder, this.getBindVolumes(), this.getPathMapper(), this.containerSettings, cl);
        }
        ProcessOutput processOutput = super.runProcess(cl, indicator, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @NotNull
    public NamedPipe openNamedPipe() {
        String string = this.getPathMapper().convertToRemote(((Object)PathKt.generateRandomPath((Path)this.getTempDirectory())).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        String pipeName = string;
        return (NamedPipe)new RemoteUnixPipe((HostMachine)this, pipeName);
    }

    @NotNull
    public PathMapper getPathMapper() {
        return new PathMapperWithRemoteFSCacheLookup(this.getMapper(), this.getFsCache());
    }

    @NotNull
    public Path getTempDirectory() {
        return this.getTmpDir();
    }

    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = suffix;
        if (string == null) {
            string = "";
        }
        String prefixAndSuffix = prefix + string;
        Path path = Files.createTempDirectory(this.getTempDirectory(), prefixAndSuffix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        return path;
    }

    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        String[] others = new String[more.length];
        int n = more.length;
        for (int i = 0; i < n; ++i) {
            others[i] = this.getPathMapper().convertToLocal(more[i]);
        }
        Path path = Paths.get(this.getPathMapper().convertToLocal(first), Arrays.copyOf(others, others.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public String[] toCanonicalPath(@NotNull List<String> paths, boolean resolveSymlink) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String[] stringArray = this.getFsCache().toCanonicalPathAndResolveSymlink(paths);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toCanonicalPathAndResolveSymlink(...)");
        return stringArray;
    }

    public boolean hasRemoteFS() {
        return this.$$delegate_0.hasRemoteFS();
    }

    public void destroyProcess(@NotNull BaseProcessHandler<?> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.$$delegate_0.destroyProcess(p0);
    }

    public void killProcessTree(@NotNull BaseProcessHandler<?> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.$$delegate_0.killProcessTree(p0);
    }

    @NotNull
    public List<ProcessInfo> getProcessList() {
        List list2 = this.$$delegate_0.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProcessList(...)");
        return list2;
    }

    @NotNull
    public File resolvePath(@NotNull Path p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        File file = this.$$delegate_0.resolvePath(p0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolvePath(...)");
        return file;
    }

    @NotNull
    public File resolvePath(@NotNull File p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        File file = this.$$delegate_0.resolvePath(p0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolvePath(...)");
        return file;
    }

    private static final Path tmpDir_delegate$lambda$0(DockerHost this$0) {
        String string = Registry.Companion.is("clion.docker.use.system.tmp") ? PathManager.getTempPath() : FileUtil.getTempDirectory();
        Intrinsics.checkNotNull((Object)string);
        String tmpLocation = string;
        Path path = CidrDockerUtil.suggestPath(Path.of(tmpLocation, new String[0]).resolve("clion_docker_tmp"), this$0.credentialsHolder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"suggestPath(...)");
        Path path2 = path;
        FileUtil.createDirectory((File)path2.toFile());
        return path2;
    }

    private static final List bindVolumes_delegate$lambda$1(DockerHost this$0, File $projectDir) {
        Path localPrettyPrintersPath;
        VolumesBuilder volumesBuilder = VolumesBuilder.builder();
        Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder, (String)"builder(...)");
        VolumesBuilder builder = volumesBuilder;
        builder.addBoundVolume("/tmp/misc", ((Object)this$0.getTmpDir()).toString());
        if ($projectDir != null && (Registry.Companion.is("clion.docker.force.project.mount") || !this$0.volumeBindingsContainProjectDir($projectDir))) {
            builder.addBoundVolume("/tmp/" + $projectDir.getName(), $projectDir.getAbsolutePath());
        }
        if (!Files.exists(localPrettyPrintersPath = this$0.getLocalPrettyPrintersDirectory(), new LinkOption[0])) {
            FileUtil.createDirectory((File)localPrettyPrintersPath.toFile());
        }
        builder.addBoundVolume(containerPrettyPrintersMount, ((Object)localPrettyPrintersPath).toString(), true);
        DockerVolumeBinding[] dockerVolumeBindingArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dockerVolumeBindingArray, (String)"build(...)");
        return ArraysKt.asList((Object[])dockerVolumeBindingArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PathMappingSettings mapper_delegate$lambda$11(DockerHost this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getBindVolumes();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerVolumeBinding dockerVolumeBinding = (DockerVolumeBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PathMappingSettings.PathMapping(it.getHostPath(), it.getContainerPath()));
        }
        List list2 = (List)destination$iv$iv;
        PathMappingSettings result = new PathMappingSettings(list2);
        if (CidrDockerUtil.isContainerOptionsEnabled()) {
            CreateContainerCmd createContainerCmd;
            Object element$iv$iv;
            List list3;
            $this$map$iv = this$0.containerSettings;
            if ($this$map$iv != null && (list3 = $this$map$iv.getVolumeBindings()) != null) {
                void $this$forEach$iv;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                destination$iv$iv = list3;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator bl = $this$filterTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    element$iv$iv = bl.next();
                    DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv$iv;
                    boolean bl2 = false;
                    String string = it.getHostPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                    if (!this$0.isPathOnHost(string)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv;
                    boolean bl3 = false;
                    String string = it.getHostPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                    result.add(new PathMappingSettings.PathMapping(this$0.convertToLocalPathIfNeeded(string), it.getContainerPath()));
                }
            }
            RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(this$0.credentialsHolder);
            Object object2 = this$0.containerSettings;
            if (object2 != null && (object2 = object2.getRunCliOptions()) != null) {
                Object it = object2;
                boolean bl = false;
                createContainerCmd = CidrDockerUtil.tryParseContainerCmd(dockerRuntime, (String)it);
            } else {
                createContainerCmd = null;
            }
            Closeable closeable = (Closeable)createContainerCmd;
            object = null;
            try {
                Unit unit;
                Bind[] bindArray;
                HostConfig hostConfig;
                CreateContainerCmd cmd = (CreateContainerCmd)closeable;
                boolean bl = false;
                if (cmd != null && (hostConfig = cmd.getHostConfig()) != null && (bindArray = hostConfig.getBinds()) != null) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Bind[] it = bindArray;
                    boolean $i$f$filter = false;
                    element$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv2;
                        void it2 = element$iv$iv2 = $this$filterTo$iv$iv[i];
                        boolean bl4 = false;
                        String string = it2.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (!this$0.isPathOnHost(string)) continue;
                        destination$iv$iv3.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv3;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Bind it3 = (Bind)element$iv;
                        boolean bl5 = false;
                        String string = it3.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        result.add(new PathMappingSettings.PathMapping(this$0.convertToLocalPathIfNeeded(string), it3.getVolume().getPath()));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        String string = CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String bundledGDBSTLPrettyPrinters = string;
        if (!result.canReplaceLocal(bundledGDBSTLPrettyPrinters)) {
            result.add(new PathMappingSettings.PathMapping(bundledGDBSTLPrettyPrinters, containerPrettyPrintersMount));
        }
        return result;
    }

    private static final Unit setupPrettyPrinters$lambda$14$lambda$12(Path $localPrettyPrintersDirectory, Path it) {
        if (!Intrinsics.areEqual((Object)it, (Object)$localPrettyPrintersDirectory)) {
            FileUtil.deleteRecursively((Path)it);
        }
        return Unit.INSTANCE;
    }

    private static final void setupPrettyPrinters$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final RemoteFSCache fsCache_delegate$lambda$15(DockerHost this$0) {
        if (!CidrDockerUtil.isValid(this$0.credentialsHolder)) {
            throw new ExecutionException(CidrDockerBundle.message("dialog.message.docker.configuration.is.not.valid", new Object[0]));
        }
        File cacheDirectory = CidrDockerUtil.suggestPath(DockerHost.Companion.getDotDocker(), this$0.credentialsHolder).toFile();
        return new RemoteFSCache(cacheDirectory, this$0.getMapper(), new DockerDownloader(this$0.credentialsHolder, this$0.containerSettings, this$0.getBindVolumes()), this$0);
    }

    private static final Path dotDocker_delegate$lambda$16() {
        return PathManager.getSystemDir().resolve(".docker");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerHost$Companion;", "", "<init>", "()V", "useTemporaryDirectoryForPrettyPrinters", "", "containerPrettyPrintersMount", "", "dotDocker", "Ljava/nio/file/Path;", "getDotDocker", "()Ljava/nio/file/Path;", "dotDocker$delegate", "Lkotlin/Lazy;", "intellij.clion.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDotDocker() {
            Lazy lazy = dotDocker$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Path)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

