/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.ui.GridBag;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerCredentialsComponent;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHost;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerSettingsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerToolSet;
import com.jetbrains.cidr.cpp.toolchains.ui.ToolchainPanel;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerHelperImpl
implements DockerHelper {
    private static final String CIDR_CONTAINER_SETTINGS = "CIDR_DOCKER_CONTAINER_SETTINGS";
    private static final Map<CacheKey, DockerHost> HOST_CACHE = new ConcurrentHashMap<CacheKey, DockerHost>();

    @Override
    public boolean isAvailable() {
        return Registry.is((String)"clion.docker");
    }

    @Override
    public Icon getToolSetIcon() {
        return DockerIcons.Docker;
    }

    @Override
    public DockerSettingsConfigurable createCredentialsEditor(@NotNull ToolchainPanel mainPanel, @NotNull GridBag bag) {
        if (mainPanel == null) {
            DockerHelperImpl.$$$reportNull$$$0(0);
        }
        if (bag == null) {
            DockerHelperImpl.$$$reportNull$$$0(1);
        }
        return new DockerCredentialsComponent(mainPanel, bag);
    }

    @Override
    public CPPToolSet createDockerToolSet(@NotNull CPPToolSet.Kind kind) {
        if (kind == null) {
            DockerHelperImpl.$$$reportNull$$$0(2);
        }
        return new DockerToolSet(kind);
    }

    @Override
    public HostMachine createHostMachine(@NotNull SettingsHandler handler2, @Nullable File projectDir) {
        if (handler2 == null) {
            DockerHelperImpl.$$$reportNull$$$0(3);
        }
        CidrDockerSettingsHandler internalHandler = DockerHelperImpl.check(handler2);
        DockerCredentialsHolder credentials = internalHandler.getDockerCredentials();
        DockerContainerSettings settings = internalHandler.getContainerSettings();
        if (AdvancedSettings.getBoolean((String)"clion.docker.cache.hosts")) {
            CacheKey key = new CacheKey(credentials, settings, projectDir);
            return HOST_CACHE.computeIfAbsent(key, k -> new DockerHost(k.credentials, k.settings, k.project));
        }
        return new DockerHost(credentials, settings, projectDir);
    }

    @Override
    public SettingsHandler loadDockerSettings(@NotNull Element element) {
        if (element == null) {
            DockerHelperImpl.$$$reportNull$$$0(4);
        }
        CidrDockerSettingsHandler handler2 = new CidrDockerSettingsHandler();
        handler2.load(element);
        return handler2;
    }

    @Override
    public void setupTestToolchain(CPPToolchains.Toolchain toolchain, String param) {
        String name;
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        RemoteServer server = remoteServersManager.findByName(name = "DOCKER", (ServerType)DockerCloudType.getInstance());
        if (server == null) {
            server = remoteServersManager.createServer((ServerType)DockerCloudType.getInstance(), name);
            DockerCloudConfiguration configuration = (DockerCloudConfiguration)server.getConfiguration();
            configuration.setApiUrl(SystemInfoRt.isWindows ? "npipe:////./pipe/docker_engine" : "unix:///var/run/docker.sock");
            String wsl = System.getProperty("cidr.docker.use.wsl");
            if (SystemInfoRt.isWindows && wsl != null) {
                configuration.setDockerExePath("/usr/bin/docker");
                configuration.setCustomConfiguratorId("DockerWslConnectionConfigurator");
                configuration.getContributedData().put("DockerWslConnectionConfigurator.distribution", wsl);
            }
            remoteServersManager.addServer(server);
        }
        CidrDockerSettingsHandler settingsHandler = new CidrDockerSettingsHandler();
        settingsHandler.myCredentials.setImageName(param);
        settingsHandler.myCredentials.setAccountName(name);
        DockerContainerSettings settings = new DockerContainerSettings();
        settings.setRunCliOptions("--entrypoint= --rm");
        DockerVolumeBindingImpl hostTmpBinding = new DockerVolumeBindingImpl("/host_tmp", FileUtilRt.getTempDirectory(), false);
        DockerVolumeBindingImpl systemDirBinding = new DockerVolumeBindingImpl("/system_tmp", PathManagerEx.getAppSystemDir().toString(), false);
        settings.setVolumeBindings(List.of(hostTmpBinding, systemDirBinding));
        settingsHandler.myContainerSettings = settings;
        toolchain.setDockerSettingsHandler(settingsHandler);
        toolchain.setCustomCMakePath("/usr/bin/cmake");
    }

    static CidrDockerSettingsHandler check(@NotNull SettingsHandler handler2) {
        if (handler2 == null) {
            DockerHelperImpl.$$$reportNull$$$0(5);
        }
        try {
            return (CidrDockerSettingsHandler)handler2;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCredentialsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDockerToolSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHostMachine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDockerSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CidrDockerSettingsHandler
    implements SettingsHandler {
        private final DockerCredentialsHolder myCredentials;
        private DockerContainerSettings myContainerSettings;

        CidrDockerSettingsHandler() {
            this.myContainerSettings = null;
            this.myCredentials = new DockerCredentialsHolder();
        }

        CidrDockerSettingsHandler(@NotNull DockerCredentialsHolder credentials, @Nullable DockerContainerSettings settings) {
            if (credentials == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(0);
            }
            this.myContainerSettings = null;
            this.myCredentials = credentials;
            this.myContainerSettings = settings;
        }

        public DockerCredentialsHolder getDockerCredentials() {
            return this.myCredentials;
        }

        public DockerContainerSettings getContainerSettings() {
            return this.myContainerSettings;
        }

        @Override
        public void save(@NotNull Element root) {
            if (root == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(1);
            }
            this.myCredentials.save(root);
            if (this.myContainerSettings != null) {
                Element settingElement = new Element(DockerHelperImpl.CIDR_CONTAINER_SETTINGS);
                XmlSerializer.serializeInto((Object)this.myContainerSettings, (Element)settingElement);
                root.addContent(settingElement);
            }
        }

        @Override
        public void load(@NotNull Element root) {
            if (root == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(2);
            }
            this.myCredentials.load(root);
            Element settingsElement = root.getChild(DockerHelperImpl.CIDR_CONTAINER_SETTINGS);
            if (settingsElement != null) {
                this.myContainerSettings = (DockerContainerSettings)XmlSerializer.deserialize((Element)settingsElement, DockerContainerSettings.class);
                DockerContainerSettings.upgradeSettings(null, (DockerContainerSettings)this.myContainerSettings, (int)2);
            }
        }

        @Override
        @NotNull
        public SettingsHandler copy() {
            DockerCredentialsHolder credentials = new DockerCredentialsHolder(this.myCredentials);
            DockerContainerSettings settings = null;
            if (this.myContainerSettings != null) {
                settings = new DockerContainerSettings();
                this.myContainerSettings.copyTo(settings);
            }
            return new CidrDockerSettingsHandler(credentials, settings);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrDockerSettingsHandler handler2 = (CidrDockerSettingsHandler)o;
            return Objects.equals(this.myCredentials, handler2.myCredentials) && Objects.equals(this.myContainerSettings, handler2.myContainerSettings);
        }

        public int hashCode() {
            return Objects.hash(this.myCredentials, this.myContainerSettings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerHelperImpl$CidrDockerSettingsHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record CacheKey(DockerCredentialsHolder credentials, DockerContainerSettings settings, File project) {
    }
}

