/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.EnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.LinuxEnvironmentReader;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.PathSeparator;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLDistribution;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSL
extends CPPToolSet {
    public static final Logger LOG = Logger.getInstance(WSL.class);
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;
    private final CidrWSLDistribution delegate;

    public WSL(@NotNull String name) {
        if (name == null) {
            WSL.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.WSL);
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.delegate = new CidrWSLDistribution(name);
    }

    @NotNull
    public String getWslDistributionName() {
        String string = this.delegate.getWslDistributionName();
        if (string == null) {
            WSL.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return this.delegate.getWslDistribution();
    }

    @Nullable
    public WSLDistribution getWslDistributionFast() {
        return this.delegate.getWslDistributionFast();
    }

    @Override
    @Nullable
    public String readVersion() {
        WSLDistribution distribution = this.getWslDistribution();
        return distribution != null ? distribution.readReleaseInfo() : null;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        WSLDistribution distribution = this.getWslDistribution();
        if (distribution == null) {
            return null;
        }
        int version = distribution.getVersion();
        return version > 0 ? new ToolVersion(version, 0, 0) : null;
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            WSL.$$$reportNull$$$0(2);
        }
        return null;
    }

    public CidrWSLDistribution getDelegate() {
        return this.delegate;
    }

    public static List<String> getDistributions() {
        return ContainerUtil.map((Collection)WSLCidrUtil.getAvailableDistributions(), dist -> dist.getMsId());
    }

    @Override
    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.UNIX;
        if (cidrFileSeparators == null) {
            WSL.$$$reportNull$$$0(3);
        }
        return cidrFileSeparators;
    }

    @Override
    @NotNull
    public File getGDBPath() {
        return new File("/usr/bin/gdb");
    }

    @Override
    public boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            WSL.$$$reportNull$$$0(4);
        }
        return debuggerKind == CPPDebugger.Kind.CUSTOM_GDB;
    }

    @Override
    @NotNull
    public PathSeparator getPathSeparator() {
        PathSeparator pathSeparator = PathSeparator.UNIX;
        if (pathSeparator == null) {
            WSL.$$$reportNull$$$0(5);
        }
        return pathSeparator;
    }

    @Contract(value="_,null -> null; _,!null -> !null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        return this.delegate.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
    }

    @Contract(value="null -> null; !null -> !null")
    public String toEnvPath(@Nullable String localPath) {
        return this.delegate.toEnvPath(localPath);
    }

    @NotNull
    String resolveSymlink(@NotNull String path) {
        if (path == null) {
            WSL.$$$reportNull$$$0(6);
        }
        String string = this.delegate.resolveSymlink(path);
        if (string == null) {
            WSL.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isAbsolutePath(@NotNull String wslOrWindowsPath) {
        if (wslOrWindowsPath == null) {
            WSL.$$$reportNull$$$0(8);
        }
        return this.delegate.isAbsolutePath(wslOrWindowsPath);
    }

    public static void initTestWSLToolchain(@NotNull CPPToolchains.Toolchain testToolchain, @NotNull String name) {
        if (testToolchain == null) {
            WSL.$$$reportNull$$$0(9);
        }
        if (name == null) {
            WSL.$$$reportNull$$$0(10);
        }
        if (LOG.assertTrue(WSLCidrUtil.hasAvailableDistributions())) {
            WSLDistribution wslDistribution = WSLCidrUtil.getDistributionByMsId((String)name);
            if (wslDistribution == null) {
                throw new RuntimeException("WSL: cannot find distribution by name (msId): " + name);
            }
            testToolchain.setToolSetKind(CPPToolSet.Kind.WSL);
            testToolchain.setToolSetPath(wslDistribution.getMsId());
            testToolchain.setCustomCMakePath(System.getProperty("cpp.test.wsl.cmake", "/usr/bin/cmake"));
        }
    }

    @Override
    protected EnvironmentReader createEnvironmentReader(@NotNull HostMachine hostMachine) {
        if (hostMachine == null) {
            WSL.$$$reportNull$$$0(11);
        }
        return new LinuxEnvironmentReader(hostMachine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslOrWindowsPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testToolchain";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSeparator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initTestWSLToolchain";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentReader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

