/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.BuildTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/Ninja;", "Lcom/jetbrains/cidr/cpp/toolchains/BuildTool;", "executable", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "<init>", "(Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)V", "readVersion", "", "readToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "Companion", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nNinja.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ninja.kt\ncom/jetbrains/cidr/cpp/toolchains/Ninja\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class Ninja
extends BuildTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CPPEnvironment environment;
    @NotNull
    private static final String VERSION_FLAG = "--version";

    public Ninja(@NotNull File executable, @NotNull CPPEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(executable);
        this.environment = environment;
    }

    @Override
    @Nullable
    public String readVersion() {
        String[] stringArray = new String[]{this.getExecutable().getAbsolutePath(), VERSION_FLAG};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        ProcessOutput processOutput = this.environment.getHostMachine().runProcess(commandLine, 10000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output2 = processOutput;
        String string = output2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String result = StringKt.nullize((String)((String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string))), (boolean)true);
        CPPLog.logReadVersion("Ninja", this.myExecutable, result);
        return result;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        ToolVersion toolVersion;
        String string = this.readVersion();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Pattern[] patternArray = new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN};
            toolVersion = ToolVersion.parse((String)it, (Pattern[])patternArray);
        } else {
            toolVersion = null;
        }
        return toolVersion;
    }

    @JvmStatic
    @Nullable
    public static final Path getBundledNinja(@NotNull CPPEnvironment environment) {
        return Companion.getBundledNinja(environment);
    }

    @JvmStatic
    public static final boolean isNinjaExecutableName(@NotNull String path) {
        return Companion.isNinjaExecutableName(path);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/Ninja$Companion;", "", "<init>", "()V", "VERSION_FLAG", "", "getBundledNinja", "Ljava/nio/file/Path;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "isNinjaExecutableName", "", "path", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Path getBundledNinja(@NotNull CPPEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            if (environment.getHostMachine().isRemote()) {
                return null;
            }
            String platformBinName = SystemInfo.isWindows ? "ninja.exe" : "ninja";
            String platformBinPath = "ninja/" + (environment.isCygwin() ? CidrPathManager.getPlatformRelativePath((String)"cygwin", (String)platformBinName) : CidrPathManager.getPlatformRelativePath((String)platformBinName));
            Path path = CidrPathManager.getBinPath(Ninja.class, (String)"clion/bin", (String)platformBinPath, null);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getBinPath(...)");
            Path ninjaPath = path;
            if (Files.exists(ninjaPath, new LinkOption[0])) {
                return ninjaPath;
            }
            return null;
        }

        @JvmStatic
        public final boolean isNinjaExecutableName(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String name = FilesKt.getNameWithoutExtension((File)new File(path));
            return Intrinsics.areEqual((Object)name, (Object)"ninja") || Intrinsics.areEqual((Object)name, (Object)"ninja-build") || Intrinsics.areEqual((Object)name, (Object)"samu");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

