/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.CidrEnvironmentUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.PathSeparator;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Cygwin
extends CPPToolSetWithHome {
    private static final SLRUMap<CacheKey, String> ourLocalToCygwinCache = new SLRUMap(10000, 10000);
    private static final SLRUMap<CacheKey, String> ourCygwinToLocalCache = new SLRUMap(10000, 10000);
    public static final Version MIN_VERSION = new Version(2, 8, 0);
    public static final Version MAX_VERSION = new Version(3, -1, -1);
    private final String myNormalizedHomePath;

    public Cygwin(@NotNull File home) {
        if (home == null) {
            Cygwin.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.CYGWIN, home);
        this.myNormalizedHomePath = FileUtil.normalize((String)home.getPath());
    }

    public boolean isCygwin64() {
        return Cygwin.isCygwin64(this.myHome);
    }

    private static boolean isCygwin64(@NotNull File home) {
        String result;
        File uname;
        if (home == null) {
            Cygwin.$$$reportNull$$$0(1);
        }
        if ((uname = new File(home, "/bin/uname.exe")).isFile() && uname.canExecute() && (result = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{uname.getAbsolutePath(), "-m"}))) != null) {
            return result.trim().equalsIgnoreCase("x86_64");
        }
        return false;
    }

    @Override
    public boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            Cygwin.$$$reportNull$$$0(2);
        }
        return debuggerKind == CPPDebugger.Kind.CUSTOM_GDB;
    }

    @Override
    @Nullable
    public File getGDBPath() {
        File file = this.getSubFile("bin/gdb.exe");
        return file.exists() ? file : null;
    }

    @Contract(value="null -> null")
    public static File getCMakePath(@Nullable File home) {
        return home == null ? null : new File(home, "bin/cmake.exe");
    }

    @Contract(value="null -> null")
    public static File getGDBPath(@Nullable File home) {
        return home == null ? null : new File(home, "bin/gdb.exe");
    }

    @Override
    @Nullable
    public String readVersion() {
        return Cygwin.readVersion(this.myHome);
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            Cygwin.$$$reportNull$$$0(3);
        }
        return Cygwin.checkVersion(version, this.isCygwin64());
    }

    @Nullable
    public static String checkVersion(@NotNull String version, boolean isX64) {
        if (version == null) {
            Cygwin.$$$reportNull$$$0(4);
        }
        if (isX64) {
            return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, Cygwin.parseVersion(version));
        }
        return "32-bit Cygwin is not supported, please install 64-bit version";
    }

    @NotNull
    private static ToolVersion parseVersion(@NotNull String version) {
        if (version == null) {
            Cygwin.$$$reportNull$$$0(5);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
        if (toolVersion == null) {
            Cygwin.$$$reportNull$$$0(6);
        }
        return toolVersion;
    }

    @Nullable
    public static String readVersion(@Nullable File home) {
        if (home == null) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.logReadVersion("Cygwin", null);
            }
            return null;
        }
        File exec = new File(home, "/bin/cygcheck.exe");
        if (!exec.isFile() || !exec.canExecute()) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.logReadVersion("Cygwin", exec);
            }
            return null;
        }
        String result = CidrRunProcessUtil.readOneLineWithProgress((GeneralCommandLine)new GeneralCommandLine(new String[]{exec.getAbsolutePath(), "-V"}), (int)10000);
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("Cygwin", exec, result);
        }
        return result == null ? null : StringUtil.trimStart((String)result, (String)"cygcheck (cygwin) ");
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        String version = this.readVersion();
        return version == null ? null : Cygwin.parseVersion(version);
    }

    @Contract(value="null, _ -> null")
    public static String toLocalPath(@Nullable String cygwinPath, @Nullable Cygwin cygwin) {
        return Cygwin.toLocalPath(null, cygwinPath, cygwin);
    }

    @Contract(value="_, null, _ -> null")
    public static String toLocalPath(@Nullable File localBaseDir, @Nullable String cygwinPath, @Nullable Cygwin cygwin) {
        if (cygwinPath == null) {
            return null;
        }
        if (FileUtil.isWindowsAbsolutePath((String)cygwinPath)) {
            return cygwinPath;
        }
        if (!FileUtil.isUnixAbsolutePath((String)cygwinPath) && localBaseDir != null) {
            String baseDirPath = Cygwin.toCygwinPath(localBaseDir.getPath(), cygwin);
            baseDirPath = StringUtil.trimEnd((String)baseDirPath, (String)"/");
            cygwinPath = FileUtil.toCanonicalPath((String)(baseDirPath + "/" + cygwinPath));
        }
        return Cygwin.toLocalPathUnchecked(cygwinPath, cygwin);
    }

    @Contract(value="null, _ -> null")
    public static String toLocalPathUnchecked(@Nullable String cygwinPath, @Nullable Cygwin cygwin) {
        if (cygwinPath == null) {
            return null;
        }
        return Cygwin.doConvert(true, cygwinPath, cygwin, ourCygwinToLocalCache);
    }

    public static boolean isAbsolutePath(@NotNull String cygwinOrWindowsPath) {
        if (cygwinOrWindowsPath == null) {
            Cygwin.$$$reportNull$$$0(7);
        }
        return OSAgnosticPathUtil.isAbsolute((String)cygwinOrWindowsPath);
    }

    @Contract(value="null, _ -> null")
    public static String toCygwinPath(@Nullable String localPath, @Nullable Cygwin cygwin) {
        return Cygwin.doConvert(false, localPath, cygwin, ourLocalToCygwinCache);
    }

    @Override
    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.WINDOWS_UNIX;
        if (cidrFileSeparators == null) {
            Cygwin.$$$reportNull$$$0(8);
        }
        return cidrFileSeparators;
    }

    public static void convertPathVariableToCygwin(@NotNull GeneralCommandLine cl, @Nullable Cygwin cygwin) {
        String path;
        if (cl == null) {
            Cygwin.$$$reportNull$$$0(9);
        }
        if (cygwin != null && (path = (String)cl.getEnvironment().get("PATH")) != null) {
            List paths = ContainerUtil.map((Object[])path.split(";"), s -> Cygwin.toCygwinPath(s, cygwin));
            cl.getEnvironment().put("PATH", StringUtil.join((Collection)paths, (String)":"));
        }
    }

    @Override
    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<CPPToolSet.Option> options) {
        if (cl == null) {
            Cygwin.$$$reportNull$$$0(10);
        }
        if (prepareFor == null) {
            Cygwin.$$$reportNull$$$0(11);
        }
        if (options == null) {
            Cygwin.$$$reportNull$$$0(12);
        }
        this.prependPathVariable(cl, this.getSubFilePath("bin"), this.getSubFilePath("usr\\local\\bin"));
        Map env = cl.getEnvironment();
        if (cl.isPassParentEnvironment()) {
            Map system = cl.getParentEnvironment();
            if (system.containsKey("TEMP")) {
                env.put("TEMP", "/tmp");
            }
            if (system.containsKey("TMP")) {
                env.put("TMP", "/tmp");
            }
            if (system.containsKey("USERNAME")) {
                env.put("USER", (String)system.get("USERNAME"));
            }
            if (system.containsKey("COMPUTERNAME")) {
                env.put("HOSTNAME", (String)system.get("COMPUTERNAME"));
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            env.put("CMAKE_LEGACY_CYGWIN_WIN32", "0");
        }
    }

    public static boolean processCygwinInstallations(CPPToolSet.InstallationProcessor processor) {
        List<CPPToolSet.VersionInfo> found = Cygwin.createSortedVersionsList();
        Set processed = FileCollectionFactory.createCanonicalFileSet();
        Processor foundProcessor = file -> {
            if (!processed.add(file)) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            String version = Cygwin.readVersion(file);
            if (version == null) {
                return true;
            }
            boolean is64 = Cygwin.isCygwin64(file);
            found.add(new CPPToolSet.VersionInfo(version, (File)file, is64));
            return true;
        };
        HashSet<String> installations = new HashSet<String>();
        String keyPath = "SOFTWARE\\Cygwin\\Installations";
        installations.addAll(CPPToolchainsUtil.getRegistryValues(WinReg.HKEY_CURRENT_USER, keyPath));
        installations.addAll(CPPToolchainsUtil.getRegistryValues(WinReg.HKEY_LOCAL_MACHINE, keyPath));
        for (String path : installations) {
            File file2 = new File(path = StringUtil.trimStart((String)path, (String)"\\??\\"));
            if (foundProcessor.process((Object)file2)) continue;
            return false;
        }
        Object[] rootDirs = new File("C:\\").listFiles();
        if (rootDirs != null) {
            Arrays.sort(rootDirs);
            for (Object each : rootDirs) {
                if (!((File)each).isDirectory() || !StringUtil.containsIgnoreCase((String)((File)each).getName(), (String)"cygwin") || foundProcessor.process(each)) continue;
                return false;
            }
        }
        for (CPPToolSet.VersionInfo eachFound : found) {
            if (processor.process(eachFound.dir(), eachFound.fullySupported())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, null, _, _ -> null")
    private static String doConvert(boolean toWindows, @Nullable String path, @Nullable Cygwin cygwin, SLRUMap<CacheKey, String> cache) {
        if (path == null) {
            return null;
        }
        if (cygwin == null) {
            return path;
        }
        if (!SystemInfo.isWindows) {
            return path;
        }
        CacheKey key = new CacheKey(path, cygwin.myNormalizedHomePath);
        SLRUMap<CacheKey, String> sLRUMap = cache;
        synchronized (sLRUMap) {
            String cached = (String)cache.get((Object)key);
            if (cached != null) {
                return cached;
            }
        }
        String result = Cygwin.runCygpath(toWindows, path, cygwin);
        if (result == null) {
            return path;
        }
        SLRUMap<CacheKey, String> sLRUMap2 = cache;
        synchronized (sLRUMap2) {
            cache.put((Object)key, (Object)result);
        }
        return result;
    }

    @Override
    @NotNull
    public Map<String, String> readEnvironment(@NotNull String environmentFile, @NotNull HostMachine hostMachine, @NotNull Map<String, String> parentEnvironment) throws ExecutionException, IOException {
        Map map;
        if (environmentFile == null) {
            Cygwin.$$$reportNull$$$0(13);
        }
        if (hostMachine == null) {
            Cygwin.$$$reportNull$$$0(14);
        }
        if (parentEnvironment == null) {
            Cygwin.$$$reportNull$$$0(15);
        }
        try {
            Map readEnvironment = CidrEnvironmentUtil.readLinuxEnvironmentFromFile((String)environmentFile, (HostMachine)hostMachine, (String)this.getSubFilePath("bin/bash"), (String)this.getSubFilePath("bin/env"), parentEnvironment);
            if (readEnvironment.containsKey("PATH")) {
                String pathValue = Arrays.stream(((String)readEnvironment.get("PATH")).split(PathSeparator.UNIX.toString())).map(path -> Cygwin.toLocalPath(path, this)).collect(Collectors.joining(PathSeparator.WINDOWS.toString()));
                readEnvironment.put("PATH", pathValue);
            }
            map = readEnvironment;
        }
        catch (IOException ex) {
            if (!environmentFile.matches("[a-zA-Z0-9/._]*")) {
                throw new ExecutionException(ToolchainsBundle.message("cygwin.error.pathname.contains.unsupported.chars", environmentFile), (Throwable)ex);
            }
            throw ex;
        }
        if (map == null) {
            Cygwin.$$$reportNull$$$0(16);
        }
        return map;
    }

    @Nullable
    private static String runCygpath(boolean toWindows, @NotNull String path, @NotNull Cygwin cygwin) {
        File cygpath;
        if (path == null) {
            Cygwin.$$$reportNull$$$0(17);
        }
        if (cygwin == null) {
            Cygwin.$$$reportNull$$$0(18);
        }
        if (!(cygpath = new File(cygwin.myHome, "\\bin\\cygpath.exe")).canExecute()) {
            return null;
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{cygpath.getPath(), toWindows ? "-w" : "-u", "-f", "-"}).withCharset(StandardCharsets.UTF_8);
        String result = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (String)path);
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            return null;
        }
        if (toWindows && result.startsWith("\\\\?\\")) {
            result = result.replace("\\\\?\\", "");
        }
        return result.trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/Cygwin";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwinOrWindowsPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironment";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/Cygwin";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCygwin64";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 6: 
            case 8: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertPathVariableToCygwin";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironment";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runCygpath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 16 -> new IllegalStateException(string);
        };
    }

    private static class CacheKey {
        @NotNull
        private final String path;
        @NotNull
        private final String cygwinHome;
        private final int hashCode;

        CacheKey(@NotNull String path, @NotNull String cygwinHome) {
            if (path == null) {
                CacheKey.$$$reportNull$$$0(0);
            }
            if (cygwinHome == null) {
                CacheKey.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.cygwinHome = cygwinHome;
            this.hashCode = this.calculateHashCode();
        }

        public int calculateHashCode() {
            return 31 * this.path.hashCode() + this.cygwinHome.hashCode();
        }

        public String toString() {
            return this.path + "@" + this.cygwinHome;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (!this.path.equals(other.path)) {
                return false;
            }
            return this.cygwinHome.equals(other.cygwinHome);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cygwinHome";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/toolchains/Cygwin$CacheKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

