/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CudaGDB;", "Lcom/jetbrains/cidr/cpp/toolchains/GDB;", "env", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "executable", "Ljava/io/File;", "<init>", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Ljava/io/File;)V", "extractGdbVersionLine", "", "stdout", "readCudaVersion", "Lcom/jetbrains/cidr/ToolVersion;", "Companion", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nCudaGDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CudaGDB.kt\ncom/jetbrains/cidr/cpp/toolchains/CudaGDB\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n295#2,2:40\n*S KotlinDebug\n*F\n+ 1 CudaGDB.kt\ncom/jetbrains/cidr/cpp/toolchains/CudaGDB\n*L\n13#1:40,2\n*E\n"})
public final class CudaGDB
extends GDB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Pattern[] VERSION_PATTERNS;
    @NotNull
    private static final Version MIN_VERSION;
    @NotNull
    private static final Version MAX_VERSION;

    public CudaGDB(@NotNull CPPEnvironment env, @NotNull File executable) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        super(env, executable);
    }

    @Override
    @Nullable
    protected String extractGdbVersionLine(@NotNull String stdout) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Iterable $this$firstOrNull$iv = StringsKt.lines((CharSequence)stdout);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pattern pattern;
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                Intrinsics.checkNotNullExpressionValue((Object)GDBDriver.VERSION_PATTERN, (String)"VERSION_PATTERN");
                if (!new Regex(pattern).matches(charSequence)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ToolVersion readCudaVersion() {
        ToolVersion toolVersion;
        Object object = this.getGdbVersionOutput();
        if (object != null && (object = StringsKt.lines((CharSequence)((CharSequence)object))) != null && (object = (String)CollectionsKt.getOrNull((List)object, (int)1)) != null) {
            Object it = object;
            boolean bl = false;
            toolVersion = Companion.parseCudaVersion((String)it);
        } else {
            toolVersion = null;
        }
        return toolVersion;
    }

    static {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("^(\\d+\\.\\d+)")};
        VERSION_PATTERNS = patternArray;
        MIN_VERSION = new Version(10, 0, -1);
        MAX_VERSION = new Version(12, -1, -1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\u000f\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\tR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CudaGDB$Companion;", "", "<init>", "()V", "VERSION_PATTERNS", "", "Ljava/util/regex/Pattern;", "[Ljava/util/regex/Pattern;", "parseCudaVersion", "Lcom/jetbrains/cidr/ToolVersion;", "displayVersion", "", "MIN_VERSION", "Lcom/intellij/openapi/util/Version;", "MAX_VERSION", "checkVersion", "Lorg/jetbrains/annotations/Nls;", "version", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolVersion parseCudaVersion(@NotNull String displayVersion) {
            Intrinsics.checkNotNullParameter((Object)displayVersion, (String)"displayVersion");
            Pattern[] patternArray = VERSION_PATTERNS;
            ToolVersion toolVersion = ToolVersion.parse((String)displayVersion, (Pattern[])Arrays.copyOf(patternArray, patternArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)toolVersion, (String)"parse(...)");
            return toolVersion;
        }

        @Nullable
        public final String checkVersion(@NotNull ToolVersion version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

