/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.StatusText;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsPanel;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CPPToolchainsComboBox
extends ComboBox<ToolchainItem>
implements Disposable {
    private final CPPToolchainsConfigurable.Listener myToolchainsConfigurableListener;
    private final MessageBusConnection myConnection;
    private Map<String, String> myToolchainRenames = null;
    private int myRenamedToolchainIndex = -1;
    private List<String> myCurrentToolchainNames;

    public CPPToolchainsComboBox() {
        this.updateToolchains(CPPToolchains.getInstance().getToolchains(), ContainerUtil.emptyList());
        this.setMinimumAndPreferredWidth(0);
        this.myToolchainsConfigurableListener = new CPPToolchainsConfigurable.Listener(){

            @Override
            public void toolchainsChanged(@NotNull List<CPPToolchains.Toolchain> newToolchains, @NotNull List<Pair<String, String>> renames) {
                if (newToolchains == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (renames == null) {
                    1.$$$reportNull$$$0(1);
                }
                CPPToolchainsComboBox.this.updateToolchains(newToolchains, renames);
            }

            @Override
            public void toolchainRenamed(int index, @NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                CPPToolchainsComboBox.this.renameToolchain(index, newName);
            }

            @Override
            public void toolchainsApplied() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newToolchains";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renames";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsComboBox$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolchainsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolchainRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myConnection = ApplicationManager.getApplication().getMessageBus().connect();
        this.myConnection.subscribe(CPPToolchainsConfigurable.TOPIC, (Object)this.myToolchainsConfigurableListener);
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    @Nullable
    public String getToolchainName() {
        ToolchainItem item = (ToolchainItem)this.getSelectedItem();
        return item == null ? null : item.name;
    }

    @TestOnly
    public void setToolchainName(@Nullable String name) {
        this.setSelectedIndex(this.getToolchainsComboBoxNames().indexOf(name));
    }

    @TestOnly
    @NotNull
    public List<String> getToolchainsComboBoxNames() {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            items.add(((ToolchainItem)this.getItemAt((int)i)).name);
        }
        ArrayList<String> arrayList = items;
        if (arrayList == null) {
            CPPToolchainsComboBox.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void reset(@Nullable String toolchainName) {
        this.resetToolchains(toolchainName);
        this.updateFromToolchainsPanel(this.getToolchainsPanel());
    }

    @Nullable
    protected CPPToolchainsPanel getToolchainsPanel() {
        return CPPToolchainsUIUtils.getToolchainsPanelIfOpen();
    }

    public void updateFromToolchainsPanel(@Nullable CPPToolchainsPanel panel2) {
        if (panel2 != null) {
            panel2.deliverCurrentToolchainChanges(this.myToolchainsConfigurableListener);
        }
    }

    public void update() {
        this.resetToolchains(this.getToolchainName());
    }

    protected void updateToolchains(List<CPPToolchains.Toolchain> toolchains, List<Pair<String, String>> renames) {
        this.myToolchainRenames = ContainerUtil.map2Map(renames);
        try {
            this.myCurrentToolchainNames = ContainerUtil.map(toolchains, it -> it.getName());
            this.update();
        }
        finally {
            this.myToolchainRenames = null;
        }
    }

    private void renameToolchain(int index, @NotNull String newName) {
        if (newName == null) {
            CPPToolchainsComboBox.$$$reportNull$$$0(1);
        }
        try {
            this.myRenamedToolchainIndex = index;
            this.myCurrentToolchainNames.set(index, newName);
            this.update();
        }
        finally {
            this.myRenamedToolchainIndex = -1;
        }
    }

    private void resetToolchains(@Nullable String currentSelectedToolchain) {
        ToolchainItem selectedItem;
        List toolchainNames = ContainerUtil.prepend(this.myCurrentToolchainNames, (Object[])new String[]{null});
        List toolchainItems = ContainerUtil.map((Collection)toolchainNames, name -> new ToolchainItem((String)name));
        int currentSelectionIndex = this.getSelectedIndex();
        int renamedToolchainIndex = this.myRenamedToolchainIndex;
        if (renamedToolchainIndex > -1 && renamedToolchainIndex == currentSelectionIndex - 1) {
            selectedItem = (ToolchainItem)toolchainItems.get(renamedToolchainIndex + 1);
        } else {
            int index;
            String renamed;
            if (this.myToolchainRenames != null && (renamed = this.myToolchainRenames.get(currentSelectedToolchain)) != null) {
                currentSelectedToolchain = renamed;
            }
            if ((index = toolchainNames.indexOf(currentSelectedToolchain)) > -1) {
                if (renamedToolchainIndex > -1 && currentSelectionIndex > -1 && currentSelectionIndex < toolchainNames.size()) {
                    index = currentSelectionIndex;
                }
                selectedItem = (ToolchainItem)toolchainItems.get(index);
            } else {
                selectedItem = new ToolchainItem(currentSelectedToolchain);
            }
        }
        CPPToolchainsUIUtils.setComboBoxModelItems(this, selectedItem, toolchainItems, s -> new ToolchainItem((String)s));
        final String defaultToolchainName = (String)ContainerUtil.getFirstItem(this.myCurrentToolchainNames);
        final String defaultToolchainTitle = defaultToolchainName == null ? null : (defaultToolchainName.equalsIgnoreCase(CPPToolchains.Toolchain.getDefault()) ? ToolchainsBundle.message("cpp.toolchains.use.default.whenItsCalledDefault", new Object[0]) : ToolchainsBundle.message("cpp.toolchains.use.default", new Object[0]));
        final HashSet toolchainNamesSet = new HashSet(toolchainNames);
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ToolchainItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ToolchainItem> list2, ToolchainItem value, int index, boolean selected, boolean hasFocus) {
                String toolchainName;
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((toolchainName = value.name) == null) {
                    if (defaultToolchainTitle == null) {
                        this.append(ToolchainsBundle.message("cpp.toolchains.empty", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else {
                        this.append(defaultToolchainTitle, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("  ");
                        this.append(defaultToolchainName, StatusText.DEFAULT_ATTRIBUTES);
                    }
                } else if (!toolchainNamesSet.contains(toolchainName)) {
                    this.append(ToolchainsBundle.message("cpp.toolchains.combobox.toolchainNotFound", toolchainName), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else if (!CPPToolchainsComboBox.this.isEnabled()) {
                    this.append(toolchainName, StatusText.DEFAULT_ATTRIBUTES);
                } else {
                    this.append(toolchainName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsComboBox$2", "customizeCellRenderer"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsComboBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchainsComboBoxNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "renameToolchain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class ToolchainItem {
        @Nullable
        @NlsSafe
        private final String name;

        public ToolchainItem(@Nullable String name) {
            this.name = name;
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }
}

