/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public final class CPPToolchainUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.toolchains", 6);
    private static final EventId1<Integer> NUMBER = GROUP.registerEvent("number", (EventField)EventFields.Int((String)"total"));
    private static final EventField<String> toolsetType = EventFields.String((String)"toolsetType", CPPToolchainUsageCollector.getAllowedToolsetTypeNames());
    private static final EventField<String> toolsetVersion = EventFields.StringValidatedByRegexpReference((String)"toolsetVersion", (String)"version");
    private static final EventField<Boolean> bundledCMake = EventFields.Boolean((String)"bundledCMake");
    private static final EventField<String> cmakeVersion = EventFields.StringValidatedByRegexpReference((String)"cmakeVersion", (String)"version");
    private static final EventField<Boolean> customBuildTool = EventFields.Boolean((String)"customBuildTool");
    private static final EventField<Boolean> customCCompiler = EventFields.Boolean((String)"customCCompiler");
    private static final EventField<Boolean> customCxxCompiler = EventFields.Boolean((String)"customCxxCompiler");
    private static final EventField<CPPDebugger.Kind> debuggerType = EventFields.Enum((String)"debugger", CPPDebugger.Kind.class);
    private static final EventField<String> debuggerVersion = EventFields.StringValidatedByRegexpReference((String)"debuggerVersion", (String)"version");
    private static final EventField<Boolean> envFile = EventFields.Boolean((String)"envFile");
    private static final VarargEventId TOOLCHAIN = GROUP.registerVarargEvent("toolchain", new EventField[]{toolsetType, toolsetVersion, bundledCMake, cmakeVersion, customBuildTool, customCCompiler, customCxxCompiler, debuggerType, debuggerVersion, envFile});
    private static final String thirdPartyToolset = "third.party";

    private static List<String> getAllowedToolsetTypeNames() {
        return ContainerUtil.append((List)ContainerUtil.map((Object[])CPPToolSet.Kind.values(), Enum::name), (Object[])new String[]{thirdPartyToolset});
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        Set<MetricEvent> set = new Impl().doWork();
        if (set == null) {
            CPPToolchainUsageCollector.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector", "getMetrics"));
    }

    private static class Impl {
        Set<MetricEvent> result = new HashSet<MetricEvent>();

        private Impl() {
        }

        public Set<MetricEvent> doWork() {
            List<CPPToolchains.Toolchain> toolchains = CPPToolchains.getInstance().getToolchains();
            this.result.add(NUMBER.metric((Object)toolchains.size()));
            for (CPPToolchains.Toolchain toolchain : toolchains) {
                GDB gdb;
                CPPToolSet toolset = toolchain.getToolSet();
                String toolsetType = PluginInfoDetectorKt.getPluginInfo(toolset.getClass()).isDevelopedByJetBrains() ? toolset.getKind().name() : CPPToolchainUsageCollector.thirdPartyToolset;
                CPPDebugger.Kind debuggerKind = toolchain.getDebuggerKind();
                String gdbVersion = null;
                if (toolchain.getDebuggerKind() == CPPDebugger.Kind.CUSTOM_GDB && (gdb = new CPPEnvironment(toolchain).getGDB()) != null) {
                    gdbVersion = Impl.readToolVersion(toolchain, () -> gdb.readToolVersion());
                }
                this.result.add(TOOLCHAIN.metric(new EventPair[]{CPPToolchainUsageCollector.toolsetType.with((Object)toolsetType), toolsetVersion.with((Object)Impl.readToolVersion(toolchain, () -> toolset.readToolVersion())), bundledCMake.with((Object)(toolchain.getCustomCMakePath() == null ? 1 : 0)), cmakeVersion.with((Object)Impl.readToolVersion(toolchain, () -> CMakeExecutableTool.readCMakeToolVersion(toolchain))), customBuildTool.with((Object)(toolchain.getCustomBuildToolPath() != null ? 1 : 0)), customCCompiler.with((Object)(toolchain.getCustomCCompilerPath() != null ? 1 : 0)), customCxxCompiler.with((Object)(toolchain.getCustomCXXCompilerPath() != null ? 1 : 0)), debuggerType.with((Object)debuggerKind), debuggerVersion.with((Object)gdbVersion), envFile.with((Object)(toolchain.getEnvironment() != null ? 1 : 0))}));
            }
            return this.result;
        }

        @Nullable
        private static String readToolVersion(CPPToolchains.Toolchain toolchain, Supplier<ToolVersion> reader) {
            if (toolchain.getToolSetKind() == CPPToolSet.Kind.WSL) {
                return null;
            }
            return Impl.anonymizeVersion(reader.get());
        }

        @NotNull
        private static String anonymizeVersion(@Nullable ToolVersion version) {
            String string = version == null ? "unknown" : version.toCompactString();
            if (string == null) {
                Impl.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector$Impl", "anonymizeVersion"));
        }
    }
}

