/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CPPBuildUtil {
    public static boolean usePty(@NotNull CPPEnvironment environment) {
        if (environment == null) {
            CPPBuildUtil.$$$reportNull$$$0(0);
        }
        return environment.getHostMachine().getOS() != OS.Windows && (PtyCommandLine.isEnabled() || ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isUnitTestMode());
    }

    public static void setAdditionalBuildEnvironment(@NotNull GeneralCommandLine cmd) {
        if (cmd == null) {
            CPPBuildUtil.$$$reportNull$$$0(1);
        }
        cmd.getEnvironment().put("TERM", "xterm");
        cmd.getEnvironment().put("CLICOLOR_FORCE", "1");
        cmd.getEnvironment().put("GCC_COLORS", "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01");
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CPPEnvironment environment, @NonNls @NotNull String executablePath, @Nullable Path workDirectory, @NonNls @NotNull List<String> parameters2, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, boolean usePty) throws ExecutionException {
        GeneralCommandLine cl;
        if (environment == null) {
            CPPBuildUtil.$$$reportNull$$$0(2);
        }
        if (executablePath == null) {
            CPPBuildUtil.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            CPPBuildUtil.$$$reportNull$$$0(4);
        }
        if (additionalEnvironment == null) {
            CPPBuildUtil.$$$reportNull$$$0(5);
        }
        if (usePty) {
            LocalPtyOptions ptyOptions = LocalPtyOptions.defaults().builder().consoleMode(false).useWinConPty(false).build();
            cl = new PtyCommandLine().withOptions(ptyOptions);
            CPPToolSet toolSet = environment.getToolSet();
            if (toolSet.isCygwin()) {
                ((PtyCommandLine)cl).withUseCygwinLaunch(true);
            }
        } else {
            cl = new GeneralCommandLine();
        }
        cl.withParentEnvironmentType(passSystemEnvironment ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        cl.setExePath(executablePath);
        cl.getEnvironment().putAll(additionalEnvironment);
        environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        for (String variable : PredefinedVariables.getIDEVariables()) {
            cl.withEnvironment(variable, "TRUE");
        }
        if (workDirectory != null) {
            cl.withWorkingDirectory(workDirectory);
        }
        cl.addParameters(parameters2);
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            CPPBuildUtil.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPBuildUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPBuildUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "usePty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalBuildEnvironment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildCommandLine";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

