/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class CMakeExecutableTool
extends CidrExecutableTool {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(cmake|ctest)\\w*\\s+version ([\\d.]+)( \\(CMake; JetBrains IDE bundle; build [\\d.]+\\))?");
    private static final Logger LOG = Logger.getInstance(CMakeExecutableTool.class);
    public static final Version MIN_VERSION = new Version(2, 8, 11);
    public static final Version MAX_VERSION = new Version(3, 30, -1);
    public static final Version BUNDLED_VERSION = new Version(3, 30, -1);
    @NotNull
    private final CPPEnvironment myEnvironment;
    @NotNull
    private final NullableLazyValue<String[]> myVersionLines;
    @Nullable
    private static Supplier<String> ourHashCalculatorInTests = null;

    public CMakeExecutableTool(@NotNull File executable, @NotNull CPPEnvironment env) {
        if (executable == null) {
            CMakeExecutableTool.$$$reportNull$$$0(0);
        }
        if (env == null) {
            CMakeExecutableTool.$$$reportNull$$$0(1);
        }
        super(executable);
        this.myEnvironment = env;
        this.myVersionLines = NullableLazyValue.atomicLazyNullable(() -> {
            try {
                return this.readVersionLines();
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public CPPEnvironment getEnv() {
        return this.myEnvironment;
    }

    @NotNull
    public static File getBundledCMakeToolBinary(boolean cygwin, @NotNull ToolKind execTool) {
        if (execTool == null) {
            CMakeExecutableTool.$$$reportNull$$$0(2);
        }
        String platformBinPath = "cmake/" + (cygwin ? CidrPathManager.getPlatformRelativePath((String)"cygwin", (String)"bin") : CidrPathManager.getPlatformRelativePath((String)"bin"));
        File file = CidrPathManager.getBinPath(CMakeExecutableTool.class, (String)"clion/bin", (String)(platformBinPath + "/" + execTool.getOSExecutableName()), (String)platformBinPath).toFile();
        if (file == null) {
            CMakeExecutableTool.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public static Path getBundledCMakeDocumentation() {
        Path path = CidrPathManager.getBinPath(CMakeExecutableTool.class, (String)"clion/bin", (String)"cmake/quickdoc", null, (boolean)false);
        if (path == null) {
            CMakeExecutableTool.$$$reportNull$$$0(4);
        }
        return path;
    }

    public static boolean hasBundledTool(boolean cygwin, @NotNull ToolKind execTool) {
        if (execTool == null) {
            CMakeExecutableTool.$$$reportNull$$$0(5);
        }
        return CMakeExecutableTool.getBundledCMakeToolBinary(cygwin, execTool).exists();
    }

    @Nullable
    @NlsSafe
    private String[] readVersionLines() throws ExecutionException {
        ProgressIndicator indicator = CidrRunProcessUtil.getProgressIndicator();
        ProcessOutput output2 = this.executeWithOutput(new GeneralCommandLine().withParameters(new String[]{"-version"}), (ProgressIndicator)(indicator == null ? new EmptyProgressIndicator() : indicator), 10000);
        return output2 != null ? StringUtil.splitByLines((String)output2.getStdout()) : null;
    }

    private String[] getVersionLines() throws ExecutionException {
        try {
            return (String[])this.myVersionLines.getValue();
        }
        catch (RuntimeException rex) {
            Throwable throwable = rex.getCause();
            if (throwable instanceof ExecutionException) {
                ExecutionException eex = (ExecutionException)throwable;
                throw eex;
            }
            throw rex;
        }
    }

    @Override
    @Nullable
    @NlsSafe
    public String readVersion() throws ExecutionException {
        @NlsSafe String[] versionLines = this.getVersionLines();
        if (LOG.isDebugEnabled() && versionLines != null) {
            CPPLog.logReadVersion("CMake tool", this.myExecutable, versionLines[0]);
        }
        return CMakeExecutableTool.parseVersionLines(versionLines);
    }

    @VisibleForTesting
    @Nullable
    @NlsSafe
    public static String parseVersionLines(String[] versionLines) throws ExecutionException {
        String result = null;
        if (versionLines != null) {
            result = StringUtil.nullize((String)versionLines[0], (boolean)true);
        }
        if (result == null) {
            return null;
        }
        Matcher matcher = VERSION_PATTERN.matcher(result);
        boolean matched = matcher.find();
        if (!matched) {
            LOG.warn("Couldn't find CMake version in header \"" + result + "\"");
            return null;
        }
        return matcher.group(2);
    }

    @NotNull
    public CMakeDebugProtocol getDebugProtocol() {
        block12: {
            String[] versionLines;
            block11: {
                ToolVersion toolVersion;
                block10: {
                    CMakeDebugProtocol cMakeDebugProtocol;
                    try {
                        versionLines = this.getVersionLines();
                        if (versionLines != null) break block10;
                        cMakeDebugProtocol = CMakeDebugProtocol.NONE;
                    }
                    catch (ExecutionException e) {
                        CMakeDebugProtocol cMakeDebugProtocol2 = CMakeDebugProtocol.NONE;
                        if (cMakeDebugProtocol2 == null) {
                            CMakeExecutableTool.$$$reportNull$$$0(10);
                        }
                        return cMakeDebugProtocol2;
                    }
                    if (cMakeDebugProtocol == null) {
                        CMakeExecutableTool.$$$reportNull$$$0(6);
                    }
                    return cMakeDebugProtocol;
                }
                if (!AdvancedSettings.getBoolean((String)"cmake.dbg.use.dap.protocol") || this.myEnvironment.isCygwin()) break block11;
                String version = CMakeExecutableTool.parseVersionLines(versionLines);
                ToolVersion toolVersion2 = toolVersion = version != null ? CMakeExecutableTool.parseToolVersion(version) : null;
                if (toolVersion == null || !toolVersion.versionNumber.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(27))) break block11;
                CMakeDebugProtocol cMakeDebugProtocol = CMakeDebugProtocol.DAP;
                if (cMakeDebugProtocol == null) {
                    CMakeExecutableTool.$$$reportNull$$$0(7);
                }
                return cMakeDebugProtocol;
            }
            if (!ArrayUtil.contains((String)"debugging support enabled", (String[])versionLines)) break block12;
            CMakeDebugProtocol cMakeDebugProtocol = CMakeDebugProtocol.SYSPROGS;
            if (cMakeDebugProtocol == null) {
                CMakeExecutableTool.$$$reportNull$$$0(8);
            }
            return cMakeDebugProtocol;
        }
        CMakeDebugProtocol cMakeDebugProtocol = CMakeDebugProtocol.NONE;
        if (cMakeDebugProtocol == null) {
            CMakeExecutableTool.$$$reportNull$$$0(9);
        }
        return cMakeDebugProtocol;
    }

    public ProcessOutput executeWithOutput(@NotNull GeneralCommandLine commandLine, @NotNull ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (commandLine == null) {
            CMakeExecutableTool.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            CMakeExecutableTool.$$$reportNull$$$0(12);
        }
        commandLine.setExePath(this.myExecutable.getPath());
        this.myEnvironment.prepare(commandLine, CidrToolEnvironment.PrepareFor.BUILD);
        ProcessOutput output2 = this.myEnvironment.getHostMachine().runProcess(commandLine, indicator, timeout);
        CidrToolsUtil.checkSuccess((GeneralCommandLine)commandLine, (ProcessOutput)output2, (Logger)LOG);
        if (LOG.isDebugEnabled()) {
            LOG.debug(CidrToolsUtil.logInfo((GeneralCommandLine)commandLine, (ProcessOutput)output2));
        }
        return output2;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        try {
            String version = this.readVersion();
            return version == null ? null : CMakeExecutableTool.parseToolVersion(version);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    @NlsSafe
    public static String checkVersion(@NotNull String version) {
        if (version == null) {
            CMakeExecutableTool.$$$reportNull$$$0(13);
        }
        return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, CMakeExecutableTool.parseToolVersion(version));
    }

    @VisibleForTesting
    @NotNull
    public static ToolVersion parseToolVersion(@NotNull String version) {
        if (version == null) {
            CMakeExecutableTool.$$$reportNull$$$0(14);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
        if (toolVersion == null) {
            CMakeExecutableTool.$$$reportNull$$$0(15);
        }
        return toolVersion;
    }

    @TestOnly
    public static void setHashCalculatorInTests(@Nullable Supplier<String> hashCalculatorInTests) {
        ourHashCalculatorInTests = hashCalculatorInTests;
    }

    @NotNull
    public String calcCMakeHash() {
        if (ourHashCalculatorInTests != null) {
            String string = ourHashCalculatorInTests.get();
            if (string == null) {
                CMakeExecutableTool.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = "CMake: " + this.readToolVersion() + "@" + this.getExecutable() + "\n";
        if (string == null) {
            CMakeExecutableTool.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static File getBundledCMakeBinary(boolean cygwin) {
        return CMakeExecutableTool.getBundledCMakeToolBinary(cygwin, ToolKind.CMAKE);
    }

    public static boolean hasBundledCMake(boolean cygwin) {
        return CMakeExecutableTool.hasBundledTool(cygwin, ToolKind.CMAKE);
    }

    @NotNull
    public static CMakeExecutableTool getBundledCMake(@NotNull CPPEnvironment env) {
        if (env == null) {
            CMakeExecutableTool.$$$reportNull$$$0(18);
        }
        return new CMakeExecutableTool(CMakeExecutableTool.getBundledCMakeToolBinary(env.isCygwin(), ToolKind.CMAKE), env);
    }

    @Nullable
    @NlsSafe
    public static String readCMakeVersion(@Nullable CPPToolchains.Toolchain toolchain) throws ExecutionException {
        CMakeExecutableTool cmake = toolchain == null ? null : new CPPEnvironment(toolchain).getCMake();
        return cmake == null ? null : cmake.readVersion();
    }

    @Nullable
    public static ToolVersion readCMakeToolVersion(@Nullable CPPToolchains.Toolchain toolchain) {
        return CMakeExecutableTool.doWithToolchainCMake(toolchain, CMakeExecutableTool::readToolVersion);
    }

    @Nullable
    public static ToolVersion readCMakeToolVersion(@NotNull CPPEnvironment environment) {
        if (environment == null) {
            CMakeExecutableTool.$$$reportNull$$$0(19);
        }
        return CMakeExecutableTool.doWithToolchainCMake(environment, CMakeExecutableTool::readToolVersion);
    }

    @Nullable
    private static <T> T doWithToolchainCMake(@Nullable CPPToolchains.Toolchain toolchain, Function<CMakeExecutableTool, T> fun) {
        CMakeExecutableTool cmake = toolchain == null ? null : new CPPEnvironment(toolchain).getCMake();
        return cmake == null ? null : (T)fun.apply(cmake);
    }

    @Nullable
    private static <T> T doWithToolchainCMake(@NotNull CPPEnvironment environment, Function<CMakeExecutableTool, T> fun) {
        CMakeExecutableTool cmake;
        if (environment == null) {
            CMakeExecutableTool.$$$reportNull$$$0(20);
        }
        return (cmake = environment.getCMake()) == null ? null : (T)fun.apply(cmake);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 9, 10, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execTool";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCMakeToolBinary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCMakeDocumentation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProtocol";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToolVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCMakeHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBundledCMakeToolBinary";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasBundledTool";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeWithOutput";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseToolVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBundledCMake";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readCMakeToolVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doWithToolchainCMake";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 9, 10, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    public static enum ToolKind {
        CMAKE("cmake", "CMakeCurrentExecutableName"),
        CTEST("ctest", "CTestCurrentExecutableName");

        private final String myExecutableName;
        private final String myMacroName;

        private ToolKind(String executableName, String macroName) {
            if (executableName == null) {
                ToolKind.$$$reportNull$$$0(0);
            }
            this.myExecutableName = executableName;
            this.myMacroName = macroName;
        }

        @NotNull
        public String getOSExecutableName() {
            String string = this.myExecutableName + (SystemInfo.isWindows ? ".exe" : "");
            if (string == null) {
                ToolKind.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getExecutableName(@NotNull CPPToolSet toolset) {
            if (toolset == null) {
                ToolKind.$$$reportNull$$$0(2);
            }
            if (toolset.isMinGW() || toolset.isMSVC()) {
                String string = this.myExecutableName + ".exe";
                if (string == null) {
                    ToolKind.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.myExecutableName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getMacro() {
            String string = "$" + this.myMacroName + "$";
            if (string == null) {
                ToolKind.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getMacroName() {
            String string = this.myMacroName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getExecutableName() {
            String string = this.myExecutableName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        public static ToolKind findMacro(@NotNull String maybeMacro) {
            if (maybeMacro == null) {
                ToolKind.$$$reportNull$$$0(8);
            }
            for (ToolKind e : ToolKind.values()) {
                if (!e.getMacro().equals(maybeMacro)) continue;
                return e;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executableName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolset";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maybeMacro";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSExecutableName";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecutableName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMacro";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMacroName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getExecutableName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findMacro";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static enum CMakeDebugProtocol {
        NONE,
        SYSPROGS,
        DAP;

    }
}

