/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.remote;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationEditor;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.cpp.execution.remote.PathMappingsComponentKt;
import com.jetbrains.cidr.cpp.execution.remote.RemoteLauncher;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B%\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0004H\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/CLionRemoteRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrRunProfile;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "debuggerData", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "getDebuggerData", "()Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "setDebuggerData", "(Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;)V", "params", "Lcom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters;", "getParams", "()Lcom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters;", "setParams", "(Lcom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters;)V", "debuggerToolchainForLauncher", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "getDebuggerToolchainForLauncher", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "getConfigurationEditor", "Lcom/jetbrains/cidr/cpp/execution/remote/CLionRemoteRunConfigurationEditor;", "checkConfiguration", "", "getState", "Lcom/jetbrains/cidr/execution/CidrCommandLineState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "writeExternal", "element", "readExternal", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nCLionRemoteRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionRemoteRunConfiguration.kt\ncom/jetbrains/cidr/cpp/execution/remote/CLionRemoteRunConfiguration\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n26#2:143\n1755#3,3:144\n*S KotlinDebug\n*F\n+ 1 CLionRemoteRunConfiguration.kt\ncom/jetbrains/cidr/cpp/execution/remote/CLionRemoteRunConfiguration\n*L\n51#1:143\n76#1:144,3\n*E\n"})
public final class CLionRemoteRunConfiguration
extends RunConfigurationBase<Element>
implements CidrRunProfile,
RunConfigurationWithSuppressedDefaultRunAction {
    @NotNull
    private DebuggerData debuggerData;
    @NotNull
    private CidrRemoteDebugParameters params;

    @JvmOverloads
    public CLionRemoteRunConfiguration(@NotNull Project project, @Nullable String name, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory, name);
        this.debuggerData = new DebuggerData(CLionDebuggerKind.Bundled.GDB.INSTANCE);
        this.params = new CidrRemoteDebugParameters(null, null, null, null, 0, null, 63, null);
    }

    public /* synthetic */ CLionRemoteRunConfiguration(Project project, String string, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$runConfigurationType = false;
            configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(CLionRemoteRunConfigurationType.class);
        }
        this(project, string, configurationFactory);
    }

    @NotNull
    public final DebuggerData getDebuggerData() {
        return this.debuggerData;
    }

    public final void setDebuggerData(@NotNull DebuggerData debuggerData) {
        Intrinsics.checkNotNullParameter((Object)debuggerData, (String)"<set-?>");
        this.debuggerData = debuggerData;
    }

    @NotNull
    public final CidrRemoteDebugParameters getParams() {
        return this.params;
    }

    public final void setParams(@NotNull CidrRemoteDebugParameters cidrRemoteDebugParameters) {
        Intrinsics.checkNotNullParameter((Object)cidrRemoteDebugParameters, (String)"<set-?>");
        this.params = cidrRemoteDebugParameters;
    }

    private final CPPToolchains.Toolchain getDebuggerToolchainForLauncher() {
        return this.debuggerData.getOrCreateDebuggerToolchain();
    }

    @NotNull
    public CLionRemoteRunConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new CLionRemoteRunConfigurationEditor(project);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        boolean bl;
        block9: {
            CPPToolchains.Toolchain toolchain = this.getDebuggerToolchainForLauncher();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CLionRemoteRunConfigurationKt.checkDebuggerToolchain(toolchain, project);
            if (!StringsKt.isBlank((CharSequence)this.params.getSymbolFile())) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (!new File(this.params.expandSymbolFile(project2)).exists()) {
                    Object[] objectArray = new Object[]{this.params.getSymbolFile()};
                    throw new RuntimeConfigurationWarning(CLionExecutionBundle.message("gdbRemote.symbolFile.invalid", objectArray));
                }
            }
            if (!StringsKt.isBlank((CharSequence)this.params.getSysroot())) {
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                if (!new File(this.params.expandSysroot(project3)).exists()) {
                    Object[] objectArray = new Object[]{this.params.getSysroot()};
                    throw new RuntimeConfigurationWarning(CLionExecutionBundle.message("gdbRemote.sysroot.invalid", objectArray));
                }
            }
            Iterable $this$any$iv = this.params.driverPathMapping();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DebuggerDriver.PathMapping it = (DebuggerDriver.PathMapping)element$iv;
                    boolean bl2 = false;
                    String string = it.from;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"from");
                    if (!StringsKt.isBlank((CharSequence)string)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new RuntimeConfigurationException(CLionExecutionBundle.message("gdbRemote.pathMappings.invalid", new Object[0]));
        }
        List missingLocalMappings = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.params.driverPathMapping()), CLionRemoteRunConfiguration::checkConfiguration$lambda$1), CLionRemoteRunConfiguration::checkConfiguration$lambda$2));
        if (!((Collection)missingLocalMappings).isEmpty()) {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)missingLocalMappings, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null)};
            throw new RuntimeConfigurationWarning(CLionExecutionBundle.message("gdbRemote.pathMappings.localDoesNotExist", objectArray));
        }
    }

    @NotNull
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RemoteLauncher launcher = new RemoteLauncher(project, this.getDebuggerToolchainForLauncher(), this.params);
        return new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.debuggerData.writeExternal(element);
        element.setAttribute("remoteCommand", this.params.getRemoteCommand());
        element.setAttribute("symbolFile", FileUtil.toSystemIndependentName((String)this.params.getSymbolFile()));
        element.setAttribute("sysroot", FileUtil.toSystemIndependentName((String)this.params.getSysroot()));
        PathMappingsComponentKt.save((Element)element, (List)this.params.getPathMappings());
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.debuggerData.readExternal(element);
        this.params = new CidrRemoteDebugParameters(null, null, null, null, 0, null, 63, null);
        String string = element.getAttributeValue("remoteCommand");
        if (string == null) {
            string = "";
        }
        this.params.setRemoteCommand(string);
        String string2 = element.getAttributeValue("symbolFile");
        if (string2 == null) {
            string2 = "";
        }
        this.params.setSymbolFile(string2);
        String string3 = element.getAttributeValue("sysroot");
        if (string3 == null) {
            string3 = "";
        }
        this.params.setSysroot(string3);
        this.params.setPathMappings(PathMappingsComponentKt.load((Element)element));
    }

    @JvmOverloads
    public CLionRemoteRunConfiguration(@NotNull Project project, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, name, null, 4, null);
    }

    private static final boolean checkConfiguration$lambda$1(DebuggerDriver.PathMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !new File(it.to).exists();
    }

    private static final String checkConfiguration$lambda$2(DebuggerDriver.PathMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.to;
    }
}

