/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsCounterUsagesCollector;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.ProcessFusData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\u000bJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/GdbOutputProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "", "fusData", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ProcessFusData;", "<init>", "(Ljava/lang/Process;Ljava/lang/String;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ProcessFusData;)V", "errorEncountered", "", "isErrorEncountered", "outputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "notifyTextAvailable", "", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nGdbOutputProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbOutputProcessHandler.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/GdbOutputProcessHandler\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,98:1\n19#2:99\n*S KotlinDebug\n*F\n+ 1 GdbOutputProcessHandler.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/GdbOutputProcessHandler\n*L\n77#1:99\n*E\n"})
public class GdbOutputProcessHandler
extends OSProcessHandler {
    private boolean errorEncountered;
    @NotNull
    private final StringBuilder outputBuffer;

    public GdbOutputProcessHandler(@NotNull Process process2, @NotNull String commandLine, final @Nullable ProcessFusData fusData) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(process2, commandLine, null);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.isErrorEncountered()) {
                    DebugTargetsCounterUsagesCollector.INSTANCE.uploadFinished(fusData, false, event.getExitCode());
                    String string = CLionExecutionBundle.message("upload.with.issues", new Object[0]) + System.lineSeparator();
                    Key key = ProcessOutputTypes.STDERR;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"STDERR");
                    this.notifyTextAvailable(string, key);
                } else {
                    DebugTargetsCounterUsagesCollector.INSTANCE.uploadFinished(fusData, true, event.getExitCode());
                }
            }
        });
        this.outputBuffer = new StringBuilder();
    }

    public final boolean isErrorEncountered() {
        return this.errorEncountered;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
            this.outputBuffer.append(text);
            int eolIndex = 0;
            block6: while ((eolIndex = this.outputBuffer.indexOf("\n")) > 0) {
                String string = this.outputBuffer.substring(0, eolIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String line = ((Object)StringsKt.trim((CharSequence)string)).toString();
                StringBuilder stringBuilder = this.outputBuffer.delete(0, eolIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"delete(...)");
                StringsKt.trimStart((CharSequence)stringBuilder);
                if (Intrinsics.areEqual((Object)line, (Object)"(gdb)")) continue;
                try {
                    GDBResponse response;
                    GDBResponse gDBResponse = response = GDBResponse.parse((String)line);
                    if (gDBResponse instanceof GDBResponse.StreamRecord) {
                        super.notifyTextAvailable(((GDBResponse.StreamRecord)response).getText(), outputType);
                        continue;
                    }
                    if (!(gDBResponse instanceof GDBResponse.ResultRecord)) continue;
                    switch (WhenMappings.$EnumSwitchMapping$0[((GDBResponse.ResultRecord.Type)((GDBResponse.ResultRecord)response).getType()).ordinal()]) {
                        case 1: {
                            int loadSize = ((GDBResponse.ResultRecord)response).getResultList().getInt("load-size", -1);
                            if (loadSize < 0) continue block6;
                            super.notifyTextAvailable("Loaded " + loadSize + " bytes\n\r", ProcessOutputTypes.STDOUT);
                            continue block6;
                        }
                        case 2: {
                            String message = ((GDBResponse.ResultRecord)response).getResultList().getString("msg");
                            if (message == null) {
                                GDBTuple gDBTuple = ((GDBResponse.ResultRecord)response).getResultList();
                                Intrinsics.checkNotNullExpressionValue((Object)gDBTuple, (String)"getResultList(...)");
                                Iterable iterable = (Iterable)gDBTuple;
                                String string2 = System.lineSeparator();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
                                message = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, GdbOutputProcessHandler::notifyTextAvailable$lambda$0, (int)30, null);
                            }
                            this.errorEncountered = true;
                            super.notifyTextAvailable(message + System.lineSeparator(), ProcessOutputTypes.STDERR);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            super.notifyTextAvailable(text, outputType);
        }
    }

    private static final CharSequence notifyTextAvailable$lambda$0(Object it) {
        Object object;
        Object $this$asSafely$iv = it;
        boolean $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof Pair)) {
            object2 = null;
        }
        return (object = (Pair)object2) != null && (object = object.getSecond()) != null && (object = object.toString()) != null ? (CharSequence)object : (CharSequence)it.toString();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GDBResponse.ResultRecord.Type.values().length];
            try {
                nArray[GDBResponse.ResultRecord.Type.done.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GDBResponse.ResultRecord.Type.error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

