/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTarget;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetServiceKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsState;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsStateSplitter;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.GenericDebugTarget;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.NativeDebugTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="DebugServers", storages={@Storage(value="debugServers", stateSplitter=DebugTargetsStateSplitter.class)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\rH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\b\u0010\"\u001a\u0004\u0018\u00010#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020#2\u0006\u0010'\u001a\u00020#8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00062"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetsState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "dispose", "", "modificationTracker", "", "myState", "debugTargetsParameters", "", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetParameters;", "getDebugTargetsParameters", "()Ljava/util/Collection;", "getStateModificationCount", "debugTargets", "", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;", "getState", "loadState", "state", "updateTargets", "targetsEnabledAndAvailable", "", "debugTargetsUpdated", "updatedList", "newSelectedId", "", "getTargetsFor", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "value", "selectedDebugTargetId", "getSelectedDebugTargetId", "()Ljava/lang/String;", "setSelectedDebugTargetId", "(Ljava/lang/String;)V", "selectedDebugTarget", "getSelectedDebugTarget", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;", "setSelectedDebugTarget", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;)V", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nDebugTargetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTargetService.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n774#2:126\n865#2,2:127\n295#2,2:129\n*S KotlinDebug\n*F\n+ 1 DebugTargetService.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService\n*L\n46#1:122\n46#1:123,3\n66#1:126\n66#1:127,2\n81#1:129,2\n*E\n"})
public final class DebugTargetService
implements PersistentStateComponentWithModificationTracker<DebugTargetsState>,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private long modificationTracker;
    @NotNull
    private DebugTargetsState myState;
    @NotNull
    private List<? extends DebugTarget> debugTargets;

    public DebugTargetService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.myState = new DebugTargetsState();
        this.debugTargets = CollectionsKt.emptyList();
        this.updateTargets();
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public void dispose() {
    }

    @NotNull
    public final Collection<DebugTargetParameters> getDebugTargetsParameters() {
        return this.myState.getTargets();
    }

    public long getStateModificationCount() {
        return this.modificationTracker;
    }

    @NotNull
    public DebugTargetsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull DebugTargetsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myState = state;
        this.updateTargets();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateTargets() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new DebugTarget[]{NativeDebugTarget.INSTANCE};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$map$iv = this.myState.getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DebugTargetParameters debugTargetParameters = (DebugTargetParameters)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GenericDebugTarget(this.project, (DebugTargetParameters)it));
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)list2);
        this.debugTargets = list2;
    }

    public final boolean targetsEnabledAndAvailable() {
        RunManager runManager = RunManager.Companion.getInstanceIfCreated(this.project);
        return (runManager != null && (runManager = runManager.getSelectedConfiguration()) != null ? runManager.getConfiguration() : null) instanceof CLionRunConfiguration && DebugTargetServiceKt.getDebugTargetsEnabled();
    }

    public final void debugTargetsUpdated(@NotNull List<? extends DebugTargetParameters> updatedList, @Nullable String newSelectedId) {
        Intrinsics.checkNotNullParameter(updatedList, (String)"updatedList");
        this.getState().setTargets(updatedList);
        long l = this.modificationTracker;
        this.modificationTracker = l + 1L;
        this.updateTargets();
        String string = newSelectedId;
        if (string == null) {
            string = NativeDebugTarget.INSTANCE.getId();
        }
        this.setSelectedDebugTargetId(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebugTarget> getTargetsFor(@NotNull RunConfiguration runConfiguration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Iterable $this$filter$iv = this.debugTargets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DebugTarget it = (DebugTarget)element$iv$iv;
            boolean bl = false;
            if (!it.canRun(runConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getSelectedDebugTargetId() {
        String string = Strings.nullize((String)this.myState.getSelectedId());
        if (string == null) {
            string = NativeDebugTarget.INSTANCE.getId();
        }
        return string;
    }

    private final void setSelectedDebugTargetId(String value) {
        if (!Intrinsics.areEqual((Object)this.myState.getSelectedId(), (Object)value)) {
            this.myState.setSelectedId(value);
            long l = this.modificationTracker;
            this.modificationTracker = l + 1L;
        }
    }

    @NotNull
    public final DebugTarget getSelectedDebugTarget() {
        DebugTarget debugTarget;
        Object v0;
        block3: {
            if (!DebugTargetServiceKt.getDebugTargetsEnabled()) {
                return NativeDebugTarget.INSTANCE;
            }
            Iterable $this$firstOrNull$iv = this.debugTargets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DebugTarget it = (DebugTarget)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getSelectedDebugTargetId())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((debugTarget = (DebugTarget)v0) == null) {
            debugTarget = NativeDebugTarget.INSTANCE;
        }
        return debugTarget;
    }

    public final void setSelectedDebugTarget(@NotNull DebugTarget value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setSelectedDebugTargetId(value.getId());
    }
}

