/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundLauncher;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionGDBDriverConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbWithGdbServerProcess;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionsManager;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GdbServerLauncher
extends CidrCompoundLauncher {
    @NotNull
    private final CPPToolchains.Toolchain myDebuggerToolchain;

    public GdbServerLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull GdbServerRunConfiguration configuration, @NotNull CPPToolchains.Toolchain debuggerToolchain) {
        if (executionEnvironment == null) {
            GdbServerLauncher.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            GdbServerLauncher.$$$reportNull$$$0(1);
        }
        if (debuggerToolchain == null) {
            GdbServerLauncher.$$$reportNull$$$0(2);
        }
        super(executionEnvironment, configuration);
        this.myDebuggerToolchain = debuggerToolchain;
    }

    @Override
    @NotNull
    public GdbServerRunConfiguration getConfiguration() {
        GdbServerRunConfiguration gdbServerRunConfiguration = (GdbServerRunConfiguration)super.getConfiguration();
        if (gdbServerRunConfiguration == null) {
            GdbServerLauncher.$$$reportNull$$$0(3);
        }
        return gdbServerRunConfiguration;
    }

    @NotNull
    public final GdbWithGdbServerProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        GdbWithGdbServerProcess gdbWithGdbServerProcess;
        String errorMessage;
        if (state == null) {
            GdbServerLauncher.$$$reportNull$$$0(4);
        }
        if (session == null) {
            GdbServerLauncher.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)(errorMessage = CLionRemoteRunConfigurationKt.getToolchainDebuggerProblemString(this.myDebuggerToolchain, true, false)))) {
            throw new ExecutionException(errorMessage);
        }
        Pair<File, CPPEnvironment> environment = this.getRunFileAndEnvironment();
        CidrRunConfigurationExtensionsManager extensionsManager = CidrRunConfigurationExtensionsManager.getInstance();
        RunnerSettings runnerSettings = this.getExecutionEnvironment().getRunnerSettings();
        ProgramRunner runner = this.getExecutionEnvironment().getRunner();
        String runnerId = runner.getRunnerId();
        ConfigurationExtensionContext context = new ConfigurationExtensionContext();
        File projectBaseDir = this.getProjectBaseDir();
        CPPEnvironment cppEnvironment = (CPPEnvironment)environment.getSecond();
        state.setConsoleBuilder(this.createConsoleBuilder(state, cppEnvironment, projectBaseDir, false));
        GdbServerRunConfiguration configuration = this.getConfiguration();
        extensionsManager.patchCommandLineState((OCRunConfiguration)configuration, runnerSettings, (CidrToolEnvironment)cppEnvironment, projectBaseDir, state, runnerId, context);
        String gdbRemoteString = configuration.getGdbRemoteString();
        CLionGDBDriverConfiguration driverConfiguration = new CLionGDBDriverConfiguration(this.getProject(), this.myDebuggerToolchain);
        try {
            String symbolFileName = ((File)environment.getFirst()).getCanonicalPath();
            File symbolFile = new File(symbolFileName);
            List<String> additionalCommands = this.getAdditionalCommands(symbolFile);
            CidrRemoteDebugParameters parameters2 = this.createRemoteParameters(gdbRemoteString, symbolFileName, additionalCommands);
            TrivialRunParameters runParameters = new TrivialRunParameters((DebuggerDriverConfiguration)driverConfiguration, driverConfiguration.createInstaller(new GeneralCommandLine()));
            GdbWithGdbServerProcess process2 = (GdbWithGdbServerProcess)((Object)CidrCoroutineHelper.runOnEDT(() -> this.createGdbServerProcess((RunParameters)runParameters, parameters2, session, state.getConsoleBuilder())));
            CidrLauncher.configProcessHandler((ProcessHandler)process2.getProcessHandler(), (boolean)false, (boolean)true, (Project)this.getProject());
            extensionsManager.attachExtensionsToProcess((OCRunConfiguration)this.getConfiguration(), process2.getProcessHandler(), (CidrToolEnvironment)cppEnvironment, runnerSettings, runnerId, context);
            Utils.markDownloaded(symbolFile);
            gdbWithGdbServerProcess = process2;
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (gdbWithGdbServerProcess == null) {
            GdbServerLauncher.$$$reportNull$$$0(6);
        }
        return gdbWithGdbServerProcess;
    }

    @NotNull
    protected CidrRemoteDebugParameters createRemoteParameters(@NotNull String gdbRemoteString, @NotNull String symbolFileName, @NotNull List<String> additionalCommands) {
        if (gdbRemoteString == null) {
            GdbServerLauncher.$$$reportNull$$$0(7);
        }
        if (symbolFileName == null) {
            GdbServerLauncher.$$$reportNull$$$0(8);
        }
        if (additionalCommands == null) {
            GdbServerLauncher.$$$reportNull$$$0(9);
        }
        return new CidrRemoteDebugParameters(gdbRemoteString, symbolFileName, "", Collections.emptyList(), this.getConfiguration().getWarmUpMs(), additionalCommands);
    }

    @NotNull
    protected GdbWithGdbServerProcess createGdbServerProcess(@NotNull RunParameters runParameters, @NotNull CidrRemoteDebugParameters remoteParameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        if (runParameters == null) {
            GdbServerLauncher.$$$reportNull$$$0(10);
        }
        if (remoteParameters == null) {
            GdbServerLauncher.$$$reportNull$$$0(11);
        }
        if (session == null) {
            GdbServerLauncher.$$$reportNull$$$0(12);
        }
        if (consoleBuilder == null) {
            GdbServerLauncher.$$$reportNull$$$0(13);
        }
        return new GdbWithGdbServerProcess(runParameters, remoteParameters, session, consoleBuilder);
    }

    @NotNull
    public final CidrDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        if (state == null) {
            GdbServerLauncher.$$$reportNull$$$0(14);
        }
        if (session == null) {
            GdbServerLauncher.$$$reportNull$$$0(15);
        }
        String symbolFilePath = ((File)this.getRunFileAndEnvironment().getFirst()).getAbsolutePath();
        this.prepareSymbolFile(symbolFilePath, this.getConfiguration());
        String executable = ProgramParametersUtil.expandPathAndMacros((String)this.getConfiguration().getServerExecutable(), null, (Project)this.getProject());
        String executableFolder = this.getWorkingDirectory(session, executable);
        GeneralCommandLine gdbServerCommandLine = new GeneralCommandLine(new String[]{executable}).withWorkDirectory(executableFolder);
        ParametersListUtil.parse((String)ProgramParametersUtil.expandPathAndMacros((String)Objects.toString(this.getGdbServerParameters(this.getConfiguration()), ""), null, (Project)session.getProject())).forEach(arg_0 -> ((GeneralCommandLine)gdbServerCommandLine).addParameter(arg_0));
        gdbServerCommandLine.getEnvironment().putAll(this.getConfiguration().getEnvs());
        BaseProcessHandler<?> gdbServerProcess = this.createGdbServerProcess(gdbServerCommandLine);
        GdbWithGdbServerProcess debugProcess = (GdbWithGdbServerProcess)super.startDebugProcess(state, session);
        debugProcess.installServerProcess(gdbServerProcess);
        GdbWithGdbServerProcess gdbWithGdbServerProcess = debugProcess;
        if (gdbWithGdbServerProcess == null) {
            GdbServerLauncher.$$$reportNull$$$0(16);
        }
        return gdbWithGdbServerProcess;
    }

    @Nullable
    protected String getWorkingDirectory(@NotNull XDebugSession session, String executable) {
        String executableFolder;
        if (session == null) {
            GdbServerLauncher.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmptyOrSpaces((String)(executableFolder = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)session.getProject(), null)))) {
            executableFolder = StringUtil.nullize((String)PathUtilRt.getParentPath((String)executable));
        }
        return executableFolder;
    }

    @Nullable
    protected String getGdbServerParameters(@NotNull GdbServerRunConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            GdbServerLauncher.$$$reportNull$$$0(18);
        }
        return configuration.getProgramParameters();
    }

    @NotNull
    protected List<String> getAdditionalCommands(@NotNull File symbolFile) {
        if (symbolFile == null) {
            GdbServerLauncher.$$$reportNull$$$0(19);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GdbServerLauncher.$$$reportNull$$$0(20);
        }
        return list2;
    }

    protected void prepareSymbolFile(@NotNull String fileName, @NotNull GdbServerRunConfiguration configuration) throws ExecutionException {
        if (fileName == null) {
            GdbServerLauncher.$$$reportNull$$$0(21);
        }
        if (configuration == null) {
            GdbServerLauncher.$$$reportNull$$$0(22);
        }
    }

    protected BaseProcessHandler<?> createGdbServerProcess(@NotNull GeneralCommandLine gdbServerCommandLine) throws ExecutionException {
        if (gdbServerCommandLine == null) {
            GdbServerLauncher.$$$reportNull$$$0(23);
        }
        Process process2 = this.getConfiguration().isElevated() ? ElevationService.getInstance().createProcess(gdbServerCommandLine) : new PtyCommandLine(gdbServerCommandLine).createProcess();
        return new OSProcessHandler(process2, gdbServerCommandLine.getCommandLineString(), gdbServerCommandLine.getCharset()){

            public boolean isSilentlyDestroyOnClose() {
                return true;
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/execution/gdbserver/GdbServerLauncher$1", "readerOptions"));
            }
        };
    }

    protected boolean haveToBeDownloaded(@NotNull DownloadType downloadType, @NotNull File symbolFile) {
        if (downloadType == null) {
            GdbServerLauncher.$$$reportNull$$$0(24);
        }
        if (symbolFile == null) {
            GdbServerLauncher.$$$reportNull$$$0(25);
        }
        return downloadType == DownloadType.ALWAYS || downloadType == DownloadType.UPDATED_ONLY && !Utils.isLatestUploaded(symbolFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerToolchain";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbServerLauncher";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbRemoteString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolFileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalCommands";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServerCommandLine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbServerLauncher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugProcess";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createGdbServerProcess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startDebugProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getGdbServerParameters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalCommands";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareSymbolFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "haveToBeDownloaded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 16, 20 -> new IllegalStateException(string);
        };
    }
}

