/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdParser;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdTreeTableModel;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdRoot
implements SvdNode<SvdFile> {
    private final SvdTreeTableModel myTreeTableModel = new SvdTreeTableModel(this);
    private final List<SvdFile> files = new ArrayList<SvdFile>();
    private Set<SvdNode<?>> activeNodes = new HashSet();

    @Override
    @NotNull
    public List<SvdFile> getChildren() {
        List<SvdFile> list2 = this.files;
        if (list2 == null) {
            SvdRoot.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getId() {
        return "";
    }

    @Nullable
    public SvdFile addFile(InputStream stream, String shortName, @NlsSafe String fileName) {
        SvdFile svdFile = new SvdFile(shortName, fileName);
        svdFile.setChildren(SvdParser.parseFile(stream, shortName, fileName));
        Objects.requireNonNull(this.getChildren()).add(svdFile);
        this.getTreeTableModel().notifyFileInserted(svdFile);
        return svdFile;
    }

    @NotNull
    public SvdTreeTableModel getTreeTableModel() {
        SvdTreeTableModel svdTreeTableModel = this.myTreeTableModel;
        if (svdTreeTableModel == null) {
            SvdRoot.$$$reportNull$$$0(1);
        }
        return svdTreeTableModel;
    }

    public boolean isActive(@NotNull SvdNode<?> child) {
        if (child == null) {
            SvdRoot.$$$reportNull$$$0(2);
        }
        return this.activeNodes.contains(child);
    }

    public void setActive(@NotNull Set<SvdNode<?>> nodes) {
        if (nodes == null) {
            SvdRoot.$$$reportNull$$$0(3);
        }
        this.activeNodes = nodes;
    }

    public void unloadFile(@NotNull SvdFile deleted) {
        int index;
        if (deleted == null) {
            SvdRoot.$$$reportNull$$$0(4);
        }
        if ((index = this.getChildren().indexOf(deleted)) >= 0) {
            this.getChildren().remove(index);
            this.getTreeTableModel().notifyFileDeleted(deleted, index);
        }
    }

    public Set<SvdNode<?>> getActiveNodes() {
        return this.activeNodes;
    }

    public void export(PrintWriter writer2) {
        writer2.write("Peripheral, Register, Value, Fields" + System.lineSeparator());
        boolean fileNamePrefix = this.getChildren().size() > 1;
        for (SvdFile file : this.files) {
            if (!ContainerUtil.exists(file.getChildren(), this::isActive)) continue;
            String prefix = fileNamePrefix ? file.getName() + ": " : "";
            file.exportCsv(writer2, prefix, this::isActive);
        }
    }

    @NotNull
    public static String addressToString(Address address) {
        long value = address.getUnsignedLongValue();
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            String string = "0x" + StringsKt.padStart((String)Integer.toHexString((int)value), (int)8, (char)'0');
            if (string == null) {
                SvdRoot.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = address.toString();
        if (string == null) {
            SvdRoot.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTableModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addressToString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActive";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unloadFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

