/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.EnumAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.Format;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterPropsHolder;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdCluster;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdEnum;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdEnumValue;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdField;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNodeBase;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdPeripheral;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegisterBigEndian;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegisterClusterLevel;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRoot;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SvdParser {
    static final Comparator<SvdRegisterClusterLevel<?>> ADDRESS_COMPARATOR = (a, b) -> Long.compareUnsigned(a.getStartAddress(), b.getStartAddress());

    @NotNull
    public static List<SvdNodeBase<?>> parseFile(InputStream stream, String shortName, @NlsSafe String fileName) {
        Element document;
        try {
            document = JDOMUtil.load((InputStream)stream);
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)(fileName + ": " + e.getMessage()), (String)CLionExecutionBundle.message("svd.root.load.error", new Object[0]));
            List<SvdNodeBase<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                SvdParser.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList flatList = new ArrayList();
        List<Element> endian = SvdParser.selectDomSubNodes(document, "cpu", "endian");
        boolean bigEndian = !endian.isEmpty() && "big".equals(endian.get(0).getTextTrim());
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        SvdParser.selectDomSubNodes(document, "peripherals", "peripheral").forEach(element -> elements.put(element.getChildText("name"), element));
        TreeMap<String, SvdNodeBase> grouped = new TreeMap<String, SvdNodeBase>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String name = (String)entry.getKey();
            try {
                SvdPeripheral peripheral;
                String derivedFromName = element2.getAttributeValue("derivedFrom");
                Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
                String description = SvdParser.loadDescription(element2, derivedFrom);
                String groupName = SvdParser.getDomSubTagText(element2, derivedFrom, "groupName");
                long baseAddress = SvdParser.getDomSubTagValue(element2, derivedFrom, "baseAddress", Long::decode, 0L);
                int registerSize = SvdParser.getDomSubTagValue(element2, derivedFrom, "size", Integer::decode, 32);
                RegisterAccess registerAccess = SvdParser.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, RegisterAccess.READ_WRITE);
                if (groupName.isEmpty()) {
                    peripheral = new SvdPeripheral(shortName, name, description, registerAccess, baseAddress, registerSize);
                    flatList.add(peripheral);
                } else {
                    SvdNodeBase group = grouped.computeIfAbsent(groupName, s -> {
                        SvdNodeBase node = new SvdNodeBase(shortName + "|g:" + s, (String)s, "");
                        node.setChildren(new ArrayList());
                        return node;
                    });
                    peripheral = new SvdPeripheral(shortName, name, description, registerAccess, baseAddress, registerSize);
                    group.getChildren().add(peripheral);
                }
                SvdParser.loadContent(peripheral, element2, derivedFrom, bigEndian);
            }
            catch (RuntimeException e) {
                Logger.getInstance(SvdParser.class).warn(MessageFormat.format("Svd parser error at {0}/{1}", element2.getName(), element2.getChildText("name")), (Throwable)e);
            }
        }
        block9: for (SvdNodeBase node : grouped.values()) {
            List children = node.getChildren();
            switch (children.size()) {
                case 0: {
                    continue block9;
                }
                case 1: {
                    flatList.add((SvdNodeBase)children.get(0));
                    continue block9;
                }
            }
            flatList.add(node);
        }
        flatList.sort(SvdNode.NAME_COMPARATOR);
        ArrayList arrayList = flatList;
        if (arrayList == null) {
            SvdParser.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void loadContent(@NotNull SvdPeripheral peripheral, @NotNull Element peripheralElement, @Nullable Element peripheralDerivedFrom, boolean bigEndian) {
        if (peripheral == null) {
            SvdParser.$$$reportNull$$$0(2);
        }
        if (peripheralElement == null) {
            SvdParser.$$$reportNull$$$0(3);
        }
        Stream<Element> registersStream = Stream.concat(SvdParser.selectDomSubNodes(peripheralElement, "registers", "register").stream(), SvdParser.selectDomSubNodes(peripheralDerivedFrom, "registers", "register").stream());
        List<SvdRegisterClusterLevel<?>> registers = SvdParser.parseRegisters(registersStream, peripheral, bigEndian);
        Stream<Element> clustersStream = Stream.concat(SvdParser.selectDomSubNodes(peripheralElement, "registers", "cluster").stream(), SvdParser.selectDomSubNodes(peripheralDerivedFrom, "registers", "cluster").stream());
        ArrayList result = new ArrayList(SvdParser.parseClusters(clustersStream, peripheral, bigEndian));
        result.addAll(registers);
        result.sort(ADDRESS_COMPARATOR);
        peripheral.setChildren(result);
    }

    private static void loadContent(@NotNull SvdCluster cluster, @NotNull Element clusterElement, @Nullable Element clusterDerivedFrom, boolean bigEndian) {
        if (cluster == null) {
            SvdParser.$$$reportNull$$$0(4);
        }
        if (clusterElement == null) {
            SvdParser.$$$reportNull$$$0(5);
        }
        Stream<Element> registersStream = Stream.concat(SvdParser.selectDomSubNodes(clusterElement, "register").stream(), SvdParser.selectDomSubNodes(clusterDerivedFrom, "register").stream());
        List<SvdRegisterClusterLevel<?>> registers = SvdParser.parseRegisters(registersStream, cluster, bigEndian);
        Stream<Element> clusterStream = Stream.concat(SvdParser.selectDomSubNodes(clusterElement, "cluster").stream(), SvdParser.selectDomSubNodes(clusterDerivedFrom, "cluster").stream());
        ArrayList result = new ArrayList(SvdParser.parseClusters(clusterStream, cluster, bigEndian));
        result.addAll(registers);
        result.sort(ADDRESS_COMPARATOR);
        cluster.setChildren(result);
    }

    private static <T> List<Pair<String, T>> processDim(@NotNull Element element, @Nullable Element derivedFrom, String name, T base, BiFunction<T, Long, T> step) {
        int dim;
        if (element == null) {
            SvdParser.$$$reportNull$$$0(6);
        }
        if ((dim = SvdParser.getDomSubTagValue(element, derivedFrom, "dim", Integer::decode, 0).intValue()) == 0) {
            return Collections.singletonList(new Pair((Object)name, base));
        }
        String dimName = SvdParser.getDomSubTagText(element, derivedFrom, "dimName");
        if (dimName.isBlank()) {
            dimName = name;
        }
        long dimIncrement = SvdParser.getDomSubTagValue(element, derivedFrom, "dimIncrement", Long::decode, 0L);
        String dimIndexText = SvdParser.getDomSubTagText(element, derivedFrom, "dimIndex");
        return SvdParser.generateDimSequences(dim, dimIndexText, dimName, dimIncrement, base, step);
    }

    private static List<SvdRegisterClusterLevel<?>> parseClusters(@NotNull Stream<Element> clusterStream, @NotNull RegisterPropsHolder parent, boolean bigEndian) {
        if (clusterStream == null) {
            SvdParser.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            SvdParser.$$$reportNull$$$0(8);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        clusterStream.forEach(element -> elements.put(element.getChildText("name"), element));
        ArrayList clusters = new ArrayList();
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            Address address = Address.fromUnsignedLong((long)(parent.getBaseAddress() + SvdParser.getDomSubTagValue(element2, derivedFrom, "addressOffset", Long::decode, 0L)));
            int registerSize = SvdParser.getDomSubTagValue(element2, derivedFrom, "size", Integer::decode, parent.getRegisterBitSize());
            RegisterAccess registerAccess = SvdParser.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, parent.getRegisterAccess());
            String parentId = parent.getId();
            for (Pair<String, Address> p : SvdParser.processDim(element2, derivedFrom, (String)entry.getKey(), address, Address::plus)) {
                String description = SvdParser.loadDescription(element2, derivedFrom) + " (" + SvdRoot.addressToString((Address)p.second) + ")";
                SvdCluster cluster = new SvdCluster(parentId, (String)p.first, description, registerAccess, ((Address)p.second).getUnsignedLongValue(), registerSize);
                SvdParser.loadContent(cluster, element2, derivedFrom, bigEndian);
                clusters.add(cluster);
            }
        }
        clusters.sort(ADDRESS_COMPARATOR);
        return clusters;
    }

    static <T> List<Pair<String, T>> generateDimSequences(int dim, @NotNull String dimIndexText, @NotNull String dimName, long dimIncrement, T base, BiFunction<? super T, ? super Long, T> biFunction) {
        int i;
        if (dimIndexText == null) {
            SvdParser.$$$reportNull$$$0(9);
        }
        if (dimName == null) {
            SvdParser.$$$reportNull$$$0(10);
        }
        List<Object> indices = new ArrayList(dim);
        if (dimIndexText.contains(",")) {
            indices = Arrays.asList(dimIndexText.split(",\\s*"));
        } else if (dimIndexText.contains("-")) {
            String[] bounds = dimIndexText.split("-");
            if (Character.isLetter(bounds[0].charAt(0))) {
                if (bounds[0].charAt(0) <= bounds[1].charAt(0)) {
                    for (i = (int)bounds[0].charAt(0); i <= bounds[1].charAt(0); i = (int)((char)(i + 1))) {
                        indices.add(String.valueOf((char)i));
                    }
                } else {
                    for (i = (int)bounds[0].charAt(0); i >= bounds[1].charAt(0); i = (int)((char)(i - 1))) {
                        indices.add(String.valueOf((char)i));
                    }
                }
            } else {
                int n;
                int from = Integer.parseInt(bounds[0]);
                if (from <= (n = Integer.parseInt(bounds[1]))) {
                    for (i = from; i <= n; ++i) {
                        indices.add(String.valueOf(i));
                    }
                } else {
                    for (i = from; i >= n; --i) {
                        indices.add(String.valueOf(i));
                    }
                }
            }
        } else {
            for (int i2 = 0; i2 < dim; ++i2) {
                indices.add(String.valueOf(i2));
            }
        }
        ArrayList<Pair<String, T>> pairs = new ArrayList<Pair<String, T>>(dim);
        if (indices.size() < dim) {
            for (String string : indices) {
                pairs.add(new Pair((Object)String.format(dimName, string), base));
                base = step.apply(base, dimIncrement);
            }
        } else {
            for (i = 0; i < dim; ++i) {
                pairs.add(new Pair((Object)String.format(dimName, indices.get(i)), base));
                base = step.apply(base, dimIncrement);
            }
        }
        return pairs;
    }

    private static List<SvdRegisterClusterLevel<?>> parseRegisters(@NotNull Stream<Element> elementStream, @NotNull RegisterPropsHolder parent, boolean bigEndian) {
        if (elementStream == null) {
            SvdParser.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            SvdParser.$$$reportNull$$$0(12);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        elementStream.forEach(element -> elements.put(element.getChildText("name"), element));
        ArrayList registers = new ArrayList();
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            Address address = Address.fromUnsignedLong((long)(parent.getBaseAddress() + SvdParser.getDomSubTagValue(element2, derivedFrom, "addressOffset", Long::decode, 0L)));
            int registerSize = SvdParser.getDomSubTagValue(element2, derivedFrom, "size", Integer::decode, parent.getRegisterBitSize());
            RegisterAccess registerAccess = SvdParser.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, parent.getRegisterAccess());
            RegisterReadAction registerReadAction = SvdParser.getDomSubTagValue(element2, derivedFrom, "readAction", RegisterReadAction::parse, null);
            String parentId = parent.getId();
            for (Pair<String, Address> p : SvdParser.processDim(element2, derivedFrom, (String)entry.getKey(), address, Address::plus)) {
                String description = SvdParser.loadDescription(element2, derivedFrom) + " (" + SvdRoot.addressToString((Address)p.second) + ")";
                SvdRegister register = bigEndian ? new SvdRegisterBigEndian(parentId, (String)p.first, description, (Address)p.second, registerSize, registerAccess, registerReadAction) : new SvdRegister(parentId, (String)p.first, description, (Address)p.second, registerSize, registerAccess, registerReadAction);
                SvdParser.loadContent(register, element2, derivedFrom);
                registers.add(register);
            }
        }
        registers.sort(ADDRESS_COMPARATOR);
        return registers;
    }

    private static String loadDescription(@NotNull Element element, @Nullable Element derivedFrom) {
        if (element == null) {
            SvdParser.$$$reportNull$$$0(13);
        }
        return Text.normalizeString((String)SvdParser.getDomSubTagText(element, derivedFrom, "description"));
    }

    @NotNull
    private static String getDomSubTagText(@NotNull Element element, @Nullable Element derivedFrom, @NotNull String tagName) {
        if (element == null) {
            SvdParser.$$$reportNull$$$0(14);
        }
        if (tagName == null) {
            SvdParser.$$$reportNull$$$0(15);
        }
        String string = SvdParser.getDomSubTagValue(element, derivedFrom, tagName, String::valueOf, "");
        if (string == null) {
            SvdParser.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    @Contract(value="_,_,_,_,!null->!null")
    private static <T> T getDomSubTagValue(@NotNull Element element, @Nullable Element derivedFrom, @NotNull String tagName, Function<String, T> convert, @Nullable T defaultValue) {
        String text;
        if (element == null) {
            SvdParser.$$$reportNull$$$0(17);
        }
        if (tagName == null) {
            SvdParser.$$$reportNull$$$0(18);
        }
        if ((text = element.getChildText(tagName)) != null) {
            return convert.apply(text);
        }
        if (derivedFrom != null) {
            text = derivedFrom.getChildText(tagName);
        }
        return text == null ? defaultValue : convert.apply(text);
    }

    @NotNull
    private static List<Element> selectDomSubNodes(@Nullable Element parent, String ... selectors) {
        if (parent == null) {
            List<Element> list2 = Collections.emptyList();
            if (list2 == null) {
                SvdParser.$$$reportNull$$$0(19);
            }
            return list2;
        }
        for (int i = 0; i < selectors.length - 1; ++i) {
            if ((parent = parent.getChild(selectors[i])) != null) continue;
            List<Element> list3 = Collections.emptyList();
            if (list3 == null) {
                SvdParser.$$$reportNull$$$0(20);
            }
            return list3;
        }
        List list4 = parent.getChildren(selectors[selectors.length - 1]);
        if (list4 == null) {
            SvdParser.$$$reportNull$$$0(21);
        }
        return list4;
    }

    private static void loadContent(@NotNull SvdRegister register, @NotNull Element peripheralElement, @Nullable Element peripheralDerivedFrom) {
        if (register == null) {
            SvdParser.$$$reportNull$$$0(22);
        }
        if (peripheralElement == null) {
            SvdParser.$$$reportNull$$$0(23);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Stream.concat(SvdParser.selectDomSubNodes(peripheralElement, "fields", "field").stream(), SvdParser.selectDomSubNodes(peripheralDerivedFrom, "fields", "field").stream()).forEach(element -> elements.put(element.getChildText("name"), element));
        ArrayList<SvdField> fields = new ArrayList<SvdField>();
        for (Map.Entry entry : elements.entrySet()) {
            int bitSize;
            Element element2 = (Element)entry.getValue();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            RegisterAccess registerAccess = SvdParser.getDomSubTagValue(element2, derivedFrom, "access", RegisterAccess::parse, register.getAccess());
            RegisterReadAction registerReadAction = SvdParser.getDomSubTagValue(element2, derivedFrom, "readAction", RegisterReadAction::parse, null);
            int bitOffset = SvdParser.getDomSubTagValue(element2, derivedFrom, "bitOffset", Integer::decode, -1);
            if (bitOffset >= 0) {
                bitSize = SvdParser.getDomSubTagValue(element2, derivedFrom, "bitWidth", Integer::decode, register.getBitSize() - bitOffset);
            } else {
                bitOffset = SvdParser.getDomSubTagValue(element2, derivedFrom, "lsb", Integer::decode, -1);
                if (bitOffset >= 0) {
                    bitSize = SvdParser.getDomSubTagValue(element2, derivedFrom, "msb", Integer::decode, register.getBitSize()) - bitOffset + 1;
                } else {
                    String bitRange = SvdParser.getDomSubTagText(element2, derivedFrom, "bitRange");
                    int columnIndex = (bitRange = bitRange.replaceAll("\\s|\\[|]", "")).indexOf(58);
                    if (columnIndex < 1) {
                        bitOffset = 0;
                        bitSize = register.getBitSize();
                    } else {
                        int bitEnd = Integer.parseUnsignedInt(bitRange.substring(0, columnIndex), 10);
                        int bitStart = Integer.parseUnsignedInt(bitRange.substring(columnIndex + 1), 10);
                        bitOffset = Math.min(bitEnd, bitStart);
                        bitSize = Math.abs(bitEnd - bitStart) + 1;
                    }
                }
            }
            for (Pair<String, Long> p : SvdParser.processDim(element2, derivedFrom, (String)entry.getKey(), Long.valueOf(bitOffset), (a, diff) -> a + diff)) {
                Object description = SvdParser.loadDescription(element2, derivedFrom);
                description = bitSize == 1 ? (String)description + " [" + p.second + "]" : (String)description + " [" + p.second + ":" + ((Long)p.second + (long)bitSize - 1L) + "]";
                SvdField field2 = new SvdField(register, (String)p.first, (String)description, registerAccess, registerReadAction, ((Long)p.second).intValue(), bitSize);
                SvdParser.loadContent(field2, element2, derivedFrom);
                fields.add(field2);
            }
        }
        fields.sort(Comparator.comparingInt(SvdField::getBitOffset));
        register.setChildren(fields);
    }

    private static void loadContent(@NotNull SvdField field2, @NotNull Element fieldElement, @Nullable Element fieldDerivedFrom) {
        if (field2 == null) {
            SvdParser.$$$reportNull$$$0(24);
        }
        if (fieldElement == null) {
            SvdParser.$$$reportNull$$$0(25);
        }
        TreeMap elements = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Stream.concat(SvdParser.selectDomSubNodes(fieldElement, "enumeratedValues").stream(), SvdParser.selectDomSubNodes(fieldDerivedFrom, "enumeratedValues").stream()).forEach(element -> elements.put(element.getChildText("name") == null ? "" : element.getChildText("name"), element));
        for (Map.Entry entry : elements.entrySet()) {
            Element element2 = (Element)entry.getValue();
            String derivedFromName = element2.getAttributeValue("derivedFrom");
            Element derivedFrom = derivedFromName == null ? null : (Element)elements.get(derivedFromName);
            EnumAccess enumUsage = SvdParser.getDomSubTagValue(element2, derivedFrom, "usage", EnumAccess::parse, EnumAccess.READ_WRITE);
            SvdEnum svdEnum = new SvdEnum(enumUsage);
            SvdParser.loadContent(svdEnum, element2, derivedFrom);
            if (enumUsage == EnumAccess.READ || enumUsage == EnumAccess.READ_WRITE) {
                field2.setSvdEnumRead(svdEnum);
                field2.setFormat(Format.ENUM);
            }
            if (enumUsage != EnumAccess.WRITE && enumUsage != EnumAccess.READ_WRITE) continue;
            field2.setSvdEnumWrite(svdEnum);
            field2.setFormat(Format.ENUM);
        }
    }

    private static SvdEnumValue createEnumValue(String name, String description, String str) {
        int index = str.startsWith("+") ? 1 : 0;
        int radix = 10;
        if (str.startsWith("#", index)) {
            radix = 2;
            ++index;
        } else if (str.startsWith("0b", index) || str.startsWith("0B", index)) {
            radix = 2;
            index += 2;
        } else if (str.startsWith("0x", index) || str.startsWith("0X", index)) {
            radix = 16;
            index += 2;
        }
        if (radix == 2) {
            long mask = -1L;
            long value = 0L;
            while (index < str.length()) {
                mask <<= 1;
                value <<= 1;
                switch (str.charAt(index)) {
                    case '0': {
                        mask |= 1L;
                        break;
                    }
                    case '1': {
                        mask |= 1L;
                        value |= 1L;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        break;
                    }
                    default: {
                        throw new NumberFormatException(str);
                    }
                }
                ++index;
            }
            return new SvdEnumValue(name, description, value, mask);
        }
        return new SvdEnumValue(name, description, Long.parseUnsignedLong(str, index, str.length(), radix), -1L);
    }

    private static void loadContent(@NotNull SvdEnum svdEnum, @NotNull Element enumElement, @Nullable Element enumDerivedFrom) {
        if (svdEnum == null) {
            SvdParser.$$$reportNull$$$0(26);
        }
        if (enumElement == null) {
            SvdParser.$$$reportNull$$$0(27);
        }
        ArrayList values = new ArrayList();
        Stream.concat(SvdParser.selectDomSubNodes(enumElement, "enumeratedValue").stream(), SvdParser.selectDomSubNodes(enumDerivedFrom, "enumeratedValue").stream()).forEach(element -> {
            String strValue = SvdParser.getDomSubTagText(element, null, "value");
            boolean isDefault = Boolean.parseBoolean(element.getChildText("isDefault"));
            String name = element.getChildText("name");
            String description = SvdParser.loadDescription(element, null);
            if (isDefault) {
                svdEnum.setDefaultEnumValue(new SvdEnumValue(name, description, -1L, -1L));
            }
            if (!strValue.isEmpty()) {
                values.add(SvdParser.createEnumValue(name, description, strValue));
            }
        });
        svdEnum.setEnumValues(values.toArray(new SvdEnumValue[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 22, 23, 24, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheral";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheralElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusterElement";
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusterStream";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimIndexText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementStream";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "register";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svdEnum";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdParser";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomSubTagText";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "selectDomSubNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDim";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseClusters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateDimSequences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseRegisters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDomSubTagText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDomSubTagValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 22, 23, 24, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }
}

