/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.ExportCsvToClipboardAction;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.OpenAsCsvInEditorAction;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.PeripheralViewUsagesCollector;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRoot;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdShowHideDialog;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdTreeTable;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdValue;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdValueCellEditor;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdWindowState;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import icons.ClionExecutionIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.TreePath;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SvdPanel
extends JPanel {
    public static final String HELP_ID = "toolwindows.peripheralview";
    private final JComponent myInnerPanel;
    private final SvdTreeTable myTreeTable;
    private final CidrDebugProcess myProcess;
    private final SvdWindowState.ProjectState myWindowProfileState;
    private boolean autoUpdate;
    private boolean myPendingUpdateValue;

    private SvdPanel(@NotNull JComponent innerPanel, @NotNull DefaultActionGroup group, @NotNull SvdTreeTable treeTable, @NotNull CidrDebugProcess process2, SvdWindowState.ProjectState profileState) {
        if (innerPanel == null) {
            SvdPanel.$$$reportNull$$$0(0);
        }
        if (group == null) {
            SvdPanel.$$$reportNull$$$0(1);
        }
        if (treeTable == null) {
            SvdPanel.$$$reportNull$$$0(2);
        }
        if (process2 == null) {
            SvdPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.autoUpdate = true;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)group, false);
        actionToolbar.setTargetComponent((JComponent)((Object)treeTable));
        JComponent component2 = actionToolbar.getComponent();
        this.add((Component)component2, "West");
        this.add((Component)innerPanel, "Center");
        this.myInnerPanel = innerPanel;
        this.myTreeTable = treeTable;
        this.myProcess = process2;
        this.setupActions(group);
        StatusText emptyText = treeTable.getEmptyText();
        emptyText.setText(CLionExecutionBundle.message("svd.no.registers.loaded", new Object[0]));
        emptyText.appendSecondaryText(CLionExecutionBundle.message("svd.load.file", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.configureSvd());
        this.myWindowProfileState = profileState;
        this.myTreeTable.setAutoUpdate(this.autoUpdate);
        this.myTreeTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                SvdPanel.this.myWindowProfileState.notifyColumnsChange(SvdPanel.this.myTreeTable);
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                SvdPanel.this.myWindowProfileState.notifyColumnsChange(SvdPanel.this.myTreeTable);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.myTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object lastPathComponent;
                if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() < 2) {
                    return;
                }
                TreeTableTree tree = SvdPanel.this.myTreeTable.getTree();
                TreePath selectedPath = tree.getSelectionPath();
                if (selectedPath != null && (lastPathComponent = selectedPath.getLastPathComponent()) != null && !(lastPathComponent instanceof SvdValue) && tree.getModel().getChildCount(lastPathComponent) == 0) {
                    SvdPanel.this.configureSvd();
                }
            }
        });
        this.myTreeTable.setRegisterCellEditor(new SvdValueCellEditor(this.myTreeTable, process2));
        this.myTreeTable.restoreState();
        this.addHierarchyListener(e -> {
            if (this.isDisplayable() && this.myPendingUpdateValue) {
                this.doUpdateValues();
                PeripheralViewUsagesCollector.PERIPHERAL_VIEW_SHOWN.log(process2.getProject(), (Object)this.myTreeTable.getRoot().getActiveNodes().size());
            }
        });
    }

    @NotNull
    public JComponent getDefaultFocusComponent() {
        JComponent jComponent = this.myInnerPanel;
        if (jComponent == null) {
            SvdPanel.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    private void setupActions(DefaultActionGroup group) {
        group.add((AnAction)new ToggleAction(CLionExecutionBundle.message("disable.refresh.on.step", new Object[0]), null, AllIcons.Actions.StopRefresh){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !SvdPanel.this.autoUpdate;
            }

            public boolean isDumbAware() {
                return true;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                SvdPanel.this.autoUpdate = !state;
                e.getPresentation().setText(SvdPanel.this.autoUpdate ? CLionExecutionBundle.message("disable.refresh.on.step", new Object[0]) : CLionExecutionBundle.message("enable.refresh.on.step", new Object[0]));
                SvdPanel.this.myTreeTable.setAutoUpdate(SvdPanel.this.autoUpdate);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        group.add((AnAction)new DumbAwareAction(CLionExecutionBundle.message("svd.panel.refresh", new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                SvdPanel.this.updateValues(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(SvdPanel.this.myProcess.getSession().isSuspended());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        group.addSeparator();
        Function1 csvPrinter = printWriter -> {
            this.myTreeTable.getRoot().export((PrintWriter)printWriter);
            return Unit.INSTANCE;
        };
        group.add((AnAction)new ExportCsvToClipboardAction((Function1<? super PrintWriter, Unit>)csvPrinter));
        group.add((AnAction)new OpenAsCsvInEditorAction(this.myProcess, "Peripheral", (Function1<? super PrintWriter, Unit>)csvPrinter));
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(CLionExecutionBundle.message("svd.panel.configure.action", new Object[0]), null, AllIcons.General.Filter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                SvdPanel.this.configureSvd();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel$5", "actionPerformed"));
            }
        });
        group.add((AnAction)new ContextHelpAction(HELP_ID));
    }

    private void configureSvd() {
        SvdRoot root = this.myTreeTable.getRoot();
        TreeTableTree tree = this.myTreeTable.getTree();
        SvdShowHideDialog dialog2 = new SvdShowHideDialog(root, this.myProcess.getProject());
        dialog2.showHideNodes();
        root.getTreeTableModel().notifyTreeUpdated();
        ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)tree).filter(path -> !(path.getLastPathComponent() instanceof SvdRegister))).forEach(arg_0 -> tree.expandPath(arg_0));
        this.myWindowProfileState.notifyTreeChange(this.myTreeTable);
        this.updateValues(true);
    }

    public void updateValues(boolean forced) {
        if ((forced || this.autoUpdate) && this.myProcess.getSession().isSuspended()) {
            if (this.isDisplayable()) {
                this.doUpdateValues();
            } else {
                this.myPendingUpdateValue = true;
            }
        }
    }

    private void doUpdateValues() {
        try {
            this.myTreeTable.getRoot().getTreeTableModel().updateValues(this.myProcess, () -> {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    this.myTreeTable.repaint();
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.myTreeTable.repaint());
                }
            });
        }
        finally {
            this.myPendingUpdateValue = false;
        }
    }

    @NotNull
    public static SvdPanel create(@NotNull CidrDebugProcess process2, @Nullable String defaultSvdLocation) {
        if (process2 == null) {
            SvdPanel.$$$reportNull$$$0(5);
        }
        SvdWindowState.ProjectState svdWindowProfileState = SvdWindowState.get((XDebugProcess)process2);
        if (svdWindowProfileState.loadedFiles.isEmpty() && defaultSvdLocation != null) {
            svdWindowProfileState.loadedFiles.add(defaultSvdLocation);
        }
        SvdTreeTable treeTable = SvdTreeTable.create(svdWindowProfileState);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)treeTable), (int)22, (int)30);
        return new SvdPanel(scrollPane, new DefaultActionGroup(), treeTable, process2, svdWindowProfileState);
    }

    public static void registerPeripheralTab(@NotNull CidrDebugProcess process2, @NotNull RunnerLayoutUi ui) {
        if (process2 == null) {
            SvdPanel.$$$reportNull$$$0(6);
        }
        if (ui == null) {
            SvdPanel.$$$reportNull$$$0(7);
        }
        SvdPanel.registerPeripheralTab(process2, ui, null);
    }

    public static void registerPeripheralTab(@NotNull CidrDebugProcess process2, @NotNull RunnerLayoutUi ui, @Nullable String defaultSvdLocation) {
        if (process2 == null) {
            SvdPanel.$$$reportNull$$$0(8);
        }
        if (ui == null) {
            SvdPanel.$$$reportNull$$$0(9);
        }
        final SvdPanel svdPanel = SvdPanel.create(process2, defaultSvdLocation);
        Content content = ui.createContent("svdView", (JComponent)svdPanel, CLionExecutionBundle.message("svd.panel.peripherals", new Object[0]), ClionExecutionIcons.PeripheralView, svdPanel.getDefaultFocusComponent());
        content.setCloseable(false);
        content.setHelpId(HELP_ID);
        ui.addContent(content);
        process2.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                svdPanel.updateValues(false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeTable";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerPeripheralTab";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

