/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.EnumAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdEnumValue;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdEnum {
    private final EnumAccess myUsage;
    private SvdEnumValue[] myEnumValues;
    private SvdEnumValue myDefaultEnumValue;

    public SvdEnum(@NotNull EnumAccess usage) {
        if (usage == null) {
            SvdEnum.$$$reportNull$$$0(0);
        }
        this.myEnumValues = new SvdEnumValue[0];
        this.myUsage = usage;
    }

    @NotNull
    public EnumAccess getUsage() {
        EnumAccess enumAccess = this.myUsage;
        if (enumAccess == null) {
            SvdEnum.$$$reportNull$$$0(1);
        }
        return enumAccess;
    }

    public void setEnumValues(@NotNull @NotNull SvdEnumValue @NotNull [] enumValues) {
        if (enumValues == null) {
            SvdEnum.$$$reportNull$$$0(2);
        }
        this.myEnumValues = enumValues;
    }

    public void setDefaultEnumValue(@NotNull SvdEnumValue defaultEnumValue) {
        if (defaultEnumValue == null) {
            SvdEnum.$$$reportNull$$$0(3);
        }
        this.myDefaultEnumValue = defaultEnumValue;
    }

    @NotNull
    public String getEnumValueDescription(long value) {
        SvdEnumValue enumValue = this.getEnumValue(value);
        if (enumValue != null) {
            String string = enumValue.getDescription();
            if (string == null) {
                SvdEnum.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public String getDisplayValue(long value, int bitSize) {
        SvdEnumValue enumValue = this.getEnumValue(value);
        if (enumValue != null) {
            String string = enumValue.getDisplayValue();
            if (string == null) {
                SvdEnum.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = SvdField.DEFAULT_FORMAT.format(value, bitSize);
        if (string == null) {
            SvdEnum.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public SvdEnumValue getEnumValue(long value) {
        for (SvdEnumValue enumValue : this.myEnumValues) {
            if (!enumValue.isEqual(value)) continue;
            return enumValue;
        }
        return this.myDefaultEnumValue;
    }

    @Nullable
    public SvdEnumValue getEnumValue(String name) {
        for (SvdEnumValue enumValue : this.myEnumValues) {
            if (!enumValue.getDisplayValue().equals(name)) continue;
            return enumValue;
        }
        return null;
    }

    @NotNull
    public @NotNull String @NotNull [] getDisplayValues() {
        String[] result = new String[this.myEnumValues.length];
        for (int i = 0; i < this.myEnumValues.length; ++i) {
            result[i] = this.myEnumValues[i].getDisplayValue();
        }
        if (result == null) {
            SvdEnum.$$$reportNull$$$0(7);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.myEnumValues.length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdEnum";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumValues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultEnumValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdEnum";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumValueDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnumValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEnumValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

