/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.backend;

import com.intellij.cidr.translateCode.CidrTranslateCodeService;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.cpp.actions.CLionShowAssemblyFuncInfoProvider;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionDebuggerFuncAsmTranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/backend/CLionLLDBFuncAsmTranslator;", "Lcom/jetbrains/cidr/cpp/execution/debugger/backend/CLionDebuggerFuncAsmTranslator;", "archType", "Lcom/jetbrains/cidr/ArchitectureType;", "lldbExecutable", "Ljava/io/File;", "programExecutable", "funcInfo", "Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/jetbrains/cidr/ArchitectureType;Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;Lcom/intellij/openapi/editor/Editor;)V", "createDisasmCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isFailed", "", "disasmResult", "Lcom/intellij/execution/process/ProcessOutput;", "createTranslationResult", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "builder", "Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nCLionLLDBFuncAsmTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionLLDBFuncAsmTranslator.kt\ncom/jetbrains/cidr/cpp/execution/debugger/backend/CLionLLDBFuncAsmTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n774#2:137\n865#2,2:138\n*S KotlinDebug\n*F\n+ 1 CLionLLDBFuncAsmTranslator.kt\ncom/jetbrains/cidr/cpp/execution/debugger/backend/CLionLLDBFuncAsmTranslator\n*L\n75#1:137\n75#1:138,2\n*E\n"})
public final class CLionLLDBFuncAsmTranslator
extends CLionDebuggerFuncAsmTranslator {
    @NotNull
    private final File lldbExecutable;
    @NotNull
    private final File programExecutable;
    @NotNull
    private final Editor editor;

    public CLionLLDBFuncAsmTranslator(@NotNull ArchitectureType archType, @NotNull File lldbExecutable, @NotNull File programExecutable, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)archType, (String)"archType");
        Intrinsics.checkNotNullParameter((Object)lldbExecutable, (String)"lldbExecutable");
        Intrinsics.checkNotNullParameter((Object)programExecutable, (String)"programExecutable");
        Intrinsics.checkNotNullParameter((Object)funcInfo, (String)"funcInfo");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(archType, funcInfo);
        this.lldbExecutable = lldbExecutable;
        this.programExecutable = programExecutable;
        this.editor = editor;
    }

    @Override
    @NotNull
    public GeneralCommandLine createDisasmCmd() {
        char[] cArray = new char[]{':'};
        String fnName = StringsKt.trimStart((String)this.getFuncInfo().getFqn(), (char[])cArray);
        GeneralCommandLine cmd = new GeneralCommandLine();
        cmd.setExePath(this.lldbExecutable.getAbsolutePath());
        cmd.getParametersList().clearAll();
        cmd.addParameter("--batch");
        cmd.addParameter("-o");
        cmd.addParameter("settings set target.preload-symbols true");
        cmd.addParameter("-o");
        cmd.addParameter("disassemble --mixed -n " + fnName);
        cmd.addParameter(this.programExecutable.getAbsolutePath());
        return cmd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isFailed(@NotNull ProcessOutput disasmResult) {
        Intrinsics.checkNotNullParameter((Object)disasmResult, (String)"disasmResult");
        if (disasmResult.getExitCode() != 0) return true;
        String string = disasmResult.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        if (((CharSequence)string).length() == 0) {
            String string2 = disasmResult.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            if (((CharSequence)string2).length() > 0) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        String string3 = disasmResult.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"Unable to find symbol", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrTranslationResult createTranslationResult(@NotNull ProcessOutput disasmResult, @NotNull CidrTranslationResultBuilder builder, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)disasmResult, (String)"disasmResult");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)funcInfo, (String)"funcInfo");
        String string = disasmResult.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String stdout = string;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)stdout);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonBlankLines = (List)destination$iv$iv;
        boolean srcMarkerDetected = false;
        String string2 = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        List docLines = StringsKt.lines((CharSequence)string2);
        IntRange funcLineRange = funcInfo.getLineRange();
        String ignoredLinePrefix = "   ";
        String lineMarkerPrefix = "** ";
        boolean raw = CidrTranslateCodeService.Companion.getShowRawTranslatedCode();
        for (String line : nonBlankLines) {
            if (StringsKt.startsWith$default((String)line, (String)ignoredLinePrefix, (boolean)false, (int)2, null)) {
                if (!raw) continue;
                builder.addTranslatedCodeLine(line);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)lineMarkerPrefix, (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{' ', '\t'};
                int lineNumEndIdx = StringsKt.indexOfAny$default((CharSequence)line, (char[])cArray, (int)lineMarkerPrefix.length(), (boolean)false, (int)4, null);
                if (lineNumEndIdx == -1) continue;
                try {
                    String string3 = line.substring(lineMarkerPrefix.length(), lineNumEndIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    int srcLineNum1 = Integer.parseInt(string3);
                    if (!funcLineRange.contains(srcLineNum1)) {
                        if (!raw) continue;
                        builder.addTranslatedCodeLine(line);
                        continue;
                    }
                    String string4 = line.substring(lineNumEndIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    String codeSnippet = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                    String docLine = (String)CollectionsKt.getOrNull((List)docLines, (int)(srcLineNum1 - 1));
                    if (docLine == null || !StringsKt.contains$default((CharSequence)docLine, (CharSequence)codeSnippet, (boolean)false, (int)2, null)) {
                        if (!raw) continue;
                        builder.addTranslatedCodeLine(line);
                        continue;
                    }
                    builder.markSrcLine(srcLineNum1);
                    srcMarkerDetected = true;
                    if (!raw) continue;
                    builder.addTranslatedCodeLine(line);
                }
                catch (NumberFormatException e) {
                    builder.addTranslatedCodeLine(line);
                }
                continue;
            }
            if (!srcMarkerDetected) continue;
            builder.addTranslatedCodeLine(((Object)StringsKt.trimStart((CharSequence)line)).toString());
        }
        if (!srcMarkerDetected) {
            for (String line : nonBlankLines) {
                builder.addTranslatedCodeLine(((Object)StringsKt.trimStart((CharSequence)line)).toString());
            }
        }
        return builder.build();
    }
}

