/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.backend;

import com.intellij.cidr.translateCode.CidrTranslateCodeService;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.cpp.actions.CLionShowAssemblyFuncInfoProvider;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionDebuggerFuncAsmTranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/backend/CLionGDBFuncAsmTranslator;", "Lcom/jetbrains/cidr/cpp/execution/debugger/backend/CLionDebuggerFuncAsmTranslator;", "archType", "Lcom/jetbrains/cidr/ArchitectureType;", "gdbExecutablePath", "", "programExecutable", "Ljava/io/File;", "funcInfo", "Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;", "<init>", "(Lcom/jetbrains/cidr/ArchitectureType;Ljava/lang/String;Ljava/io/File;Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;)V", "createDisasmCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createTranslationResult", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "disasmResult", "Lcom/intellij/execution/process/ProcessOutput;", "builder", "Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nCLionGDBFuncAsmTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionGDBFuncAsmTranslator.kt\ncom/jetbrains/cidr/cpp/execution/debugger/backend/CLionGDBFuncAsmTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n774#2:83\n865#2,2:84\n*S KotlinDebug\n*F\n+ 1 CLionGDBFuncAsmTranslator.kt\ncom/jetbrains/cidr/cpp/execution/debugger/backend/CLionGDBFuncAsmTranslator\n*L\n56#1:83\n56#1:84,2\n*E\n"})
public final class CLionGDBFuncAsmTranslator
extends CLionDebuggerFuncAsmTranslator {
    @NotNull
    private final String gdbExecutablePath;
    @NotNull
    private final File programExecutable;

    public CLionGDBFuncAsmTranslator(@NotNull ArchitectureType archType, @NotNull String gdbExecutablePath, @NotNull File programExecutable, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo) {
        Intrinsics.checkNotNullParameter((Object)archType, (String)"archType");
        Intrinsics.checkNotNullParameter((Object)gdbExecutablePath, (String)"gdbExecutablePath");
        Intrinsics.checkNotNullParameter((Object)programExecutable, (String)"programExecutable");
        Intrinsics.checkNotNullParameter((Object)funcInfo, (String)"funcInfo");
        super(archType, funcInfo);
        this.gdbExecutablePath = gdbExecutablePath;
        this.programExecutable = programExecutable;
    }

    @Override
    @NotNull
    public GeneralCommandLine createDisasmCmd() {
        GeneralCommandLine cmd = new GeneralCommandLine();
        cmd.setExePath(this.gdbExecutablePath);
        String[] stringArray = new String[]{"--batch", "-ex", "disassemble/m " + this.getFuncInfo().getFqn(), this.programExecutable.getAbsolutePath()};
        cmd.addParameters(stringArray);
        return cmd;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrTranslationResult createTranslationResult(@NotNull ProcessOutput disasmResult, @NotNull CidrTranslationResultBuilder builder, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)disasmResult, (String)"disasmResult");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)funcInfo, (String)"funcInfo");
        String string = disasmResult.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String stdout = string;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)stdout);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonBlankLines = (List)destination$iv$iv;
        String disasmPrefix = "   0x";
        boolean raw = CidrTranslateCodeService.Companion.getShowRawTranslatedCode();
        for (String line : nonBlankLines) {
            if (StringsKt.startsWith$default((String)line, (String)disasmPrefix, (boolean)false, (int)2, null)) {
                builder.addTranslatedCodeLine(((Object)StringsKt.trimStart((CharSequence)line)).toString());
                continue;
            }
            int lineEndIdx = StringsKt.indexOf$default((CharSequence)line, (char)'\t', (int)0, (boolean)false, (int)6, null);
            if (lineEndIdx != -1) {
                try {
                    String string2 = line.substring(0, lineEndIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int srcLineNum1 = Integer.parseInt(string2);
                    builder.markSrcLine(srcLineNum1);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (!raw) continue;
            builder.addTranslatedCodeLine(((Object)StringsKt.trimStart((CharSequence)line)).toString());
        }
        return builder.build();
    }
}

