/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeRunProfileState;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cmake.psi.CMakeFile;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class CMakeRunLineMarkerProvider
extends RunLineMarkerContributor {
    public static final Key<CMakeDebugSupportInfo> TEST_DEBUG_SUPPORT_INFO = Key.create((String)"CMakeRunLineMarkerProvider.cmakeDebugSupportInfo");
    private volatile CMakeDebugSupportInfo myDebugSupportInfo;

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        if (element == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public RunLineMarkerContributor.Info getSlowInfo(@NotNull PsiElement element) {
        if (element == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (!CMakeDebugProcess.isEnabled()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof CMakeFile) || PsiTreeUtil.getDeepestFirst((PsiElement)file) != element) {
            return null;
        }
        Project project = element.getProject();
        CMakeProfileInfo cmakeProfile = CMakeRunLineMarkerProvider.getCMakeProfileInfo(project);
        if (cmakeProfile == null) {
            return null;
        }
        if (!CMakeRunLineMarkerProvider.isMainProjectFile(file)) {
            return null;
        }
        if (this.getCMakeDebugProtocol(cmakeProfile, element.getProject(), file) == CMakeExecutableTool.CMakeDebugProtocol.NONE) {
            return null;
        }
        return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, e -> CLionCMakeBundle.message("cmake.dbg.gutter.icon.tooltip", new Object[0]), ExecutorAction.getActions((int)0));
    }

    private static boolean isMainProjectFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        Project project = file.getProject();
        CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(project);
        VirtualFile vfile = file.getVirtualFile();
        VirtualFile dir = vfile != null ? vfile.getParent() : null;
        String dirPath = dir != null ? dir.getPath() : null;
        return dirPath != null && cmakeWorkspace.getProjectPath().equals(Path.of(dirPath, new String[0]));
    }

    @NotNull
    private CMakeExecutableTool.CMakeDebugProtocol getCMakeDebugProtocol(@NotNull CMakeProfileInfo cmakeProfileInfo, final @NotNull Project project, final @NotNull PsiFile cmakeFile) {
        CPPEnvironment environment;
        CPPToolchains.Toolchain toolchain;
        if (cmakeProfileInfo == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (cmakeFile == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        CPPToolchains.Toolchain toolchain2 = toolchain = (environment = cmakeProfileInfo.getEnvironment()) != null ? environment.getToolchain() : null;
        if (toolchain == null || !CMakeRunProfileState.isSupportedToolchain(toolchain)) {
            CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
            if (cMakeDebugProtocol == null) {
                CMakeRunLineMarkerProvider.$$$reportNull$$$0(5);
            }
            return cMakeDebugProtocol;
        }
        final CMakeExecutableTool tool = environment.getCMake();
        if (tool == null) {
            CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
            if (cMakeDebugProtocol == null) {
                CMakeRunLineMarkerProvider.$$$reportNull$$$0(6);
            }
            return cMakeDebugProtocol;
        }
        final File cmake = tool.getExecutable();
        CMakeDebugSupportInfo testDebugSupportInfo = (CMakeDebugSupportInfo)TestModeFlags.get(TEST_DEBUG_SUPPORT_INFO);
        CMakeDebugSupportInfo debugSupportInfo = testDebugSupportInfo != null ? testDebugSupportInfo : this.myDebugSupportInfo;
        final boolean dapSupportFlag = AdvancedSettings.getBoolean((String)"cmake.dbg.use.dap.protocol");
        if (debugSupportInfo != null && cmake.getPath().equals(debugSupportInfo.cmakePath) && cmake.length() == debugSupportInfo.length && cmake.lastModified() == debugSupportInfo.lastModified && dapSupportFlag == debugSupportInfo.dapSupportFlag) {
            CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = debugSupportInfo.debugProtocol;
            if (cMakeDebugProtocol == null) {
                CMakeRunLineMarkerProvider.$$$reportNull$$$0(7);
            }
            return cMakeDebugProtocol;
        }
        String title = CLionCMakeBundle.message("cmake.dbg.read.version.progress", new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CMakeRunLineMarkerProvider.this.myDebugSupportInfo = new CMakeDebugSupportInfo(cmake.getPath(), cmake.length(), cmake.lastModified(), tool.getDebugProtocol(), dapSupportFlag);
                DaemonCodeAnalyzer.getInstance((Project)project).restart(cmakeFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunLineMarkerProvider$1", "run"));
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
        CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
        if (cMakeDebugProtocol == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return cMakeDebugProtocol;
    }

    @Nullable
    static CMakeProfileInfo getCMakeProfileInfo(@NotNull Project project) {
        CMakeWorkspace cmakeWorkspace;
        if (project == null) {
            CMakeRunLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (!(cmakeWorkspace = CMakeWorkspace.getInstance(project)).isInitialized()) {
            return null;
        }
        CMakeBuildProfileExecutionTarget selectedProfile = CMakeAppRunConfiguration.getSelectedBuildProfile(project);
        if (selectedProfile == null) {
            return (CMakeProfileInfo)ContainerUtil.getFirstItem(cmakeWorkspace.getProfileInfos());
        }
        return cmakeWorkspace.getCMakeProfileInfoByName(selectedProfile.getProfileName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeProfileInfo";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunLineMarkerProvider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDebugProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSlowInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeDebugProtocol";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeProfileInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static class CMakeDebugSupportInfo {
        private final String cmakePath;
        private final long length;
        private final long lastModified;
        private final boolean dapSupportFlag;
        private final CMakeExecutableTool.CMakeDebugProtocol debugProtocol;

        /*
         * WARNING - void declaration
         */
        public CMakeDebugSupportInfo(@NotNull String cmakePath, long length, long lastModified, @NotNull CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol, boolean bl) {
            void dapSupportFlag;
            void debugProtocol;
            if (cmakePath == null) {
                CMakeDebugSupportInfo.$$$reportNull$$$0(0);
            }
            if (cMakeDebugProtocol == null) {
                CMakeDebugSupportInfo.$$$reportNull$$$0(1);
            }
            this.cmakePath = cmakePath;
            this.length = length;
            this.lastModified = lastModified;
            this.debugProtocol = debugProtocol;
            this.dapSupportFlag = dapSupportFlag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cmakePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugProtocol";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunLineMarkerProvider$CMakeDebugSupportInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

