/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListConfigurationType;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListRunConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeRunLineMarkerProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeRunConfigurationProducer
extends LazyRunConfigurationProducer<CMakeListRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = CMakeListConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull CMakeListRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!CMakeDebugProcess.isEnabled()) {
            return false;
        }
        CMakeFile file = CMakeRunConfigurationProducer.getCMakeFile(context);
        if (file == null) {
            return false;
        }
        CMakeProfileInfo cmakeProfile = CMakeRunLineMarkerProvider.getCMakeProfileInfo(configuration.getProject());
        if (cmakeProfile == null) {
            return false;
        }
        String projectName = CMakeRunConfigurationProducer.getProjectName(file);
        configuration.setName(projectName);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull CMakeListRunConfiguration configuration, @NotNull ConfigurationContext context) {
        CMakeFile file;
        if (configuration == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((file = CMakeRunConfigurationProducer.getCMakeFile(context)) == null) {
            return false;
        }
        CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(configuration.getProject());
        return cmakeWorkspace.isInitialized();
    }

    @Nullable
    private static CMakeFile getCMakeFile(@NotNull ConfigurationContext context) {
        PsiElement element;
        if (context == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((element = context.getPsiLocation()) == null) {
            return null;
        }
        return element.isValid() ? (CMakeFile)ObjectUtils.tryCast((Object)element.getContainingFile(), CMakeFile.class) : null;
    }

    private static String getProjectName(@NotNull CMakeFile file) {
        CMakeCommand projectCommand;
        if (file == null) {
            CMakeRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        CMakeCommandArguments args = (projectCommand = (CMakeCommand)ContainerUtil.find(file.getTopLevelCommands(), it -> "project".equals(it.getName()))) != null ? projectCommand.getCMakeCommandArguments() : null;
        CMakeArgument projectNameArg = args != null ? (CMakeArgument)ContainerUtil.getFirstItem(args.getCMakeArgumentList()) : null;
        return projectNameArg != null ? projectNameArg.getText() : "Project";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

