/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugConstants;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakePackets {
    @NotNull
    static CMakePacket readGenericPacket(int type, @NotNull Payload payload) {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(0);
        }
        return new CMakePacketGeneric(type, payload.getData());
    }

    @NotNull
    static CMakePacketScHandshake readHandshake(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(1);
        }
        int version = payload.readInt();
        String delimiter = payload.readString();
        return new CMakePacketScHandshake(version, delimiter);
    }

    @NotNull
    static CMakePacketScTargetStopped readTargetStopped(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(2);
        }
        int stopReason = payload.readInt();
        int intArg = payload.readInt();
        String stringArg = payload.readString();
        int backtraceEntryCount = payload.readInt();
        ArrayList<CMakeBacktraceEntry> backtrace = new ArrayList<CMakeBacktraceEntry>();
        for (int i = 0; i < backtraceEntryCount; ++i) {
            int frameId = payload.readInt();
            String func = payload.readString();
            String argsStr = payload.readString();
            String file = payload.readString();
            int line = payload.readInt();
            if (line == 0) {
                line = 1;
            }
            int argCount = payload.readInt();
            ArrayList<String> argList = new ArrayList<String>();
            for (int j = 0; j < argCount; ++j) {
                String arg = payload.readString();
                argList.add(arg);
            }
            backtrace.add(new CMakeBacktraceEntry(frameId, func, argsStr, file, line, argList));
        }
        return new CMakePacketScTargetStopped(stopReason, stringArg, intArg, backtrace);
    }

    @NotNull
    static CMakePacketScError readScError(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(3);
        }
        String details = payload.readString();
        return new CMakePacketScError(details);
    }

    @NotNull
    static CMakePacketDebugMessage readDebugMessage(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(4);
        }
        int stream = payload.readInt();
        String text = payload.readString();
        return new CMakePacketDebugMessage(stream, text);
    }

    @NotNull
    static CMakePacketScBreakpointCreated readBreakpointCreated(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(5);
        }
        int breakpointId = payload.readInt();
        return new CMakePacketScBreakpointCreated(breakpointId);
    }

    @NotNull
    static CMakePacketScBreakpointUpdated readBreakpointUpdated() {
        return new CMakePacketScBreakpointUpdated();
    }

    @NotNull
    static CMakePacketScTargetRunning readTargetRunning() {
        return new CMakePacketScTargetRunning();
    }

    @NotNull
    static CMakePacketScTargetExited readTargetExited(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(6);
        }
        int exitCode = payload.readInt();
        return new CMakePacketScTargetExited(exitCode);
    }

    @NotNull
    static CMakePacketScExpressionCreated readScExpressionCreated(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(7);
        }
        int exprId = payload.readInt();
        String name = payload.readString();
        String type = payload.readString();
        String value = payload.readString();
        int flags = payload.readInt();
        int count = payload.readInt();
        int exprType = payload.readInt();
        int exprSubType = payload.readInt();
        return new CMakePacketScExpressionCreated(exprId, name, type, value, flags, count, exprType, exprSubType);
    }

    @NotNull
    static CMakePacketScVarsOut readVarsOut(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(8);
        }
        int count = payload.readInt();
        ArrayList<CMakeVarValue> varWrites = new ArrayList<CMakeVarValue>();
        for (int i = 0; i < count; ++i) {
            String varName = payload.readString();
            String varValue = payload.readString();
            int line = payload.readInt();
            varWrites.add(new CMakeVarValue(varName, varValue, line));
        }
        return new CMakePacketScVarsOut(varWrites);
    }

    @NotNull
    static CMakePacketScExpressionChildrenQueried readScExpressionChildrenQueried(@NotNull Payload payload) throws CMakeParsePacketException {
        if (payload == null) {
            CMakePackets.$$$reportNull$$$0(9);
        }
        int childCount = payload.readInt();
        ArrayList<CMakePacketScExpressionCreated> children = new ArrayList<CMakePacketScExpressionCreated>();
        for (int i = 0; i < childCount; ++i) {
            children.add(CMakePackets.readScExpressionCreated(payload));
        }
        return new CMakePacketScExpressionChildrenQueried(children);
    }

    static void writeInt(@NotNull OutputStream out, int x) throws IOException {
        if (out == null) {
            CMakePackets.$$$reportNull$$$0(10);
        }
        out.write((byte)(x & 0xFF));
        out.write((byte)(x >> 8 & 0xFF));
        out.write((byte)(x >> 16 & 0xFF));
        out.write((byte)(x >> 24 & 0xFF));
    }

    static void writeInt(@NotNull ByteArrayList buf, int x) {
        if (buf == null) {
            CMakePackets.$$$reportNull$$$0(11);
        }
        buf.add((byte)(x & 0xFF));
        buf.add((byte)(x >> 8 & 0xFF));
        buf.add((byte)(x >> 16 & 0xFF));
        buf.add((byte)(x >> 24 & 0xFF));
    }

    static void writeString(@NotNull OutputStream out, @NotNull String s) throws IOException {
        if (out == null) {
            CMakePackets.$$$reportNull$$$0(12);
        }
        if (s == null) {
            CMakePackets.$$$reportNull$$$0(13);
        }
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        CMakePackets.writeInt(out, bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    static void writeString(@NotNull ByteArrayList buf, @NotNull String s) {
        if (buf == null) {
            CMakePackets.$$$reportNull$$$0(14);
        }
        if (s == null) {
            CMakePackets.$$$reportNull$$$0(15);
        }
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        CMakePackets.writeInt(buf, bytes.length);
        for (byte aByte : bytes) {
            buf.add(aByte);
        }
    }

    static void writeBytes(@NotNull OutputStream out, byte[] bytes) throws IOException {
        if (out == null) {
            CMakePackets.$$$reportNull$$$0(16);
        }
        out.write(bytes, 0, bytes.length);
    }

    static byte[] readFully(@NotNull InputStream in, int nbytes) throws IOException {
        int count;
        if (in == null) {
            CMakePackets.$$$reportNull$$$0(17);
        }
        byte[] result = new byte[nbytes];
        for (int nread = 0; nread < nbytes; nread += count) {
            count = in.read(result, nread, nbytes - nread);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readGenericPacket";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readHandshake";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readTargetStopped";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readScError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readDebugMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readBreakpointCreated";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readTargetExited";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readScExpressionCreated";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readVarsOut";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "readScExpressionChildrenQueried";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "writeInt";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "writeString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "readFully";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CMakePacketGeneric
    extends CMakePacket {
        private final int typeId;
        private final byte[] payload;

        CMakePacketGeneric(int type, byte[] payload) {
            super(type < CMakeDebugConstants.CMakePacketType.values().length ? CMakeDebugConstants.CMakePacketType.values()[type] : CMakeDebugConstants.CMakePacketType.Invalid);
            this.typeId = type;
            this.payload = payload;
        }

        @Override
        public String toString() {
            return "CMakePacketGeneric{type=" + this.type + "(" + this.typeId + "), payload=" + Arrays.toString(this.payload) + "}";
        }
    }

    static class Payload {
        @Nullable
        private final Integer myPacketType;
        private final byte[] myData;
        private int myIdx;

        Payload(byte[] data) {
            this(null, data);
        }

        Payload(@Nullable Integer packetType, byte[] data) {
            this.myData = data;
            this.myPacketType = packetType;
        }

        byte[] getData() {
            return this.myData;
        }

        int readInt() throws CMakeParsePacketException {
            if (this.myIdx + 4 > this.myData.length) {
                throw new CMakeParsePacketException("Unexpected end of packet", this.formatPayload());
            }
            int result = this.myData[this.myIdx] & 0xFF | (this.myData[this.myIdx + 1] & 0xFF) << 8 | (this.myData[this.myIdx + 2] & 0xFF) << 16 | (this.myData[this.myIdx + 3] & 0xFF) << 24;
            this.myIdx += 4;
            return result;
        }

        String readString() throws CMakeParsePacketException {
            int len = this.readInt();
            if (len < 0) {
                throw new CMakeParsePacketException("Negative string length " + len, this.formatPayload());
            }
            if (this.myIdx > this.myData.length) {
                throw new CMakeParsePacketException("Unexpected end of packet", this.formatPayload());
            }
            if (this.myIdx + len > this.myData.length) {
                throw new CMakeParsePacketException("Wrong string length " + len, this.formatPayload());
            }
            String result = new String(this.myData, this.myIdx, len, StandardCharsets.UTF_8);
            this.myIdx += len;
            return result;
        }

        @NotNull
        String formatPayload() {
            StringBuilder result = new StringBuilder();
            if (this.myPacketType != null) {
                result.append("packetType=").append(this.myPacketType).append(", ");
            }
            result.append("idx=").append(this.myIdx).append(", ");
            result.append("data=[");
            for (int i = 0; i < this.myData.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(String.format("0x%x", this.myData[i]));
            }
            result.append("]");
            String string = result.toString();
            if (string == null) {
                Payload.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$Payload", "formatPayload"));
        }
    }

    static class CMakePacketScHandshake
    extends CMakePacket {
        private final int version;
        private final String delim;

        CMakePacketScHandshake(int version, @NotNull String delim) {
            if (delim == null) {
                CMakePacketScHandshake.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.scHandshake);
            this.version = version;
            this.delim = delim;
        }

        @Override
        public String toString() {
            return "CmakePacketScHandshake{version=" + this.version + ", delim='" + this.delim + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delim", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketScHandshake", "<init>"));
        }
    }

    static class CMakeBacktraceEntry {
        final int frameId;
        @NlsSafe
        final String function;
        private final String argsStr;
        final String file;
        final int line1;
        final List<String> args;

        CMakeBacktraceEntry(int frameId, String function2, String argsStr, String file, int line1, List<String> args) {
            if (line1 < 1) {
                throw new IllegalArgumentException("Unexpected line " + line1);
            }
            this.frameId = frameId;
            this.function = function2;
            this.argsStr = argsStr;
            this.file = file;
            this.line1 = line1;
            this.args = args;
        }

        public String toString() {
            return "CMakeBacktraceEntry{frameId=" + this.frameId + ", function='" + this.function + "', argsStr='" + this.argsStr + "', file='" + this.file + "', line='" + this.line1 + "', args='" + this.args + "'}";
        }
    }

    static class CMakePacketScTargetStopped
    extends CMakePacket {
        final CMakeDebugConstants.CMakeTargetStopReason stopReason;
        private final int stopReasonInt;
        final String strArg;
        final int intArg;
        final List<CMakeBacktraceEntry> backtrace;

        CMakePacketScTargetStopped(int stopReason, String strArg, int intArg, @NotNull List<CMakeBacktraceEntry> backtrace) {
            if (backtrace == null) {
                CMakePacketScTargetStopped.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.scTargetStopped);
            this.stopReason = 0 <= stopReason && stopReason < CMakeDebugConstants.CMakeTargetStopReason.Invalid.ordinal() ? CMakeDebugConstants.CMakeTargetStopReason.values()[stopReason] : CMakeDebugConstants.CMakeTargetStopReason.Invalid;
            this.stopReasonInt = stopReason;
            this.strArg = strArg;
            this.intArg = intArg;
            this.backtrace = backtrace;
        }

        @Override
        public String toString() {
            return "CMakePacketScTargetStopped{stopReason=" + this.stopReason + (String)(this.stopReason == CMakeDebugConstants.CMakeTargetStopReason.Invalid ? "(" + this.stopReasonInt + ")" : "") + ", strArg='" + this.strArg + "', intArg=" + this.intArg + ", backtrace=[" + this.backtrace.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + "]}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backtrace", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketScTargetStopped", "<init>"));
        }
    }

    static class CMakePacketScError
    extends CMakePacket {
        final String details;

        CMakePacketScError(String details) {
            super(CMakeDebugConstants.CMakePacketType.scError);
            this.details = details;
        }

        @Override
        public String toString() {
            return "CMakePacketScError{details='" + this.details + "'}";
        }
    }

    static class CMakePacketDebugMessage
    extends CMakePacket {
        private final int stream;
        private final String text;

        CMakePacketDebugMessage(int stream, String text) {
            super(CMakeDebugConstants.CMakePacketType.scDebugMessage);
            this.stream = stream;
            this.text = text;
        }

        @Override
        public String toString() {
            return "CMakeDebugMessage{stream=" + this.stream + ", text='" + this.text + "'}";
        }
    }

    static class CMakePacketScBreakpointCreated
    extends CMakePacket {
        final int breakpointId;

        CMakePacketScBreakpointCreated(int breakpointId) {
            super(CMakeDebugConstants.CMakePacketType.scBreakpointCreated);
            this.breakpointId = breakpointId;
        }

        @Override
        public String toString() {
            return "CMakePacketScBreakpointCreated{breakpointId=" + this.breakpointId + "}";
        }
    }

    static class CMakePacketScBreakpointUpdated
    extends CMakePacket {
        CMakePacketScBreakpointUpdated() {
            super(CMakeDebugConstants.CMakePacketType.scBreakpointUpdated);
        }

        @Override
        public String toString() {
            return "CMakePacketScBreakpointUpdated{}";
        }
    }

    static class CMakePacketScTargetRunning
    extends CMakePacket {
        CMakePacketScTargetRunning() {
            super(CMakeDebugConstants.CMakePacketType.scTargetRunning);
        }

        @Override
        public String toString() {
            return "CMakeScTargetRunning{}";
        }
    }

    static class CMakePacketScTargetExited
    extends CMakePacket {
        private final int exitCode;

        CMakePacketScTargetExited(int exitCode) {
            super(CMakeDebugConstants.CMakePacketType.scTargetExited);
            this.exitCode = exitCode;
        }

        @Override
        public String toString() {
            return "CMakeScTargetExited{exitCode=" + this.exitCode + "}";
        }
    }

    static class CMakePacketScExpressionCreated
    extends CMakePacket {
        final int exprId;
        final String name;
        private final String exprTypeStr;
        final String value;
        private final int flags;
        final int childCount;
        private final int exprTypeId;
        final CMakeDebugConstants.CMakeExpressionType exprType;
        final int exprSubType;

        CMakePacketScExpressionCreated(int exprId, String name, String typeStr, String value, int flags, int childCount, int exprTypeId, int exprSubType) {
            super(CMakeDebugConstants.CMakePacketType.scExpressionCreated);
            this.exprId = exprId;
            this.name = name;
            this.exprTypeStr = typeStr;
            this.value = value;
            this.flags = flags;
            this.childCount = childCount;
            this.exprTypeId = exprTypeId;
            this.exprType = 0 <= exprTypeId && exprTypeId < CMakeDebugConstants.CMakeExpressionType.values().length ? CMakeDebugConstants.CMakeExpressionType.values()[exprTypeId] : CMakeDebugConstants.CMakeExpressionType.Invalid;
            this.exprSubType = exprSubType;
        }

        @Override
        public String toString() {
            return "CMakePacketScExpressionCreated{exprId=" + this.exprId + ", name='" + this.name + "', value='" + this.value + "', exprType='" + this.exprTypeStr + "', flags=" + this.flags + ", childCount=" + this.childCount + ", exprTypeId='" + this.exprTypeId + "', exprType='" + this.exprType + "', exprSubType='" + this.exprSubType + "'}";
        }
    }

    static class CMakeVarValue {
        final String varName;
        final String varValue;
        final int line1;

        CMakeVarValue(@NotNull String varName, @Nullable String varValue, int line1) {
            if (varName == null) {
                CMakeVarValue.$$$reportNull$$$0(0);
            }
            if (line1 < 1) {
                throw new IllegalArgumentException("Unexpected line " + line1);
            }
            this.varName = varName;
            this.varValue = varValue;
            this.line1 = line1;
        }

        public String toString() {
            return "CMakeVarValue{varName='" + this.varName + "', varValue='" + this.varValue + "', line=" + this.line1 + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakeVarValue", "<init>"));
        }
    }

    static class CMakePacketScVarsOut
    extends CMakePacket {
        final List<CMakeVarValue> vars;

        CMakePacketScVarsOut(@NotNull List<CMakeVarValue> vars) {
            if (vars == null) {
                CMakePacketScVarsOut.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.scVarsOut);
            this.vars = vars;
        }

        @Override
        public String toString() {
            return "CMakePacketScVarsOut{vars=" + this.vars + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketScVarsOut", "<init>"));
        }
    }

    static class CMakePacketScExpressionChildrenQueried
    extends CMakePacket {
        private final List<CMakePacketScExpressionCreated> children;

        CMakePacketScExpressionChildrenQueried(@NotNull List<CMakePacketScExpressionCreated> children) {
            if (children == null) {
                CMakePacketScExpressionChildrenQueried.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.scExpressionChildrenQueried);
            this.children = children;
        }

        @NotNull
        List<CMakePacketScExpressionCreated> getChildren() {
            List<CMakePacketScExpressionCreated> list2 = this.children;
            if (list2 == null) {
                CMakePacketScExpressionChildrenQueried.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public String toString() {
            return "CMakePacketScExpressionChildrenQueried{myChildren=" + this.children + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketScExpressionChildrenQueried";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketScExpressionChildrenQueried";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class CMakeParsePacketException
    extends Exception {
        final String payload;

        CMakeParsePacketException(String message, String payload) {
            super(message);
            this.payload = payload;
        }

        CMakeParsePacketException(String message, String payload, Throwable cause) {
            super(message, cause);
            this.payload = payload;
        }

        CMakeParsePacketException(String message, Throwable cause) {
            super(message, cause);
            this.payload = null;
        }

        String getPayload() {
            return this.payload;
        }
    }

    static class CMakePacketCsVarsIn
    extends CMakePacket {
        private final int frameId;
        private final int fromLine1;
        private final int toLine1;

        CMakePacketCsVarsIn(int frameId, int fromLine1, int toLine1) {
            super(CMakeDebugConstants.CMakePacketType.csVarsIn);
            if (fromLine1 < 1) {
                throw new IllegalArgumentException("Unexpected fromLine " + fromLine1);
            }
            if (toLine1 < 1) {
                throw new IllegalArgumentException("Unexpected toLine " + fromLine1);
            }
            this.frameId = frameId;
            this.fromLine1 = fromLine1;
            this.toLine1 = toLine1;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsVarsIn.$$$reportNull$$$0(0);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            CMakePackets.writeInt(out, 12);
            CMakePackets.writeInt(out, this.frameId);
            CMakePackets.writeInt(out, this.fromLine1);
            CMakePackets.writeInt(out, this.toLine1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsVarsIn", "writeToStream"));
        }
    }

    static class CMakePacketCsStepOver
    extends CMakePacket {
        CMakePacketCsStepOver() {
            super(CMakeDebugConstants.CMakePacketType.csStepOver);
        }

        @Override
        public String toString() {
            return "CMakePacketCsStepOver{}";
        }
    }

    static class CMakePacketCsStepOut
    extends CMakePacket {
        CMakePacketCsStepOut() {
            super(CMakeDebugConstants.CMakePacketType.csStepOut);
        }

        @Override
        public String toString() {
            return "CMakePacketCsStepOut{}";
        }
    }

    static class CMakePacketCsStepIn
    extends CMakePacket {
        CMakePacketCsStepIn() {
            super(CMakeDebugConstants.CMakePacketType.csStepIn);
        }

        @Override
        public String toString() {
            return "CMakePacketCsStepIn{}";
        }
    }

    static class CMakePacketCsTerminate
    extends CMakePacket {
        CMakePacketCsTerminate() {
            super(CMakeDebugConstants.CMakePacketType.csTerminate);
        }

        @Override
        public String toString() {
            return "CMakeCsTerminate{}";
        }
    }

    static class CMakePacketCsBreakIn
    extends CMakePacket {
        CMakePacketCsBreakIn() {
            super(CMakeDebugConstants.CMakePacketType.csBreakIn);
        }

        @Override
        public String toString() {
            return "CMakePacketCsBreakIn{}";
        }
    }

    static class CMakePacketCsQueryExpressionChildren
    extends CMakePacket {
        private final int exprId;

        CMakePacketCsQueryExpressionChildren(int exprId) {
            super(CMakeDebugConstants.CMakePacketType.csQueryExpressionChildren);
            this.exprId = exprId;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsQueryExpressionChildren.$$$reportNull$$$0(0);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            CMakePackets.writeInt(out, 4);
            CMakePackets.writeInt(out, this.exprId);
        }

        @Override
        public String toString() {
            return "CMakePacketCsQueryExpressionChildren{myExprId=" + this.exprId + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsQueryExpressionChildren", "writeToStream"));
        }
    }

    static class CMakePacketCsCreateExpression
    extends CMakePacket {
        private final int frameId;
        private final String varName;

        CMakePacketCsCreateExpression(int frameId, String varName) {
            super(CMakeDebugConstants.CMakePacketType.csCreateExpression);
            this.frameId = frameId;
            this.varName = varName;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsCreateExpression.$$$reportNull$$$0(0);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            CMakePackets.writeInt(out, 8 + this.varName.getBytes(StandardCharsets.UTF_8).length);
            CMakePackets.writeInt(out, this.frameId);
            CMakePackets.writeString(out, this.varName);
        }

        @Override
        public String toString() {
            return "CMakePacketCsCreateExpression{frameId=" + this.frameId + ", varName='" + this.varName + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsCreateExpression", "writeToStream"));
        }
    }

    static class CMakePacketCsDeleteBreakpoint
    extends CMakePacket {
        private final int breakpointId;

        CMakePacketCsDeleteBreakpoint(int breakpointId) {
            super(CMakeDebugConstants.CMakePacketType.csDeleteBreakpoint);
            this.breakpointId = breakpointId;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsDeleteBreakpoint.$$$reportNull$$$0(0);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            CMakePackets.writeInt(out, 4);
            CMakePackets.writeInt(out, this.breakpointId);
        }

        @Override
        public String toString() {
            return "CMakePacketCsDeleteBreakpoint{breakpointId=" + this.breakpointId + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsDeleteBreakpoint", "writeToStream"));
        }
    }

    static class CMakePacketCsCreateBreakpoint
    extends CMakePacket {
        private final String file;
        private final int line1;

        CMakePacketCsCreateBreakpoint(@NotNull String file, int line1) {
            if (file == null) {
                CMakePacketCsCreateBreakpoint.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.csCreateBreakpoint);
            if (line1 < 1) {
                throw new IllegalArgumentException("Unexpected line " + line1);
            }
            this.file = file;
            this.line1 = line1;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsCreateBreakpoint.$$$reportNull$$$0(1);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            ByteArrayList buf = new ByteArrayList();
            CMakePackets.writeString(buf, this.file);
            CMakePackets.writeInt(buf, this.line1);
            CMakePackets.writeInt(out, buf.size());
            CMakePackets.writeBytes(out, buf.toByteArray());
        }

        @Override
        public String toString() {
            return "CMakePacketCsCreateBreakpoint{file='" + this.file + "', line=" + this.line1 + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsCreateBreakpoint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToStream";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CMakePacketCsContinue
    extends CMakePacket {
        CMakePacketCsContinue() {
            super(CMakeDebugConstants.CMakePacketType.csContinue);
        }

        @Override
        public String toString() {
            return "CMakePacketCsContinue{}";
        }
    }

    static class CMakePacketCsHandshake
    extends CMakePacket {
        private final String debugToken;

        CMakePacketCsHandshake(@NotNull String debugToken) {
            if (debugToken == null) {
                CMakePacketCsHandshake.$$$reportNull$$$0(0);
            }
            super(CMakeDebugConstants.CMakePacketType.csHandshake);
            this.debugToken = debugToken;
        }

        @Override
        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacketCsHandshake.$$$reportNull$$$0(1);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            ByteArrayList buf = new ByteArrayList();
            CMakePackets.writeString(buf, this.debugToken);
            CMakePackets.writeInt(out, buf.size());
            CMakePackets.writeBytes(out, buf.toByteArray());
        }

        @Override
        public String toString() {
            return "CmakePacketCsHandshake{debugToken='" + this.debugToken + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugToken";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacketCsHandshake";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToStream";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CMakePacket {
        protected final CMakeDebugConstants.CMakePacketType type;

        CMakePacket(@NotNull CMakeDebugConstants.CMakePacketType type) {
            if (type == null) {
                CMakePacket.$$$reportNull$$$0(0);
            }
            this.type = type;
        }

        void writeToStream(@NotNull OutputStream out) throws IOException {
            if (out == null) {
                CMakePacket.$$$reportNull$$$0(1);
            }
            CMakePackets.writeInt(out, this.type.ordinal());
            CMakePackets.writeInt(out, 0);
        }

        public String toString() {
            return "CmakePacket{type=" + this.type + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakePackets$CMakePacket";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToStream";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

