/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.ui.MessageType;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuild;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTaskImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u000eH\u0016J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeBuildTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "<init>", "()V", "getConfiguration", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration;", "task", "Lcom/intellij/task/ProjectModelBuildTask;", "Lcom/intellij/openapi/roots/ProjectModelBuildableElement;", "getExplicitTargetName", "", "buildableElement", "expandTask", "", "Lcom/intellij/task/ProjectTask;", "executeTask", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/task/ProjectTask;Ljava/lang/Object;Lcom/intellij/task/ProjectTaskContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "build", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "expandBuildTask", "expandModule", "Lcom/intellij/task/ModuleBuildTask;", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeBuildTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeBuildTaskRunner.kt\ncom/jetbrains/cidr/cpp/execution/build/runners/CMakeBuildTaskRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1557#2:119\n1628#2,3:120\n1557#2:123\n1628#2,3:124\n*S KotlinDebug\n*F\n+ 1 CMakeBuildTaskRunner.kt\ncom/jetbrains/cidr/cpp/execution/build/runners/CMakeBuildTaskRunner\n*L\n108#1:119\n108#1:120,3\n111#1:123\n111#1:124,3\n*E\n"})
public final class CMakeBuildTaskRunner
implements CidrTaskRunner {
    @NotNull
    public static final CMakeBuildTaskRunner INSTANCE = new CMakeBuildTaskRunner();

    private CMakeBuildTaskRunner() {
    }

    private final CMakeConfiguration getConfiguration(ProjectModelBuildTask<? extends ProjectModelBuildableElement> task2) {
        CMakeConfiguration cMakeConfiguration;
        if (task2.getBuildableElement() instanceof CMakeConfiguration) {
            ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
            Intrinsics.checkNotNull((Object)projectModelBuildableElement, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration");
            cMakeConfiguration = (CMakeConfiguration)projectModelBuildableElement;
        } else {
            CPPLog.LOG.assertTrue(task2.getBuildableElement() instanceof CMakeExplicitTargetConfiguration);
            ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
            Intrinsics.checkNotNull((Object)projectModelBuildableElement, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration");
            cMakeConfiguration = ((CMakeExplicitTargetConfiguration)projectModelBuildableElement).getCmakeConfiguration();
        }
        return cMakeConfiguration;
    }

    private final String getExplicitTargetName(ProjectModelBuildableElement buildableElement) {
        return buildableElement instanceof CMakeExplicitTargetConfiguration ? ((CMakeExplicitTargetConfiguration)buildableElement).getExplicitBuildTargetName() : null;
    }

    @NotNull
    public List<ProjectTask> expandTask(@NotNull ProjectTask task2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        ProjectTask projectTask = task2;
        if (projectTask instanceof ProjectModelBuildTask) {
            list2 = this.expandBuildTask((ProjectModelBuildTask)task2);
        } else if (projectTask instanceof ModuleBuildTask) {
            list2 = this.expandModule((ModuleBuildTask)task2);
        } else {
            CPPLog.LOG.error("Invalid project task: " + task2.getPresentableName());
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public Object executeTask(@NotNull Project project, @NotNull ProjectTask task2, @NotNull Object sessionId, @NotNull ProjectTaskContext context, @NotNull Continuation<? super Promise<ProjectTaskRunner.Result>> $completion) {
        CPPLog.LOG.assertTrue(task2 instanceof ProjectModelBuildTask);
        AsyncPromise promise = new AsyncPromise();
        Intrinsics.checkNotNull((Object)task2, (String)"null cannot be cast to non-null type com.intellij.task.ProjectModelBuildTask<*>");
        this.build(project, (ProjectModelBuildTask)task2, (AsyncPromise<ProjectTaskRunner.Result>)promise, sessionId);
        return promise;
    }

    public final void build(@NotNull Project project, @NotNull ProjectModelBuildTask<?> task2, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise, @NotNull Object sessionId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        CMakeConfiguration cMakeConfiguration = this.getConfiguration(task2);
        ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
        Intrinsics.checkNotNullExpressionValue((Object)projectModelBuildableElement, (String)"getBuildableElement(...)");
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = new CMakeAppRunConfiguration.BuildAndRunConfigurations(cMakeConfiguration, null, null, this.getExplicitTargetName(projectModelBuildableElement));
        configurations.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, sessionId);
        ExecutionResult<CidrBuildResult> result = CMakeBuild.build(project, configurations);
        CLionBuildUtil.handleProjectTaskResults(result, promise);
    }

    private final List<ProjectTask> expandBuildTask(ProjectModelBuildTask<?> task2) {
        List list2;
        if (task2.isIncrementalBuild()) {
            list2 = CollectionsKt.listOf(task2);
        } else {
            Object[] objectArray = new ProjectTask[]{new CidrCleanTaskImpl((CidrBuildConfiguration)this.getConfiguration(task2)), task2};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectTask> expandModule(ModuleBuildTask task2) {
        List list2;
        Project project = task2.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Object object = ActionsKt.runReadAction(() -> CMakeBuildTaskRunner.expandModule$lambda$0(project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        List configurations = (List)object;
        if (configurations.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> CMakeBuildTaskRunner.expandModule$lambda$1(project2));
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable iterable;
            Iterable destination$iv$iv;
            List list3;
            if (task2.isIncrementalBuild()) {
                list3 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = configurations;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    CMakeConfiguration cMakeConfiguration = (CMakeConfiguration)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    iterable.add(new CidrCleanTaskImpl((CidrBuildConfiguration)it));
                }
                list3 = (List)destination$iv$iv;
            }
            List cleanTasks = list3;
            Iterable $this$map$iv = configurations;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void configuration;
                CMakeConfiguration bl = (CMakeConfiguration)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)configuration);
                iterable.add(new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)new CMakeExplicitTargetConfiguration((CMakeConfiguration)configuration, "all"), true));
            }
            List buildTasks = (List)destination$iv$iv2;
            list2 = CollectionsKt.plus((Collection)cleanTasks, (Iterable)buildTasks);
        }
        return list2;
    }

    private static final List expandModule$lambda$0(Project $project) {
        return CMakeRunConfigurationType.getHelper($project).findAllProfileConfigurations();
    }

    private static final void expandModule$lambda$1(Project $project) {
        CMakeBuild.showBuildNotification($project, MessageType.ERROR, CLionCMakeBundle.message("cmake.build.project.noProfileError.message", new Object[0]));
    }
}

