/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CLionLauncher;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.ExplicitBuildTargetHolder;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.io.File;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeRunConfigurationUtil {
    private CMakeRunConfigurationUtil() {
    }

    @Nullable
    public static CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull CLionRunConfiguration<?, ?> configuration, @NotNull ExecutionTarget target) {
        if (configuration == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (target == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        return CMakeRunConfigurationUtil.getBuildAndRunConfigurations(configuration, target, null, false);
    }

    @Nullable
    public static <CONFIGURATION extends CidrRunConfiguration<?, ?> & ExplicitBuildTargetHolder> CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull CONFIGURATION configuration, @NotNull ExecutionTarget target, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        if (configuration == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        if (target == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        return CMakeRunConfigurationUtil.getBuildAndRunConfigurations(configuration, CMakeBuildProfileExecutionTarget.getProfileName(target), problems, checkExecutableSpecified);
    }

    @Nullable
    public static <CONFIGURATION extends CidrRunConfiguration<?, ?> & ExplicitBuildTargetHolder> CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull CONFIGURATION configuration, @Nullable String buildProfileName, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        if (configuration == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        return (CMakeAppRunConfiguration.BuildAndRunConfigurations)((Object)ReadAction.compute(() -> {
            BuildTargetAndConfigurationData buildData;
            if (configuration.getProject().isDisposed()) {
                return null;
            }
            String explicitBuildTargetName = ((ExplicitBuildTargetHolder)configuration).getExplicitBuildTargetName();
            CMakeBuildConfigurationHelper helper = CMakeRunConfigurationType.getHelper(configuration.getProject());
            if (!BuildTargetAndConfigurationData.checkData((CidrBuildConfigurationHelper)helper, (BuildTargetAndConfigurationData)(buildData = CMakeRunConfigurationUtil.constructBuildData(buildProfileName, explicitBuildTargetName, configuration.getTargetAndConfigurationData())), (BuildConfigurationProblems)problems, (explicitBuildTargetName != null ? 1 : 0) != 0, (boolean)true)) {
                return null;
            }
            CPPLog.LOG.assertTrue(buildData != null);
            ExecutableData runData = ((CidrExecutableDataHolder)configuration).getExecutableData();
            if (runData == null && checkExecutableSpecified) {
                if (problems != null) {
                    problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])new Object[]{CidrRunnerBundle.message((String)"build.configuration.executable", (Object[])new Object[0])}));
                }
                return null;
            }
            boolean needSetupRunExecutable = runData != null && runData.path != null;
            CMakeConfiguration runConfig = null;
            boolean invalidRunTarget = false;
            if (runData != null) {
                if (runData.target == null) {
                    CPPLog.LOG.assertTrue(needSetupRunExecutable);
                } else {
                    needSetupRunExecutable = false;
                    if (!runData.target.equals((Object)buildData.target) && (runConfig = CMakeRunConfigurationUtil.checkAndGetConfiguration(helper, problems, runData.target, buildData.configurationName, true, true)) == null) {
                        invalidRunTarget = true;
                    }
                }
            }
            CMakeConfiguration buildConfig = CMakeRunConfigurationUtil.getBuildConfiguration(helper, problems, buildData, explicitBuildTargetName, !needSetupRunExecutable);
            if (invalidRunTarget || buildConfig == null) {
                return null;
            }
            String runExecutable = null;
            if (needSetupRunExecutable) {
                runExecutable = runData.path;
            }
            return new CMakeAppRunConfiguration.BuildAndRunConfigurations(buildConfig, runConfig, runExecutable, explicitBuildTargetName);
        }));
    }

    private static BuildTargetAndConfigurationData constructBuildData(@Nullable String buildProfileName, @Nullable String explicitBuildTargetName, @Nullable BuildTargetAndConfigurationData configBuildData) {
        BuildTargetAndConfigurationData buildData = configBuildData;
        if (buildData == null) {
            if (explicitBuildTargetName != null) {
                buildData = new BuildTargetAndConfigurationData((BuildTargetData)null, buildProfileName);
            }
        } else {
            buildData = new BuildTargetAndConfigurationData(buildData.target, buildProfileName);
        }
        return buildData;
    }

    @Nullable
    private static CMakeConfiguration getBuildConfiguration(@NotNull CMakeBuildConfigurationHelper helper, @Nullable BuildConfigurationProblems problems, @NotNull BuildTargetAndConfigurationData buildData, @Nullable String explicitBuildTargetName, boolean checkProduct) {
        CMakeConfiguration buildConfig;
        if (helper == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        if (buildData == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (explicitBuildTargetName == null) {
            CPPLog.LOG.assertTrue(buildData.target != null);
            buildConfig = CMakeRunConfigurationUtil.checkAndGetConfiguration(helper, problems, buildData.target, buildData.configurationName, false, checkProduct);
        } else {
            buildConfig = CMakeRunConfigurationUtil.getBuildConfiguration(buildData, helper);
            if (buildConfig == null && buildData.configurationName != null && problems != null) {
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotFound", (Object[])new Object[]{helper.getConfigurationTitle(), buildData.configurationName}));
            }
        }
        return buildConfig;
    }

    @Nullable
    private static CMakeConfiguration getBuildConfiguration(@NotNull BuildTargetAndConfigurationData buildData, @NotNull CMakeBuildConfigurationHelper helper) {
        if (buildData == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(7);
        }
        if (helper == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(8);
        }
        for (CMakeTarget each : helper.getTargets()) {
            CMakeConfiguration buildConfig = (CMakeConfiguration)helper.findConfiguration(each, buildData.configurationName);
            if (buildConfig == null) continue;
            return buildConfig;
        }
        return null;
    }

    @Nullable
    private static CMakeConfiguration checkAndGetConfiguration(@NotNull CMakeBuildConfigurationHelper helper, @Nullable BuildConfigurationProblems problems, @NotNull BuildTargetData dataTarget, @Nullable String configurationName, boolean checkTargetType, boolean checkProduct) {
        CMakeTarget target;
        if (helper == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(9);
        }
        if (dataTarget == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(10);
        }
        if ((target = (CMakeTarget)helper.findTarget(dataTarget)) == null || checkTargetType && !target.isExecutable()) {
            if (problems != null) {
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotFound", (Object[])new Object[]{helper.getTargetTitle(), dataTarget.getDisplayString()}));
            }
            return null;
        }
        if (configurationName == null) {
            return null;
        }
        CMakeConfiguration config = (CMakeConfiguration)helper.findConfiguration(target, configurationName);
        if (config == null) {
            if (problems != null) {
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotFoundForTarget", (Object[])new Object[]{helper.getConfigurationTitle(), configurationName, StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString()}));
            }
            return null;
        }
        if (checkProduct && config.getProductFile() == null) {
            if (problems != null) {
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.productNotFound", (Object[])new Object[]{StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString(), configurationName}));
            }
            return null;
        }
        return config;
    }

    @NotNull
    public static Pair<File, CPPEnvironment> getRunFileAndEnvironment(@NotNull CLionLauncher launcher) throws ExecutionException {
        if (launcher == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(11);
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = CMakeRunConfigurationUtil.getBuildAndRunConfigurations(launcher);
        CPPEnvironment cppEnvironment = CMakeRunConfigurationUtil.getRunEnvironment(launcher.getProject(), buildAndRunConfigurations);
        File runFile = buildAndRunConfigurations.getRunFile(launcher.getProject());
        CPPLog.LOG.assertTrue(runFile != null);
        return new Pair((Object)runFile, (Object)cppEnvironment);
    }

    @NotNull
    public static CPPEnvironment getRunEnvironment(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations) throws ExecutionException {
        if (project == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(12);
        }
        if (buildAndRunConfigurations == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(13);
        }
        CMakeConfiguration runConfiguration = buildAndRunConfigurations.getRunConfiguration();
        CPPEnvironment cPPEnvironment = CMakeWorkspace.getInstance(project).getProfileInfoFor(runConfiguration).getEnvironmentSafe(false);
        if (cPPEnvironment == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(14);
        }
        return cPPEnvironment;
    }

    @NotNull
    private static CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull CLionLauncher launcher) throws ExecutionException {
        ExecutionTarget target;
        if (launcher == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(15);
        }
        if (!((target = launcher.getExecutionEnvironment().getExecutionTarget()) instanceof CMakeBuildProfileExecutionTarget)) {
            throw new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage(launcher.getConfiguration(), (ExecutionTarget)target));
        }
        OCRunConfiguration<?, ?> config = launcher.getConfiguration();
        CPPLog.LOG.assertTrue(config instanceof CLionRunConfiguration);
        CLionRunConfiguration configuration = (CLionRunConfiguration)config;
        BuildConfigurationProblems buildConfigurationProblems = new BuildConfigurationProblems();
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = CMakeRunConfigurationUtil.getBuildAndRunConfigurations(configuration, target, buildConfigurationProblems, true);
        if (buildAndRunConfigurations == null) {
            throw new ExecutionException(buildConfigurationProblems.getText());
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations2 = buildAndRunConfigurations;
        if (buildAndRunConfigurations2 == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(16);
        }
        return buildAndRunConfigurations2;
    }

    @Nullable
    public static OCResolveConfiguration getResolveConfiguration(@NotNull CLionRunConfiguration<?, ?> configuration, @NotNull ExecutionTarget target) {
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations;
        if (configuration == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(17);
        }
        if (target == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(18);
        }
        return (configurations = CMakeRunConfigurationUtil.getBuildAndRunConfigurations(configuration, target)) == null ? null : CMakeWorkspace.getInstance(configuration.getProject()).getResolveConfigurationFor(configurations.buildConfiguration);
    }

    @Nullable
    public static String getDefaultWorkingDir(@NotNull CLionLauncher launcher) throws ExecutionException {
        if (launcher == null) {
            CMakeRunConfigurationUtil.$$$reportNull$$$0(19);
        }
        CMakeConfiguration runConfiguration = CMakeRunConfigurationUtil.getBuildAndRunConfigurations(launcher).getRunConfiguration();
        CMakeProfileInfo profileInfo = CMakeWorkspace.getInstance(launcher.getProject()).getProfileInfoFor(runConfiguration);
        return profileInfo.getGenerationDir().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataTarget";
                break;
            }
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildAndRunConfigurations";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeRunConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeRunConfigurationUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunEnvironment";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildAndRunConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildAndRunConfigurations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuildConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRunFileAndEnvironment";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunEnvironment";
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultWorkingDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16 -> new IllegalStateException(string);
        };
    }
}

