/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentsUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.actions.EditCMakeCacheAction;
import com.jetbrains.cidr.cpp.cmake.actions.OpenCMakeSettingsAction;
import com.jetbrains.cidr.cpp.cmake.actions.ShowCMakeGeneratedDirAction;
import com.jetbrains.cidr.cpp.cmake.actions.ToggleCMakeProfileAction;
import com.jetbrains.cidr.cpp.cmake.actions.base.CMakeProjectActionsProvider;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleBuilder;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.flavor.CMakeProjectFlavorService;
import com.jetbrains.cidr.cpp.cmake.flavor.plain.CMakePlainProjectFlavorKt;
import com.jetbrains.cidr.cpp.cmake.model.CMakeData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeMessagesCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeMessagesContainer;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeToolWindowFactory;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CMakeOutputConsole {
    private static final Logger LOG = Logger.getInstance(CMakeOutputConsole.class);
    private static final Key<@NotNull CMakeConsoleViewImpl> CONSOLE_VIEW_KEY = Key.create((String)"CMAKE_CONSOLE_VIEW");
    public static final Key<@Nullable CMakeProfileInfo> PROFILE_INFO_KEY = Key.create((String)"CMAKE_PROFILE_INFO");
    private static final Key<String> CONSOLE_INDEX = Key.create((String)"CONSOLE_INDEX");
    private static final Key<String> CONSOLE_TITLE = Key.create((String)"CONSOLE_TITLE");
    private static final Key<File> CONSOLE_GENERATION_DIR = Key.create((String)"CONSOLE_GENERATION_DIR");
    private static final Key<ProcessHandler> CONSOLE_PROCESS_HANDLER = Key.create((String)"CONSOLE_PROCESS_HANDLER");
    private static final Key<List<CMakeMessage>> CONSOLE_MESSAGES = Key.create((String)"CONSOLE_MESSAGES");
    private static final Key<String> MESSAGES_COLLECTED = Key.create((String)"MESSAGES_COLLECTED");
    private static final Key<String> CURRENT_MESSAGE_TYPE = Key.create((String)"MESSAGE_TYPE");
    private static final Key<?> CONSOLE_HISTORY_KEY = Key.create((String)"CONSOLE_HISTORY_KEY");
    @NonNls
    public static final String HELP_ID = "Cmake_Output";
    public static final DataKey<CMakeProfileInfo> CURRENT_CONSOLE_PROFILE = DataKey.create((String)"CURRENT_CMAKE_CONSOLE_PROFILE");
    private final Project myProject;
    @NlsContexts.TabTitle
    private final String myToolWindowTitle;
    private MessageBusConnection myConnection;
    private boolean isOnceActivated;
    @Nullable
    private ProgressIndicator myCurrentReloadingIndicator;
    private final AtomicLong myUpdateSessionId;
    private final Map<Integer, CMakeMessagesCollector> myMessagesCollectors = new ConcurrentHashMap<Integer, CMakeMessagesCollector>();

    public CMakeOutputConsole(Project project, @NlsContexts.TabTitle String toolWindowTitle) {
        this.myProject = project;
        this.myToolWindowTitle = toolWindowTitle;
        this.myUpdateSessionId = new AtomicLong(0L);
        ToolWindow window = CMakeOutputConsole.getToolWindow(project);
        if (window != null) {
            window.remove();
        }
        if (CMakeOutputConsole.isMockExpected()) {
            this.getOrRegisterToolWindow();
        }
    }

    @NotNull
    private ContentManager getContentManager() {
        ThreadingAssertions.assertEventDispatchThread();
        ToolWindow toolWindow = this.getOrRegisterToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        if (contentManager == null) {
            CMakeOutputConsole.$$$reportNull$$$0(0);
        }
        return contentManager;
    }

    @NotNull
    private ToolWindow getOrRegisterToolWindow() {
        ThreadingAssertions.assertEventDispatchThread();
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = manager.getToolWindow("CMake");
        if (toolWindow != null) {
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2 == null) {
                CMakeOutputConsole.$$$reportNull$$$0(1);
            }
            return toolWindow2;
        }
        return this.registerToolWindow();
    }

    @NotNull
    private ToolWindow registerToolWindow() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.debug(new Throwable("Registering CMake tool window for project: " + this.myProject));
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        CMakeToolWindowFactory factory = new CMakeToolWindowFactory();
        RegisterToolWindowTask task2 = !CMakeOutputConsole.isMockExpected() ? new RegisterToolWindowTask("CMake", ToolWindowAnchor.BOTTOM, null, false, false, DumbService.isDumbAware((Object)factory), factory.shouldBeAvailable(this.myProject), (ToolWindowFactory)factory, CMakeProjectFlavorService.getInstance(this.myProject).getFlavor().getToolwindowIcon(), () -> this.myToolWindowTitle) : RegisterToolWindowTask.notClosable((String)"CMake");
        ToolWindow toolWindow = manager.registerToolWindow(task2);
        toolWindow.getContentManager();
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            CMakeOutputConsole.$$$reportNull$$$0(2);
        }
        return toolWindow2;
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            CMakeOutputConsole.$$$reportNull$$$0(3);
        }
        return ToolWindowManager.getInstance((Project)project).getToolWindow("CMake");
    }

    private static boolean isMockExpected() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isHeadlessEnvironment();
    }

    void listenForChanges() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void reloadingFinished(boolean canceled) {
                CMakeOutputConsole.this.reloadingFinished(canceled);
            }
        });
    }

    void shutdown() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
            LOG.debug("CMakeOutputConsole shutdown");
        }
    }

    public void updateTabs(@Nullable Path sourceDir, @NotNull List<CMakeProfileInfo> profileInfos) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(4);
        }
        this.updateTabs(sourceDir, profileInfos, null);
    }

    private void updateTabs(@Nullable Path sourceDir, @NotNull List<CMakeProfileInfo> profileInfos, @Nullable Runnable ifCreated) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(5);
        }
        this.myUpdateSessionId.incrementAndGet();
        LOG.debug("updateTabs(): current sessionId = " + this.myUpdateSessionId.get());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateMessagesCollectors(sourceDir, profileInfos);
        }
        this.invokeLater(() -> {
            Content[] contents;
            CMakeConsoleViewImpl consoleIfExists;
            ContentManager contentManager = this.getContentManager();
            Content selectedContent = contentManager.getSelectedContent();
            int selectedTabIndex = -1;
            if (selectedContent != null && (consoleIfExists = CMakeOutputConsole.getConsoleIfExists(selectedContent)) != null) {
                selectedTabIndex = consoleIfExists.getProfileId();
            }
            contentManager.removeAllContents(true);
            if (profileInfos.isEmpty()) {
                Content content = this.doCreateConsole(CLionCMakeBundle.message("output.display.title", new Object[0]), 0, null, null);
                ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (boolean)true);
                ConsoleView cmakeConsole = this.getConsole(0);
                cmakeConsole.print(CLionCMakeBundle.message("cmake.console.noProfiles", new Object[0]) + " ", ConsoleViewContentType.SYSTEM_OUTPUT);
                if (!CMakeWorkspace.getInstance(this.myProject).isInitialized() || CMakePlainProjectFlavorKt.isInitializedPlainCMakeProject(this.myProject)) {
                    cmakeConsole.printHyperlink(CLionCMakeBundle.message("cmake.toolchain.incompatible.fix", new Object[0]), new HyperlinkInfo(){

                        public void navigate(@NotNull Project project) {
                            if (project == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            OpenCMakeSettingsAction.openProfileSettings(project);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$2", "navigate"));
                        }
                    });
                }
            } else {
                for (int i = 0; i < profileInfos.size(); ++i) {
                    CMakeProfileInfo each = (CMakeProfileInfo)profileInfos.get(i);
                    @NlsSafe String title = each.getProfile().getName();
                    Content content = this.doCreateConsole(title, i, sourceDir, each);
                    ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (i == selectedTabIndex ? 1 : 0) != 0);
                }
            }
            for (Content each : contents = contentManager.getContents()) {
                each.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                each.setIcon(CMakeProjectFlavorService.getInstance(this.myProject).getFlavor().getContentToolwindowIcon());
            }
            if (ifCreated != null) {
                ifCreated.run();
            }
        });
    }

    public void restoreTabs(@Nullable Path sourceDir, @NotNull List<CMakeProfileInfo> profileInfos, boolean loadPreviousOutput) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(6);
        }
        this.updateTabs(sourceDir, profileInfos, () -> {
            if (loadPreviousOutput) {
                for (int i = 0; i < profileInfos.size(); ++i) {
                    CMakeOutputConsole.doLoadLogFile(this.getConsole(i), ((CMakeProfileInfo)profileInfos.get(i)).getGenerationDir());
                }
            }
        });
    }

    @NotNull
    private Content doCreateConsole(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, int profileIndex, @Nullable Path sourceDir, @Nullable CMakeProfileInfo profileInfo) {
        if (title == null) {
            CMakeOutputConsole.$$$reportNull$$$0(7);
        }
        File generationDir = null;
        CPPEnvironment environment = null;
        if (profileInfo != null) {
            generationDir = profileInfo.getGenerationDir();
            environment = profileInfo.getEnvironment();
        }
        DefaultActionGroup group = new DefaultActionGroup();
        CMakeProjectActionsProvider actionsProvider = CMakeProjectFlavorService.getInstance(this.myProject).getFlavor().getProjectActionsProvider();
        group.add(actionsProvider.getReloadAction());
        group.add(actionsProvider.getStopReloadAction());
        group.addSeparator();
        group.add((AnAction)new EditCMakeCacheAction(generationDir));
        group.add(ActionManager.getInstance().getAction("CMakeEventTracer.Extra"));
        group.add(ActionManager.getInstance().getAction("PackageManager.Extra"));
        DefaultActionGroup extra = new DefaultActionGroup();
        extra.setPopup(true);
        extra.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        extra.add(actionsProvider.getOpenSettingsAction(profileIndex));
        extra.add(ActionManager.getInstance().getAction("CMake.ChangeCMakeProjectContentRoot"));
        extra.add((AnAction)new ShowCMakeGeneratedDirAction(generationDir));
        extra.addSeparator();
        CMakeSettings settings = CMakeSettings.getInstance(this.myProject);
        if (CMakePlainProjectFlavorKt.isInitializedPlainCMakeProject(this.myProject)) {
            if (profileInfo != null) {
                extra.add((AnAction)new ToggleCMakeProfileAction(profileInfo.getProfile(), settings, CLionCMakeBundle.message("action.disable.this.profile.text", new Object[0])));
            }
            extra.add((AnAction)CMakeOutputConsole.createEnableProfileActionGroup(settings));
        }
        extra.addSeparator();
        extra.add(actionsProvider.getClearCacheAndReloadAction());
        group.add((AnAction)extra);
        String profileName = profileInfo != null ? profileInfo.getProfile().getName() : null;
        CMakeConsoleBuilder consoleBuilder = new CMakeConsoleBuilder(this.myProject, environment, sourceDir, profileIndex, profileName);
        final CMakeConsoleViewImpl console = (CMakeConsoleViewImpl)consoleBuilder.getConsole();
        console.addMessageListener(new CMakeConsoleViewImpl.MessageListener(){

            @Override
            public void messageReported(@NotNull CMakeConsoleMessageType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                CMakeOutputConsole.this.doUpdateTabIconAndActivate((ConsoleView)console, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$3", "messageReported"));
            }
        });
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(console.createConsoleActions());
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder(IdeBorderFactory.createBorder((int)4));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar leftToolbar = actionManager.createActionToolbar("CMakeOutputLeft", (ActionGroup)group, false);
        ActionToolbar centerToolbar = actionManager.createActionToolbar("CMakeOutputCenter", (ActionGroup)consoleActionGroup, false);
        toolbarPanel.add((Component)leftToolbar.getComponent(), "West");
        toolbarPanel.add((Component)centerToolbar.getComponent(), "Center");
        JComponent consoleComponent = console.getComponent();
        consoleComponent.add((Component)toolbarPanel, "West");
        leftToolbar.setTargetComponent(consoleComponent);
        centerToolbar.setTargetComponent(consoleComponent);
        consoleComponent.putClientProperty(CONSOLE_INDEX, profileIndex);
        consoleComponent.putClientProperty(CONSOLE_TITLE, title);
        consoleComponent.putClientProperty(CONSOLE_MESSAGES, new ArrayList());
        consoleComponent.putClientProperty(CONSOLE_GENERATION_DIR, generationDir);
        consoleComponent.putClientProperty(PROFILE_INFO_KEY, profileInfo);
        DataProviderPanel dataProviderPanel = new DataProviderPanel(console, profileInfo);
        ContentImpl content = new ContentImpl((JComponent)dataProviderPanel, title, false);
        content.setPreferredFocusableComponent((JComponent)dataProviderPanel);
        content.setCloseable(false);
        content.setHelpId(HELP_ID);
        content.putUserData(CONSOLE_VIEW_KEY, (Object)console);
        content.putUserData(PROFILE_INFO_KEY, (Object)profileInfo);
        ContentImpl contentImpl = content;
        if (contentImpl == null) {
            CMakeOutputConsole.$$$reportNull$$$0(8);
        }
        return contentImpl;
    }

    private static void doLoadLogFile(final ConsoleView console, @NotNull File logDir) {
        if (logDir == null) {
            CMakeOutputConsole.$$$reportNull$$$0(9);
        }
        ((CMakeConsoleViewImpl)console).dimHighlighting();
        ConsoleViewContentType outputType = ConsoleViewContentType.getConsoleViewType(CONSOLE_HISTORY_KEY);
        try {
            File logFile = CMakeOutputConsole.getOutputLogFile(logDir, CMakeOutputConsole.getConsoleTitle(console), true);
            String text = FileUtil.loadFile((File)logFile, (Charset)StandardCharsets.UTF_8);
            console.print(text, outputType);
            console.print("\n" + CLionCMakeBundle.message("cmake.console.outputRestored", DateFormatUtil.formatDateTime((long)logFile.lastModified())) + "\n", outputType);
        }
        catch (IOException ignore) {
            console.print(CLionCMakeBundle.message("cmake.console.noOutput", new Object[0]) + "\n", outputType);
        }
        console.requestScrollingToEnd();
        ((ConsoleViewImpl)console).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    ((ConsoleViewImpl)console).removeHierarchyListener((HierarchyListener)this);
                    console.requestScrollingToEnd();
                }
            }
        });
    }

    public void reportMessage(int profileId, @NotNull CMakeMessage message) {
        if (message == null) {
            CMakeOutputConsole.$$$reportNull$$$0(10);
        }
        this.reportMessage(profileId, message, (Fix)null);
    }

    public void reportMessage(int profileId, @NotNull CMakeMessage message, @Nullable Fix fix) {
        if (message == null) {
            CMakeOutputConsole.$$$reportNull$$$0(11);
        }
        this.doReportMessages(profileId, Collections.singletonList(Pair.create((Object)message, Collections.singletonList(fix))));
    }

    public void reportMessage(int profileId, @NotNull CMakeMessage message, @NotNull List<Fix> fixes) {
        if (message == null) {
            CMakeOutputConsole.$$$reportNull$$$0(12);
        }
        if (fixes == null) {
            CMakeOutputConsole.$$$reportNull$$$0(13);
        }
        this.doReportMessages(profileId, Collections.singletonList(Pair.create((Object)message, fixes)));
    }

    private void doReportMessages(int profileId, @NotNull List<Pair<CMakeMessage, List<Fix>>> messagesWithFixes) {
        if (messagesWithFixes == null) {
            CMakeOutputConsole.$$$reportNull$$$0(14);
        }
        Runnable runnable2 = () -> {
            for (ConsoleView consoleView : profileId == -1 ? this.getConsoles() : Collections.singletonList(this.getConsole(profileId))) {
                for (Pair eachMessageWithFix : messagesWithFixes) {
                    CMakeMessage eachMessage = (CMakeMessage)eachMessageWithFix.first;
                    CMakeMessage.MessageLevel level = eachMessage.getLevel();
                    boolean error = level.isError();
                    boolean normalText = level.compareTo(CMakeMessage.MessageLevel.WARNING) == 0;
                    consoleView.print(eachMessage.getText(), normalText ? ConsoleViewContentType.LOG_WARNING_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
                    ((List)eachMessageWithFix.second).forEach(fix -> {
                        if (fix != null) {
                            each.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                            each.printHyperlink(fix.text, new HyperlinkInfo(){
                                final /* synthetic */ Fix val$fix;
                                {
                                    this.val$fix = fix;
                                }

                                public void navigate(@NotNull Project project) {
                                    if (project == null) {
                                        5.$$$reportNull$$$0(0);
                                    }
                                    this.val$fix.action.run();
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$5", "navigate"));
                                }
                            });
                        }
                    });
                    consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.doUpdateTabIconAndActivate(consoleView, error ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                CMakeMessagesCollector messagesCollector = this.getMessagesCollector(consoleView);
                messagesCollector.addMessages(ContainerUtil.map((Collection)messagesWithFixes, it -> (CMakeMessage)it.first));
            }
        };
        if (profileId == -1) {
            this.invokeLaterOnAllTabs(runnable2);
        } else {
            this.invokeLaterOnTab(runnable2, profileId);
        }
    }

    public void attachConsoleToProcess(final int profileId, @NotNull CMakeProfileInfo profileInfo, @Nullable Path sourceDir, @NotNull ProcessHandler handler2) {
        if (profileInfo == null) {
            CMakeOutputConsole.$$$reportNull$$$0(15);
        }
        if (handler2 == null) {
            CMakeOutputConsole.$$$reportNull$$$0(16);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.invokeAndWait(() -> {
                ConsoleView console = this.getConsole(profileId);
                console.attachToProcess(handler2);
                CMakeOutputConsole.setConsoleProcessHandler(console, handler2);
            });
        } else {
            CMakeMessagesCollector messagesCollector = this.myMessagesCollectors.get(profileId);
            if (messagesCollector == null) {
                throw new IllegalStateException("Messages collector for profile " + profileId + " doesn't exist");
            }
            messagesCollector.attachToProcess(handler2);
            this.invokeLaterOnTab(() -> CMakeOutputConsole.setConsoleProcessHandler(this.getConsole(profileId), handler2), profileId);
            handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    CMakeOutputConsole.this.invokeLaterOnTab(() -> CMakeOutputConsole.this.getConsole(profileId).print(event.getText(), ConsoleViewContentType.NORMAL_OUTPUT), profileId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$6";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @TestOnly
    private void updateMessagesCollectors(@Nullable Path sourceDir, @NotNull List<CMakeProfileInfo> profileInfos) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(17);
        }
        this.myMessagesCollectors.clear();
        if (profileInfos.isEmpty()) {
            CMakeMessagesCollector messagesCollector = new CMakeMessagesCollector(this.myProject, null, null);
            this.myMessagesCollectors.put(0, messagesCollector);
        } else {
            for (int i = 0; i < profileInfos.size(); ++i) {
                CMakeMessagesCollector messagesCollector = new CMakeMessagesCollector(this.myProject, profileInfos.get(i).getEnvironment(), sourceDir);
                this.myMessagesCollectors.put(i, messagesCollector);
            }
        }
    }

    @TestOnly
    @NotNull
    public CMakeMessagesCollector getMessagesCollector(@NotNull ConsoleView console) {
        int index;
        CMakeMessagesCollector collector2;
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(18);
        }
        if ((collector2 = this.myMessagesCollectors.get(index = CMakeOutputConsole.getConsoleIndex(console))) == null) {
            collector2 = new CMakeMessagesCollector(this.myProject, null, null);
            this.myMessagesCollectors.put(index, collector2);
        }
        CMakeMessagesCollector cMakeMessagesCollector = collector2;
        if (cMakeMessagesCollector == null) {
            CMakeOutputConsole.$$$reportNull$$$0(19);
        }
        return cMakeMessagesCollector;
    }

    @TestOnly
    public CMakeData<List<CMakeMessage>> getMessages() {
        ThreadingAssertions.assertEventDispatchThread();
        CMakeMessagesContainer messagesContainer = new CMakeMessagesContainer();
        for (Map.Entry<Integer, CMakeMessagesCollector> entry : this.myMessagesCollectors.entrySet()) {
            int index = entry.getKey();
            String title = CMakeOutputConsole.getConsoleTitle(this.getConsole(index));
            messagesContainer.addAll(title, entry.getValue().getMessages());
        }
        return messagesContainer.getMessages();
    }

    @NotNull
    private static File getOutputLogFile(@NotNull File outputDir, @NotNull String title, boolean allowOldFile) {
        File newLogFile;
        if (outputDir == null) {
            CMakeOutputConsole.$$$reportNull$$$0(20);
        }
        if (title == null) {
            CMakeOutputConsole.$$$reportNull$$$0(21);
        }
        if (!(newLogFile = CMakeGeneratorUtils.getCMakeFilesIDEFile(outputDir, FileUtil.sanitizeFileName((String)title, (boolean)false, (String)"") + "-log.txt")).exists() && allowOldFile) {
            File file = CMakeGeneratorUtils.getCMakeFilesIDEFile(outputDir, "log.txt");
            if (file == null) {
                CMakeOutputConsole.$$$reportNull$$$0(22);
            }
            return file;
        }
        File file = newLogFile;
        if (file == null) {
            CMakeOutputConsole.$$$reportNull$$$0(23);
        }
        return file;
    }

    void reloadingStarted(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeOutputConsole.$$$reportNull$$$0(24);
        }
        this.invokeLater(() -> {
            this.isOnceActivated = false;
            this.myCurrentReloadingIndicator = indicator;
        });
    }

    void reloadingFinished(final boolean canceled) {
        this.invokeLater(() -> {
            if (this.myCurrentReloadingIndicator == null) {
                return;
            }
            this.myCurrentReloadingIndicator = null;
            final List<CMakeConsoleViewImpl> consoles = this.getConsoles();
            final Runnable consoleFinished = new Runnable(){
                int finishedConsoles = 0;

                @Override
                public void run() {
                    if (++this.finishedConsoles < consoles.size()) {
                        return;
                    }
                    for (ConsoleView each : consoles) {
                        boolean hasErrors;
                        boolean bl = hasErrors = CMakeOutputConsole.getConsoleMessageType(each) == CMakeConsoleMessageType.ERROR;
                        File generationDir = CMakeOutputConsole.getConsoleGenerationDir(each);
                        if (generationDir == null) continue;
                        if (canceled) {
                            each.print("\n" + CLionCMakeBundle.message("cmake.console.reloadingCanceled", new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                            continue;
                        }
                        File logFile = CMakeOutputConsole.getOutputLogFile(generationDir, CMakeOutputConsole.getConsoleTitle(each), false);
                        try {
                            FileUtil.writeToFile((File)logFile, (String)CMakeOutputConsole.getFlushedConsoleText(each), (Charset)StandardCharsets.UTF_8);
                        }
                        catch (IOException e) {
                            CPPLog.LOG.warn("Can't write CMake log: " + e);
                        }
                        each.print("\n" + CLionCMakeBundle.message(hasErrors ? "cmake.console.reloadingFinishedWithErrors" : "cmake.console.reloadingFinished", new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                }
            };
            for (ConsoleView consoleView : consoles) {
                final Runnable finishOnce = new Runnable(){
                    boolean finished = false;

                    @Override
                    public void run() {
                        if (!this.finished) {
                            this.finished = true;
                            consoleFinished.run();
                        }
                    }
                };
                ProcessHandler handler2 = CMakeOutputConsole.getConsoleProcessHandler(consoleView);
                if (handler2 != null) {
                    handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                9.$$$reportNull$$$0(0);
                            }
                            CMakeOutputConsole.this.invokeLater(finishOnce);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$9", "processTerminated"));
                        }
                    });
                }
                if (handler2 != null && !handler2.isProcessTerminated()) continue;
                finishOnce.run();
            }
        });
    }

    private void doUpdateTabIconAndActivate(@NotNull ConsoleView console, @NotNull CMakeConsoleMessageType type) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(25);
        }
        if (type == null) {
            CMakeOutputConsole.$$$reportNull$$$0(26);
        }
        ContentManager manager = this.getContentManager();
        Content content = manager.getContent(CMakeOutputConsole.getConsoleIndex(console));
        assert (content != null);
        CMakeConsoleMessageType currentType = CMakeOutputConsole.getConsoleMessageType(console);
        if (currentType == null || currentType.getLevel() < type.getLevel()) {
            CMakeOutputConsole.setConsoleMessageType(console, type);
            Icon icon = type == CMakeConsoleMessageType.ERROR ? AllIcons.General.BalloonError : AllIcons.General.BalloonWarning;
            content.setIcon(icon);
        }
        if (!this.isOnceActivated) {
            this.isOnceActivated = true;
            manager.setSelectedContent(content, false);
            ToolWindow toolWindow = CMakeWorkspace.getToolWindow(this.myProject);
            if (toolWindow != null) {
                toolWindow.activate(null, false, false);
            }
        }
    }

    @Nullable
    private static CMakeConsoleViewImpl getConsoleIfExists(@NotNull Content content) {
        CMakeConsoleViewImpl console;
        if (content == null) {
            CMakeOutputConsole.$$$reportNull$$$0(27);
        }
        if ((console = (CMakeConsoleViewImpl)((Object)content.getUserData(CONSOLE_VIEW_KEY))) == null && content.getDisplayName() != null) {
            CPPLog.LOG.warn("Key CONSOLE_VIEW_KEY not found in the named " + content + ". Check content creation process.");
        }
        return console;
    }

    @Nullable
    private static CMakeProfileInfo getProfileInfo(@NotNull Content content) {
        if (content == null) {
            CMakeOutputConsole.$$$reportNull$$$0(28);
        }
        return (CMakeProfileInfo)content.getUserData(PROFILE_INFO_KEY);
    }

    @NotNull
    private ConsoleView getConsole(int id) {
        List<CMakeConsoleViewImpl> consoles = this.getConsoles();
        CMakeConsoleViewImpl console = (CMakeConsoleViewImpl)((Object)ContainerUtil.find(consoles, it -> it.getProfileId() == id));
        if (console == null) {
            IllegalArgumentException warn = new IllegalArgumentException("Console for profile " + id + " not available among " + ContainerUtil.map(consoles, each -> CMakeOutputConsole.getConsoleTitle((ConsoleView)each) + " " + each.getProfileId()));
            CPPLog.LOG.warn((Throwable)warn);
            throw warn;
        }
        ConsoleView consoleView = (ConsoleView)consoles.get(id);
        if (consoleView == null) {
            CMakeOutputConsole.$$$reportNull$$$0(29);
        }
        return consoleView;
    }

    @NotNull
    public List<CMakeConsoleViewImpl> getConsoles() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.debug("getConsoles():\nmyUpdateSessionId = " + this.myUpdateSessionId.get() + "\ncontentManager = " + this.getContentManager());
        ContentManager contentManager = this.getContentManager();
        List<CMakeConsoleViewImpl> list2 = Arrays.stream(contentManager.getContents()).map(it -> CMakeOutputConsole.getConsoleIfExists(it)).filter(it -> it != null).collect(Collectors.toList());
        if (list2 == null) {
            CMakeOutputConsole.$$$reportNull$$$0(30);
        }
        return list2;
    }

    private static int getConsoleIndex(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(31);
        }
        return (Integer)each.getComponent().getClientProperty(CONSOLE_INDEX);
    }

    @NotNull
    public static String getConsoleTitle(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(32);
        }
        String string = (String)each.getComponent().getClientProperty(CONSOLE_TITLE);
        if (string == null) {
            CMakeOutputConsole.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public static File getConsoleGenerationDir(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(34);
        }
        return (File)each.getComponent().getClientProperty(CONSOLE_GENERATION_DIR);
    }

    @Nullable
    private static ProcessHandler getConsoleProcessHandler(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(35);
        }
        return (ProcessHandler)each.getComponent().getClientProperty(CONSOLE_PROCESS_HANDLER);
    }

    private static void setConsoleProcessHandler(@NotNull ConsoleView console, @NotNull ProcessHandler handler2) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(36);
        }
        if (handler2 == null) {
            CMakeOutputConsole.$$$reportNull$$$0(37);
        }
        console.getComponent().putClientProperty(CONSOLE_PROCESS_HANDLER, handler2);
    }

    @NotNull
    public static String getFlushedConsoleText(@NotNull ConsoleView console) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(38);
        }
        ConsoleViewImpl impl = (ConsoleViewImpl)console;
        impl.flushDeferredText();
        String string = impl.getText();
        if (string == null) {
            CMakeOutputConsole.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    private static CMakeConsoleMessageType getConsoleMessageType(@NotNull ConsoleView console) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(40);
        }
        return (CMakeConsoleMessageType)((Object)console.getComponent().getClientProperty(CURRENT_MESSAGE_TYPE));
    }

    private static void setConsoleMessageType(@NotNull ConsoleView console, @NotNull CMakeConsoleMessageType type) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(41);
        }
        if (type == null) {
            CMakeOutputConsole.$$$reportNull$$$0(42);
        }
        console.getComponent().putClientProperty(CURRENT_MESSAGE_TYPE, (Object)type);
    }

    private void invokeAndWait(Runnable runnable2) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            runnable2.run();
        }, ModalityState.nonModal());
    }

    private void invokeLater(Runnable runnable2) {
        this.invokeLater(runnable2, null);
    }

    private void invokeLater(Runnable runnable2, @Nullable Condition<Object> expired) {
        Condition projectDisposed = __ -> this.myProject.isDisposed();
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.nonModal(), expired == null ? projectDisposed : Conditions.or((Condition)projectDisposed, expired));
    }

    private void invokeLaterOnAllTabs(Runnable runnable2) {
        long currentUpdateSessionId = this.myUpdateSessionId.get();
        Condition sessionExpiration = __ -> this.myUpdateSessionId.get() != currentUpdateSessionId;
        this.invokeLater(runnable2, (Condition<Object>)sessionExpiration);
    }

    private void invokeLaterOnTab(Runnable runnable2, int tabIndex) {
        Runnable tabExpiration = () -> {
            try {
                this.getConsole(tabIndex);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            runnable2.run();
        };
        this.invokeLaterOnAllTabs(tabExpiration);
    }

    @NotNull
    private static DefaultActionGroup createEnableProfileActionGroup(@NotNull CMakeSettings settings) {
        if (settings == null) {
            CMakeOutputConsole.$$$reportNull$$$0(43);
        }
        DefaultActionGroup actionGroup2 = new DefaultActionGroup(CLionCMakeBundle.message("action.enable.profile.text", new Object[0]), true);
        actionGroup2.getTemplatePresentation().setHideGroupIfEmpty(true);
        for (CMakeSettings.Profile profile : settings.getDisabledProfiles()) {
            actionGroup2.add((AnAction)new ToggleCMakeProfileAction(profile, settings, profile.getName()));
        }
        DefaultActionGroup defaultActionGroup = actionGroup2;
        if (defaultActionGroup == null) {
            CMakeOutputConsole.$$$reportNull$$$0(44);
        }
        return defaultActionGroup;
    }

    @RequiresEdt
    @Nullable
    public static CMakeProfileInfo findCurrentConsoleProfile(@NotNull Project project, @Nullable AnActionEvent e) {
        CMakeProfileInfo profile;
        Content focusedContent;
        CMakeProfileInfo profile2;
        if (project == null) {
            CMakeOutputConsole.$$$reportNull$$$0(45);
        }
        ThreadingAssertions.assertEventDispatchThread();
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project);
        if (!workspace.isInitialized()) {
            return null;
        }
        if (e != null && (profile2 = (CMakeProfileInfo)e.getData(CURRENT_CONSOLE_PROFILE)) != null) {
            return profile2;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("CMake");
        if (toolWindow != null && toolWindow.isAvailable() && (focusedContent = toolWindow.getContentManager().getSelectedContent()) != null && (profile = CMakeOutputConsole.getProfileInfo(focusedContent)) != null) {
            return profile;
        }
        return (CMakeProfileInfo)ContainerUtil.getFirstItem(workspace.getProfileInfos());
    }

    static {
        ConsoleViewContentType.registerNewConsoleViewType(CONSOLE_HISTORY_KEY, (TextAttributesKey)ConsoleViewContentType.LOG_EXPIRED_ENTRY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 24, 25, 26, 27, 28, 31, 32, 34, 35, 36, 37, 38, 40, 41, 42, 43, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole";
                break;
            }
            case 3: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileInfos";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesWithFixes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileInfo";
                break;
            }
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: 
            case 25: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRegisterToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerToolWindow";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsole";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagesCollector";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLogFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoles";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleTitle";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlushedConsoleText";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnableProfileActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateTabs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restoreTabs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLogFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doReportMessages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachConsoleToProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateMessagesCollectors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMessagesCollector";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOutputLogFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reloadingStarted";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTabIconAndActivate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleIfExists";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProfileInfo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleIndex";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleTitle";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleGenerationDir";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleProcessHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleProcessHandler";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFlushedConsoleText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleMessageType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleMessageType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createEnableProfileActionGroup";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentConsoleProfile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 24, 25, 26, 27, 28, 31, 32, 34, 35, 36, 37, 38, 40, 41, 42, 43, 45 -> new IllegalArgumentException(string);
        };
    }

    private static final class DataProviderPanel
    extends JPanel
    implements UiDataProvider,
    Disposable {
        @Nullable
        private final CMakeProfileInfo myProfile;

        private DataProviderPanel(@NotNull CMakeConsoleViewImpl c, @Nullable CMakeProfileInfo p) {
            if (c == null) {
                DataProviderPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myProfile = p;
            this.add((Component)((Object)c), "Center");
            Disposer.register((Disposable)this, (Disposable)c);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                DataProviderPanel.$$$reportNull$$$0(1);
            }
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)CMakeOutputConsole.HELP_ID);
            sink.set(CURRENT_CONSOLE_PROFILE, (Object)this.myProfile);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$DataProviderPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Fix {
        @NotNull
        private final String text;
        @NotNull
        private final Runnable action;

        public Fix(@NotNull String text, @NotNull Runnable action2) {
            if (text == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                Fix.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.action = action2;
        }

        public Fix(@NotNull EnvironmentProblems.Fix fix) {
            if (fix == null) {
                Fix.$$$reportNull$$$0(2);
            }
            this.text = fix.getText();
            this.action = () -> fix.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fix";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$Fix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

