/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.settings;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0007\"#$%&'(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u001a\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0007J\u0015\u0010\u001d\u001a\u00020\u001b2\u000b\u0010\u0010\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0003J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0002R\u0011\u0010\u0005\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R0\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "<init>", "()V", "generator", "getGenerator", "()Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "defaultGeneratorName", "getDefaultGeneratorName", "()Ljava/lang/String;", "setDefaultGeneratorName", "(Ljava/lang/String;)V", "customGeneratorName", "getCustomGeneratorName", "shouldShowSpinner", "", "getShouldShowSpinner", "()Z", "setShouldShowSpinner", "(Z)V", "lastEmptyGenerator", "firstPredefinedGenerator", "setGeneratorName", "", "generatorName", "selectCustomGenerator", "hasCustomGeneratorItem", "findPredefinedGenerator", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "name", "Item", "Customizable", "GeneratorItem", "DefaultGeneratorItem", "CustomGeneratorItem", "NoGeneratorItem", "Companion", "intellij.clion.cmake"})
public final class CMakeGeneratorComboBox
extends ComboBox<Item> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String defaultGeneratorName = "";
    @NotNull
    private String customGeneratorName = "";
    private boolean shouldShowSpinner = true;
    @NotNull
    private Item lastEmptyGenerator = DefaultGeneratorItem.INSTANCE;
    @Nullable
    private Item firstPredefinedGenerator;
    @NotNull
    private static final List<CMakeGeneratorType> WIN_GENERATORS;
    @NotNull
    private static final List<CMakeGeneratorType> UNIX_GENERATORS;
    @NotNull
    private static final List<CMakeGeneratorType> MAC_GENERATORS;

    public CMakeGeneratorComboBox() {
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(DefaultGeneratorItem.INSTANCE);
        items.add(NoGeneratorItem.INSTANCE);
        List<CMakeGeneratorType> generators = SystemInfo.isWindows ? WIN_GENERATORS : (SystemInfo.isMac ? MAC_GENERATORS : UNIX_GENERATORS);
        for (CMakeGeneratorType generator : generators) {
            GeneratorItem item = new GeneratorItem(generator);
            items.add(item);
            if (this.firstPredefinedGenerator != null) continue;
            this.firstPredefinedGenerator = item;
        }
        this.setModel((ComboBoxModel)new CollectionComboBoxModel<Item>(items){

            public void setSelectedItem(Object item) {
                if (item == DefaultGeneratorItem.INSTANCE) {
                    lastEmptyGenerator = DefaultGeneratorItem.INSTANCE;
                } else if (item == NoGeneratorItem.INSTANCE) {
                    lastEmptyGenerator = NoGeneratorItem.INSTANCE;
                }
                super.setSelectedItem(item);
            }
        });
        this.renderer = (ListCellRenderer)new GroupedComboBoxRenderer<Item>(){

            public ListSeparator separatorFor(Item value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return Intrinsics.areEqual((Object)value, (Object)firstPredefinedGenerator) ? new ListSeparator(StringUtil.shortenTextWithEllipsis((String)CLionCMakeBundle.message("cmake.generator.predefined.generators.header", new Object[0]), (int)40, (int)3)) : null;
            }

            public String getText(Item item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.toString();
            }

            public void customize(SimpleColoredComponent item, Item value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value instanceof Customizable) {
                    ((Customizable)((Object)value)).customize(item, this);
                } else {
                    super.customize(item, (Object)value, index, isSelected, cellHasFocus);
                }
            }
        };
        this.setSwingPopup(false);
    }

    @NotNull
    public final Item getGenerator() {
        Object object = this.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (Item)object;
    }

    @RequiresEdt
    @NotNull
    public final String getDefaultGeneratorName() {
        return this.defaultGeneratorName;
    }

    @RequiresEdt
    public final void setDefaultGeneratorName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.defaultGeneratorName = value;
        this.repaint();
    }

    @NotNull
    public final String getCustomGeneratorName() {
        return this.customGeneratorName;
    }

    public final boolean getShouldShowSpinner() {
        return this.shouldShowSpinner;
    }

    public final void setShouldShowSpinner(boolean bl) {
        this.shouldShowSpinner = bl;
    }

    @RequiresEdt
    public final void setGeneratorName(@NotNull String generatorName) {
        Intrinsics.checkNotNullParameter((Object)generatorName, (String)"generatorName");
        if (StringsKt.isBlank((CharSequence)generatorName)) {
            this.setSelectedItem(this.lastEmptyGenerator);
            return;
        }
        GeneratorItem predefined = this.findPredefinedGenerator(generatorName);
        if (predefined != null) {
            this.setSelectedItem(predefined);
            return;
        }
        this.selectCustomGenerator(generatorName);
    }

    @RequiresEdt
    private final void selectCustomGenerator(String customGeneratorName) {
        this.customGeneratorName = customGeneratorName;
        if (this.hasCustomGeneratorItem()) {
            this.repaint();
        } else {
            ComboBoxModel comboBoxModel = this.getModel();
            Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionComboBoxModel<com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBox.Item>");
            ((CollectionComboBoxModel)comboBoxModel).add(0, (Object)CustomGeneratorItem.INSTANCE);
        }
        this.setSelectedItem(CustomGeneratorItem.INSTANCE);
    }

    private final boolean hasCustomGeneratorItem() {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Item item = (Item)this.getModel().getElementAt(i);
            if (!(item instanceof CustomGeneratorItem)) continue;
            return true;
        }
        return false;
    }

    private final GeneratorItem findPredefinedGenerator(String name) {
        if (name == null) {
            return null;
        }
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Item item = (Item)this.getModel().getElementAt(i);
            if (!(item instanceof GeneratorItem) || !Intrinsics.areEqual((Object)((GeneratorItem)item).getGeneratorName(), (Object)name)) continue;
            return (GeneratorItem)item;
        }
        return null;
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String changeGenerator(@NotNull String options, @NotNull String newGenerator) {
        return Companion.changeGenerator(options, newGenerator);
    }

    static {
        Object[] objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.BORLAND_MAKEFILES.INSTANCE, CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE, CMakeGeneratorType.NMAKE_MAKEFILES_JOM.INSTANCE, CMakeGeneratorType.MSYS_MAKEFILES.INSTANCE, CMakeGeneratorType.MINGW_MAKEFILES.INSTANCE, CMakeGeneratorType.WATCOM_MAKEFILES.INSTANCE, CMakeGeneratorType.VS14.INSTANCE, CMakeGeneratorType.VS15.INSTANCE, CMakeGeneratorType.VS16.INSTANCE, CMakeGeneratorType.VS17.INSTANCE, CMakeGeneratorType.GREEN_HILLS_MULTI.INSTANCE};
        WIN_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.WATCOM_MAKEFILES.INSTANCE, CMakeGeneratorType.GREEN_HILLS_MULTI.INSTANCE};
        UNIX_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.XCODE.INSTANCE};
        MAC_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Companion;", "", "<init>", "()V", "WIN_GENERATORS", "", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "UNIX_GENERATORS", "MAC_GENERATORS", "changeGenerator", "", "options", "newGenerator", "addGenerator", "new", "removeGenerator", "old", "replaceGenerator", "createGeneratorReplacementRegex", "Lkotlin/text/Regex;", "generator", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String changeGenerator(@NotNull String options, @NotNull String newGenerator) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)newGenerator, (String)"newGenerator");
            List<String> optionsList = CMakeSettings.Companion.getOptionsList(options);
            boolean hasUserGenerator = CMakeGeneratorUtils.hasUserSpecifiedGenerator(optionsList);
            String userGenerator = CMakeGeneratorUtils.getUserSpecifiedGenerator(optionsList);
            return !hasUserGenerator && StringsKt.isBlank((CharSequence)newGenerator) ? options : (!hasUserGenerator && !StringsKt.isBlank((CharSequence)newGenerator) ? this.addGenerator(options, newGenerator) : (hasUserGenerator && StringsKt.isBlank((CharSequence)newGenerator) ? this.removeGenerator(options, userGenerator) : this.replaceGenerator(options, userGenerator, newGenerator)));
        }

        private final String addGenerator(String options, String string) {
            ParametersList parameters2 = new ParametersList();
            parameters2.add("-G");
            parameters2.add(string);
            return parameters2.getParametersString() + " " + options;
        }

        private final String removeGenerator(String options, String old) {
            Regex regex = this.createGeneratorReplacementRegex(old);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)options, (int)0, (int)2, null));
            if (matchResult == null) {
                return options;
            }
            MatchResult match = matchResult;
            String string = options.substring(0, match.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String beforeMatch = string;
            String string2 = options.substring(match.getRange().getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String afterMatch = string2;
            if (StringsKt.isBlank((CharSequence)beforeMatch)) {
                String string3 = options.substring(match.getRange().getLast() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return ((Object)StringsKt.trimStart((CharSequence)string3)).toString();
            }
            if (StringsKt.isBlank((CharSequence)afterMatch)) {
                String string4 = options.substring(0, match.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                return ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
            }
            IntRange replaceRange = match.getRange();
            if (StringsKt.endsWith$default((String)beforeMatch, (String)" ", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)afterMatch, (String)" ", (boolean)false, (int)2, null)) {
                replaceRange = new IntRange(replaceRange.getFirst(), replaceRange.getLast() + 1);
            }
            String string5 = options;
            CharSequence charSequence = "";
            return ((Object)StringsKt.replaceRange((CharSequence)string5, (IntRange)replaceRange, (CharSequence)charSequence)).toString();
        }

        private final String replaceGenerator(String options, String old, String string) {
            Regex regex = this.createGeneratorReplacementRegex(old);
            ParametersList parameters2 = new ParametersList();
            parameters2.add("-G");
            parameters2.add(string);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)options, (int)0, (int)2, null));
            if (matchResult == null) {
                return options;
            }
            MatchResult match = matchResult;
            StringBuilder sb = new StringBuilder(options.length());
            sb.append(options, 0, match.getRange().getFirst());
            sb.append(parameters2.getParametersString());
            sb.append(options, match.getRange().getLast() + 1, options.length());
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final Regex createGeneratorReplacementRegex(String generator) {
            String quotes = "`'\"";
            String openingQuotes = "\u201e\u00ab" + quotes;
            String closingQuotes = "\u201c\u00bb" + quotes;
            String string = generator;
            if (string == null) {
                string = "";
            }
            String generatorRegex = "-G\\s*[" + openingQuotes + "]?\\Q" + string + "\\E[" + closingQuotes + "]?";
            return new Regex(generatorRegex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$CustomGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "toString", "", "intellij.clion.cmake"})
    public static final class CustomGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final CustomGeneratorItem INSTANCE = new CustomGeneratorItem();

        private CustomGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component2, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            String customGeneratorName = comboBox.getCustomGeneratorName();
            component2.append(CLionCMakeBundle.message("cmake.generator.custom.label", new Object[0]));
            if (!StringsKt.isBlank((CharSequence)customGeneratorName)) {
                component2.append(" ");
                component2.append(customGeneratorName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        @NotNull
        public String toString() {
            String string = CLionCMakeBundle.message("cmake.generator.custom.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "intellij.clion.cmake"})
    private static interface Customizable {
        public void customize(@NotNull SimpleColoredComponent var1, @NotNull CMakeGeneratorComboBox var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$DefaultGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "UNKNOWN", "", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "toString", "intellij.clion.cmake"})
    public static final class DefaultGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final DefaultGeneratorItem INSTANCE = new DefaultGeneratorItem();
        @NotNull
        public static final String UNKNOWN = "__CIDR_UNKNOWN_GENERATOR__";

        private DefaultGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component2, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            String defaultGeneratorName = comboBox.getDefaultGeneratorName();
            component2.append(CLionCMakeBundle.message("cmake.generator.default.label", new Object[0]));
            if (Intrinsics.areEqual((Object)defaultGeneratorName, (Object)UNKNOWN)) {
                return;
            }
            if (!StringsKt.isBlank((CharSequence)defaultGeneratorName)) {
                component2.append("  ");
                component2.append(defaultGeneratorName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (comboBox.getShouldShowSpinner()) {
                component2.setIconOnTheRight(true);
                component2.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
            }
        }

        @NotNull
        public String toString() {
            String string = CLionCMakeBundle.message("cmake.generator.default.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "generator", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "<init>", "(Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;)V", "getGenerator", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "toString", "", "generatorName", "Lcom/intellij/openapi/util/NlsSafe;", "getGeneratorName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.clion.cmake"})
    public static final class GeneratorItem
    implements Item {
        @NotNull
        private final CMakeGeneratorType generator;

        public GeneratorItem(@NotNull CMakeGeneratorType generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        @NotNull
        public final CMakeGeneratorType getGenerator() {
            return this.generator;
        }

        @NotNull
        public String toString() {
            return this.generator.getName();
        }

        @NotNull
        public final String getGeneratorName() {
            return this.generator.getName();
        }

        @NotNull
        public final CMakeGeneratorType component1() {
            return this.generator;
        }

        @NotNull
        public final GeneratorItem copy(@NotNull CMakeGeneratorType generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            return new GeneratorItem(generator);
        }

        public static /* synthetic */ GeneratorItem copy$default(GeneratorItem generatorItem, CMakeGeneratorType cMakeGeneratorType, int n, Object object) {
            if ((n & 1) != 0) {
                cMakeGeneratorType = generatorItem.generator;
            }
            return generatorItem.copy(cMakeGeneratorType);
        }

        public int hashCode() {
            return this.generator.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneratorItem)) {
                return false;
            }
            GeneratorItem generatorItem = (GeneratorItem)other;
            return Intrinsics.areEqual((Object)this.generator, (Object)generatorItem.generator);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$CustomGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$DefaultGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$NoGeneratorItem;", "intellij.clion.cmake"})
    public static interface Item {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$NoGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "intellij.clion.cmake"})
    public static final class NoGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final NoGeneratorItem INSTANCE = new NoGeneratorItem();

        private NoGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component2, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            component2.append(CLionCMakeBundle.message("cmake.generator.none.label", new Object[0]));
            component2.append("  ");
            component2.append(CLionCMakeBundle.message("cmake.generator.none.description", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

